<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Account_Logger extends DEProcessing_Dentevents_Account{

   function initialize($params = array()){
       $this->EE->load->model("account_hits");
   }
    
   function process($params = array()){
       if($this->helper->is_crawlers_bots()){
            return true;
       }
        
       $cmd = self::$utility->fetch_router();
        
       switch($cmd){
           case "logger":
               return $this->logger($params);
           break;
           case "logger_super":
               return $this->logger_super($params);
           break;
           case "ajax":
               return $this->ajax($params);
           break;
       }
   }
   
   function ajax($params = array()){
       $logger_field = $this->EE->input->get_post("logger_field");
       $logger_field_prefix = $this->EE->input->get_post("logger_field_prefix");
       
       $result = $this->logger(array('logger_field' => $logger_field, 'logger_field_prefix' => $logger_field_prefix));
       
       if($result){
           $result = "success";
       }else{
           $result = "failed";
       }
       
       $output = array("result" => $result);
        
       $this->EE->load->library('javascript');
       $output = $this->EE->javascript->generate_json($output, TRUE);
       return $output;
   }
   
   function logger($params = array()){
        $_account = self::$account;
        $logger_field_prefix = $params['logger_field_prefix'];
        $logger_field = $params['logger_field'];
        
        $id = $_account['id'];
        $name = $_account['name'];
        
        $now_date = new DateTime();
        $now_month = $now_date->format("m");
        $now_year = $now_date->format("Y");
        
        $params = array();
        $params['id'] = $id;
        $params['selects'] = "{#m}.id,{$logger_field_prefix}.{$logger_field}";
        $params['where'] = "{#m}.month='$now_month' and {#m}.year='$now_year'";
        $params['single'] = true;
        
        $_hit = $this->EE->accounts->get_relationship_hits($params);   
        if(empty($_hit)){
             $data = array('name' => $name, 'month' => $now_month, 'year' => $now_year, $logger_field => 1);

             $success = $this->EE->account_hits->set_record($data);
             if(!$success){
                $this->logger->developer("Failed to create the account hits.");
                return false;
             }
             $link_id = $success;
             $success = $this->EE->accounts->add_relationship_app($id, $link_id, 'account_hits');
             if(!$success){
                 $this->logger->developer("Failed to link the account hits to account.");
                 return false;
             }
        }else{
             $logger_field_value = $_hit[$logger_field] * 1 + 1;
             $_hit[$logger_field] = $logger_field_value;
             
             $success = $this->EE->account_hits->set_record($_hit);
             if(!$success){
                $this->logger->developer("Failed to update the account hits.");
                return false;
             }
        }
        
        return true;
   }
   
   function logger_super($params = array()){
        $_account = self::$account;

        $id = $_account['id'];
        $name = $_account['name'];
        
        $now_date = new DateTime();
        $now_month = $now_date->format("m");
        $now_year = $now_date->format("Y");
        
        $params = array();
        $params['id'] = $id;
        $params['selects'] = "{#m}.id,{#m}.schclick,{#m}.schurl";
        $params['where'] = "{#m}.month='$now_month' and {#m}.year='$now_year'";
        $params['single'] = true;
        
        $_hit = $this->EE->accounts->get_relationship_hits($params);   
        if(empty($_hit)){
             $data = array('name' => $name, 'month' => $now_month, 'year' => $now_year, 'schclick' => 1, 'schurl' => 1);

             $success = $this->EE->account_hits->set_record($data);
             if(!$success){
                $this->logger->developer("Failed to create the account hits.");
                return false;
             }
             $link_id = $success;
             $success = $this->EE->accounts->add_relationship_app($id, $link_id, 'account_hits');
             if(!$success){
                 $this->logger->developer("Failed to link the account hits to account.");
                 return false;
             }
        }else{
             $schclick = $_hit['schclick'] * 1 + 1;
             $_hit['schclick'] = $schclick;
             $schurl = $_hit['schurl'] * 1 + 1;
             $_hit['schurl'] = $schurl;
             
             $success = $this->EE->account_hits->set_record($_hit);
             if(!$success){
                $this->logger->developer("Failed to update the account hits.");
                return false;
             }
        }
        
        $output = array("result" => 'success');
        
        $this->EE->load->library('javascript');
        $output = $this->EE->javascript->generate_json($output, TRUE);
        return $output;
   }
}