<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class EVTProcessing_Events_Cron extends EVTProcessing_Events{
    static $ticket_events;
    static $act_selects;
    static $organiser = null;

    function initialize($params = array()){     
        self::$utility->fetch_contact();
        $this->EE->load->model('cpd_events');
        $this->EE->load->model('cpd_activity');
        $this->EE->load->model('accounts');
        $this->EE->load->model("cpd_eventregooptions");

        self::$act_selects = "{#m}.id,IF({#c}.show_as_paid_c=1, '4PaymentAccepted', {#m}.status) as status,{#m}.date_entered,{#c}.payment_date_c,{#c}.payment_type_c,{#c}.rego_option_type_c,{#c}.payment_total_charged_c,{#c}.cpd_activity_id_c,{#c}.payment_currency_c,{#c}.special_diet_choice_c,{#c}.notes_c,{#c}.notes_checked_c,{#c}.receipt_data_c,{#c}.ticketing_commission_c,{#c}.ticketing_merchant_fee_c,{#c}.ticketing_charges_c,{#c}.address_used_c,{#c}.payment_process_method_c,{#c}.hide_payment_c,{#c}.cpd_certificate_sent_text_c, {#c}.paid_option_c,{#c}.contact_checked_c,{#c}.user_update_log_c";        
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "reminder":
                return $this->reminder($params);
            break;            
        }
    }

    function get_primary_activities_from_event_for_registrants($event_id){
        $selects = self::$act_selects;
        $acts = $this->EE->cpd_events->get_relationship_cpdactivity(array(
                        'id' => $event_id,
                        'selects' => $selects
                    ));
        $results = array();
        foreach($acts as $item){                        
            if($item['rego_option_type_c'] == 'Core' || $item['rego_option_type_c'] == 'Guests'){
                self::$ticket_events[$event_id]['core_acts'][] = $item['id'];
                $results[] = $item;
                continue;
            }
            $act = $this->EE->cpd_activity->get_relationship_related_cpdactivity_core(array(
                        'id' => $item['id'],
                        'selects' => $selects,
                        'single' => true
                    ));
            if(empty($act)){
                continue;
            }
            $primary_act = $this->EE->cpd_activity->get_relationship_transactions_cpdactivity_principal(array(
                        'id' => $act['id'],
                        'selects' => $selects,
                        'single' => true
                    ));
            
            if(empty($primary_act)){
                $primary_act = $act;
            }
            
            self::$ticket_events[$event_id]['core_acts'][] = $act['id'];
            $results[] = $primary_act;
        }
        
        $results = array_unique($results, SORT_REGULAR);

        return $results;
    }

    function recurring_fetch_events($type, $evt_id){
        $map_orders = array('Stream' => 'Day', 'Day' => 'Session');
        
        /// check if has link to rego options ///
          
        $params = array();
        $params['id'] = $evt_id;
        $params['selects'] = "{#m}.id";  
        $options = $this->EE->cpd_events->get_relationship_payment_matrix($params);
        if(!empty($options)){
            self::$ticket_events[] = $evt_id;    
        }    
        /////////////////////////////////////////
        
        if($type == null){
            return;
        }
                
        /// order ///
        $orders = '{#m}.start_date asc';
        if($type == 'Stream'){
            $orders = '{#c}.stream_c asc';    
        }
        /////////////
        
        /// where ///
        $where = "{#c}.rec_type_c='{$type}'";
        if($type == 'Session'){
            $where = "{#c}.rec_type_c IN('Session','Break')";
        }
        /////////////
        
        $params = array();
        $params['id'] = $evt_id;
        $params['selects'] = "{#m}.id";
        $params['where'] = $where;
        $params['orders'] = $orders;
        $events = $this->EE->cpd_events->get_relationship_streams_sessions($params);
        
        if(empty($events)){
            $this->recurring_fetch_events($map_orders[$type], $evt_id);
        }
        
        foreach($events as $item){   
            $this->recurring_fetch_events($map_orders[$type], $item['id']);
        }
    }

    function get_email_content($sparmas = array()){
        $_event = $sparmas['event'];
        $_contact = $sparmas['contact'];
        $_act = $sparmas['act'];
        $_organiser = self::$organiser;
        $_organiser['billing_address_street'] = str_replace("\r", "<br>", $_organiser['billing_address_street']);
        /////////venue//////
        $venue = $this->EE->cpd_events->get_relationship_event_venue(array("id" => $_event['id'], 'selects' => "{#m}.id, {#m}.name, {#m}.billing_address_street,{#m}.billing_address_city,{#m}.billing_address_state,{#m}.billing_address_postalcode,{#m}.billing_address_country, {#c}.billing_name_c, {#c}.exact_location_c, {#c}.parking_c, {#m}.phone_office, {#c}.lat_c, {#c}.longitude_c, {#c}.account_id_nr_c", 'single' => true));
        
        $venue['url'] = $this->seo_helper->get_url(
                            Seo_Helper::ACCOUNT_VENUE_DETAIL, 
                            array(
                                'id' => $venue['account_id_nr_c'], 
                                'country' => $venue['billing_address_country'], 
                                'name' => $venue['billing_name_c']
                            )
                        );
        $venue_lat = $venue['lat_c'];
        $venue_longitude = $venue['longitude_c'];

        $map_api_key = $this->_crm_config['main']['map_api_key'];
        $venue_map_url = "https://maps.googleapis.com/maps/api/staticmap?center={$venue_lat},{$venue_longitude}&zoom=14&scale=1&size=250x300&key={$map_api_key}&maptype=roadmap&format=png&visual_refresh=true&markers=size:mid%7Ccolor:0xff0000%7Clabel:1%7C{$venue_lat},{$venue_longitude}";
        
        $venue_target_url = $this->_crm_config['main']['temp_path'] . $venue['id'] . "-map";
        copy($venue_map_url, $venue_target_url);
        $venue['map'] = $venue['id'] . "-map";
        ///////////

        /// content ///
        $contents = array();
        
        $datas = array();

        if(($_act['address_used_c'] == 'Principle') || (empty($act))){
            /// principal account ///
            $params = array();
            $params['selects'] = "{#m}.id, {#m}.name, {#m}.billing_address_street, {#m}.billing_address_city, {#m}.billing_address_state, {#m}.billing_address_postalcode, {#m}.billing_address_country, {#c}.billing_name_c";
            $params['where'] = "{#m}.id='{$_contact['account_id_c']}'";
            $params['single'] = true;
            $principal_account = $this->EE->accounts->get_main_data($params);
            ///////////////
            $address['billing_address_street'] = $principal_account['billing_address_street'];
            $address['billing_address_city'] = $principal_account['billing_address_city'];
            $address['billing_address_state'] = $principal_account['billing_address_state'];
            $address['billing_address_postalcode'] = $principal_account['billing_address_postalcode'];
            $address['billing_address_country'] = $principal_account['billing_address_country'];
            $_contact['billing_name'] = $principal_account['billing_name_c'];
        }else{
            $address['billing_address_street'] = $_contact['alt_address_street'];
            $address['billing_address_city'] = $_contact['alt_address_city'];
            $address['billing_address_state'] = $_contact['alt_address_state'];
            $address['billing_address_postalcode'] = $_contact['alt_address_postalcode'];
            $address['billing_address_country'] = $_contact['alt_address_country'];
            $_contact['billing_name'] = '';
        }
        /// email option link ///
        $email_option = array();
        $_event['add_option_to_email_c'] = trim($_event['add_option_to_email_c'], "^");
        $_event['add_option_to_email_c'] = explode("^,^", $_event['add_option_to_email_c']);
        $now_date = date('Y-m-d');
        if(in_array("reminder", $_event['add_option_to_email_c']) && $now_date <= $_event['rego_close_date_c']){
            $core_id = $_act['id'];
            $email_option['exist'] = "yes";
            $email_option['link'] = "https://www.dentevents.com/addoptions={$core_id}&id={$_event['event_id_c']}";
        }
        /////////////////////////

        $swaps = array(
                    'organiser' => 'organiser', 'event' => 'event', 'venue' => 'venue', 'contact' => 'contact', 'act' => 'act', 'contact_organiser' => 'contact_organiser', 'email_option' => 'email_option'
                );
        $datas = array(
                    'organiser' => $_organiser, 'event' => $_event, 'venue' => $venue, 'contact' => $_contact, 'act' => $_act, 'contact_organiser' => $address, 'email_option' => $email_option
                );
        $TMPL = new EE_Template();
        $TMPL->run_template_engine('events', 'registration_registrants_email');
        $content = $this->EE->output->app_output($swaps, $datas, array('output' => false));    

        return $content;
    }

    function fetch_data(){  
        $data = array();
        ///// Current date and after 1 hour /////
        $now_date = date("Y-m-d H:00:00");

        $nowDate = new DateTime($now_date);
        $nowDate->setTimezone( new DateTimeZone("UTC"));
        $nowTimeFrom = $nowDate->format("Y-m-d H:00:00");

        $nowDate->add(new DateInterval('PT1H'));
        $nowTimeTo = $nowDate->format("Y-m-d H:00:00");
        ///// -------- ///////////////

        $_params = array();
        $_params['selects'] = "{#m}.id,{#m}.name,{#m}.start_date,{#m}.end_date,{#c}.add_option_to_email_c,{#c}.rego_close_date_c,{#c}.event_id_c,{#c}.receipt_footer_c,{#c}.event_reminder_1_c,{#c}.accommodation_info_c,{#c}.rego_opens_date_c,{#c}.event_reminder_2_c,{#c}.event_reminder_3_c";        
        $_params['where'] = "({#c}.event_reminder_1_c>='{$nowTimeFrom}' and {#c}.event_reminder_1_c<'{$nowTimeTo}') or ({#c}.event_reminder_2_c>='{$nowTimeFrom}' and {#c}.event_reminder_2_c<'{$nowTimeTo}') or ({#c}.event_reminder_3_c>='{$nowTimeFrom}' and {#c}.event_reminder_3_c<'{$nowTimeTo}')";
        
        $_events = $this->EE->cpd_events->get_main_data($_params);
        
        if(empty($_events)){
            return;
        }

        foreach($_events as $key => $item){

            /// checking which reminder is ////
            if($item['event_reminder_1_c'] >= $nowTimeFrom && $item['event_reminder_1_c'] < $nowTimeTo){
                $item['reminder_no'] = 1;
                $remind_time = $item['event_reminder_1_c'];
            }
            if($item['event_reminder_2_c'] >= $nowTimeFrom && $item['event_reminder_2_c'] < $nowTimeTo){
                $item['reminder_no'] = 2;
                $remind_time = $item['event_reminder_2_c'];
            }
            if($item['event_reminder_3_c'] >= $nowTimeFrom && $item['event_reminder_3_c'] < $nowTimeTo){
                $item['reminder_no'] = 3;
                $remind_time = $item['event_reminder_3_c'];
            }
            ///////////////
            self::$ticket_events = array();
            $contacts = array();

            /////////formatting date/////////////
            $item['start_date'] = new DateTime($item['start_date'], new DateTimeZone('UTC'));
            $item['start_date']->setTimezone( new DateTimeZone("Australia/Sydney"));
            $start_date = $item['start_date'];
            $item['start_date'] = $item['start_date']->format("D, j F, Y");
            $item['start_time'] = $start_date->format("h:i A");
            
            $item['end_date'] = new DateTime($item['end_date'], new DateTimeZone('UTC'));
            $item['end_date']->setTimezone( new DateTimeZone("Australia/Sydney"));
            $end_date = $item['end_date'];
            $item['end_date'] = $item['end_date']->format("D, j F, Y");
            $item['end_time'] = $end_date->format("h:i A");
            /////

            if(!empty($_event['rego_opens_date_c'])){
                $item['reg_date'] = new DateTime($item['rego_opens_date_c'], new DateTimeZone('UTC'));
                $item['reg_date']->setTimezone( new DateTimeZone("Australia/Sydney"));
                $reg_date = $item['reg_date'];
                $item['reg_date'] = $item['reg_date']->format("D, j F, Y");
                $item['reg_time'] = $reg_date->format("h:i A");    
            }else{
                $item['reg_date'] = "";
                $item['reg_time'] = "";
            }
            
            
            if($item['reg_date'] == $item['start_date']){
                $item['regstart'] = "yes";
            }

            /// organiser ///
            $params = array();
            $params['id'] = $item['id'];
            $params['selects'] = "{#m}.id,{#m}.name,{#m}.billing_address_city,{#m}.billing_address_state,{#m}.billing_address_postalcode,{#m}.billing_address_street,{#m}.billing_address_country,{#c}.contact_id1_c,{#c}.contact_id_c,{#c}.account_id_nr_c, {#c}.logo_c, {#c}.tax_nr_c, {#c}.free_phone_c, {#c}.free_fax_c, {#c}.billing_name_c, {#c}.mailing_name_c, {#m}.phone_fax, {#m}.phone_office, {#c}.exact_location_c, {#c}.parking_c, {#m}.website,{#c}.ticketing_commission_c,{#c}.ticketing_charges_c,{#c}.ticketing_merch_fee_app_1_c,{#c}.ticketing_merch_fee_app_2_c,{#c}.ticketing_merch_fee_app_3_c,{#c}.auto_accept_free_regos_c,{#c}.cancellation_policy_c,{#c}.payment_types_accepted_c,{#c}.payments_methods_c,{#c}.payment_note_1_c,{#c}.payment_note_2_c,{#c}.payment_note_1_free_c,{#c}.payment_note_2_free_c,{#c}.ticketing_merch_fee_1_c,{#c}.ticketing_merch_fee_2_c,{#c}.ticketing_merch_fee_3_c,{#c}.auto_email_booking_summaries_c";
            $params['single'] = true;
            self::$organiser = $this->EE->cpd_events->get_relationship_organiser($params);
            //////////////////
            if(empty(self::$ticket_events)){            
                self::$ticket_events[] = $item['id'];
                $this->recurring_fetch_events('Stream', $item['id']);
                self::$ticket_events = array_unique(self::$ticket_events, SORT_REGULAR);
                
                $events = array();
                foreach(self::$ticket_events as $evt_id){
                    $events[$evt_id] = $this->EE->cpd_events->get_main_data(array(
                                        'selects' => "{#m}.id,{#m}.name,{#m}.start_date,{#c}.rec_type_c",
                                        'where' => "{#m}.id='{$evt_id}'",
                                        'single' => true
                                    ));
                    $events[$evt_id]['core_acts'] = array();
                }
                self::$ticket_events = $events;

                $acts_reg = array();                
                
                foreach(self::$ticket_events as $item_event){                    
                    ///// for registrant tab ////
                    $acts_reg = array_merge(
                                        $acts_reg, 
                                        $this->get_primary_activities_from_event_for_registrants($item_event['id'])
                            );
                }
                $acts_reg = array_unique($acts_reg, SORT_REGULAR);
                
                foreach($acts_reg as $_item){
                    $ids[] = $_item['registrant']['id'];    
                    if($_item['registrant']['email'] != ''){
                        $emails[] = $_item['registrant']['email'];
                    }
                    $acts_ids[] = $_item['id'];
                    ///// getting contact ////
                    $params = array();
                    $params['id'] = $_item['id'];
                    $params['selects'] = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.prefname_c,{#c}.account_id_c,{#c}.email_c, {#m}.alt_address_street, {#m}.alt_address_city, {#m}.alt_address_state, {#m}.alt_address_postalcode, {#m}.alt_address_country";                    
                    $params['single'] = true;
                    $_contact = $this->EE->cpd_activity->get_relationship_contacts($params);

                    $user_tasks = $this->EE->cpd_activity->get_relationship_tasks(array(
                       'id' => $_item['id'],
                        'selects' => "{#m}.id,{#m}.name,{#m}.date_entered,{#m}.description,{#c}.message_type_c,{#c}.email_from_name_c",
                        'where' => "{#c}.message_type_c='User' and {#m}.date_entered>='$remind_time'",
                        'orders' => "{#m}.date_entered desc"
                    ));
                    if(empty($user_tasks)){
                    
                        ////
                        //// getting email content ///
                        $content = '';
                        $content = $this->get_email_content(array('event' => $item, 'contact' => $_contact, 'act' => $_item));
                        //////////////////////////////
                        $itemData = array();
                        $itemData['content'] = $content;
                        $itemData['act'] = $_item;
                        $itemData['contact'] = $_contact;
                        $itemData['event'] = $item;
                        $emailTo = $_contact['email_c'];
                        $data[$emailTo] = $itemData;
                    }
                }
                            
            } 
        }
        return $data;
    }
    public function reminder($params = array()){
        $data = $this->fetch_data();
        if(empty($data)){
            return;
        }

        foreach($data as $email => $item){


            $subject = "Reminder: You are registered for " . $item['event']['name'] . " starting on " . $item['event']['start_date'];
            $bcc = $item['event']['event_email'];
            $this->EE->load->library('email');
            $this->EE->email->wordwrap = true;
            $this->EE->email->set_mailtype('html');
            
            $address = $item['contact']['email_c'];

            $this->EE->email->from('info@dentevents.com', 'Event Reminder');
            $this->EE->email->to($address);
            $this->EE->email->bcc($bcc);
            $this->EE->email->reply_to('info@dentevents.com');
            $this->EE->email->subject($subject);
            $this->EE->email->message($item['content']);
                           
            if($this->EE->email->send()){
                $status = "success";
            }else{
                $status = "fail";
            }

            ////// Reminder Msg //////
            $now_date = date("Y-m-d H:i:00");

            $nowDate = new DateTime($now_date);
            $nowDate->setTimezone( new DateTimeZone("Australia/Sydney"));
            $nowTime = $nowDate->format("H:i A");
            $nowDate = $nowDate->format("j F Y");
            $reminder_msg = "Event Reminder Message sent to all registrant at " . $nowTime . " on " . $nowDate;

            $_data = array();
            $_data['id'] = $item['event']['id'];

            if($item['event']['reminder_no'] == 1){
                $_data['event_reminder_msg_1_c'] = $reminder_msg;
            }
            if($item['event']['reminder_no'] == 2){
                $_data['event_reminder_msg_2_c'] = $reminder_msg;
            }
            if($item['event']['reminder_no'] == 3){
                $_data['event_reminder_msg_3_c'] = $reminder_msg;
            }
            $success = $this->EE->cpd_events->set_record($_data);
            
            if (!$success) {
                $this->logger->developer("Failed to save reminder msg.");
            }
            /////////////////////////

            //////// task log ////////
            $this->EE->load->model('tasks');
            $task_datas = array(
                'name' => 'Reminder to Attend Email Sent',
                'status' => 'Completed',
                'priority' => 'Low',
                'message_type_c' => 'User',
                'description' => $item['content'],
                'email_from_name_c' => $address,
                'message_no_c' => 'DVT005',
                'contact_id' => $item['contact']['id'],
                'ext_cpdactivity_tasks_1ext_cpdactivity_ida' => $item['act']['id']
            );

            $success = $this->tasks->set_record($task_datas);
            if (!$success) {
                $this->logger->developer("Failed to create the tasks for Reminder.");
            }
            ////////////////////
            
        }
        echo "success";exit;
    }
}