<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details extends DEProcessing_Dentevents{
    static $event;
    
    function initialize($params = array()){
        $id = $this->EE->input->get_post("id"); 
        $act_id = $this->EE->input->get_post("act_id");
        $event_id = $this->EE->input->get_post("event_id");

        $this->EE->load->model("cpd_events");
        $this->EE->load->model("topics");
        $this->EE->load->model("general_hits");
        $this->EE->load->model("cpd_activity");


        if(empty($id) && !empty($act_id)){
            $id = $event_id;
        }
        
        if(empty($id)){
            return;
        }
        //////////////////////////////////
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.start_date,{#m}.end_date,{#m}.name,{#m}.event_theme,{#m}.event_url,{#c}.sef_url_c, {#m}.event_logo,{#m}.description,{#m}.event_city,{#m}.event_country,{#m}.listing_type,{#m}.event_banner,{#m}.event_email,{#m}.event_rego_online,{#m}.registration_url,
                              {#m}.cpd_points_type_1,{#m}.cpd_points_type_2,{#m}.cpd_points_type_3,{#m}.more_info,{#m}.event_format,{#m}.event_max_attendance,{#m}.special_diet_available,{#m}.audience,{#m}.event_status,
                              {#c}.overview_c,{#c}.overview_detail_c,{#c}.more_info_heading_c,{#c}.accommodation_info_c,{#c}.tax_rate_c,{#c}.tax_name_c,{#c}.sold_out_c,{#c}.rego_close_date_c,{#c}.ticketing_charges_c,  
                              {#c}.event_options_c,{#c}.event_id_c,{#c}.special_diet_choices_c,{#c}.payment_types_accepted_c,{#c}.payments_methods_c,{#c}.payment_gateway_id_c,{#c}.payment_note_1_c,{#c}.payment_note_2_c,{#c}.payment_success_text_c,
                              {#c}.cancellation_policy_c,{#c}.cancel_policy_method_c,{#c}.cancel_currency_c,{#c}.cancellation_fee_c,{#c}.cancel_set_fee_expiry_c,{#c}.merchant_account_name_c,{#c}.receipt_footer_c,{#c}.ticketing_commission_c,{#c}.rego_time_limit_c,
                              {#c}.cancel_refund_1_months_c,{#c}.cancel_refund_2_months_c,{#c}.cancel_refund_3_months_c,
                              {#c}.cancel_refund_4_months_c,{#c}.cancel_refund_5_months_c,{#c}.cancel_refund_6_months_c,
                              {#c}.ticketing_merch_fee_app_1_c,{#c}.ticketing_merch_fee_app_2_c,{#c}.ticketing_merch_fee_app_3_c,
                              {#c}.ticketing_merch_fee_1_c,{#c}.ticketing_merch_fee_2_c,{#c}.ticketing_merch_fee_3_c,{#c}.allow_special_requests_c,
                              {#c}.force_meal_selection_c,{#c}.allow_waitlist_c,
                              {#c}.facebook_c,{#c}.twitter_c,{#c}.googleplus_c,{#c}.yelp_c,
                              {#c}.youtube_c,{#c}.flickr_c,{#c}.pinterest_c,{#c}.linkedin_c,
                              {#c}.instagram_c,{#c}.xing_c, {#c}.rego_opens_date_c, {#c}.payment_success_user_message_c, {#c}.payment_in_progress_text_c, {#c}.payment_in_progress_user_msg_c, {#c}.paypal_info_c, {#c}.paypal_merchant_id_c, {#c}.paypal_client_id_c, {#c}.paypal_client_secret_c, {#c}.paypal_sbn_code_c, {#c}.what_to_bring_c,{#c}.rec_type_c,{#c}.auto_accept_free_regos_c,{#c}.payment_note_1_user_c,{#c}.payment_note_2_user_c,{#c}.comp_heading_c,{#c}.comp_label_c,{#c}.comp_question_c,{#c}.comp_force_selection_c,{#c}.comp_force_error_c,{#c}.comp_terms_c,{#c}.event_views_c,{#c}.event_banner_url_c,{#c}.event_logo_url_c,{#c}.dentevents_tv_content_status_c,{#c}.dentevents_tv_thumnail_img_c,{#c}.dentevents_tv_thumbnail_url_c";
        $params['where'] = "{#c}.event_id_c='{$id}'";
        $params['single'] = true;
        
        self::$event = $this->EE->cpd_events->get_main_data($params);
        $f_status = true;

        // if(self::$event['event_status'] != "Approved_Online" || self::$event['event_status'] == "Approved_Online_Private" ){
        //     f_status = false;
        //     header('Location: https://www.dentevents.com/dentevents/details_premium_unavaliale'); exit;

        // }
        self::$event['event_id'] = self::$event['event_id_c'];
        
        /// start date ///
        $date_time = new DateTime(self::$event['start_date'], new DateTimeZone('UTC'));
        $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
        $date = $date_time->format("l, j F, Y");
        $date1 = $date_time->format("j F Y");
        $time = $date_time->format("g:i A");
        self::$event['start'] = array('date' => $date, 'time' => $time, 'date1' => $date1);
        //////////////////
		/// registration date ///
        if(empty(self::$event['rego_opens_date_c'])){
            self::$event['reg'] = array('date' => "", 'time' => "");
        }else{
            $date_time = new DateTime(self::$event['rego_opens_date_c'], new DateTimeZone('UTC'));
            $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
            $date = $date_time->format("j F Y");
            $time = $date_time->format("g:i A");
            self::$event['reg'] = array('date' => $date, 'time' => $time);
            
            if(self::$event['reg']['date'] == self::$event['start']['date1']){
                self::$event['regstart'] = "yes";
            }
        }
        //////////////////
        /// end date ///
        $date_time = new DateTime(self::$event['end_date'], new DateTimeZone('UTC'));
        $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
        $date = $date_time->format("l, j F, Y");
        $time = $date_time->format("g:i A");
        self::$event['end'] = array('date' => $date, 'time' => $time);
     
        ////////////////
        /////////////////////////////////
        //self::$event['event_email'] = "adeelgod@gmail.com";
        //self::$event['listing_type'] = "Express";
        //self::$event['event_theme'] = "Express";
        /*self::$event['event_rego_online'] = "Yes";
        self::$event['event_logo'] = "daa64c19-fcb2-5927-9cfa-5066beaaa859";
        self::$event['event_email'] = "adeelgod@gmail.com";
        self::$event['cpd_points_type_1'] = "3";
        self::$event['description'] = "45 789 789 d";
        self::$event['start_date'] = "2014-09-06 20:30:10";*/
        //self::$event['youtube_c'] = "daa64c19-fcb2-5927-9cfa-5066beaaa859";
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "logger":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/logger.php');
                $processing = new DEProcessing_Dentevents_Details_Logger();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "like":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/like.php');
                $processing = new DEProcessing_Dentevents_Details_Like();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "email":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/email.php');
                $processing = new DEProcessing_Dentevents_Details_Email();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "standard":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/standard.php');
                $processing = new DEProcessing_Dentevents_Details_Standard();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "premium":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium.php');
                $processing = new DEProcessing_Dentevents_Details_Premium();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "show":
                return $this->show($params);
            break;
        }

    }
    
    function show($params = array()){
        if(self::$event['listing_type'] == 'Premium'){
            self::$router = "premium:show";
        }else{
            self::$router = "standard:show";
        }

        return DEProcessing_Dentevents_Details::process($params);
    }
}