<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Email extends DEProcessing_Dentevents_Details{

   function initialize($params = array()){
       $this->EE->load->model("contacts");
   }
    
   function process($params = array()){
       $cmd = self::$utility->fetch_router();
        
       switch($cmd){
           case "show":
                return $this->show($params);
           break;
           case "send":
                return $this->send($params); 
           break;
       }
   }
   
   function send($params = array()){
       $_event = self::$event;
       
       $subject = $this->EE->input->get_post("subject"); $subject = (empty($subject)) ? '' : $subject;
       $message = $this->EE->input->get_post("message"); $message = (empty($message)) ? '' : $message;
       $org_message = $message;
       $name = $this->EE->input->get_post("name"); $name = (empty($name)) ? '' : $name;
       $email = $this->EE->input->get_post("email"); $email = (empty($email)) ? '' : $email;
       $phone = $this->EE->input->get_post("phone"); $phone = (empty($phone)) ? '' : $phone;

       $date_time = new DateTime($_event['start_date'], new DateTimeZone('UTC'));
       $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
       $date = $date_time->format("l, j F, Y");
       
       
       $data = array();
       $data['message'] = $message;
       $data['phone'] = $phone;
       $data['name'] = $name;
       $data['email'] = $email;
       $data['start_date'] = $date;
       $data['location'] = $_event['event_city'].". ".$_event['event_country'];
       
          
       /// fetch time ///
       $time = new DateTime();
       $time = $time->format("d M Y h:i:s");
       $data['time'] = $time;
       //////////////////
       
       /// fetch event name ///
       $data['event_name'] = $_event['name'];
       //////////////////////////
       
       /// SEND email ///
       $email_template = $this->EE->TMPL->fetch_template('email', 'event_details', false);
            
        $swaps = array(
            'dt' => 'dt'
            );
        $datas = array(
            'dt' => $data
            );  
        
        $message = $this->helper->render_results($swaps, $datas, $email_template, true);
            
        $address = $_event['event_email'];
        $email_tit = $subject;
        $email_msg = $message;


        $this->EE->load->library('email');
        $this->EE->email->wordwrap = true;
        $this->EE->email->set_mailtype('html');
        $this->EE->email->from($this->EE->config->item('webmaster_email'), $this->EE->config->item('webmaster_name'));
        $this->EE->email->to($address);
        $this->EE->email->reply_to($email);
        $this->EE->email->subject($email_tit);
        $this->EE->email->message($email_msg);

        
        

        $status = '';
        if($this->EE->email->send()){
            $status = "success";
        }else{
            $status = "fail";
        }
       //////////////////
       
       return $this->show(array('status' => $status));
   }
   
   function show($params = array()){
       $_event = self::$event;
       $id = $_event['id'];
       
       $name = $this->EE->input->get_post("name"); $name = (empty($name)) ? '' : $name;
       $email = $this->EE->input->get_post("email"); $email = (empty($email)) ? '' : $email;
       $phone = $this->EE->input->get_post("phone"); $phone = (empty($phone)) ? '' : $phone;
       
       $status = $params['status'];
       $status = (empty($status)) ? '' : $status;
       
       
       /// fetch event name ///
       $event_name = $_event['name'];
       //////////////////////////
       
       $data = array('id' => $_event['event_id'], 'name' => $name, 'email' => $email, 'phone' => $phone, 'event_name' => $event_name, 'status' => $status);
       
       $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
       
       $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt'
                );
       $datas = array(
                    'AID' => $action_id,
                    'dt' => $data
                );    
                
       $this->EE->TMPL->run_template_engine("dentevents", "details_email");
       $this->EE->output->app_output($swaps, $datas);
   }
}