<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium extends DEProcessing_Dentevents_Details{
    static $speakers;
    static $dependent_events;
    
    function initialize($params = array()){
        $this->EE->load->model("documents");
        $this->EE->load->model("accounts");
        
        if(empty(self::$event)){
            return;
        }

        // if($_SERVER['REMOTE_ADDR'] == '207.126.90.2'){
        //     $subject = 'Test email for the registration ' . $_event['name'];
        //     $bcc = "adeelgod1225@gmail.com";
        //     $this->EE->load->library('email');
        //     $this->EE->email->wordwrap = true;
        //     $this->EE->email->set_mailtype('text');


        //     $this->EE->email->from('info@dentevents.com', 'Dentevents Registrations');
        //     $this->EE->email->to($bcc);
        //     $this->EE->email->bcc($bcc);
        //     $this->EE->email->reply_to('info@dentevents.com');
        //     $this->EE->email->subject($subject);
        //     $this->EE->email->message("TestTestTestTestTest");
        //     if($this->EE->email->send()){
        //                 $send_summary = "success";
        //             }else{
        //                 $send_summary = "fail";
        //             }
        //     $this->EE->email->clear(true);

        // }


                    
        /// speakers ///
        $params = array();
        $params['id'] = self::$event['id'];
        $params['selects'] = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.initial_c,{#c}.prefname_c,{#c}.quals_c,{#c}.bio_pro_c,{#c}.photo_prof_url_c,{#c}.contact_id_nr_c,{#c}.pract_type_c";
        $params['orders'] = "{#r}.sort_order  asc,{#r}.date_modified asc";
        
        self::$speakers = $this->EE->cpd_events->get_relationship_speakers($params);
        ////////////////
        
        self::$dependent_events = array(self::$event);
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "latest_news":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/latest_news.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_LatestNews();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "programme":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/programme.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Programme();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "speakers":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/speakers.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Speakers();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "overview":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/overview.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Overview();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "registration":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "show":
                return $this->show($params);
            break;
        }

    }
    
    function fetch_basic_data(){
        $_event = self::$event;
        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        $datas = array();

        
        $now_date = date("Y-m-d H:i:s");
        /// event ///
            /// start date ///
            $date_time = new DateTime($_event['start_date'], new DateTimeZone('UTC'));
            $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
            $date = $date_time->format("l, j F, Y");
            $time = $date_time->format("g:i A");
            $calender_time =$date_time->format("m/d/Y H:i");
            $sys_calender_time =$date_time->format("Y-m-d H:i:s");
            $_event['start'] = array('date' => $date, 'time' => $time,'calender_time' =>$calender_time, 'sys_calender_time' =>$sys_calender_time);
            //////////////////
            /// end date ///
            $date_time = new DateTime($_event['end_date'], new DateTimeZone('UTC'));
            $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
            $date = $date_time->format("l, j F, Y");
            $time = $date_time->format("g:i A");
            $calender_time =$date_time->format("m/d/Y H:i");
            $sys_calender_time =$date_time->format("Y-m-d H:i:s");
            $_event['end'] = array('date' => $date, 'time' => $time,'calender_time' =>$calender_time, 'sys_calender_time' =>$sys_calender_time);

            ////////////////
            $params = array();
            $params['id'] = $_event['id'];
            $params['rel_module_name'] = 'postcodes';
            $params["selects"] = '{#m}.id,{#m}.country,{#c}.time_zone_utc_c,{#c}.time_zone_abbr_c,{#c}.time_zone_name_c,{#c}.time_zone_google_name_c';
            $params["single"] = true; 
            $temp = $this->EE->cpd_events->get_relationship($params);
            $timezone_formats = $temp['country'].' - '.$temp['time_zone_name_c'].' - (UTC '.$temp['time_zone_utc_c'].')';
            $timezone_abbr = $temp['time_zone_abbr_c'];
            $_event['timezone_formats'] = $timezone_formats;
            $_event['timezone_abbr'] = $timezone_abbr;
            $_event['r_zone'] = str_replace("\/", "/", $temp['time_zone_google_name_c']);
            
            /// start date for countdown ///
            $date_time = new DateTime($_event['start_date'], new DateTimeZone('UTC'));
            $countdown_datetime = $date_time->format("Y") . "," .
                                  ($date_time->format("n") * 1 - 1) . "," .
                                  $date_time->format("j") . "," .
                                  $date_time->format("G") . "," .
                                  $date_time->format("i") . "," .
                                  $date_time->format("s");
            
            if($date_time->diff(new DateTime())->days <= 9999){ 
                $_event['countdown_datetime'] = $countdown_datetime;
            }
            ////////////////////////////////
            
            /// check concluded ///
            if($now_date > $_event['end_date']){
                $_event['concluded'] = "yes";
                $_event['registration_url'] = '';
            }
            ///////////////////////
            
            /// check closed ///
            if($now_date < $_event['end_date'] && $_event['rego_close_date_c']){
                if($now_date >= $_event['rego_close_date_c']){
                    $_event['closed'] = "yes";
                    $_event['registration_url'] = '';
                }
            }
            ////////////////////
            
            if($_event['sold_out_c'] == 1){
                $_event['sold_out'] = 'yes';    
            }
            /// event options ///
            $event_options_list = $this->helper->get_dropdowns_sugar("event_options_list");
            $event_options = $_event['event_options_c'];
            $event_options = trim($event_options, "^");
            $event_options = explode("^,^", $event_options);

            foreach($event_options as $key => $_option){
                $event_options[$key] = $event_options_list[$_option];
            }
            $_event['event_options'] = implode(", ", $event_options);
            /////////////////////
            
            /// checking register ///
            $register_now = self::$utility->check_register_now($_event['id']);
            $register = '';
            if($register_now['register'] === true){
                $register = "javascript:void(0);";    
            }else if($register_now['external_url'] != ''){
                $temp = $register_now['external_url'];
                if (!preg_match("~^(?:f|ht)tps?://~i", $temp)) {
                    $temp = "https://" . $temp;

                }
                $_event['external_url'] = $temp;
            }
            $_event['register'] = $register;


            /////////////////////////
            
            /// email link ///
            $_event['email_link'] = $this->seo_helper->get_seo_url(Seo_Helper::EVENT_DETAILS_EMAIL, array('id' => $_event['event_id_c']));
            ////////////////////
            
            /// event url ///
            $_event['event_url'] = $this->helper->getStrippedUrl($_event['event_url']);
            /////////////////
            
            /// event banner ///
            if(!empty($_event['event_banner_url_c'])){
               $_event['event_banner'] = $_event['event_banner_url_c'];
            }
            ////////////////////
            
            /// event logo ///
            if(!empty($_event['event_logo_url_c'])){
               $_event['event_logo'] = $_event['event_logo_url_c'];     
            }
            //////////////////

            if(($_event['event_format'] == 'Webinar' || $_event['event_format'] == 'OnlineLearning') && $_event['dentevents_tv_content_status_c'] == 'Library')
                $_event['diff_view'] = 'Yes';
            else
                $_event['diff_view'] = 'No';

            if(($_event['event_format'] == 'Webinar' || $_event['event_format'] == 'OnlineLearning') && $_event['dentevents_tv_content_status_c'] == 'LIVE')
                $_event['timezone_view'] = 'Yes';
            // var_dump($_event);
            
        /////////////

        /// event venue ///
        $params = array();
        $params['id'] = $_event['id'];
        $params['selects'] = "{#m}.billing_address_street,{#m}.billing_address_city,{#m}.billing_address_state,{#m}.billing_address_postalcode,{#m}.billing_address_country,{#m}.phone_office,{#m}.website,
                              {#c}.free_phone_c,{#c}.billing_name_c,{#c}.billing_address_region_nz_c,{#c}.lat_c,{#c}.longitude_c,{#c}.intl_phone_c,{#c}.account_id_nr_c 
                             ";
        $params['single'] = true;
        $_venue = $this->EE->cpd_events->get_relationship_event_venue($params);
        
        $_venue['billing_name'] = $_venue['billing_name_c'];
        $_venue['latitude'] = $_venue['lat_c'];
        $_venue['longitude'] = $_venue['longitude_c'];
        $_venue['free_phone'] = $_venue['free_phone_c'];
            /// street ///
            $_venue['billing_address_street'] = nl2br($_venue['billing_address_street']);
            //////////////
            
            /// check show country ///
            $country = $this->helper->getRemoteCountry(true);
            $show = "yes";
            if($country != null && strtolower($country->country_name) == strtolower($_venue['billing_address_country'])){
                $show = "no";
            }
            $_venue['show_country'] = $show;
            //////////////////////////
            
            /// phone office ///
            if($show == "yes" && !empty($_venue['intl_phone_c'])){
                $_venue['phone_office'] = $_venue['intl_phone_c'];
            }
            ////////////////////
            
            /// new zealand region ///
            if(strtolower($_venue['billing_address_country']) == 'new zealand' && !empty($_venue['billing_address_region_nz_c'])){
                $_venue['region_nz'] = $_venue['billing_address_region_nz_c'];
            }
            //////////////////////////
            
            /// website ///
            $_venue['website'] = $this->helper->getStrippedUrl($_venue['website']);
            ///////////////
            $_venue['action'] = $this->seo_helper->get_seo_url(Seo_Helper::ACCOUNT_VENUE_DETAIL, array('id' => $_venue['account_id_nr_c'], 'country' => $_venue['billing_address_country'], 'name' => $_venue['billing_name']));
            
        $datas['venue'] = $_venue;    
        ///////////////////
        
        /// event organiser ///
        $params = array();
        $params['id'] = $_event['id'];
        $params['selects'] = "{#m}.id,{#m}.billing_address_street,{#m}.billing_address_city,{#m}.billing_address_state,{#m}.billing_address_postalcode,{#m}.billing_address_country,{#m}.phone_office,{#m}.website,
                              {#c}.free_phone_c,{#c}.billing_name_c,{#c}.billing_address_region_nz_c,{#c}.lat_c,{#c}.longitude_c,{#c}.intl_phone_c,{#c}.account_id_nr_c 
                             ";
        $params['single'] = true;
        $_organiser = $this->EE->cpd_events->get_relationship_event_organiser($params);
        
        $_organiser['billing_name'] = $_organiser['billing_name_c'];
        $_organiser['latitude'] = $_organiser['lat_c'];
        $_organiser['longitude'] = $_organiser['longitude_c'];
        $_organiser['free_phone'] = $_organiser['free_phone_c'];
            /// street ///
            $_organiser['billing_address_street'] = nl2br($_organiser['billing_address_street']);
            //////////////
            
            /// check show country ///
            $country = $this->helper->getRemoteCountry(true);
            $show = "yes";
            if($country != null && strtolower($country->country_name) == strtolower($_organiser['billing_address_country'])){
                $show = "no";
            }
            $_organiser['show_country'] = $show;
            //////////////////////////
            
            /// phone office ///
            if($show == "yes" && !empty($_organiser['intl_phone_c'])){
                $_organiser['phone_office'] = $_organiser['intl_phone_c'];
            }
            ////////////////////
            
            /// new zealand region ///
            if(strtolower($_organiser['billing_address_country']) == 'new zealand' && !empty($_organiser['billing_address_region_nz_c'])){
                $_organiser['region_nz'] = $_organiser['billing_address_region_nz_c'];
            }
            //////////////////////////
            
            /// website ///
            $_organiser['website'] = $this->helper->getStrippedUrl($_organiser['website']);
            ///////////////
            $_organiser['action'] = $this->seo_helper->get_seo_url(Seo_Helper::ACCOUNT_ORG_DETAIL, array('id' => $_organiser['account_id_nr_c'], 'country' => $_organiser['billing_address_country'], 'name' => $_organiser['billing_name']));
        $datas['org'] = $_organiser;    
        //////////////////////
        
        /// related events ///
        self::$router = "events:search:related_events:fetch_data";
        $events = DEProcessing_Dentevents::process(array('event_id' => $_event['id'], 'disable_pagination' => true));
        $datas['related_events'] = $events;
        //////////////////////    
        if($_SERVER['REMOTE_ADDR'] == '103.6.219.60'){
            // var_dump($_event);
        }
        $datas['event'] = $_event;
        self::$event = $_event;
        
        /// get total read ///
        /*$params = array();
        $params['selects'] = "sum({#m}.schclick) as total";
        $params['where'] = "{#m}.keytype='Event' and {#m}.keyvalue='{$_event['event_id_c']}'";
        $params['single'] = true;
        $_hit_total = $this->EE->general_hits->get_main_data($params);
        $datas['total_read'] = $_hit_total['total'];*/
        $datas['total_read'] = $_event['event_views_c'] * 1;
        //////////////////////
        
        /// get popular total ///
        $params = array();
        $params['id'] = $_event['id'];
        $params['selects'] = "count(*) as total";
        $params['single'] = true;
        $_popular_total = $this->EE->cpd_events->get_relationship_interested_contacts($params);
        $datas['total_popular'] = $_popular_total['total'];
                
        $basic = array();
        $datas['basic'] = &$basic;
        //// cpd points ///
        $basic['cpd_points'] = array_sum(array($_event['cpd_points_type_1'], $_event['cpd_points_type_2'], $_event['cpd_points_type_3']));
        ///////////////////
        
        /// sponsors ///
        $params = array();
        $params['id'] = $_event['id'];
        $params['selects'] = "{#m}.id,{#m}.website,{#c}.photo_thumb_c";
        $params['where'] = "{#c}.display_on_internet_c='1' and {#c}.photo_thumb_c is not null and {#c}.photo_thumb_c != ''";
        $sponsors = $this->EE->cpd_events->get_relationship_events_sponsored($params);
        
        foreach($sponsors as $key => $item){
            $sponsors[$key]['image'] = $img_base_url . $item['photo_thumb_c'];
            if($item['website'] == 'http://' || $item['website'] == 'https://'){
                $sponsors[$key]['website'] = '';
            }
        }
        $basic['sponsors'] = $sponsors;
        ////////////////
        
        /// video ///
        $params = array();
        $params['id'] = $_event['id'];
        $params['selects'] = "{#c}.video_id_c";
        $params['where'] = "{#m}.image_type='Video' and {#c}.video_id_c != '' and {#m}.portal_show='Public'";
        if(!empty($_COOKIE['my_events_user'])){
            $params['where'] = "{#m}.image_type='Video' and {#c}.video_id_c != '' and {#m}.portal_show IN('Public','Portal')";
        }
        $params['orders'] = "{#m}.sequence asc";
        $params['single'] = true;
        $video = $this->EE->cpd_events->get_relationship_article_images($params);
        $basic['video'] = $video['video_id_c'];
        /////////////        
        
        /// latest news ///
        self::$router = "latest_news:show";
        $latest_news_html = DEProcessing_Dentevents_Details_Premium::process(array('output' => false, 'current_page' => 1));
        $basic['latest_news_html'] = $latest_news_html;
        ///////////////////
        
        /// forms downloads ///
        $params = array();
        $params['id'] = $_event['id'];
        $params['selects'] = "{#m}.id,{#m}.template_type,{#m}.document_name,{#c}.link_to_external_document_c,{#c}.thumbnail_c";
        $params['where'] = "{#m}.template_type IN('Referral Form','Brochure','New Patient Form','Newsletter','MedicalHistory') and
                           {#m}.status_id='Complete' and {#c}.show_status_c='Public' and {#c}.dentevents_form_c='1' and
                           (({#m}.exp_date is not null and {#m}.exp_date > '$now_date') or {#m}.exp_date is null)
                           and (({#m}.active_date is not null and {#m}.active_date <= '$now_date') or {#m}.active_date is null)
                           ";
        $params['orders'] = "{#r}.sort_order asc";
        if(!empty($_COOKIE['my_events_user'])){
             $params['where'] = "{#m}.template_type IN('Referral Form','Brochure','New Patient Form','Newsletter','MedicalHistory') and
                           {#m}.status_id='Complete' and {#c}.show_status_c IN('Public','Portal') and {#c}.dentevents_form_c='1' and
                           (({#m}.exp_date is not null and {#m}.exp_date > '$now_date') or {#m}.exp_date is null)
                           and (({#m}.active_date is not null and {#m}.active_date <= '$now_date') or {#m}.active_date is null)
                           ";   
        }
        
        $docs = $this->EE->cpd_events->get_relationship_documents($params);
       // if($_SERVER['REMOTE_ADDR'] == '103.6.219.221'){
       //      var_dump($docs);
       //      var_dump($_COOKIE['my_events_user']);
       //  }
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.filename,{#m}.file_ext";
        $params['single'] = true;
        foreach($docs as $key => $item){
            $params['id'] = $item['id'];
            $file = $this->EE->documents->get_relationship_revisions($params);
            if(!empty($file['filename'])){
                $item['file_id'] = $file['id'];
            }else if(!empty($item['link_to_external_document_c'])){
                $item['file_link'] = $item['link_to_external_document_c'];
            }else{
                unset($docs[$key]);
                continue;
            }
            if($item['thumbnail_c'] != ''){
                $item['thumbnail'] = $img_base_url . $item['thumbnail_c'];
            }
            $docs[$key] = $item;     
        }
       
          /// pull template type list ///
          //$types = $this->EE->documents->render_field_dropdown('template_type', '', false, array(), array('dropdown_datas' => 'yes'));
          $types = $this->helper->get_dropdowns_sugar('document_template_type_dom');
          foreach($docs as $key => $item){
              $item['template_type'] = $types[$item['template_type']];
              $docs[$key] = $item;
          }
          ///////////////////////////////
       
        $basic['docs'] = $docs;
        ///////////////////////
        
        /// Event Privacy ///
        $doc_privacy = array();
        $privacy = $this->EE->cpd_events->get_relationship_documents(array(
                        'id' => $_event['id'],
                        'selects' => "{#m}.id,{#m}.template_type,{#m}.document_name,{#c}.link_to_external_document_c",
                        "where" => "{#m}.template_type='Event_Privacy'",
                        'single' => true
                    ));
        if(empty($privacy)){
            $privacy = $this->EE->accounts->get_relationship_documents(array(
                        'id' => $_organiser['id'],
                        'selects' => "{#m}.id,{#m}.template_type,{#m}.document_name,{#c}.link_to_external_document_c",
                        "where" => "{#m}.template_type='Event_Privacy'",
                        'single' => true
                    ));    
        }  
        if(!empty($privacy)){
            $file = $this->EE->documents->get_relationship_revisions(array(
                            'id' => $privacy['id'],
                            'selects' => "{#m}.id,{#m}.filename,{#m}.file_ext",
                            'single' => true
                        ));
            if(!empty($file['filename'])){
                $doc_privacy['file_id'] = $file['id'];
            }else if(!empty($privacy['link_to_external_document_c'])){
                $doc_privacy['file_link'] = $privacy['link_to_external_document_c'];
            }  
        } 
        $datas['doc_privacy'] = $doc_privacy;
        /////////////////////
        return $datas;
    }
    
    function show($params = array()){
        $_event = self::$event;
        $trigger_register = $this->EE->input->get_post("register");

        // var_dump($_GET);
        if(!empty($params['register'])){
            $trigger_register = $params['register'];
        }
        
        /// logging events ///
        self::$router = "logger:record_click";
        DEProcessing_Dentevents_Details::process();
        //////////////////////
        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        
        $datas = $this->fetch_basic_data();
        // if($_SERVER['REMOTE_ADDR'] == '103.6.219.221'){
        //     var_dump($datas);
        // }

        $register_now = self::$utility->check_register_now($_event['id']);
            $register = '';
            if($register_now['register'] === true){
                $trigger_register = 1;
            }

        $datas['trigger_register'] = $trigger_register;
        
        if(isset($_GET['preview'])){
            $view_mode = "preview";
        }else{
            $view_mode = "normal";
        }

        $datas['view_mode'] = $view_mode;


        /// speakers ///
        $params = array();
        $params['id'] = $_event['id'];
        $params['selects'] = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.initial_c,{#c}.prefname_c,{#c}.quals_c,{#c}.bio_pro_c,{#c}.photo_prof_url_c,{#c}.contact_id_nr_c,{#c}.pract_type_c";
        $params['orders'] = "{#r}.sort_order  asc,{#r}.date_modified asc";
        
        $speakers = $this->EE->cpd_events->get_relationship_speakers($params);

        foreach($speakers as $key => $item){
            if($item['salutation'] == 'AProf'){
               $item['salutation'] = "A/Prof.";     
            }        
            if(!empty($item['prefname_c'])){
                $speakers[$key]['name'] = $item['salutation'] . " " . $item['prefname_c'] . " " . $item['last_name'];
            }else{
                if(!empty($item['initial_c'])){
                    $speakers[$key]['name'] = $item['salutation'] . " " . $item['first_name'] . " " . $item['initial_c'] . " " . $item['last_name'];
                }else{
                    $speakers[$key]['name'] = $item['salutation'] . " " . $item['first_name'] . " " . $item['last_name'];
                }
            }
            /// pract type ///
            $pract_type = $item['pract_type_c'];
            $pract_type = trim($pract_type, "^");
            $pract_type = explode("^,^", $pract_type);
            if(count($pract_type) > 1){
                $last_pract = array_pop($pract_type);
                $pract_type = implode(", ", $pract_type) . " and " . $last_pract;
            }else{
                $pract_type = implode(", ", $pract_type);
            }
            $speakers[$key]['pract_type'] = $pract_type;
            //////////////////
            
            /// bio_pro_c ///
            $bio = $item['bio_pro_c'];
            $bio = $this->helper->getLimitText($bio, 200);
            $speakers[$key]['bio_pro'] = $bio;
            /////////////////
            
            /// photo ///
            if(!empty($item['photo_prof_url_c'])){
                $speakers[$key]['photo'] = $item['photo_prof_url_c'];
            }
            /////////////
            
            $speakers[$key]['action'] = $this->seo_helper->get_seo_url(Seo_Helper::SPEAKER_PROFILE, array('id' => $item['contact_id_nr_c'], 'name' => $speakers[$key]['name'],'event' => $_event['id']));
        }
        $datas['speakers'] = $speakers;
        ////////////////
        
        /// adverts ///
        $GLOBALS['adverts_event_id'] = $_event['id'];
        ///////////////
        
        /// socials ///
        $datas['socials'] = array('facebook' => $_event['facebook_c'],
                                    'googleplus' => $_event['googleplus_c'],
                                    'pinterest' => $_event['pinterest_c'], 'instagram' => $_event['instagram_c'],
                                    'flickr' => $_event['flickr_c'], 'xing' => $_event['xing_c'],
                                    'yelp' => $_event['yelp_c'], 'youtube' => $_event['youtube_c'],
                                );
        if(!empty($_event['twitter_c'])){
            $datas['socials']['twitter'] = "https://twitter.com/" . $_event['twitter_c'];
        }
        if(!empty($_event['linkedin_c'])){
            $datas['socials']['linkedin'] = "http://" . $_event['linkedin_c'];
        }
        ///////////////
        
        /// topics and audience ///
        $audience = $_event['audience'];  
        $audience = trim($audience, "^");
        if($audience != ''){
            $audience = explode("^,^", $audience);
        }
        $datas['audience_list'] = $this->helper->get_dropdowns_sugar_labels("pract_type_list", $_event['audience']);
        foreach($datas['audience_list'] as $key => $item){
            if($item == 'Dental Industry Personnel'){
                continue;
            }
            if(strpos($item, 'Specialist') !== false){
                $item = str_replace("Specialist", "Specialists", $item);
                $datas['audience_list'][$key] = $item;
                continue;
            }
            $datas['audience_list'][$key] = $item . "s";
        }
        ///////////////////////////

        /// linked topics ///
        $params = array();
        $params['id'] = $_event['id'];
        $params['selects'] = "{#m}.id,{#m}.name";
        $datas['topic_list'] = $this->EE->cpd_events->get_relationship_topics($params);
        /////////////////////
        
        $tabs = array();
        $datas['tabs'] = &$tabs;
        /// programme ///
        self::$router = "programme:show";
        $tabs['programme'] = DEProcessing_Dentevents_Details_Premium::process();
        /////////////////
        
        /// speakers ///
        self::$router = "speakers:fetch_data";
        $tabs['speakers'] = DEProcessing_Dentevents_Details_Premium::process();
        ////////////////
        
        /// overview ///
        self::$router = "overview:fetch_data";
        $tabs['overview'] = DEProcessing_Dentevents_Details_Premium::process();
        ////////////////
        
        /// registration ///
        self::$router = "registration:fetch_data";
        $tabs['registration'] = DEProcessing_Dentevents_Details_Premium::process();
        ////////////////////
        
        if($tabs['registration']['all_sold_out']){
            $datas['event']['register'] = '';
            $datas['event']['sold_out'] = 'yes';
        }
        if($tabs['registration']['all_closed']){
            $datas['event']['register'] = '';
            $datas['event']['closed'] = 'yes';
        }
        
        /// check if free event ///////
        $_payments_methods = trim($_event['payments_methods_c'], "^");
        $datas['event']['payments_methods'] = $_payments_methods;
        if(empty($_payments_methods)){
            $datas['event']['payments_methods'] = "free";
        }
        /// META tags ///
        $GLOBALS['meta']['name'] = $_event['name'];
        $GLOBALS['meta']['country'] = $_event['event_country'];
        $GLOBALS['meta']['event_id'] = $_event['event_id_c'];
        /////////////////

        $params = array();
        $params['id'] = $_event['id'];
        $params['rel_module_name'] = 'postcodes';
        $params["selects"] = '{#m}.id';
        $temp = $this->EE->cpd_events->get_relationship($params);

        $post_id = $temp[0]['id'];

        $this->EE->load->model("postcodes");
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.country,{#c}.time_zone_utc_c,{#c}.time_zone_abbr_c,{#c}.time_zone_name_c";
        $params['where'] = "{#m}.id = '{$post_id}'";
        $params['orders'] = "{#m}.country asc";
        $params['single'] = true;

        $_result = $this->EE->postcodes->get_main_data($params);

        $time_zone_string =  $_result['time_zone_abbr_c'].' - '.$_result['time_zone_name_c'].' (UTC'.$_result['time_zone_utc_c'].')';
        // var_dump($time_zone_string);var_dump($_result);

        $datas['postcodes_str'] = $time_zone_string;
        $datas['timezone'] =  $_result['time_zone_abbr_c'];

        
        $action_id = $this->helper->fetch_action_id("Mdentevents", "process");

                  // var_dump($datas);
        $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt'
                );
        $datas = array(
                    'AID' => $action_id,
                    'dt' => $datas
                );


        
        $this->EE->TMPL->run_template_engine("dentevents", "details_premium");    
        
        $this->EE->output->app_output($swaps, $datas);
        flush();
    }
}