<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Overview extends DEProcessing_Dentevents_Details_Premium{

    function initialize($params = array()){
        
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "exhibitors":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/overview/exhibitors.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Overview_Exhibitors();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "fetch_data":
                return $this->fetch_data();
            break;
        }

    }
    
    function fetch_data($sparams = array()){
        $_event = self::$event;
        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        
        $datas = array();
        
        /// images ///
        $params = array();
        $params['id'] = $_event['id'];
        $params['selects'] = "{#m}.id,{#m}.article_image,{#m}.description";
        $params['where'] = "{#m}.image_type='Photograph' and {#m}.image_format='News' and {#m}.portal_show='Public'";
        $params['orders'] = "{#r}.sort_order  asc,{#r}.date_modified asc,{#m}.sequence asc,{#m}.date_entered asc";
        $images = $this->EE->cpd_events->get_relationship_article_images($params);   
        foreach($images as $key => $item){
            if(!empty($images[$key]['article_image'])){
                $images[$key]['article_image'] = $img_base_url . $images[$key]['article_image'];    
            }
        }
        $datas['images'] = $images;
        //////////////
        
        /// boards ///
        $board_maps = array();
        $board_maps[] = array('head' => 'Overview', 'desc_field' => 'overview_detail_c', 'head_field' => 'overview_c');
        if($_event['event_format'] == 'OnlineLearning' || $_event['event_format'] == 'Webinar'){
            $datas['page_style'] = "other_style";
        }else{
            $board_maps[] = array('head' => 'More Information', 'desc_field' => 'more_info', 'head_field' => 'more_info_heading_c');    
        }
        
        $board_maps[] = array('head' => 'What To Bring', 'desc_field' => 'what_to_bring_c', 'head_field' => '');
        $board_maps[] = array('head' => 'Accommodation Information', 'desc_field' => 'accommodation_info_c', 'head_field' => '');
        $boards = array();
        
        $idx = 1;
        foreach($board_maps as $item){
            $desc = $_event[$item['desc_field']];
            if(empty($desc)){
                continue;
            }
            
            $head_field = $_event[$item['head_field']];
            if(($idx == 2) && ($head_field == "OFF")){
                continue;
            }
            
            $head = $item['head'];
            if(!empty($item['head_field']) && !empty($_event[$item['head_field']])){
                $head = $_event[$item['head_field']];
            }
            
            $boards[] = array('head' => $head, 'description' => $desc, 'idx' => $idx++);
        }
        $datas['boards'] = $boards;
        ///////////////
        
        /// exhibitors ///
        $datas['exhibitors'] = array();
        
        self::$router = "exhibitors:show";
        $exhibitors_html = DEProcessing_Dentevents_Details_Premium_Overview::process(array('output' => false, 'current_page' => 1));
        $datas['exhibitors']['html'] = $exhibitors_html;
        
        self::$router = "exhibitors:selectors";
        $selectors = DEProcessing_Dentevents_Details_Premium_Overview::process(array('output' => false, 'current_page' => 1));
        $datas['exhibitors']['selectors'] = $selectors;
        ///////////////////
        
        /// check empty ///
        if(empty($datas['images']) && empty($datas['boards']) && empty($datas['']) && empty($datas['exhibitors']['html'])){
             $datas['is_empty'] = "yes";
        }
        ///////////////////
        
        return $datas;
    }
}