<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Overview_Exhibitors extends DEProcessing_Dentevents_Details_Premium_Overview{

    static $list;
    protected $current_page;
    
    function initialize($params = array()){
        $this->EE->load->model("cpd_events");
                
        $event_id = self::$event['id'];
        $now_date = date("Y-m-d");
        
        $current_page = $this->EE->input->get_post('current_page');
        if(!empty($params['current_page'])){
            $current_page = $params['current_page'];
        }
        $this->current_page = $current_page;
        
        $selector = $this->EE->input->get_post("selector");
        
        $params = array();
        $params['id'] = $event_id;
        $params['selects'] = "{#m}.id,{#m}.billing_address_city,{#m}.billing_address_state,{#m}.billing_address_postalcode,billing_address_country,{#c}.billing_name_c,{#c}.account_type_new_c,{#c}.account_id_nr_c";
        $params['where'] = "{#c}.display_on_internet_c='1'";
        
        if(!empty($selector)){
            if($selector == 'num'){
                $params['where'] .= " and {#c}.billing_name_c REGEXP '^[0-9]'";
            }else{
                $params['where'] .= " and {#c}.billing_name_c like '{$selector}%'";
            }
        }
        
        $params['orders'] = "{#c}.billing_name_c asc";
        
        self::$list = $this->EE->cpd_events->get_relationship_sponsors($params);
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "fetch_data":
                return $this->fetch_data($params);
            break;
            case "selectors":
                return $this->selectors($params);
            break;
            case "show":
                return $this->show($params);
            break;
        }

    }
    
    function selectors($params=''){
        $items_per_page = $this->_app_config['pagination']['events:details:premium:exhibitors']['items_per_page'];
        
        if(count(self::$list) <= $items_per_page){
            return '';
        } 
        
        $selectors = array();
        
        $numeric = '';
        foreach(self::$list as $item){
            $name = strtolower($item['billing_name_c']);    
            $name = substr($name, 0, 1);
            if(is_numeric($name)){
                $numeric = '123';
                continue;
            }
            if(!ctype_alpha($name)){
                continue;
            }
            
            $selectors[] = $name;
        }
        $selectors = array_unique($selectors);
        
        return array('num' => $numeric, 'letters' => $selectors);
    }
    
    function fetch_data($params=''){
        $disable_pagination = $params['disable_pagination'];
        
        /// INITIALIZE the pagination ///
        $current_page = $this->current_page;
        $items_per_page = $this->_app_config['pagination']['events:details:premium:exhibitors']['items_per_page'];
        $items_per_navigation = $this->_app_config['pagination']['events:details:premium:exhibitors']['items_per_navigation'];
        if(empty($current_page)){
             $current_page = 1;
        }
        $totals = count(self::$list);
        //////////////////////////////////
        
        $offset = ($current_page - 1) * $items_per_page;
        $list = array_slice(self::$list, $offset, $items_per_page);
        if($disable_pagination === true){
            $list = self::$list;
        }
        
        /// logging events ///
        //self::$router = "logger:record_events";
        //DEProcessing_Dentevents::process(array('events' => $events));
        //////////////////////
        
        $image_base_url = $this->_crm_config['main']['upload_url'];
        
        $limit_text_length = 50;
        if($this->helper->is_mobile_device()){
            $limit_text_length = 40;    
        }
        
        
        foreach($list as $key => $item){
            $list[$key]['billing_name'] = $item['billing_name_c'];
            $list[$key]['account_type_new'] = $item['account_type_new_c'];
                        
            /// action ///
            $list[$key]['action'] = $this->seo_helper->get_seo_url(Seo_Helper::ACCOUNT_EXHIBITOR_DETAIL, array('id' => $item['account_id_nr_c'], 'country' => $item['billing_address_country'], 'name' => $item['billing_name_c']));
            //////////////
            
        }
        
        return $list;
    }
    
    private function _prepare_pagination(){
        $totals = count(self::$list);
        /// INITIALIZE the pagination ///
        $current_page = $this->current_page;
        $items_per_page = $this->_app_config['pagination']['events:details:premium:exhibitors']['items_per_page'];
        $items_per_navigation = $this->_app_config['pagination']['events:details:premium:exhibitors']['items_per_navigation'];
        if(empty($current_page)){
             $current_page = 1;
        }
        //////////////////////////////////
        
        $totals = ceil($totals / $items_per_page);
        
        $start_page_number =  (int)(($current_page - 1) / $items_per_navigation) * $items_per_navigation + 1;
        $end_page_number = $start_page_number + $items_per_navigation - 1;
        $end_page_number = min($totals, $end_page_number);
        
        /// FETCH datas ///
        $datas = array();
        if($start_page_number == 1){
             $datas['start_class'] = 'disabled';
        }
        if($end_page_number == $totals){
             $datas['end_class'] = 'disabled';
        }
        if ($current_page == 1)
             $datas['prev_class'] = 'disabled';  
        if ($current_page == $totals)
             $datas['next_class'] = 'disabled';       
        
        $datas['links'] = array();
        for ($i = $start_page_number; $i < $end_page_number + 1; $i++){
            $active = '';
            if($i == $current_page){
                $active = "active";    
            }
            $datas['links'][] = array('number' => $i, 'active' => $active); 
        }
         
        $datas['current_page'] = $current_page;
        $datas['total_pages'] = $totals;
        ///////////////////
        
        return $datas;
    }
    
    function show($params=''){
        if($params['output'] === false && empty(self::$list)){
            return '';
        }
        
        $datas = array();
        $datas['list'] = $this->fetch_data($params);
        $datas['totals'] = count(self::$list);
        $pagination = $this->_prepare_pagination();
        
        $swaps = array(
                    'dt' => 'dt',
                    'pagination' => 'pagination'
                );
        $datas = array(
                    'dt' => $datas,
                    'pagination' => $pagination
                );
        $TMPL = new EE_Template();         
        $TMPL->run_template_engine('dentevents', 'details_premium_overview_exhibitors');
        $html = $this->EE->output->app_output($swaps, $datas, array('output' => false));  
        
        if($params['output'] === false){
            return $html;
        }
        
        echo $html;
        exit;
    }
}