<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Programme_Sessions extends DEProcessing_Dentevents_Details_Premium_Programme{
    
    function initialize($params = array()){
        $this->EE->load->model("topics");
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "show":
                return $this->show($params);
            break;
        }

    }
    
       
    function show($params=''){
        $sparams = $params;
        $_event = self::$event;
        
        $parent_id = $sparams['parent_id'];
        if(empty($parent_id)){
            $parent_id = $_event['id'];
        }
        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        $datas = array();
        /// get sessions ///
        $params = array();
        $params['id'] = $parent_id;
        $params['selects'] = "{#m}.id,{#m}.start_date,{#m}.end_date,{#m}.event_rego_online,{#m}.name,{#m}.description,{#m}.registration_url,{#m}.event_format,{#m}.event_max_attendance,{#m}.audience,{#c}.rec_type_c,{#c}.session_location_c,
                              {#c}.cpd_points_total_c,{#c}.message_1_c,{#c}.message_2_c,{#c}.message_3_c,{#c}.message_4_c,{#c}.sold_out_c,{#c}.session_name_override_c
                             ";
        $params['where'] = "{#c}.rec_type_c IN('Session','Break')";
        $params['orders'] = "{#m}.start_date asc";
        $sessions = $this->EE->cpd_events->get_relationship_streams_sessions($params);
        ////////////////////
        if($_SERVER['REMOTE_ADDR'] == '103.6.219.221'){
            // var_dump($sessions);
        }
        self::$dependent_events = array_merge(self::$dependent_events, $sessions);

        if(empty($sessions)){
            if($sparams['output'] === false){
                 return '';     
            }
            echo '';exit;
        }
        
        $session_number = 1;
        foreach($sessions as $key => $item){
            //$sessions[$key]['description'] = 'ddd';
            $sessions[$key]['rec_type'] = $item['rec_type_c'];
            $sessions[$key]['session_location'] = $item['session_location_c'];
            $sessions[$key]['registration_url'] = $this->helper->getStrippedUrl($item['registration_url']);
            
            /// session number ///
            if($item['rec_type_c'] == 'Session'){
                $sessions[$key]['session_number'] = $session_number++;
            }
            //////////////////////
            
            /// start date ///
            $start_date = $item['start_date'];
            $start_date = new DateTime($start_date, new DateTimeZone('UTC'));
            $start_date->setTimezone( new DateTimeZone("Australia/Sydney"));
            $sessions[$key]['start_date'] = $start_date->format("G.i");
            //////////////////
            
            /// end date ///
            $end_date = $item['end_date'];
            $end_date = new DateTime($end_date, new DateTimeZone('UTC'));
            $end_date->setTimezone( new DateTimeZone("Australia/Sydney"));
            $sessions[$key]['end_date'] = $end_date->format("G.i");
            ////////////////
            
            /// speakers ///
            $params = array();
            $params['id'] = $item['id'];
            $params['selects'] = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.contact_id_nr_c,{#c}.prof_photo_c,{#c}.photo_prof_url_c,{#c}.prefname_c,{#c}.initial_c,{#c}.quals_c,{#c}.bio_pro_c,{#c}.pract_type_c";
            $speakers = $this->EE->cpd_events->get_relationship_speakers($params);
            
            if(!empty($speakers)){
                self::$speakers = array_merge(self::$speakers, $speakers);
            }
            
            $names = array();
            $sliders = array();

            foreach($speakers as $key1 => $item1){
                if($item1['salutation'] == 'AProf'){
                    $item1['salutation'] = "A/Prof";
                }
                /// name ///
                $name = '';
                if(!empty($item1['prefname_c'])){
                    $name = $item1['salutation'] . " " . $item1['prefname_c'] . " " . $item1['last_name'];
                }else{
                    if(!empty($item1['initial_c'])){
                        $name = $item1['salutation'] . " " . $item1['first_name'] . " " . $item1['initial_c'] . " " . $item1['last_name'];
                    }else{
                        $name = $item1['salutation'] . " " . $item1['first_name'] . " " . $item1['last_name'];
                    }
                }
                $url = $this->seo_helper->get_seo_url(Seo_Helper::SPEAKER_PROFILE, array('id' => $item1['contact_id_nr_c'], 'name' => $name));
                $name = "<a href='{$url}' target='_blank'>{$name}</a>";
                $names[] = $name;
                /////////////
                
                /// slider ///
                $image = '';
                if(!empty($item1['prof_photo_c'])){
                    // $image = $img_base_url . $item1['prof_photo_c'];
                    $image = $item1['photo_prof_url_c'];
                    $image = "<li><a href='{$url}' target='_blank'><img width='200' src='{$image}'/></a></li>";
                    $sliders[] = $image;
                }
                //////////////
            }
            if(sizeof($names) > 1){
                $sessions[$key]['speakers_single'] = 'yes';
            }else{
                $sessions[$key]['speakers_single'] = '';
            }
            $sessions[$key]['speakers_names'] = implode(", ", $names);
            $sessions[$key]['speakers_sliders'] = implode(", ", $sliders);
            //////////////// 

            //// related topic ////
            $topics = $this->EE->cpd_events->get_relationship_topics(array(
                    'id' => $item['id'],
                    'selects' => "{#m}.id,{#m}.name"                    
                ));
            $topic_names = array();
            foreach ($topics as $key2 => $item2) {
                $topic_name = $item2['name'];
                $topic_name = "<span>{$topic_name}</span>";
                $topic_names[] = $topic_name;
            }

            if(sizeof($topic_names) > 1){
                $sessions[$key]['topic_single'] = 'yes';
            }else{
                $sessions[$key]['topic_single'] = '';
            }
            $sessions[$key]['topic_names'] = implode(", ", $topic_names);
            /////////

            ///// audience /////
            $audience = $item['audience'];
            $audience = trim($audience, "^");
            if($audience != ''){
                $audience = explode("^,^", $audience);
            }
            $audiences = array();
            foreach ($audience as $key3 => $item3) {
                $audience_name = "<span>{$item3}</span>";
                $audiences[] = $audience_name;
            }

            if(sizeof($audiences) > 1){
                $sessions[$key]['audience_single'] = 'yes';
            }else{
                $sessions[$key]['audience_single'] = '';
            }
            $sessions[$key]['audiences'] = implode(", ", $audiences);
            ///////////////////

            /// sponsors///
            $params = array();
            $params['id'] = $item['id'];
            $params['selects'] = "{#m}.id,{#m}.website,{#c}.photo_thumb_c,{#c}.logo_c";
            $params['single'] = true;
            $sponsor = $this->EE->cpd_events->get_relationship_events_sponsored($params);
            if(!empty($sponsor)){
                if(!empty($sponsor['photo_thumb_c'])){
                   $sponsor['image'] = $img_base_url . $sponsor['photo_thumb_c'];
                }else if(!empty($sponsor['logo_c'])){
                   $sponsor['image'] = $img_base_url . $sponsor['logo_c']; 
                }
                $sponsor['website'] = $this->helper->getStrippedUrl($sponsor['website']);
            }
            
            $sessions[$key]['sponsor_website'] = $sponsor['website'];
            $sessions[$key]['sponsor_image'] = $sponsor['image'];
            ///////////////
            
            /// summary list ///
            $summary_list_idx = 0;
            $summary_list = '';
            if(!empty($item['event_format']) && $summary_list_idx < 4){
                $event_format_label = $this->helper->get_dropdowns_sugar_labels("Event_Format_list", $item['event_format'], false);
                $summary_list .= "<li>{$event_format_label}</li>"; $summary_list_idx++;
            }
            if(!empty($item['event_max_attendance']) && $item['event_max_attendance'] != 0 && $summary_list_idx < 4){
                $reserve_ticket = self::$utility->load_reserve_tickets($item);
                
                if($reserve_ticket['status'] == 'sold-out'){
                    $text = "SOLD OUT";
                }else if($reserve_ticket['status'] == 'unavailable'){
                    $text = "Unavailable";
                }else{
                    $remains = $reserve_ticket['remains'];
                    $text = "ONLY {$remains} Place";
                    if($remains > 1){
                        $text .= "s";
                    }
                }
                
                $summary_list .= "<li class='red'>{$text}</li>"; $summary_list_idx++;
            }
            if(!empty($item['cpd_points_total_c']) && $item['cpd_points_total_c'] != 0 && $summary_list_idx < 4){
                $summary_list .= "<li>{$item['cpd_points_total_c']} CPD Points</li>"; $summary_list_idx++;
            }
            if(!empty($item['message_1_c']) && $summary_list_idx < 4){
                $message1 = $this->helper->getLimitText($item['message_1_c'], 20);
                $summary_list .= "<li>{$message1}</li>"; $summary_list_idx++;
            }
            if(!empty($item['message_2_c']) && $summary_list_idx < 4){
                $message2 = $this->helper->getLimitText($item['message_2_c'], 20);
                $summary_list .= "<li>{$message2}</li>"; $summary_list_idx++;
            }
            if(!empty($item['message_3_c']) && $summary_list_idx < 4){
                $message3 = $this->helper->getLimitText($item['message_3_c'], 20);
                $summary_list .= "<li>{$message3}</li>"; $summary_list_idx++;
            }
            if(!empty($item['message_4_c']) && $summary_list_idx < 4){
                $message4 = $this->helper->getLimitText($item['message_4_c'], 20);
                $summary_list .= "<li>{$message4}</li>"; $summary_list_idx++;
            }
            $sessions[$key]['summary_list'] = $summary_list;
            ////////////////////
                 
        }

        $datas['sessions'] = $sessions;
        $swaps = array(
                    'dt' => 'dt',
                );
        $datas = array(
                    'dt' => $datas,
                );
        $TMPL = new EE_Template();         
        $TMPL->run_template_engine('dentevents', 'details_premium_programme_sessions');
        $html = $this->EE->output->app_output($swaps, $datas, array('output' => false));  
        
        if($sparams['output'] === false){
            return $html;
        }
        
        echo $html;
        exit;
    }
    
}