<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Registration extends DEProcessing_Dentevents_Details_Premium{
    static $_selects_regooptions = '';
    static $organiser = '';
    static $reserve_ticket = '';
    static $cookie_reserve_ticket;
    static $register_contact;
    static $registered = '';
    static $all_registrants = array();
    // debugging_start
    function logConsole($name, $data = NULL, $jsEval = FALSE)
 {
      if (! $name) return false;

      $isevaled = false;
      $type = ($data || gettype($data)) ? 'Type: ' . gettype($data) : '';

      if ($jsEval && (is_array($data) || is_object($data)))
      {
           $data = 'eval(' . preg_replace('#[\s\r\n\t\0\x0B]+#', '', json_encode($data)) . ')';
           $isevaled = true;
      }
      else
      {
           $data = json_encode($data);
      }

      # sanitalize
      $data = $data ? $data : '';
      $search_array = array("#'#", '#""#', "#''#", "#\n#", "#\r\n#");
      $replace_array = array('"', '', '', '\\n', '\\n');
      $data = preg_replace($search_array,  $replace_array, $data);
      $data = ltrim(rtrim($data, '"'), '"');
      $data = $isevaled ? $data : ($data[0] === "'") ? $data : "'" . $data . "'";

$js = <<<JSCODE
\n<script>
 // fallback - to deal with IE (or browsers that don't have console)
 if (! window.console) console = {};
 console.log = console.log || function(name, data){};
 // end of fallback

 console.log('$name');
 console.log('------------------------------------------');
 console.log('$type');
 console.log($data);
 console.log('\\n');
</script>
JSCODE;

      echo $js;
 } # end logConsole
    // debugging_end        
    function initialize($params = array()){
        
        $this->EE->load->model('cpd_activity');
        $this->EE->load->model("cpd_eventregooptions");
        $this->EE->load->model("publication");
        $this->EE->load->model('reserve_tickets');
        $this->EE->load->model('accounts');
        $this->EE->load->model('grp_groups');
        $this->EE->load->model('grp_group_members');
        
        if(empty(self::$event)){
            return;
        }
        
        self::$_selects_regooptions = "{#m}.id,{#m}.name,{#m}.audience,{#m}.event_part_attend,{#m}.currency,{#m}.base_rate,
                                 {#m}.earlybird_cutoff,{#m}.earlybird_discount,{#m}.member_discount_rate,{#m}.subscriber_discount_rate,{#m}.cumulative_discounts,{#c}.include_tax_c,{#c}.tax_rate_c,{#c}.tax_name_c,  
                                 {#c}.option_type_c,{#c}.accept_bookings_c,{#c}.option_group_c,{#c}.sub_disc_pub_c,{#c}.audience_show_c,{#c}.allow_guests_c,{#c}.guest_limit_c,{#c}.sold_out_c,{#c}.guest_text_override_c,{#c}.sort_order_c,{#c}.auto_opt_in_c,{#c}.option_message_c,{#c}.force_option_selection_c,{#c}.force_option_error_msg_c,{#c}.groups_to_exclude_c,{#c}.groups_to_exclude_message_c,{#c}.registrant_no_c,{#c}.registrant_no_message_main_c,{#c}.charge_fta_only_message_c,{#c}.charge_fta_only_c,{#c}.hide_price_c";
        
        
        /// organiser ///
        $params = array();
        $params['id'] = self::$event['id'];

        $params['selects'] = "{#m}.id,{#m}.name,{#m}.phone_office,{#m}.billing_address_city,{#m}.billing_address_state,{#m}.billing_address_postalcode,{#m}.billing_address_street,{#m}.billing_address_country,{#c}.contact_id1_c,{#c}.contact_id_c,{#c}.logo_c,{#c}.billing_name_c,{#c}.tax_nr_c,{#c}.free_phone_c,{#c}.free_fax_c, {#m}.phone_fax, {#c}.paypal_api_username_c, {#c}.paypal_api_password_c, {#c}.paypal_merchant_id_c";
        $params['single'] = true;
        //var_dump(self::$_selects_regooptions);
        self::$organiser = $this->EE->cpd_events->get_relationship_organiser($params);
        
        /// reserve_ticket ///
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");


        
        $register_btn = $this->EE->input->get_post("register_btn");            
        if($register_btn == "yes"){
            $this->do_apply_reset();
        }else{
            if($primary_rego_id != false){
                self::$cookie_reserve_ticket = self::$utility->load_cookie_reserve_ticket(self::$event, $primary_rego_id);
                
                $reserve_ticket = '';
                if(self::$cookie_reserve_ticket['id_for_master'] != ''){
                    $reserve_ticket = self::$utility->get_reserve_ticket(self::$cookie_reserve_ticket['id_for_master']);
                    if(empty($reserve_ticket)){
                        $this->do_apply_reset();
                    }
                }
                self::$reserve_ticket = $reserve_ticket;
                
            }    
        }
        //////////////////////

    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();

        switch($cmd){
            case "options":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/options.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Options();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "registrants":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/registrants.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Registrants();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "payment":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/payment.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Payment();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "success":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/success.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Success();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "wallet":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/wallet.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Wallet();
                $processing->initialize($params);
                return $processing->process($params);
            case "receipt":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/receipt.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Receipt();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "summary":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/summary.php');
             
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Summary();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "reset":
                return $this->do_reset();
            break;
            case "close":
                return $this->do_close();
            break;
            case "fetch_data":
                return $this->fetch_data();
            break;
            case "show":
                return $this->show($params);
            break;
            case "sendemail":
                return $this->sendEmail($params);
            break;
            case "payment_fail":
                return $this->set_fail_log();
            break;
        }

    }
    protected function get_address_principal_registrant($act_id){
        $_principal_act = $this->EE->cpd_activity->get_main_data(array(
                    'selects' => "{#m}.id,{#c}.address_used_c",
                    'where' => "{#m}.id='{$act_id}'",
                    'single' => true
                ));
        $_principal_registrant = $this->EE->cpd_activity->get_relationship_contacts(array(   
                                    'id' => $act_id,
                                    'selects' => "{#m}.id,{#m}.alt_address_street,{#m}.alt_address_city,{#m}.alt_address_state,{#m}.alt_address_postalcode,{#m}.alt_address_country,{#c}.account_id_c",
                                    'single' => true
                                ));        
        $address = array();
        if($_principal_act['address_used_c'] == 'Principle'){
            /// principal account ///
            $params = array();
            $params['selects'] = "{#m}.id,{#m}.billing_address_street,{#m}.billing_address_city,{#m}.billing_address_state,{#m}.billing_address_postalcode,{#m}.billing_address_country,{#c}.billing_name_c";
            $params['where'] = "{#m}.id='{$_principal_registrant['account_id_c']}'";
            $params['single'] = true;
            $principal_account = $this->EE->accounts->get_main_data($params);
            ///////////////
            $address['name'] = $principal_account['billing_name_c'];
            $address['city'] = $principal_account['billing_address_city'];
            $address['state'] = $principal_account['billing_address_state'];
            $address['postalcode'] = $principal_account['billing_address_postalcode'];
            $address['street'] = $principal_account['billing_address_street'];
            $address['country'] = $principal_account['billing_address_country'];
        }else{
            $address['city'] = $_principal_registrant['alt_address_city'];
            $address['state'] = $_principal_registrant['alt_address_state'];
            $address['postalcode'] = $_principal_registrant['alt_address_postalcode'];
            $address['street'] = $_principal_registrant['alt_address_street'];
            $address['country'] = $_principal_registrant['alt_address_country'];
        }
        
        return $address;
    }  
    
    function prepare_rego_option($item){
        $_event = self::$event;
        
        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        $now_date = date("Y-m-d");
       
        /// check tax ////
        if($item['include_tax_c'] == 1){
            $item['base_rate'] = $item['base_rate'] * 1 + $item['base_rate'] * $item['tax_rate_c'] / 100;
            $item['member_discount_rate'] = $item['member_discount_rate'] * 1 + $item['member_discount_rate'] * $item['tax_rate_c'] / 100;
            $item['earlybird_discount'] = $item['earlybird_discount'] * 1 + $item['earlybird_discount'] * $item['tax_rate_c'] / 100;
            $item['subscriber_discount_rate'] = $item['subscriber_discount_rate'] * 1 + $item['subscriber_discount_rate'] * $item['tax_rate_c'] / 100;
        }
        //////////////////
        
        $row = $item;
        $row['accept_bookings'] = $item['accept_bookings_c'];
        $row['option_type'] = $item['option_type_c'];
        $row['option_group'] = $item['option_group_c'];
        $subscriber_discount_rate = $item['subscriber_discount_rate']; 
        
        /// check register ///
        if($item['accept_bookings_c'] == 1 && $_event['event_rego_online'] == 'Yes' && $_event['register'] != ''){
           $row['can_register'] = 1;    
        }
        //////////////////////
        
        /// audience ///
        if(!empty($item['audience_show_c'])){
            $audience = $this->helper->get_dropdowns_sugar_labels('audience_show_list', $item['audience_show_c']);
            $audience = implode(", ", $audience);
        }else{
            $audience = $this->helper->get_dropdowns_sugar_labels('pract_type_list', $item['audience']);
            if(empty($audience)){
                $audience = "All";
            }
            $audience = implode(", ", $audience);
        }
        $row['audience'] = $audience;
        ////////////////
        if(empty($item['currency'])){
            $item['currency'] = 'AUD';
        }
        
        $currency = $this->helper->get_dropdowns_sugar_labels('acc_currency_list', $item['currency'], false) . " "; 
        $currency_baserate = $currency . $this->helper->toFixed($item['base_rate'], 2);
        $fta_baserate = $currency . "0.00";
        $member_discount_rate = $item['member_discount_rate'] * 1;
        /// earlybird_cutoff ///
        $earlybird_cutoff = '';
        $earlybird_cutoff_diff = '';
        $earlybird_cutoff_format = '';
        if(!empty($item['earlybird_cutoff'])){
            $earlybird_cutoff = new DateTime($item['earlybird_cutoff']);
            $earlybird_cutoff_diff = $earlybird_cutoff->diff(new DateTime())->days;
            $earlybird_cutoff_format = $earlybird_cutoff->format("M d, Y");    
            $earlybird_cutoff = $earlybird_cutoff->format("Y-m-d");    
        }
        ////////////////////////
        
        /// check relationship to member_discounts ///
        $member_discounts = $this->EE->cpd_eventregooptions->get_relationship_member_discounts(
                               array('selects' => '{#m}.id', 'id' => $item['id'])
                             );
        
        //////////////////////////////////////////////
        $row['color_class'] = '';
        /// a1 a2 a3 ///
        $row['a1'] = $this->helper->get_dropdowns_sugar_labels('event_part_attend_list', $item['event_part_attend'], false);
        $row['a2'] = $currency_baserate;
        $row['a3'] = '&nbsp;';
        if($item['include_tax_c'] == 1 && !empty($item['tax_rate_c'])){
            $tax_rate = $this->helper->toFixed($item['tax_rate_c'], 0);
            $row['a3'] = "Including {$tax_rate}% {$item['tax_name_c']}";
        }
        if($item['charge_fta_only_c'] == 1){
            $row['a2'] = $fta_baserate;
            $row['a3'] = "Including 0% GST";
        }
        ////////////////
        
        /// b1 b2 b3 ///
        $row['b1'] = '&nbsp;';
        $row['b2'] = '&nbsp;';
        $row['b3'] = '&nbsp;';
        if(!empty($item['earlybird_discount']) && $item['earlybird_discount'] * 1 > 0){
            $row['b1'] = 'Early Bird Discount';        
            $row['b2'] = "Less $currency" . $this->helper->toFixed($item['earlybird_discount'], 2);    
            if($earlybird_cutoff >= $now_date){
                $row['b3'] = "Before {$earlybird_cutoff_format}";
                if($earlybird_cutoff_diff < 7){
                    $row['b3'] = $row['b3'];
                    $row['b3_alert'] = "yes";
                }
            }else{
                $row['b3'] = "Expired";
            }    
        }

        if($item['charge_fta_only_c'] == 1){
            $row['color_class'] = 'red';
            $row['b1'] = 'Failure to Attend';
            $row['b2'] = $currency_baserate;
            $row['b3'] = '&nbsp;';
            if($item['include_tax_c'] == 1 && !empty($item['tax_rate_c'])){
                $tax_rate = $this->helper->toFixed($item['tax_rate_c'], 0);
                $row['b3'] = "Including {$tax_rate}% {$item['tax_name_c']}";
            }
        }
        ////////////////
        
        /// c1 c2 c3 ///
        $row['c1'] = '&nbsp;';
        $row['c2'] = '&nbsp;';
   
        if(!empty($member_discount_rate) && $member_discount_rate * 1 > 0){
            $row['c1'] = 'Member Discount';   
            $row['c2'] = "Less $currency" . $this->helper->toFixed($member_discount_rate, 2); 

            $_dis_accounts = $this->EE->cpd_eventregooptions->get_relationship_member_discounts(array(
                                                'id' => $item['id'],
                                                'selects' => "{#c}.billing_name_c as name",
                                                'to_values' => 'name'
                                            ));       
            if(!empty($_dis_accounts)){
                $msg = "This discount will automatically be applied to current Members of the following organisations:<br/>";                                   
                $msg .= implode("<br/>", $_dis_accounts);
                $msg = htmlspecialchars($msg);
                $row['c3'] = $msg;
            }
        }
        ////////////////
        
        /// d1 d2 d3 ///
        $row['d1'] = '&nbsp;';
        $row['d2'] = '&nbsp;';
        $row['d3'] = '&nbsp;';
        if(!empty($subscriber_discount_rate) && $item['subscriber_discount_rate'] * 1 > 0){
            $row['d1'] = 'Subscriber Discount';        
            $row['d2'] = "Less $currency" . $this->helper->toFixed($item['subscriber_discount_rate'], 2);        
        }
        
        
        ////////////////

        ////// registrant no message main ////
        $registrant_no_message_main = '';
        $alternate_options_message = '';
        if(($item['registrant_no_c'] == '' || $item['registrant_no_c'] == '1') && (!empty($item['registrant_no_message_main_c']))){
            $registrant_no_message_main = $item['registrant_no_message_main_c'];
        }

        $alternate_options = $this->EE->cpd_eventregooptions->get_relationship_alternate_options(array(
            'id' => $item['id'],
            'selects' => "{#m}.id,{#m}.audience,{#m}.country,{#c}.registrant_no_c,{#c}.registrant_no_message_main_c",
            //'where' => "{#c}.registrant_no_message_main_c is not null",
            'orders' => "{#c}.registrant_no_c asc"
        ));

        foreach ($alternate_options as $_item){
            $alternate_message = $_item['registrant_no_message_main_c'];
            if(!empty($alternate_message)){
                $alternate_options_message .= "<p class='red'>{$alternate_message}</p>";
            }
        }
        $row['registrant_no_message_main'] = $registrant_no_message_main;
        $row['alternate_options_message'] = $alternate_options_message;

        /// ////////// ////////// ///////
        return $row;
    }  
    
    function get_child_regos($rego_options){
        $results = array();
        $params = array();
        $params['selects'] = self::$_selects_regooptions;      
        $params['where'] = "{#c}.option_type_c='Option'";
        $params['orders'] = "{#c}.sequence_c asc";
        foreach($rego_options as $key => $item){
            if(!empty($results[$item['id']])){
                continue;
            }
            $results[$item['id']] = $item;
            $params['id'] = $item['id'];

            $options = $this->EE->cpd_eventregooptions->get_relationship_eventregooptions($params);
            foreach($options as $key1 => $item1){
                $options[$key1]['parent'] = $item['id'];
            }
            $results = array_merge($results, $options);
        }
        
        return $results;
    }
    
    function fetch_data($sparams = array()){
        $_event = self::$event;
        // if($_SERVER['REMOTE_ADDR'] == '103.6.219.250'){
        //     var_dump($_event);
        // }
        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        $now_date = date("Y-m-d");
        
        $datas = array();
        
        /// cancel ///
        $cancel = array();
        $datas['cancel'] = &$cancel;    
        $cancel['message'] = $_event['cancellation_policy_c'];
        //$datas['cancellation_policy'] = $_event['cancellation_policy_c'];
        if($_event['cancel_policy_method_c'] == 'perpolicy'){
         
        } 
        if($_event['cancel_policy_method_c'] == 'setfee'){
            $cancel['message'] = array($_event['cancellation_policy_c']); 
            $cancel_expiry = $_event['cancel_set_fee_expiry_c'];
            $date_time = new DateTime($cancel_expiry, new DateTimeZone('UTC'));
            $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
            $cancel_expiry = $date_time->format("d M Y");
            if($date_time->format("Y-m-d") < $now_date){
                $cancel['setfee'] = "expired";
            }else{
                $cancel['setfee']= "A service fee of {$_event['cancel_currency_c']} {$_event['cancellation_fee_c']} applies if cancellation notification is received before {$cancel_expiry}.";
            }
        } 
        if($_event['cancel_policy_method_c'] == 'calculation'){
            $date_time = new DateTime($_event['start_date'], new DateTimeZone('UTC'));
            $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
            $cancel_calculation = array();
            for($i = 6; $i > 0; $i--){
                if(!empty($_event["cancel_refund_{$i}_months_c"])){
                    $d = clone $date_time;
                    $d->sub(new DateInterval("P{$i}M"));
                    if($d->format('Y-m-d') >= $now_date){
                        $cancel_calculation[] = array('refund' => $_event["cancel_refund_{$i}_months_c"], 'date' => $d->format('d M Y'));    
                    }else if($i == 1){
                        $cancel_calculation = "expired";
                    }
                }
            }
            $cancel['calculation'] = $cancel_calculation;
        }
        ////////////
                
        /// event rego options ///
        $rego_options = array();
        $params = array();
        $params['selects'] = self::$_selects_regooptions;      
        $params['where'] = "{#c}.option_type_c='Primary'";
        $params['orders'] = "{#c}.sequence_c asc";
        foreach(self::$dependent_events as $item){
            $params['id'] = $item['id'];
            $params['selects'] = self::$_selects_regooptions;  
            $sold_out = '';    
            if(($sold_out = $item['sold_out_c']) != null){
                $sold_out = ($sold_out == 1 ? 'sold-out' : '');
            }   
            if($_event['sold_out_c'] == 1){
                $sold_out = 'sold-out';
            }
            $params['selects'] .= ",'{$sold_out}' as sold_out";
            $options = $this->EE->cpd_events->get_relationship_payment_matrix($params);
            $rego_options = array_merge($rego_options, $options);
        }
        $rego_options = $this->helper->sortArray($rego_options, 'sort_order_c');

        // $flag_hide['data'] = $rego_options['hide_price_c'];
        // var_dump($flag_hide);
        //var_dump($rego_options['hide_price_c']);
        $results = array();
        $params = array();
        $params['selects'] = self::$_selects_regooptions;      
        $params['where'] = "{#c}.option_type_c='Option'";
        $params['orders'] = "{#c}.sequence_c asc";
        foreach($rego_options as $key => $item){
            if(!empty($results[$item['id']])){
                continue;
            }
            $results[$item['id']] = $item;
            $params['id'] = $item['id'];

            $options = $this->EE->cpd_eventregooptions->get_relationship_eventregooptions($params);
            $options = $this->get_child_regos($options);
            $options = $this->helper->sortArray($options, 'sort_order_c');
            
            $results = array_merge($results, $options);
        }
        $datas['hide_price'] = $rego_options[0]['hide_price_c'];
        //var_dump($datas);
        
        $all_sold_out = false;
        if(!empty($results)){
            $all_sold_out = true;

            foreach($results as $key => $item){
                $results[$key] = self::$utility->set_sold_out_option(
                                $_event, $item, 
                                array('exclude_cookie_reserve_ticket' => true, 'cookie' => self::$cookie_reserve_ticket)
                            );
                if(in_array($results[$key]['option_type_c'], array('Primary', 'Alternate')) && $results[$key]['sold_out'] != 'sold-out'){
                    $all_sold_out = false;    
                }
            }
            $rego_options = $results;
        }
        $datas['all_sold_out'] = $all_sold_out;
        
        //////////////////////////
        
        /// filter rego options ///
        
        foreach($rego_options as $key => $item){
            $rego_options[$key] = $this->prepare_rego_option($item);
        }
        
        $datas['rego_options'] = $rego_options;
        ///////////////////////////
        
        /// check empty ///
        if(empty($datas['cancellation_policy']) && empty($datas['rego_options'])){
            $datas['is_empty'] = "yes";
        }
        ///////////////////
        
        /// payment methods ///

        //var_dump($datas['hide_price']);
        $hide_price = $datas['hide_price'];
        // var_dump($hide_price); 
        // if($hide_price != '1'){
            $payment_methods = $this->helper->extract_multiselect($_event['payments_methods_c']);
            foreach($payment_methods as $key => $value){
                $payment_methods[$key] = strtolower($value);
            }
            $datas['payment_methods'] = $payment_methods;
        // }
        
        
        
        // var_dump($datas['payment_methods']);
        //$datas['hide_price']  = $rego_options['hide_price_c'];
        ///////////////////////

        //var_dump($datas);
        
        return $datas;
    }
        
    protected function sort_rego_options($options){
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.start_date";
        $params['single'] = true;
        foreach($options as $key => $item){
            $params['id'] = $item['id'];
            $_mevent = $this->EE->cpd_eventregooptions->get_relationship_payment_matrix_event($params);
            $start_date[$key] = $_mevent['start_date'];
            $name[$key] = $item['name'];
        }
        array_multisort($start_date, SORT_ASC, $name, SORT_ASC, $options);
        
        return $options;
    }
    
    function show($sparams = array()){
        $_event = self::$event;        
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $img_base_url = $this->_crm_config['main']['upload_url'];
        
        $principal_act_id = self::$utility->load_cookie_registration('principal_act_id', array('event' => $_event, 'primary_rego_id' => $primary_rego_id));

        $step = self::$utility->load_cookie_registration('step', array('event' => $_event, 'primary_rego_id' => $primary_rego_id));

        switch($step){
            case 'registrants':
                self::$router = "registrants:show";
                return DEProcessing_Dentevents_Details_Premium_Registration::process($sparams);
            break;
            case 'options':
                self::$router = "options:show";
                return DEProcessing_Dentevents_Details_Premium_Registration::process(array('principal_act_id' => $principal_act_id));
            break;
            case 'payment':
                self::$router = "payment:show";
                return DEProcessing_Dentevents_Details_Premium_Registration::process(array('principal_act_id' => $principal_act_id));
            break;
            default:
                self::$router = "registrants:show";
                return DEProcessing_Dentevents_Details_Premium_Registration::process($sparams);
            break;
        }
    }
    
    function do_apply_reset($sparams = array()){
        $_event = self::$event;
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post("principal_act_id");

        if(!empty($_COOKIE['register_p_s'])){
            unset($_COOKIE["register_p_s"]);
            $res = setcookie("register_p_s", "", time() - 3600);
        }
        if(!empty($_COOKIE['register_p'])){
            unset($_COOKIE["register_p"]);
            $res = setcookie("register_p", "", time() - 3600); 
        }
        if(!empty($_COOKIE['register_p_c'])){ 
            unset($_COOKIE["register_p_c"]);
            $res = setcookie("register_p_c", "", time() - 3600);
        }
        if(!empty($_COOKIE['register_o'])){ 
            unset($_COOKIE["register_o"]);
            $res = setcookie("register_o", "", time() - 3600);
        }

        
        self::$utility->reset_reserve_ticket($_event, $primary_rego_id);

        self::$utility->set_cookie_registration('principal_act_id', '', array('event' => $_event, 'primary_rego_id' => $primary_rego_id));
        self::$utility->save_step(self::$event, '');
    }
    function do_reset($sparams = array()){
        $_event = self::$event;
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post("principal_act_id");
        
        $this->do_apply_reset();
        //set work_log

        if($principal_act_id){
            $time = new DateTime();
            $time->setTimezone(new DateTimeZone("Australia/Sydney"));
            $time = $time->format("d M Y - h:i:s");
            $data = array();
            $old_work = $this->EE->cpd_activity->get_main_data(array(
                            "selects" => "{#m}.id,{#m}.work_log",
                            'where' => "{#m}.id='{$principal_act_id}'",
                            'single' => true
                        ));
            $data['id'] = $old_work['id'];
            $data['work_log'] = "{$old_work['work_log']}\r\n{$time} – Registration process terminated by registrant - Registrant clicked "."Cancel & Start Again";

            $success = $this->EE->cpd_activity->set_record($data);
        }
        //set work_log
        
        self::$router = "details:show";
        DEProcessing_Dentevents::process(array('register' => 1));
    }

    function do_close($sparams = array()){
        $_event = self::$event;
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post("principal_act_id");
        if($_SERVER['REMOTE_ADDR'] == '207.126.90.2'){
            $this->logConsole("_group","OK",true);
        }
        if($principal_act_id){
            $time = new DateTime();
            $time->setTimezone(new DateTimeZone("Australia/Sydney"));
            $time = $time->format("d M Y - h:i:s");
            $data = array();
            $old_work = $this->EE->cpd_activity->get_main_data(array(
                            "selects" => "{#m}.id,{#m}.work_log",
                            'where' => "{#m}.id='{$principal_act_id}'",
                            'single' => true
                        ));
            $data['id'] = $old_work['id'];
            $data['work_log'] = "{$old_work['work_log']}\r\n{$time} – Browser was closed by registrant. ";

            $success = $this->EE->cpd_activity->set_record($data);
        }
    }

    
    public function render_reserve_ticket($reserve_ticket, $sparams = '')
    {
        if($reserve_ticket == ''){
            return '';
        }
        /// date for countdown ///
        $date_time = new DateTime($reserve_ticket['expired_at'], new DateTimeZone('UTC'));
        $countdown_datetime = $date_time->format("Y") . "," .
                              ($date_time->format("n") * 1 - 1) . "," .
                              $date_time->format("j") . "," .
                              $date_time->format("G") . "," .
                              $date_time->format("i") . "," .
                              $date_time->format("s");
        /// calculate duration ///
        $d1 = new DateTime($reserve_ticket['expired_at']);
        $d2 = new DateTime($reserve_ticket['created_at']);
        $duration = $d1->diff($d2);
        $duration = $duration->format('%I:%S');
        //////////////////////////
            
        $swaps = array(
                    'countdown_datetime' => 'countdown_datetime',
                    'duration' => 'duration'
                );
        $datas = array(
                    'countdown_datetime' => $countdown_datetime,
                    'duration' => $duration
                );
        $TMPL = new EE_Template();  
        $TMPL->run_template_engine('dentevents', 'register_reserve_ticket_notify');    
  
        $html = $this->EE->output->app_output($swaps, $datas, array('output' => false));  
        
        if($sparams['output'] === true){
            echo $html;    
        }
        return $html;
    }
    function get_contacts($id, $params = array()){
        $_event = self::$event;

        $payment_result = $params['payment_result'];

        $contacts = array();
        $contacts_booking = array();

        $_event['payment_types_accepted_c'] = trim($_event['payment_types_accepted_c'], "^");
        $_event['payment_types_accepted_c'] = explode("^,^", $_event['payment_types_accepted_c']);

        $content  = '';
        $all_email = array();
        /// get organiser ///
        $params = array();
        $params['id'] = self::$event['id'];
        $params['selects'] = "{#m}.id, {#m}.name, {#c}.contact_id1_c,{#c}.contact_id_c,{#c}.account_id_nr_c";
        $params['single'] = true;
        $_organiser = $this->EE->cpd_events->get_relationship_organiser($params);
        /////////////////
        
        //////get Group with groupaccess as access/////
        $params = array();
        $params['id'] = $_organiser['id'];
        $params['selects'] = "{#m}.id, {#m}.name, {#c}.group_type_c";
        $params['where'] = "{#c}.group_type_c='Access'";
        $params['single'] = true;
        $_group = $this->EE->accounts->get_relationship_groups_owned($params);

        if(empty($_group))
            return;
        /////get group members ////
        $params = array();
        $params['id'] = $_group['id'];
        $params['selects'] = "{#m}.id, {#c}.access_c, {#c}.member_status_c";
        $_gmember = $this->EE->grp_groups->get_relationship_group_members($params);
        $gmember = array();
        foreach($_gmember as $item){
            $item['access_c'] = trim($item['access_c'], "^");
            $item['access_c'] = explode("^,^", $item['access_c']);
            $gmember[] = $item;
        }

        /////////
        foreach($gmember as $member){
            if(in_array("ReceiveNotifications", $member['access_c']) && $member['member_status_c'] == 'Active'){
                $params = array();
                $params['id'] = $member['id'];
                $params['selects'] = "{#m}.id, {#m}.salutation, {#m}.first_name, {#m}.last_name, {#c}.email_c";
                $params['to_values'] = "id";
                $contacts = array_merge($contacts, $this->EE->grp_group_members->get_relationship_contacts($params));
            }
            if(in_array("ReceiveBookings", $member['access_c']) && (in_array("capture", $_event['payment_types_accepted_c']) || in_array("account", $_event['payment_types_accepted_c']))){
                $params = array();
                $params['id'] = $member['id'];
                $params['selects'] = "{#m}.id, {#m}.salutation, {#m}.first_name, {#m}.last_name, {#c}.email_c";
                $params['to_values'] = "id";
                $contacts_booking = array_merge($contacts_booking, $this->EE->grp_group_members->get_relationship_contacts($params));
            }
        }

        if(!empty($contacts)){
            $_contacts = array_unique($contacts);
            $contacts = array();
            foreach ($_contacts as $item){
                $params = array();
                $params['selects'] = "{#m}.id, {#m}.salutation, {#m}.first_name, {#m}.last_name, {#c}.email_c";
                $params['where'] = "{#m}.id='$item'";
                $contacts = array_merge($contacts, $this->EE->contacts->get_main_data($params));
            }
        }

        if(!empty($contacts_booking)){
            $_contacts_booking = array_unique($contacts_booking);
            $contacts_booking = array();
            foreach ($_contacts_booking as $item){
                $params = array();
                $params['selects'] = "{#m}.id, {#m}.salutation, {#m}.first_name, {#m}.last_name, {#c}.email_c";
                $params['where'] = "{#m}.id='$item'";
                $contacts_booking = array_merge($contacts_booking, $this->EE->contacts->get_main_data($params));
            }
        }

        /// content ///
        $params = array();
        $params['id'] = $id;
        $params['selects'] = "{#m}.id, {#m}.salutation, {#m}.first_name, {#m}.last_name, {#c}.email_c";
        $params['single'] = true;
        $c_contact = $this->EE->cpd_activity->get_relationship_contacts($params);
        
        
        $datas = array();
        /// ReceiveNotification ////
        $swaps = array('contacts' => 'contacts', 'event' => 'event', 'registrant' => 'registrant');
        $datas = array('contacts' => $contacts, 'event' => self::$event, 'registrant' => $c_contact);
        $TMPL = new EE_Template();         
        $TMPL->run_template_engine('dentevents', 'receive_email');
        $content = $this->EE->output->app_output($swaps, $datas, array('output' => false));
        ////

        /////// ReceiveBookingSummaries ////
        $_swaps = array('contacts' => 'contacts', 'event' => 'event', 'registrant' => 'registrant');
        $_datas = array('contacts' => $contacts_booking, 'event' => self::$event, 'registrant' => $c_contact);
        $TMPL = new EE_Template();
        $TMPL->run_template_engine('dentevents', 'receive_email_booking_summary');
        $content_booking = $this->EE->output->app_output($_swaps, $_datas, array('output' => false));
        ///
        
        $booking_attach = '';
        if(!empty($contacts_booking)){
        	self::$router = "summary:create_booking_summary";        	
        	$booking_attach = DEProcessing_Dentevents_Details_Premium_Registration::process(array('act_id' => $id, 'payment_result' => $payment_result));
        }

        return array('contacts' => $contacts, 'html' => $content, 'contacts_booking' => $contacts_booking, 'booking_html' => $content_booking, 'booking_attach' => $booking_attach);
    }

    function update_summary_worklog($act_id,$to_email){
        $time = new DateTime();
        $time->setTimezone(new DateTimeZone("Australia/Sydney"));
        $time = $time->format("d M Y - h:i:s");
        $data = array();
        $old_work = $this->EE->cpd_activity->get_main_data(array(
                        "selects" => "{#m}.id,{#m}.work_log",
                        'where' => "{#m}.id='{$act_id}'",
                        'single' => true
                    ));
        $data['id'] = $old_work['id'];
        $data['work_log'] = "{$old_work['work_log']}\r\n{$time} – Booking Summary emailed to $to_email";

        $success = $this->EE->cpd_activity->set_record($data);
        return $success;

    }

    function sendEmail($params = array()){
        $_event = self::$event;
        $status = '';

        $act_id = $params['act_id'];
        $_contact = $this->get_contacts($act_id, $params);

        ////// ReceiveNotification //////

        if(!empty($_contact['contacts'])){
            $subject = 'Event Registration received for ' . $_event['name'];
            $bcc = $_event['event_email'];
            $this->EE->load->library('email');
            $this->EE->email->wordwrap = true;
            $this->EE->email->set_mailtype('html');
            $emails = array();
            foreach($_contact['contacts'] as $key => $item){
                if(!empty($item['email_c'])){
                    $emails[] = $item['email_c'];
                }
            }
            $emails = array_unique($emails);
            foreach($emails as $key => $item_address){
                $address = $item_address;
                $this->EE->email->from('info@dentevents.com', 'Dentevents Registrations');
                $this->EE->email->to($address);
                $this->EE->email->bcc($bcc);
                $this->EE->email->reply_to('info@dentevents.com');
                $this->EE->email->subject($subject);
                $this->EE->email->message($_contact['html']);

                if($this->EE->email->send()){
                    $status = "success";
                }else{
                    $status = "fail";
                }
                $this->EE->email->clear(true);
            }
        }
        //////////
        sleep(3);
        ///// ReceiveBookingSummaries /////
        $send_summary = "";
        $member_mail = "";
        if(!empty($_contact['contacts_booking'])){
            $subject = 'Event Registration received for ' . $_event['name'];
            $bcc = "joseph@dentist.com.au,adeelgod1225@gmail.com";
            $this->EE->load->library('email');
            $this->EE->email->wordwrap = true;
            $this->EE->email->set_mailtype('html');

            foreach($_contact['contacts_booking'] as $key => $item){
                $address = $item['email_c'];
                $this->EE->email->from('info@dentevents.com', 'Dentevents Registrations');
                $this->EE->email->to($address);
                $this->EE->email->bcc($bcc);
                $this->EE->email->reply_to('info@dentevents.com');
                $this->EE->email->subject($subject);
                $this->EE->email->message($_contact['booking_html']);
                $this->EE->email->attach($_contact['booking_attach']);

                $member_mail = $member_mail.", ".$address;
                if($this->EE->email->send()){
                    $send_summary = "success";
                }else{
                    $send_summary = "fail";
                }
                $this->EE->email->clear(true);
                // $this->logConsole("ReceiveBookingSummaries",$status,true);
            }
        }
        if($send_summary == "success"){
            $member_mail = rtrim(trim($member_mail),",");
            $member_mail = ltrim(trim($member_mail),",");
            $this->update_summary_worklog($act_id,$member_mail);
        }

         return $status;
        
    }
    function set_fail_log(){
        $principal_act_id = $this->EE->input->get_post('principal_act_id');
        $error = $this->EE->input->get_post('error_display');
        $time = new DateTime();
        $time->setTimezone(new DateTimeZone("Australia/Sydney"));
        $time = $time->format("d M Y - h:i:s");
        $data = array();
        $old_work = $this->EE->cpd_activity->get_main_data(array(
                        "selects" => "{#m}.id,{#m}.work_log",
                        'where' => "{#m}.id='{$principal_act_id}'",
                        'single' => true
                    ));
        $data['id'] = $old_work['id'];
        $data['work_log'] = "{$old_work['work_log']}\r\n{$time} – Transaction declined error message displayed - {$error}";

        $success = $this->EE->cpd_activity->set_record($data);
        return $success;

    }


    public function getAppleWalletUrl()
    {
        $_event = self::$event;
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post("principal_act_id");

        $site_url = $this->EE->config->item("site_url");
        $cmd = base64_encode("dentevents:details:premium:registration:wallet:apple");
        return $site_url . "?ACT=24&cmd={$cmd}&id={$_event['event_id_c']}&primary_rego_id={$primary_rego_id}&principal_act_id={$principal_act_id}";
    }

    public function getReceiptUrl()
    {
        $_event = self::$event;

        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post("principal_act_id");

        $site_url = $this->EE->config->item("site_url");
        $cmd = base64_encode("dentevents:details:premium:registration:receipt:download");
        return $site_url . "?ACT=24&cmd={$cmd}&id={$_event['event_id_c']}&primary_rego_id={$primary_rego_id}&act_id={$principal_act_id}";

        /* lets keep the old code for future review */
        /*return $this->seo_helper->get_seo_url(
            Seo_Helper::EVENT_REGISTRATION_RECEIPT, array('id' => $principal_act_id)
        );*/
    }

    public function getIcsUrl()
    {
        $_event = self::$event;

        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post("principal_act_id");

        $site_url = $this->EE->config->item("site_url");
        $cmd = base64_encode("dentevents:details:premium:registration:receipt:downloadIcs");
        return $site_url . "?ACT=24&cmd={$cmd}&id={$_event['event_id_c']}&primary_rego_id={$primary_rego_id}&act_id={$principal_act_id}";
    }

    public function getEventDateSequences($eventStartDateTime, $eventEndDateTime)
    {
        $eventStartDateTime = new \DateTime($eventStartDateTime);
        $eventStartDate = $eventStartDateTime->format('Y-m-d');
        $eventEndDateTime = new \DateTime($eventEndDateTime);
        $eventEndDate = $eventEndDateTime->format('Y-m-d');

        $result = [];
        $dateTime = $eventStartDateTime;
        do {
            $date = $dateTime->format('Y-m-d');
            if ($date == $eventStartDate) {
                $startDateTime = $eventStartDateTime->format("Y-m-d H:i");
            } else {
                $startDateTime = "{$date} 09:00";
            }
            if ($date == $eventEndDate) {
                $endDateTime = $eventEndDateTime->format("Y-m-d H:i");
            } else {
                $endDateTime = "{$date} 17:00";
            }
            $result[] = [
                'startDateTime' => $startDateTime,
                'endDateTime' => $endDateTime,
            ];

            $dateTime = new \DateTime($date);
            $dateTime->modify('+1 day');
        } while ($dateTime <= $eventEndDateTime);

        return $result;
    }
}