<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Registration_Options extends DEProcessing_Dentevents_Details_Premium_Registration{
    protected $step = 'options';
    
    function initialize($params = array()){
        
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "item":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/options/item.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Options_Item();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "reserve":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/options/reserve.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Options_Reserve();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "show":
                self::$utility->save_step(self::$event, $this->step);
                return $this->show($params);
            break;
            case "registered_show":
                return $this->registered_show($params);
            break;
            case "step_next":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/options/step_next.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Options_StepNext();
                $processing->initialize($params);
                return $processing->process($params);
            break;
        }

    }

    public function show($sparams=''){
        if(!empty($_COOKIE['register_o'])) {
                    $cookie_name = "register_o";
                    unset($_COOKIE[$cookie_name]);
                    $res = setcookie($cookie_name, "", time() - 3600);
                    $principal_act_id = $sparams['principal_act_id'];
                    $time = new DateTime();
                    $time->setTimezone(new DateTimeZone("Australia/Sydney"));
                    $time = $time->format("d M Y - h:i:s");
                    $old_worklog = array();
                    if($principal_act_id){
                        $old_worklog = $this->EE->cpd_activity->get_main_data(array(
                                    "selects" => "{#m}.id,{#m}.work_log",
                                    'where' => "{#m}.id='{$principal_act_id}'",
                                    'single' => true
                                ));
                    }
                    $new_worklog = "{$old_worklog['work_log']}\r\n{$time} – Page Refreshed on the Option Page.";
                    $data = array();
                    $data['id'] = $principal_act_id;
                    $data['work_log'] = $new_worklog;
                    //  if($_SERVER['REMOTE_ADDR'] == '207.126.90.2'){
                    //     DEProcessing_Dentevents_Details_Premium_Registration::logConsole("option",$data,true);
                    //     exit;
                    // }
                    $success = $this->EE->cpd_activity->set_record($data);
                    if(!$success){
                        $this->logger->developer("Failed to update the work_log-" . get_class($this) . '-update_worklog_activities');
                    }
                    self::$router = "reset";
                    return DEProcessing_Dentevents_Details_Premium_Registration::process($sparams);
                    
        }else{
            $_event = self::$event;        
            $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
            $img_base_url = $this->_crm_config['main']['upload_url'];
            
            $datas = $this->fetch_basic_data();

            $principal_act_id = $sparams['principal_act_id'];
            
            /// render items ///
            $act_list = array();
            if($principal_act_id){
                $act_list = $this->EE->cpd_activity->get_relationship_transactions_cpdactivity(array(
                        'id' => $principal_act_id,
                        'selects' => "{#m}.id",
                        'where' => "{#c}.rego_option_type_c='Core'",
                        'to_values' => "id"
                    ));
            }

        // if($_SERVER['REMOTE_ADDR'] == '149.154.156.99'){
        //     var_dump($act_list);exit;
        // }  

            $act_list = array_merge(array($principal_act_id), $act_list);
            
            $items_html = '';
            $idx = 0;
            $registered = '';
            foreach($act_list as $item){
                self::$router = "item:show";
                $result = DEProcessing_Dentevents_Details_Premium_Registration_Options::process(array('need_data' => true, 'act_id' => $item, 'number' => $idx++, 'total_acts' => count($act_list)));
                $html = !empty($result['html']) ? $result['html'] : [];
                $items_html .= $html;

                $data = !empty($result['data']['dt']) ? $result['data']['dt'] : [];
                if ($registered == '') {
                    $registered = !empty($data['registered']) ? $data['registered'] : '';
                }
            }
            $datas['registered'] = $registered;
            ////////////////////
            $datas['items_html'] = $items_html;
            $datas['principal_act_id'] = $principal_act_id;
            $datas['primary_rego_id'] = $primary_rego_id;

            if($_event['event_max_attendance'] != ''){
                /// reserve data ///
                self::$router = "reserve:fetch_data";
                $reserve_data = DEProcessing_Dentevents_Details_Premium_Registration_Options::process(array(
                                        'act_list' => $act_list,
                                        'event' => $_event,
                                        'primary_rego_id' => $primary_rego_id
                                    ));
                $reserve_data['config'] = json_encode($reserve_data['config']);
                ////////////////////
                
                /// reserve options ///
                if(empty(self::$cookie_reserve_ticket['ids_for_options'])){
                    self::$router = "reserve:apply";
                    self::$cookie_reserve_ticket = DEProcessing_Dentevents_Details_Premium_Registration_Options::process(array(
                                        'act_list' => $act_list,
                                        'event' => $_event,
                                        'primary_rego_id' => $primary_rego_id
                                    ));    
                }
                ///////////////////////
            }

            $cookie_name = "register_o";
            $cookie_value = true;
            setcookie($cookie_name, $cookie_value, time() + (86400 * 30), '/'); 
                           
            $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
            $swaps = array(
                        'AID' => 'AID',
                        'dt' => 'dt',
                        'reserve_data' => 'reserve_data',
                        'reserve_ticket_html' => 'reserve_ticket_html',
                    );
            $datas = array(
                        'AID' => $action_id,
                        'dt' => $datas,
                        'reserve_data' => $reserve_data,
                        'reserve_ticket_html' => $this->render_reserve_ticket(self::$reserve_ticket),
                    );
            
            $this->EE->TMPL->run_template_engine("dentevents", "register_options");    
            
            $this->EE->output->app_output($swaps, $datas, array('env' => true));
        }
    }

    public function registered_show($sparams=''){
        $_event = self::$event;  
        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        
        $datas = $this->fetch_basic_data();
        $principal_act_id = $this->EE->input->get_post("act_id");

        $principal_act_data = $this->EE->cpd_activity->get_main_data(array(
                            'selects' => "{#m}.id",
                            'where' => "{#m}.id='{$principal_act_id}'",
                            'single' => true
                        ));

        ///// check if it is expired ///////
        $now_date = date('Y-m-d');
        if($now_date > $_event['rego_close_date_c'] || empty($principal_act_data) || $now_date > $_event['end_date']){            
            if($now_date > $_event['rego_close_date_c']){
                $bug_flag = "expired";
            }
            if(empty($principal_act_data)){
                $bug_flag = "invalid";
            }
            if($now_date > $_event['end_date']){
                $bug_flag = "concluded";
            }
            $datas['bug_flag'] = $bug_flag;
            $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
            $swaps = array(
                        'AID' => 'AID',
                        'dt' => 'dt'
                    );
            $datas = array(
                        'AID' => $action_id,
                        'dt' => $datas
                    );
            
            $this->EE->TMPL->run_template_engine("dentevents", "register_options_expired");    
            
            $this->EE->output->app_output($swaps, $datas, array('env' => true));
        }else{
            ////// get rego option ///////
            $params = array();
            $params['id'] = $principal_act_id;
            $params['selects'] = "{#m}.id";
            $params['single'] = true;
            $primary_rego = $this->EE->cpd_activity->get_relationship_cpd_eventregooptions($params);
            $primary_rego_id = $primary_rego['id'];
            ////////////////////////////

            /// render items ///
            $act_list = $this->EE->cpd_activity->get_relationship_transactions_cpdactivity(array(
                        'id' => $principal_act_id,
                        'selects' => "{#m}.id",
                        'where' => "{#c}.rego_option_type_c='Core'",
                        'to_values' => "id"
                    ));

            $act_list = array_merge(array($principal_act_id), $act_list);
            $items_html = '';
            $idx = 0;
            $registered = true;
            foreach($act_list as $item){
                self::$router = "item:show";
                $items_html .= DEProcessing_Dentevents_Details_Premium_Registration_Options::process(array('act_id' => $item, 'registered' => $registered, 'number' => $idx++, 'total_acts' => count($act_list)));
            }
            
            ////////////////////
            $datas['items_html'] = $items_html;
            $datas['principal_act_id'] = $principal_act_id;
            $datas['primary_rego_id'] = $primary_rego_id;
            
            if($_event['event_max_attendance'] != ''){
                /// reserve data ///
                self::$router = "reserve:fetch_data";
                $reserve_data = DEProcessing_Dentevents_Details_Premium_Registration_Options::process(array(
                                        'act_list' => $act_list,
                                        'event' => $_event,
                                        'primary_rego_id' => $primary_rego_id
                                    ));
                $reserve_data['config'] = json_encode($reserve_data['config']);
                ////////////////////
                
                /// reserve options ///
                if(empty(self::$cookie_reserve_ticket['ids_for_options'])){
                    self::$router = "reserve:apply";
                    self::$cookie_reserve_ticket = DEProcessing_Dentevents_Details_Premium_Registration_Options::process(array(
                                        'act_list' => $act_list,
                                        'event' => $_event,
                                        'primary_rego_id' => $primary_rego_id
                                    ));    
                }
                ///////////////////////
            }
                                    
            $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
            $swaps = array(
                        'AID' => 'AID',
                        'dt' => 'dt',
                        'reserve_data' => 'reserve_data',
                        'reserve_ticket_html' => 'reserve_ticket_html'
                    );
            $datas = array(
                        'AID' => $action_id,
                        'dt' => $datas,
                        'reserve_data' => $reserve_data,
                        'reserve_ticket_html' => $this->render_reserve_ticket(self::$reserve_ticket)
                    );
            
            $this->EE->TMPL->run_template_engine("dentevents", "register_options");    
            
            $this->EE->output->app_output($swaps, $datas, array('env' => true));
        }        
    } 
}