<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Registration_Options_Item extends DEProcessing_Dentevents_Details_Premium_Registration_Options{
    protected $_registrant = '';
    
    function initialize($params = array()){
        $this->EE->load->model("cpd_eventregooptions");
        $this->EE->load->model("publication");
        
        if(!empty($params['registrant'])){
            $this->_registrant = $params['registrant'];
        }
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "show":
                return $this->show($params);
            break;
            case "prepare_register_rego_option":
                return $this->prepare_register_rego_option($params);
            break;
        }

    }
    function prepare_register_rego_option($params){
        $item = $params['item'];
        if(is_string($item)){
            $iparams = array();
            $iparams['selects'] = self::$_selects_regooptions;      
            $iparams['where'] = "{#m}.id='{$item}'";
            $iparams['single'] = true;
            $item = $this->EE->cpd_eventregooptions->get_main_data($iparams);
        }
        
        /// check tax ////    
        if($item['include_tax_c'] == 1){
            $item['base_rate'] = $item['base_rate'] * 1 + $item['base_rate'] * $item['tax_rate_c'] / 100;
            $item['member_discount_rate'] = $item['member_discount_rate'] * 1 + $item['member_discount_rate'] * $item['tax_rate_c'] / 100;
            $item['earlybird_discount'] = $item['earlybird_discount'] * 1 + $item['earlybird_discount'] * $item['tax_rate_c'] / 100;
            $item['subscriber_discount_rate'] = $item['subscriber_discount_rate'] * 1 + $item['subscriber_discount_rate'] * $item['tax_rate_c'] / 100;
            $tax_rate = $this->helper->toFixed($item['tax_rate_c'], 0);
            $item['tax_label'] = "Including {$tax_rate}% {$item['tax_name_c']}";
        }
        $item['base_rate'] = $this->helper->toFixed($item['base_rate'], 2);
        $item['member_discount_rate'] = $this->helper->toFixed($item['member_discount_rate'], 2);
        $item['earlybird_discount'] = $this->helper->toFixed($item['earlybird_discount'], 2);
        $item['subscriber_discount_rate'] = $this->helper->toFixed($item['subscriber_discount_rate'], 2);
        //////////////////
        
                
        $_event = self::$event;
        /// check sold out ///
        $item = self::$utility->set_sold_out_option(
                        $_event, $item,
                        array('exclude_cookie_reserve_ticket' => true, 'cookie' => self::$cookie_reserve_ticket)
                    );
        //////////////////////
        
        $_contact = $this->_registrant;
        
        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        $now_date = date("Y-m-d");
        
        $row = $item;
        $row['lock'] = "yes";
        
        $currency = $this->helper->get_dropdowns_sugar_labels('acc_currency_list', $item['currency'], false);
        $row['currency'] = $currency;
        
        /// audience ///
        if(!empty($item['audience_show_c'])){
            $audience = $this->helper->get_dropdowns_sugar_labels('audience_show_list', $item['audience_show_c']);
            $audience = implode(", ", $audience);
        }else{
            $audience = $this->helper->get_dropdowns_sugar_labels('pract_type_list', $item['audience']);
            if(empty($audience)){
                $audience = "All";
            }
            $audience = implode(", ", $audience);
        }
        $row['audience'] = $audience;
        ////////////////
        
        /// event ///
        $params = array();
        $params['id'] = $item['id'];
        $params['selects'] = "{#m}.id,{#m}.start_date,{#m}.end_date,{#c}.special_diet_guests_c,{#c}.special_diet_choices_c";
        $params['single'] = true;
        $_mevent = $this->EE->cpd_eventregooptions->get_relationship_payment_matrix_event($params);
            /// start date ///
            $date_time = new DateTime($_mevent['start_date'], new DateTimeZone('UTC'));
            $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
            $date = $date_time->format("l, j F, Y");
            $time = $date_time->format("g:i A");
            $row['start'] = array('date' => $date, 'time' => $time);
            $row['start_date'] = $_mevent['start_date'];
        
            //////////////////
            /// end date ///
            $date_time = new DateTime($_mevent['end_date'], new DateTimeZone('UTC'));
            $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
            $date = $date_time->format("l, j F, Y");
            $time = $date_time->format("g:i A");
            $row['end'] = array('date' => $date, 'time' => $time);
            $row['end_date'] = $_mevent['end_date'];
            
            $row['payment_matrix_event'] = $_mevent['id'];
            ////////////////
        /////////////
        
        /// guest limist ///
        $row['force_diet'] = $_mevent['special_diet_guests_c'];
        $row['diets_opts'] = '';
        if($item['allow_guests_c'] == 1){
            $row['guest_limit'] = $item['guest_limit_c'];
            if(!empty($_event['special_diet_choices_c'])){
                if($row['force_diet'] == 'Yes' || $row['force_diet'] == 'Force'){
                    $diets = trim($_event['special_diet_choices_c'], "^");
                    $diets = explode("^,^", $diets);
                    $diets_labels = $this->helper->get_dropdowns_sugar_labels('special_diet_choices_list', $_event['special_diet_choices_c'], true);
                    $row['diets_opts'] = $this->helper->make_select_opts(array_combine($diets, $diets_labels), null);    
                }
            }
        }
        ////////////////////
        
        $discounts = array();
        $discounts_values = array();
        /// check early bird discount ///
        if(!empty($item['earlybird_cutoff']) && !empty($item['earlybird_discount']) && $item['cumulative_discounts'] == 'No'){
            $earlybird_cutoff = new DateTime($item['earlybird_cutoff']);    
            $earlybird_cutoff = $earlybird_cutoff->format("Y-m-d");   
            if($earlybird_cutoff >= $now_date){
                $discounts[] = array('type' => 'Earlybird', 'label' => 'Less Early Bird Discount', 'value' => $item['earlybird_discount'], 'lock' => 'no');
                $discounts_values[] = $this->helper->toFixed($item['earlybird_discount'], 2);
            } 
        }
        /////////////////////////////////
        
        /// check member discount ///
        if(!empty($item['member_discount_rate']) && $item['cumulative_discounts'] == 'No' && !empty($_contact)){
            $_dis_accounts = $this->EE->cpd_eventregooptions->get_relationship_member_discounts(array(
                                                'id' => $item['id'],
                                                'selects' => "{#m}.id,{#c}.billing_name_c",
                                            ));
            if(!empty($_dis_accounts)){
                $_dis_account = reset($_dis_accounts);
                $ditems = array();
                foreach($_dis_accounts as $ditem){
                    $ditems[] = $ditem['id'];    
                }
                $members = $this->EE->contacts->get_relationship_memberships(array(
                                        'id' => $_contact['id'],
                                        'selects' => "{#m}.id",
                                        'to_values' => 'id'
                                    ));
                if(array_intersect($ditems, $members)){
                    $discounts[] = array(
                        'type' => 'Member',
                        'label' => "Less {$_dis_account['billing_name_c']} Member Discount", 
                        'value' => $item['member_discount_rate'], 
                        'lock' => 'yes', 
                        'note' => array('id' => $_dis_account['id'], 'name' => $_dis_account['billing_name_c'])
                        );
                    $discounts_values[] = $item['member_discount_rate'];    
                }
            }
        }
        /////////////////////////////
        
        /// check subscriber discount ///
        if(!empty($item['subscriber_discount_rate']) && $item['cumulative_discounts'] == 'No' && !empty($_contact)){
            $_dis_subscriptions = $this->EE->contacts->get_relationship_subscriptions(array(
                                    'id' => $_contact['id'],
                                    'selects' => "{#m}.id,{#m}.ext_publications_id_c",
                                    'where' => "({#m}.status='Paid Subscriber' and {#m}.validto > '{$now_date}') OR ({#m}.status='Contributor')",
                                ));
            $pubs = trim($item['sub_disc_pub_c'], "^");
            $pubs = explode("^,^", $pubs);
            foreach($_dis_subscriptions as $_subsc){
                $pub_id = $_subsc['ext_publications_id_c'];
                $_pub = $this->EE->publication->get_main_data(array(
                                    'selects' => "{#m}.id,{#m}.name",
                                    'where' => "{#m}.id='{$pub_id}'",
                                    'single' => true
                                ));
                if(in_array($_pub['name'], $pubs)){
                    $discounts[] = array(
                        'type' => 'Subscriber',
                        'label' => "Less {$_pub['name']} Subscriber Discount", 
                        'value' => $item['subscriber_discount_rate'], 
                        'lock' => 'yes',
                        'note' => array('id' => $_pub['id'], 'name' => $_pub['name'])
                        );
                    $discounts_values[] = $item['subscriber_discount_rate'];        
                }
            }
        }
        /////////////////////////////////
        $row['discounts_html'] = '';
        if(!empty($discounts)){
            $selected_key = array_keys($discounts_values, max($discounts_values));
            $selected_key = $selected_key[0];
            $sel_discount = $discounts[$selected_key];
            $row['discounts'] = array($sel_discount);
            /*foreach($row['discounts'] as $_discount){
                if($_discount['lock'] == "yes"){
                    $row['lock'] = "yes";break;
                }
            }*/
            
            /// discounts html ///
  
            $datas = array('discounts' => $row['discounts'], 'currency' => $row['currency']);
            $swaps = array(
                        'dt' => 'dt',
                    );
            $datas = array(
                        'dt' => $datas,
                    );
            $TMPL = new EE_Template();         
            $TMPL->run_template_engine('dentevents', 'register_snippet_discounts');
            $row['discounts_html'] = $this->EE->output->app_output($swaps, $datas, array('output' => false));  
        }
        return $row;
    }
     
    function get_child_regos($rego_options){
        $results = array();
        $params = array();
        $params['selects'] = self::$_selects_regooptions;      
        $params['where'] = "{#c}.option_type_c='Option'";
        $params['orders'] = "{#c}.sequence_c asc";
        foreach($rego_options as $key => $item){
            if(!empty($results[$item['id']])){
                continue;
            }
            $results[$item['id']] = $item;
            $params['id'] = $item['id'];
            $options = $this->EE->cpd_eventregooptions->get_relationship_eventregooptions($params);
            $options = $this->sort_rego_options($options);
            foreach($options as $key1 => $item1){
                $options[$key1]['parent'] = $item['id'];
            }
            $results = array_merge($results, $options);
        }
        // var_dump($results);
        return $results;
    }
    
        
    public function show($sparams=''){
       
        
        $sys_primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $img_base_url = $this->_crm_config['main']['upload_url'];
        
        $act_id = $sparams['act_id'];
         $_event = self::$event;  

        
   

        if($sparams['registered'] == true){
            self::$registered = "yes";
        }
        
        ///// check registered user /////
        $primary_registered_rego = array();
        $registered_regos = array();
        $related_act_ids = array();

        $registered_flag = self::$utility->check_already_register_by_act($act_id);

        if(self::$registered == "yes" && $registered_flag){
            $params = array();
            $params['id'] = $act_id;
            $params['selects'] = "{#m}.id";
            $params['where'] = "{#m}.status='3PaymentEntered' or {#m}.status='3aRegistrationRequested' or {#m}.status='4PaymentAccepted' or {#m}.status='6RegistrationAccepted'";
            $related_act_ids = $this->EE->cpd_activity->get_relationship_related_cpdactivity($params);
            ///// removing previous acts ////
            $params = array();
            $params['id'] = $act_id;
            $params['selects'] = "{#m}.id";
            $params['where'] = "{#m}.status!='3PaymentEntered' and {#m}.status!='3aRegistrationRequested' and {#m}.status!='4PaymentAccepted' and {#m}.status!='6RegistrationAccepted'";
            $previous_act_ids = $this->EE->cpd_activity->get_relationship_related_cpdactivity($params);
            if(!empty($previous_act_ids)){
                foreach($previous_act_ids as $key => $item){
                    $_params = array();
                    $_params['id'] = $item['id'];
                    $_params['deleted'] = '1';
                    $success = $this->EE->cpd_activity->set_record($_params);
                }
            }
            /// ///////
            $params = array();
            $params['id'] = $act_id;
            $params['selects'] = "{#m}.id";
            $params['single'] = true;
            $primary_registered_rego = $this->EE->cpd_activity->get_relationship_cpd_eventregooptions($params);

            foreach ($related_act_ids as $key => $item) {
                $params = array();
                $params['id'] = $item['id'];
                $params['selects'] = "{#m}.id";
                $params['single'] = true;
                $_registered_rego = $this->EE->cpd_activity->get_relationship_cpd_eventregooptions($params);                
                $registered_regos[] = $_registered_rego['id'];
            }

        }

        ////////
        $datas = array();
        $datas['total_acts'] = $sparams['total_acts'];
        /// pull registrant ///
        $_registrant = $this->EE->cpd_activity->get_relationship_contacts(array(   
                                    'id' => $act_id,
                                    'selects' => "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.rego_domain_c,{#c}.rego_no_c,{#c}.rego_no_nz_c,{#c}.rego_no_other_c,{#c}.pract_type_c,{#c}.pract_type_nz_c,{#c}.pract_type_other_1_c",
                                    'single' => true
                                ));
        $_registrant['number'] = $sparams['number'] * 1 + 1;
        $this->_registrant = $datas['registrant'] = $_registrant;
        $datas['act_id'] = $act_id;
        ///////////////////////
        $datas['salutation_opts'] = $this->helper->make_select_opts('salutation_dom', null);
        
        /// pull primary rego ///
        $_rego_option = $this->EE->cpd_activity->get_relationship_cpd_eventregooptions(array(   
                                    'id' => $act_id,
                                    'selects' => "{#m}.id",
                                    'single' => true
                                ));
        $primary_rego_id = $_rego_option['id'];
        
        /////////////////////////
        
        $rego_list = array();
        $datas['rego_list'] = &$rego_list;
        self::$_selects_regooptions = "{#m}.id,{#m}.name,{#m}.audience,{#m}.event_part_attend,{#m}.currency,{#m}.base_rate,
                                 {#m}.earlybird_cutoff,{#m}.earlybird_discount,{#m}.member_discount_rate,{#m}.subscriber_discount_rate,{#m}.cumulative_discounts,{#c}.include_tax_c,{#c}.tax_rate_c,{#c}.tax_name_c,  
                                 {#c}.option_type_c,{#c}.accept_bookings_c,{#c}.option_group_c,{#c}.sub_disc_pub_c,{#c}.audience_show_c,{#c}.allow_guests_c,{#c}.guest_limit_c,{#c}.sold_out_c,{#c}.guest_text_override_c,{#c}.sort_order_c,{#c}.auto_opt_in_c,{#c}.option_message_c,{#c}.force_option_selection_c,{#c}.force_option_error_msg_c,{#c}.groups_to_exclude_c,{#c}.groups_to_exclude_message_c,{#c}.registrant_no_message_c,{#c}.charge_fta_only_c,{#c}.hide_price_c";
        /// primary rego ///
        $params = array();
        $params['selects'] = self::$_selects_regooptions;      
        $params['where'] = "{#m}.id='{$primary_rego_id}'";
        $params['single'] = true;
        $_primary_rego = $this->EE->cpd_eventregooptions->get_main_data($params);

        if($_primary_rego['id'] == $primary_registered_rego['id']){
            $_primary_rego['registered'] = "yes";
        }else{
            $_primary_rego['registered'] = "";
        }
//customized
//$_primary_rego['registered'] = "yes";
        $_primary_rego = $this->prepare_register_rego_option(array('item' => $_primary_rego));
        ///////////////////////////
        
        /// option rego ///
        $params = array();
        $params['id'] = $_primary_rego['id'];
        $params['selects'] = self::$_selects_regooptions;      
        $params['where'] = "{#c}.option_type_c='Option'";
        $params['orders'] = "{#c}.sequence_c asc";
        $options = $this->EE->cpd_eventregooptions->get_relationship_eventregooptions($params);
        
        //$options = $this->sort_rego_options($options);
        $options = $this->get_child_regos($options);
        $options = $this->helper->sortArray($options, 'sort_order_c');

        // var_dump($options);
        
        $option_groups = array();
        $options_status = array();
        $registered_groups = array();
        foreach ($options as $key => $item) {
            if(in_array($item['id'], $registered_regos)){
                $item['registered'] = "yes";
            }else{
                $item['registered'] = "";
            }

            $_group = $item['option_group_c']; 
            if(!empty($_group)){
                if($item['registered'] == "yes"){
                    $registered_groups[] = $_group;
                }
            }           
        }

        foreach($options as $key => $item){
            if(in_array($item['id'], $registered_regos)){
                $item['registered'] = "yes";                
            }else{
                $item['registered'] = "";                
            }

            $_group = $item['option_group_c'];
            $group_exclude = trim($item['groups_to_exclude_c'], "^");
            $group_exclude = explode("^,^", $group_exclude);
            $group_exclude_message = $item['groups_to_exclude_message_c'];
            
            $_status = 0;
            if($item['auto_opt_in_c'] == "1"){
                $_status = 1;
            }

            if($item['force_option_selection_c'] == "1"){
                $_status = 2;
            }

            if(!empty($_group)){
                if(empty($option_groups[$_group])){
                   $option_groups[$_group] = array(); 
                }

                $option_groups[$_group][] = $item['id'];
                if(in_array($_group, $registered_groups)){
                    if($item['registered'] != "yes"){
                        $_status = -1;
                    }
                    //$item['registered'] = "yes";
                }
            }

            $options[$key] = $this->prepare_register_rego_option(array('item' => $item));

            $options_status[$item['id']] = array('parent' => $item['parent'], 'group' => $_group, 'status' => $_status, 'name' => $item['name'], 'group_exclude' => $group_exclude, 'exclude_message' => $group_exclude_message, 'registered' => $item['registered']);
        }
                
        $datas['option_groups'] = json_encode($option_groups);
        $datas['options_status'] = json_encode($options_status);

        // var_dump($datas['options_status']);
        ///////////////////

        // $datas['hide_flag'] = $rego_options[0]['hide_price_c'];
        
        $rego_list['primary'] = array($_primary_rego);
        $rego_list['options'] = $options;
        $data['options_count'] = count($options);
        $datas['primary_rego_id'] = $sys_primary_rego_id;

        if($sparams['registered'] == true){
            $datas['registered'] = "yes";    
        }else{
            $datas['registered'] = "";    
        }
        foreach ($rego_list['options'] as $option) {
            if (!empty($option['registered']) && $option['registered'] == 'yes') {
                $datas['registered'] = "yes";
                break;
            }
        }
        foreach ($rego_list['primary'] as $option) {
            if (!empty($option['registered']) && $option['registered'] == 'yes') {
                $datas['registered'] = "yes";
                break;
            }
        }

        $datas['event_name'] = $_event['name'];
        $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
        $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt'
                );
        $datas = array(
                    'AID' => $action_id,
                    'dt' => $datas
                );

        $TMPL = new EE_Template();
        $TMPL->run_template_engine('dentevents', 'register_options_item');
        $html = $this->EE->output->app_output($swaps, $datas, array('output' => false));

        $isNeedData = !empty($sparams['need_data']) ? $sparams['need_data'] : false;
        if ($isNeedData) {
            return [
                'data' => $datas,
                'html' => $html
            ];
        }

        return $html;
        
    }
}