<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Registration_Options_Reserve extends DEProcessing_Dentevents_Details_Premium_Registration_Options{
    protected $_registrant = '';
    
    function initialize($params = array()){
        $this->EE->load->model("cpd_eventregooptions");
        $this->EE->load->model("publication");
        
        if(!empty($params['registrant'])){
            $this->_registrant = $params['registrant'];
        }
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "fetch_data":
                return $this->fetch_data($params);
            break;
            case "apply":
                return $this->apply($params);
            break;
        }

    }
    
    function fetch_data($sparams = array())
    {
        $_event = $sparams['event'];
        $primary_rego_id = $sparams['primary_rego_id']; 
        $act_list = $sparams['act_list'];
        
        $reserve_config = array();
        $reserve_opt_list = array();
        $idx = 1; foreach($act_list as $act_id){
            /// pull primary rego ///
            $_rego_option = $this->EE->cpd_activity->get_relationship_cpd_eventregooptions(array(   
                                        'id' => $act_id,
                                        'selects' => "{#m}.id",
                                        'single' => true
                                    ));
            $parent_rego_id = $_rego_option['id'];
            /////////////////////////
            
            $options = $this->EE->cpd_eventregooptions->get_relationship_eventregooptions(array(
                        'id' => $parent_rego_id,
                        'selects' => "{#m}.id",
                        'where' => "{#c}.option_type_c='Option'",
                        'to_values' => 'id'
                ));
            $options = $this->get_child_regos($options);
            
            $result = array();    
            foreach($options as $option_id){
                $_matrix_event = $this->EE->cpd_eventregooptions->get_relationship_payment_matrix_event(array(
                                'id' => $option_id,
                                'selects' => '{#m}.id,{#m}.event_max_attendance,{#c}.allow_waitlist_c',
                                'single' => true
                            ));
                $reserve = $reserve_config[$option_id];
                if($reserve == null){
                    $status = self::$utility->load_reserve_tickets(
                                    $_matrix_event,
                                    array('exclude_cookie_reserve_ticket' => true, 'cookie' => self::$cookie_reserve_ticket)
                                );
                    $reserve = $reserve_config[$option_id] = array(
                                'event_id' => $_matrix_event['id'],
                                'allow_waitlist' => $_matrix_event['allow_waitlist_c'],
                                'remains' => $status['remains']
                            );
                }                                               
                $result[$option_id] = array('remains' => $reserve['remains']); 
            }
            $reserve_opt_list[] = array('key' => $idx, 'content' => json_encode($result));
            $idx++;
        }
        
        return array('config' => $reserve_config, 'opt_list' => $reserve_opt_list);   
    }
    
    function apply($sparams = array())
    {
        $_event = $sparams['event'];
        $primary_rego_id = $sparams['primary_rego_id']; 
        $act_list = $sparams['act_list'];
        
        $reserve_id_list = array();
        foreach($act_list as $act_id){
            /// pull primary rego ///
            $_rego_option = $this->EE->cpd_activity->get_relationship_cpd_eventregooptions(array(   
                                        'id' => $act_id,
                                        'selects' => "{#m}.id",
                                        'single' => true
                                    ));
            $parent_rego_id = $_rego_option['id'];
            /////////////////////////
            
            $options = $this->EE->cpd_eventregooptions->get_relationship_eventregooptions(array(
                        'id' => $parent_rego_id,
                        'selects' => "{#m}.id",
                        'where' => "{#c}.option_type_c='Option'",
                        'to_values' => 'id'
                ));
            $options = $this->get_child_regos($options);
            
            $matrix_events = array();
            foreach($options as $option_id){
                $_matrix_event = $this->EE->cpd_eventregooptions->get_relationship_payment_matrix_event(array(
                                'id' => $option_id,
                                'selects' => '{#m}.id,{#m}.event_max_attendance,{#c}.allow_waitlist_c',
                                'single' => true
                            ));
                if(empty($_matrix_event)){
                    continue;
                }
                if(in_array($_matrix_event['id'], $matrix_events)){
                    continue;
                }
                $matrix_events[] = $_matrix_event['id'];
                
                $opt_reserve_ticket = self::$utility->add_reserve_ticket(
                                        $_matrix_event, $primary_rego_id, 
                                        array(
                                            'data' => array('expired_at' => self::$reserve_ticket['expired_at'])
                                        )
                             );
                $reserve_id_list[] = $opt_reserve_ticket['id'];
            }            
        }
        
        self::$cookie_reserve_ticket = self::$utility->save_cookie_reserve_ticket(
                    $_event, $primary_rego_id,
                    array( 'key' => 'ids_for_options', 'value' => $reserve_id_list)
                );
        return self::$cookie_reserve_ticket;   
    }
    
    function get_child_regos($rego_options){
        $results = array();
        
        $params = array();
        $params['selects'] = "{#m}.id";      
        $params['where'] = "{#c}.option_type_c='Option'";
        $params['to_values'] = "id";
        foreach($rego_options as $id){
            $params['id'] = $item['id'];
            $options = $this->EE->cpd_eventregooptions->get_relationship_eventregooptions($params);
            if($options == null){
                $options = array();
            }
            $results = array_merge($results, $options);
        }
        
        $results = array_unique($results);
        return $results;
    }
}