<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Registration_Options_StepNext extends DEProcessing_Dentevents_Details_Premium_Registration_Options{
    protected $reg = 0;
    protected $already_registered = false;
    static $paid_option_id = "";
    function initialize($params = array()){
        
    }
    
    function process($params = array()){
        $cart = $this->EE->input->get_post("cart");
        $principal_act_id = $this->EE->input->get_post("principal_act_id");
        if ($principal_act_id == "") {
            echo 'error: principal_act_id is empty';exit;
        }

        $cart = json_decode($cart, true);

        $total = 0;

        foreach($cart as $act_id => $cart_item){
            $options = $cart_item['options'];
            $sub_total = 0;
            if(!$this->process_activity($act_id, $options, $sub_total)){
                return false;
            }
            $total += $sub_total;
        }

        self::$router = "payment:show";
        return DEProcessing_Dentevents_Details_Premium_Registration::process(array('principal_act_id' => $principal_act_id));
    }
    
    function process_activity($act_id, $options, &$total){
        /// pull registrant ///
        $_registrant = $this->EE->cpd_activity->get_relationship_contacts(array(   
                                    'id' => $act_id,
                                    'selects' => "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.rego_domain_c,{#c}.rego_no_c,{#c}.rego_no_nz_c,{#c}.rego_no_other_c,{#c}.pract_type_c,{#c}.pract_type_nz_c,{#c}.pract_type_other_1_c",
                                    'single' => true
                                ));
        ///////////////////////
        /// pull act data  ///
        $_act = $this->EE->cpd_activity->get_main_data(array(
                            "selects" => "{#m}.id,{#m}.name,{#m}.date_undertaken,{#m}.acttype,{#m}.location,{#m}.attendance,{#c}.address_used_c,{#c}.date_commenced_c,{#c}.special_diet_choice_c,{#c}.cat_a_cpd_c,{#c}.cat_b_cpd_c,{#c}.cat_c_cpd_c",
                            'where' => "{#m}.id='{$act_id}'",
                            'single' => true
                        ));
        //////////////////////
        $idx = 0;
        foreach($options as $opt_id => $opt_data){
            $activity_id = '';
            $sub_total = 0;
            if(($activity_id = $this->update_cpd_activity(($idx == 0), $_registrant, $_act, $opt_id, $opt_data, $sub_total)) == false){
                return false;
            }
            
            $total += $sub_total;
            $idx++;
        }

        return true;
    }
    
    function register_guests($is_primary, $_registrant, $_act, $opt_id, $opt_data, $act_data, $item){
        $_event = self::$event;
        $guests = $opt_data['guests'];
        
        $list_act_data = array();
        $list_guest_data = array();
        $task_datas = array();
        if($this->already_registered && $this->reg > 2){
            $act_data['paid_option_id_c'] = self::$paid_option_id;
        }
        if(empty($guests)){
            if($is_primary){
                return true;
            }
            $list_act_data[] = $act_data;    
        }
        
        foreach($guests as $guest_data){
            $temp_act_data = $act_data;
            $guest_data = json_decode($guest_data, true);
            $data = array(
                        'first_name' => $guest_data['first_name'],
                        'last_name' => $guest_data['last_name'],
                        'salutation' => $guest_data['salutation'],
                        'gender_c' => $guest_data['gender'],
                        'email_c' => $guest_data['email'],
                        'email1' => $guest_data['email'],
                        'phone_mobile' => $guest_data['mobile'],
                        'pract_type_c' => '^Event_Guest^'
                    );
            $list_guest_data[] = $data;
            
            /// update special meal ///
            if($guest_data['special_meal'] == 'none'){
                $guest_data['special_meal'] = '';
            }
            if($guest_data['special_meal'] != ''){
                $temp_act_data['special_diet_choice_c'] = $guest_data['special_meal'];   
            }
            ///////////////////////////
            $temp_act_data['rego_option_type_c'] = "Guests";
            $temp_act_data['payment_qty_c'] = 1;
            $temp_act_data['payment_total_c'] /= $opt_data['qty'];
            $list_act_data[] = $temp_act_data;
        }
        
        ///  create activity ///
        if(!empty($list_act_data)){
            $success = $this->EE->cpd_activity->set_records($list_act_data);
            if (!$success){
                $this->logger->developer("Failed to create the CPD Act. " . get_class($this));
                return false;
            } 
            $act_id_list = $success;
            if($this->already_registered && $this->reg == 2){
                self::$paid_option_id = $act_id_list[0];
            }
        }
        ////////////////////////
        
        ///  create guests ///
        if(!empty($list_guest_data)){
            $success = $this->EE->contacts->set_records($list_guest_data);
            if (!$success){
                $this->logger->developer("Failed to create the Guests. " . get_class($this));
                return false;
            } 
            $guest_id_list = $success;
            
            foreach($guest_id_list as $guest_id){
                $desc = "A new contact record for a Guest was created as a registrant for the CPD Event {$_event['name']}. Please check it.";
                $task_datas[] = array(
                    'name' => 'NewGuest Contact Added as Event Registrant',
                    'status' => 'In Progress',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'High',
                    'message_type_c' => 'System',
                    'description' => $desc,
                    'contact_id' => $guest_id,
                    'message_no_c' => 'MEV0089',
                );    
            }
        }
        ////////////////////////
        
        if(!empty($task_datas)){
            $success = $this->tasks->set_records($task_datas);
            if (!$success){
                $this->logger->developer("Failed to create the tasks for guests." . get_class($this));
            }  
        }
        
        /// link CPD Act to Contacts ///  
        $contact_id_list = $guest_id_list;
        if(empty($guests)){
            $contact_id_list = array($_registrant['id']);    
        }
        $success = $this->EE->contacts->add_relationships_app($contact_id_list, $act_id_list, 'cpdactivity');
        if(!$success){
            $this->logger->developer("Failed to link the cpd activityies to contacts " . get_class($this));
            return false;
        }
        ////////////////////////////////
        
        /// Link CPD Act(option or Guest) to CPD Act(Core) ///
        foreach($act_id_list as $act_item){
            $success = $this->EE->cpd_activity->add_relationship_app($act_item, $_act['id'], 'related_cpdactivity');
            if(!$success){
                $this->logger->developer("Failed to create the link between related_cpdactivity_core_to_opt " . get_class($this));
                return false;
            }    
        }
        //////////////////////////////////////////////////////
        
        /// link regooption and cpdactivity ///
        $success = $this->EE->cpd_eventregooptions->add_relationship_app($opt_id, $act_id_list, 'cpdactivity');
        if(!$success){
            $this->logger->developer("Failed to create the link between rego option and cpd activity " . get_class($this));
            return false;
        }
        ///////////////////////////////////////
        
        /// link CPD Acts to event ///
        $success = $this->EE->cpd_events->add_relationship_app($item['payment_matrix_event'], $act_id_list, 'cpdactivity');
        if(!$success){
            $this->logger->developer("Failed to link the cpd activity to event " . get_class($this));
            return false;
        }
        ////////////////////////
        
        return true;
    }
     
    function update_cpd_activity($is_primary, $_registrant, $_act, $opt_id, $opt_data, &$total){ 
        $_event = self::$event;
      
        self::$router = "item:prepare_register_rego_option";
        $item = DEProcessing_Dentevents_Details_Premium_Registration_Options::process(array('registrant' => $_registrant, 'item' => $opt_id, 'tax' => $tax));
        
        /// calculate total ///
        $discount = array_shift($item['discounts']);
        ///////////////////////
        
        $data = array();
        $data['payment_rate_c'] = $item['base_rate'];
        $data['payment_qty_c'] = $opt_data['qty'];
        
        /// tax ///
        if($item['include_tax_c'] == 1){
            $data['payment_tax_name_c'] = $item['tax_name_c'];
            $data['payment_tax_c'] = $item['tax_rate_c'];
        }
        ///////////
        
        $total = $data['payment_total_c'] = $opt_data['qty'] * ($item['base_rate'] - $discount['value'] * 1);
        if($discount != null){
            $data['payment_disc_c'] = $discount['value'];
            $data['payment_disc_type_c'] = $discount['type'];
            $data['payment_disc_note_c'] = $discount['note']['name'];
        }
        $data['status'] = "2AwaitingPayment";
        /////////////////////////////////////
        
        
        $registered_flag = !self::$utility->check_already_register_by_act($_act['id']);
        $data['payment_currency_c'] = $item['currency'];
        if($is_primary && $registered_flag){
             $data['id'] = $_act['id'];
             $data['name'] = $_act['name'] . " - " . $item['name'];
             


            $time = new DateTime();
            $time->setTimezone(new DateTimeZone("Australia/Sydney"));
            $time = $time->format("d M Y - h:i:s");
            $datas = array();
            $old_worklog = $this->EE->cpd_activity->get_main_data(array(
                            "selects" => "{#m}.work_log",
                            'where' => "{#m}.id='{$_act['id']}'",
                            'single' => true
                        ));
            $data['work_log'] = "{$old_worklog['work_log']}\r\n{$time} – CPD Activity Record Status changed from Incomplete to Awaiting Payment";

             $success = $this->EE->cpd_activity->set_record($data);
             if(!$success){
                 $this->logger->developer("Failed to update the cpd activity " . get_class($this));
                 return false;
             }
             $activity_id = $success;
             /// link it to event ///
             $success = $this->EE->cpd_events->add_relationship_app($item['payment_matrix_event'], $activity_id, 'cpdactivity');
             
             if(!$success){
                 $this->logger->developer("Failed to link the cpd activity to event " . get_class($this));
                 return false;
             }
        }
        
        if(!$registered_flag && $this->reg == 1){
            $data['paid_option_c'] = "1";
            $this->already_registered = true;
        }
        $this->reg++;
        $data = array_merge($data, $_act);
        $data['rego_option_type_c'] = "Option";   
        $data['name'] = $data['name'] . " - " . $item['name'];
        
        /// check matrix event ///
        $params = array();
        $params['id'] = $item['id'];
        $params['selects'] = "{#m}.id,{#m}.cpd_points_type_1,{#m}.cpd_points_type_2,{#m}.cpd_points_type_3";
        $params['single'] = true;
        $_mevent = $this->EE->cpd_eventregooptions->get_relationship_payment_matrix_event($params);
         
        $data['cat_a_cpd_c'] = $_mevent['cpd_points_type_1'];
        $data['cat_b_cpd_c'] = $_mevent['cpd_points_type_2'];
        $data['cat_c_cpd_c'] = $_mevent['cpd_points_type_3'];
        //////////////////////////
        unset($data['id']);

        return $this->register_guests($is_primary, $_registrant, $_act, $opt_id, $opt_data, $data, $item);
    }
}