<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Registration_Payment extends DEProcessing_Dentevents_Details_Premium_Registration{
    protected $step = 'payment';
    protected $cart = '';
    static $total_balance = NULL;
    
    function initialize($params = array()){
        $this->EE->load->model('rates');
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();


        
        switch($cmd){
            case "display_cart":
                return $this->display_cart($params);
            break;
            case "show":
                if(false && !empty($_COOKIE['register_p_c'])) {
                    $cookie_name = "register_p_c";
                    unset($_COOKIE[$cookie_name]);
                    $res = setcookie($cookie_name, "", time() - 3600);
                    $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
                    $principal_act_id = $this->EE->input->get_post("principal_act_id");
                    $time = new DateTime();
                    $time->setTimezone(new DateTimeZone("Australia/Sydney"));
                    $time = $time->format("d M Y - h:i:s");
                    $old_worklog = array();
                    if($principal_act_id){
                        $old_worklog = $this->EE->cpd_activity->get_main_data(array(
                                "selects" => "{#m}.id,{#m}.work_log",
                                'where' => "{#m}.id='{$principal_act_id}'",
                                'single' => true
                            ));
                    }
                    $new_worklog = "{$old_worklog['work_log']}\r\n{$time} – Page Refreshed on the Payment Page.";
                    $data = array();
                    $data['id'] = $principal_act_id;
                    $data['work_log'] = $new_worklog;
                    // $data[] = array('id' => $principal_act_id, 'work_log' => $new_worklog);
                    $success = $this->EE->cpd_activity->set_record($data);
                    // if($_SERVER['REMOTE_ADDR'] == '207.126.90.2'){
                    //     DEProcessing_Dentevents_Details_Premium_Registration::logConsole("data",$data,true);
                    //     DEProcessing_Dentevents_Details_Premium_Registration::logConsole("primary_rego_id",$primary_rego_id,true);
                    //     exit;
                    // }
                    if(!$success){
                        $this->logger->developer("Failed to update the work_log-" . get_class($this) . '-update_worklog_activities');
                    }
                    $this->update_worklog_activities();
                    self::$router = "reset";
                    return DEProcessing_Dentevents_Details_Premium_Registration::process($sparams);
                            
                }else{
                    $cookie_name = "register_p_c";
                    $cookie_value = true;
                    setcookie($cookie_name, $cookie_value, time() + (86400 * 30), '/');
                    self::$utility->save_step(self::$event, $this->step);
                    return $this->show($params);
                }
            break;
            case "step_next":
                return $this->step_next($params);
            break;
            case "cart_review":
                return $this->cart_review($params);
            break;
            case "bill":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/payment/bill.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Payment_Bill();
                $processing->initialize($params);
                return $processing->process($params);
            break;
        }

    }
    
    public function getPaypalConfig()
    {
        $_event = self::$event;
        $_organiser = self::$organiser;
        $data = array();
        /*$data['MERCHANT_ID'] = 'E9GCL5FX4TU2C';
        $data['SANDBOX_CLIENT_ID'] = 'AZazaq902xcELwoNkYxhzsbbdIX-jShBHYnKT0d43ODzXRvHdwkdjubUXO9yR20kYlVAFabTsZJuhKmM';
        $data['SANDBOX_CLIENT_SECRET'] = 'EEsK8Bs1NKdA7VCxwO2tR1uMtUV5hhboEHKMR5HBkEa44rlJyeUlr7T12D5B1cMc2hqZ2daEVTOk6tWx';
        $data['LIVE_CLIENT_ID'] = '';
        $data['LIVE_CLIENT_SECRET'] = '';
        $data['SANDBOX_FLAG'] = true;*/
        
        /*$data['MERCHANT_ID'] = '5SVD9LJTAW53A';
        $data['SANDBOX_CLIENT_ID'] = 'AVmG2Xkt5OYfRFDrKkQj9OEAN-IgaeSX4ZRRMJIk7YkaJ1KLoJ0eOaZdmZlvL1pULKEnWr52c_xJozV7';
        $data['SANDBOX_CLIENT_SECRET'] = 'EEiUSlQlym7QCELZq7mQBY98-Yo3rpW_PL0Clh87FiatN_9r199KbYNJLJ9X0Ol7KGgkBEYdisXQwIoo';
        $data['LIVE_CLIENT_ID'] = 'AbjVtiEuBz-Tzs5aMWsKgVZa-W4666v1LULZvCgQHTvb791dNVCoK-X6ZILuBWSaAEZEzFGLWs4E5PIX';
        $data['LIVE_CLIENT_SECRET'] = 'EIVlSIUYVBMhuG4SZ47THGAwMi6V0VXWdIRMuUJk9-ctw9EBCKkh-Faus9ZPfU1Y1WF2VlUOvo8AWGU0';
        $data['SANDBOX_FLAG'] = true; */
        
        $config = $_event['more_info'];
        $config = trim($config, " ");
        $config = explode("\r\n", $config);
        
        $data['MERCHANT_ID'] = $config[0];
        $data['SANDBOX_CLIENT_ID'] = $config[1];
        $data['SANDBOX_CLIENT_SECRET'] = $config[2];
        $data['LIVE_CLIENT_ID'] = $config[3];
        $data['LIVE_CLIENT_SECRET'] = $config[4];
        $data['SANDBOX_FLAG'] = ($config[5] == 'sandbox');
        ///// using paypal new fields ///////////
        $data['MERCHANT_ID'] = $_event['paypal_merchant_id_c'];
        $data['SANDBOX_CLIENT_ID'] = $config[1];
        $data['SANDBOX_CLIENT_SECRET'] = $config[2];
        $data['LIVE_CLIENT_ID'] = $_event['paypal_client_id_c'];
        $data['LIVE_CLIENT_SECRET'] = $_event['paypal_client_secret_c'];
        $data['SANDBOX_FLAG'] = ($config[5] == 'sandbox');
        ////////////////////////////////////////

        /////////// using paypal new fields in account record //////
        $data['MERCHANT_ID'] = $_organiser['paypal_merchant_id_c'];
        $data['SANDBOX_CLIENT_ID'] = "";
        $data['SANDBOX_CLIENT_SECRET'] = "";
        $data['LIVE_CLIENT_ID'] = $_organiser['paypal_api_username_c'];
        $data['LIVE_CLIENT_SECRET'] = $_organiser['paypal_api_password_c'];
        $data['SANDBOX_FLAG'] = false;
        //////////////////////////
        $data['ENV'] = 'production';
        
        return $data;
    }
    
    function cart_review($sparams = array()){
        $principal_act_id = $sparams['principal_act_id'];
        
        $promotion = array('code' => '', 'action' => '');
        if($sparams['promotion'] == null){
            $sparams['promotion'] = array();
        }
        $diffs = array_diff_key($promotion, $sparams['promotion']);
        $promotion = array_merge($sparams['promotion'], $diffs);
        
        $currency = "AUD";
                
        /// render items ///
        $act_list = $this->EE->cpd_activity->get_relationship_transactions_cpdactivity(array(
                    'id' => $principal_act_id,
                    'selects' => "{#m}.id",
                    'where' => "{#c}.rego_option_type_c='Core'",
                    'to_values' => "id"
                ));
        $act_list = array_merge(array($principal_act_id), $act_list);
        // var_dump($act_list);exit;
        $total = 0;
        $cart_review = array();
        $cart_review_datas = array();
        $number = 1;
        
        $all_acts = array();
        $tax = null;
        $result_promotion = 'no_exist';
        $promotion_message = '';
        
        $sql_where_promocode = "{#c}.rate_type_c='Promo_Code' and {#m}.rategroup='Dentevents' and {#m}.datefrom <= CURDATE() and {#m}.dateto >= CURDATE() and {#m}.amount > 0";
        if($promotion['code'] != ''){
            $sql_where_promocode .= " and {#m}.name='{$promotion['code']}'";    
        }
        $test_key = 0;
        foreach($act_list as $act_id){
            $registered = self::$utility->check_already_register_by_act($act_id);
            if(!$registered){
                $all_acts[] = $act_id;
            }
            
            /// pull registrant ///
            $_registrant = $this->EE->cpd_activity->get_relationship_contacts(array(   
                                        'id' => $act_id,
                                        'selects' => "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.email_c,{#c}.rego_domain_c,{#c}.rego_no_c,{#c}.rego_no_nz_c,{#c}.rego_no_other_c,{#c}.pract_type_c,{#c}.pract_type_nz_c,{#c}.pract_type_other_1_c",
                                        'single' => true
                                    ));
            $_contact_pract_type = self::$utility->get_pract_type_from_contact($_registrant);
            $_contact_pract_type = $this->helper->extract_multiselect($_contact_pract_type);
            ///////////////////////
            
            
            /// get options activity ///
            $act_list_options = $this->EE->cpd_activity->get_relationship_related_cpdactivity(array(
                    'id' => $act_id,
                    'selects' => "{#m}.id",
                    'where' => "{#c}.rego_option_type_c='Option' or {#c}.rego_option_type_c='Guests'",
                    'to_values' => "id"
                ));
            
            ////////////////////////////

            ///////// registered check ///////
            $_act_list_options = $this->EE->cpd_activity->get_relationship_related_cpdactivity(array(
                        'id' => $act_id,
                        'selects' => "{#m}.id,{#c}.paid_option_c",
                        'where' => "{#c}.rego_option_type_c='Option' or {#c}.rego_option_type_c='Guests'"
                    ));
            $paid_option = "";
            foreach($_act_list_options as $item){
                if($item['paid_option_c'] == "1"){
                    $paid_option = $item['id'];
                }
            }
            
            if(empty($paid_option)){
                $act_list_options = array_merge(array($act_id), $act_list_options);    
            }
            /////////////////////////////////
            
            /// options review ///
            $options_review = array();
            $sub_total = 0;            
            
            foreach($act_list_options as $act_id_option){
                $registered = self::$utility->check_already_register_by_act($act_id_option);
                if($registered){
                    continue;
                }
                $all_acts[] = $act_id_option;
                $act_option = $this->EE->cpd_activity->get_main_data(array(
                                'selects' => "{#m}.id,{#c}.rego_option_type_c,{#c}.payment_qty_c,{#c}.payment_disc_type_c,{#c}.payment_disc_note_c,{#c}.payment_disc_c,{#c}.payment_rate_c,{#c}.payment_total_c,{#c}.payment_currency_c,{#c}.payment_tax_c,{#c}.payment_tax_name_c",
                                'where' => "{#m}.id='{$act_id_option}'",
                                'single' => true
                            ));
                $regooption = $this->EE->cpd_activity->get_relationship_cpd_eventregooptions(array(
                                'id' => $act_id_option,
                                'selects' => "{#m}.id,{#m}.name,{#c}.charge_fta_only_c,{#c}.force_option_selection_c,{#c}.hide_price_c",
                                'single' => true
                            ));

                /// check promotion ///
                $rates = $this->EE->cpd_eventregooptions->get_relationship_rates(array(
                            'id' => $regooption['id'],
                            'selects' => "{#m}.id,{#m}.name,{#m}.amount,{#m}.country,{#m}.target,{#c}.cumulative_disc_c",
                            'where' => $sql_where_promocode
                        ));
                
                $promotion_rate = '';
                foreach($rates as $rate){
                    $targets = $rate['target'];
                    $targets = $this->helper->extract_multiselect($targets);
                    $country = $rate['country'];
                    $country = $this->helper->extract_multiselect($country);
                    //if(in_array($_registrant['rego_domain_c'], $country) &&
                    //    array_intersect($_contact_pract_type, $targets)
                    //   ){
                       $result_promotion = "exist"; 
                       $promotion_rate = $rate;
                    //   break;      
                    //}
                }
                ///////////////////////
                
                /// check tax ///
                if($tax == null && $act_option['payment_tax_name_c'] != null){
                    $tax = array('name' => $act_option['payment_tax_name_c'], 'rate' => $this->helper->toFixed($act_option['payment_tax_c'], 0));    
                }
                /////////////////
                $item = array();
                $item['review_name'] = $regooption['name'];
                $item['force_option_selection_c'] = $regooption['force_option_selection_c'];
                $item['hide_price_c'] = $regooption['hide_price_c'];
                $item['color_class'] = '';
                if($regooption['charge_fta_only_c'] == 1){
                    $item['review_name'] = 'Failure to Attend Fee';
                    $item['color_class'] = 'red';
                }
                /// get guest ///
                $item['guest'] = '';
                if($act_option['rego_option_type_c'] == 'Guests'){
                    $_guest = $this->EE->cpd_activity->get_relationship_contacts(array(   
                                        'id' => $act_id_option,
                                        'selects' => "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.email_c,{#c}.rego_domain_c,{#c}.rego_no_c,{#c}.rego_no_nz_c,{#c}.rego_no_other_c,{#c}.pract_type_c,{#c}.pract_type_nz_c,{#c}.pract_type_other_1_c",
                                        'single' => true
                                    ));  
                    if($_guest['salutation'] == 'AProf'){
                        $_guest['salutation'] = "A/Prof";    
                    }
                    $name = $_guest['salutation'] . ' ' . $_guest['first_name'] . ' ' . $_guest['initial_c'] . ' ' . $_guest['last_name']; 
                    if(!empty($_registrant['prefname_c'])){
                        $name = $_guest['salutation'] . ' ' .  $_guest['prefname_c'] . ' ' . $_guest['last_name']; 
                    }
                    $item['guest'] = array('name' => $name, 'id' => $_guest['id']);                                 
                }
                /////////////////
                $discount = array();
                if(!empty($act_option['payment_disc_type_c'])){                                        
                    /// label ///
                    $label = '';
                        switch($act_option['payment_disc_type_c']){
                            case 'Earlybird':
                                $label = 'Less Early Bird Discount';
                            break;
                            case 'Member':
                                $label = "Less {$act_option['payment_disc_note_c']} Member Discount";
                            break;
                            case 'Subscriber':
                                $label = "Less {$act_option['payment_disc_note_c']} Subscriber Discount";
                            break;
                        }
                    $discount['label'] = $label;
                    /////////////
                    $discount['value'] = $act_option['payment_disc_c'];
                    $discount['total'] = $this->helper->toFixed($act_option['payment_qty_c'] * $discount['value'], 2);

                    $item['discount'] = $discount;
                }
                                
                /// calculate promotion ///
                if($promotion['code'] != '' && $promotion_rate != ''){
                    $discount_promo = array();
                    $discount_promo['label'] = "Less Promo Code Discount - " . $promotion_rate['name'];    
                    $discount_promo['value'] = $this->helper->toFixed($promotion_rate['amount'], 2);
                    $discount_promo['total'] =  $this->helper->toFixed($act_option['payment_qty_c'] * $discount_promo['value'], 2);
                    
                    $data_for_account = array();
                    if($promotion_rate['cumulative_disc_c'] == 1){
                        $item['discount_promo'] = $discount_promo;    
                        $sub_total -= $discount_promo['total'] * 1;
                        
                        $data_for_account['id'] = $act_id_option;
                        $data_for_account['promo_code_disc_c'] = $promotion_rate['amount'];
                        $data_for_account['promo_code_c'] = $promotion_rate['name'];
                    }   
                    if($promotion_rate['cumulative_disc_c'] == 0){
                        $other_discount = ($discount['value'] > 0) ? $discount['value'] : 0;
                        
                        if($discount['value'] != null){
                            if($discount_promo['value'] * 1 < $other_discount){
                                $promotion_message = 'The Promo Code discount has not been applied because it is less than the other discounts applied.';    
                            }
                            if($discount_promo['value'] * 1 > $other_discount){
                                $promotion_message = 'The Promo Code discount has replaced the other discounts applied.';    
                            }
                        }
                        if($discount_promo['value'] * 1 > $other_discount){                            
                            $item['discount_promo'] = $discount_promo;    
                            $sub_total = $sub_total - $discount_promo['total'] * 1 + $discount['total'] * 1;
                            $data_for_account['id'] = $act_id_option;
                            $data_for_account['promo_code_disc_c'] = $promotion_rate['amount'];
                            $data_for_account['promo_code_c'] = $promotion_rate['name'];
                            $data_for_account['payment_disc_type_c'] = '';
                            $data_for_account['payment_disc_c'] = '';
                            $data_for_account['payment_total_c'] = $act_option['payment_rate_c'] * 1;
							unset($item['discount']);
                        }
                    }
                    
                    if($promotion['action'] == 'apply' && !empty($data_for_account)){
                        $success = $this->EE->cpd_activity->set_record($data_for_account);
                        if(!$success){
                            $this->logger->developer("Failed to update the account linked to rego option.");
                            return false; 
                        }
                        
                        $success = $this->EE->rates->add_relationship_app($promotion_rate['id'], $act_id_option, 'cpdactivity_promotion');
                        if(!$success){
                            $this->logger->developer("Failed to link between rate and cpdactivity.");
                            return false; 
                        }
                        $promotion['action_result'] = 'applied';
                    } 
                }
                ///////////////////////////
                
                $item['qty'] = $act_option['payment_qty_c'] * 1;
                $item['base_rate'] = $act_option['payment_rate_c'];
                $item['total'] = $this->helper->toFixed($item['qty'] * $item['base_rate'], 2);
                // if($_SERVER['REMOTE_ADDR'] == '103.6.219.221'){
                //     var_dump($act_option['payment_currency_c']);
                // }
                $item['currency'] = $act_option['payment_currency_c'];   
                $currency = $act_option['payment_currency_c'];
                $options_review[] = $item;                               
                                         
                $sub_total += $act_option['payment_total_c'] * 1;
                
            }

            // var_dump($options_review);exit;
            $sub_total = $this->helper->toFixed($sub_total, 2);
            //////////////////////
            if($_SERVER['REMOTE_ADDR'] == '103.6.219.221'){

                // var_dump($options_review);


            }
            /// render cart review ///
            $swaps = array(
                        'registrant' => 'registrant', 'options_review' => 'options_review', 'total' => 'total', 'number' => 'number'
                    );
            $datas = array(
                        'registrant' => $_registrant, 'options_review' => $options_review, 'total' => $sub_total, 'number' => $number++
                    );
            $TMPL = new EE_Template();         
            $TMPL->run_template_engine('dentevents', 'register_payment_review');
            $cart_review[] = $this->EE->output->app_output($swaps, $datas, array('output' => false));
            $cart_review_datas[] = $datas;
            //////////////////////////
            
            $total += $sub_total;
            
            $test_key++;
        }
                    
        $all_acts = array_unique($all_acts);
        
        /// promotion ///
        $promotion['result'] = $result_promotion;
        
        if($promotion_message == '' && $promotion['code'] != '' && $result_promotion == 'no_exist'){
            $promotion_message = 'The Promo Code entered is invalid or has expired';    
        }
        $promotion['message'] = $promotion_message;
        /////////////////
        self::$total_balance = $total;
       
       
        return array('cart_review' => $cart_review, 'cart_review_datas' => $cart_review_datas, 'total' => $total, 'all_acts' => $all_acts, 'tax' => $tax, 'promotion' => $promotion, 'currency' => $currency);
    }
    
    public function update_status_activities($all_acts, $status){
        $datas = array();
        foreach($all_acts as $item){
            $datas[] = array('id' => $item, 'status' => $status);
        }
        $success = $this->EE->cpd_activity->set_records($datas);
        if(!$success){
            $this->logger->developer("Failed to update the status-" . get_class($this) . '-update_status_activities');
        }
    }
    public function update_worklog_activities($all_acts, $log, $params){


        // DEProcessing_Dentevents_Details_Premium_Registration::logConsole("flag","enter",true);

        $time = new DateTime();
        $time->setTimezone(new DateTimeZone("Australia/Sydney"));
        $time = $time->format("d M Y - h:i:s");
        $datas = array();

        $tatal = number_format((float)$all_acts['total'], 2, '.', '');
        foreach($all_acts['all_acts'] as $item){
            $old_worklog = $this->EE->cpd_activity->get_main_data(array(
                                "selects" => "{#m}.work_log",
                                'where' => "{#m}.id='{$item}'",
                                'single' => true
                            ));
            switch($log){
            case "Initial":
                $new_worklog = "{$old_worklog['work_log']}\r\n{$time} – {$params['payment_type']} Payment Submitted for {$all_acts['currency']} {$tatal}";
                break;
            case "AwaitingPayment":
                $new_worklog = "{$old_worklog['work_log']}\r\n{$time} – CPD Activity Record Status changed from Incomplete to Awaiting Payment";
                break;
                case "RefreshPage-payment":
                $new_worklog = "{$old_worklog['work_log']}\r\n{$time} – CPD Activity Record Status changed from Incomplete to Awaiting Payment";
                break;
            case "PaymentEntered":
                if($params['payment_type'] == "Account"){
                    $new_worklog = "{$old_worklog['work_log']}\r\n{$time} – {$params['payment_type']} Payment is processed in the Portal {$all_acts['currency']} {$tatal} - {$params['payment_type']} receipt {$params['account_name']} - {$params['account_number']}";
                }
                if($params['payment_type'] == "Eway"){

                    $new_worklog = "{$old_worklog['work_log']}\r\n{$time} – {$params['payment_type']} Payment successful for {$all_acts['currency']} {$tatal} - {$params['payment_type']} receipt {$params['invoice_num']}";
                }
                break;
            case "PaymentAccept":
                $new_worklog = "{$old_worklog['work_log']}\r\n{$time} – CPD Activity Record Status changed from Awaiting Payment to Payment Accepted";
                break;
            case "PaymentFailed":
                $new_worklog = "{$old_worklog['work_log']}\r\n{$time} – {$params['payment_type']} Payment failed for {$all_acts['currency']} {$tatal} - {$params['msg']}";
                break;
            case "PaymentRjected":
                $new_worklog = "{$old_worklog['work_log']}\r\n{$time} – CPD Activity Record Status changed from Awaiting Payment to Payment Rejected";
                break;
            case "LoadSuccessPage":
                $new_worklog = "{$old_worklog['work_log']}\r\n{$time} – Registration Complete Page Displayed";
                break;
            case "ErrorDisplayed":
                $new_worklog = "{$old_worklog['work_log']}\r\n{$time} – Transaction declined error message displayed - {$params['msg']}";
                break;
            }
            
            
            $datas[] = array('id' => $item, 'work_log' => $new_worklog);
        }

        
        // DEProcessing_Dentevents_Details_Premium_Registration::logConsole("all_acts",$all_acts,true);
        // DEProcessing_Dentevents_Details_Premium_Registration::logConsole("log",$log,true);
        // if($_SERVER['REMOTE_ADDR'] == '103.6.219.0'){
        //     $sub = number_format((float)$all_acts['total'], 2, '.', ''); 
        //     DEProcessing_Dentevents_Details_Premium_Registration::logConsole("sub",$sub,true);

        //     exit;
        // }

        $success = $this->EE->cpd_activity->set_records($datas);
        if(!$success){
            $this->logger->developer("Failed to update the work_log-" . get_class($this) . '-update_worklog_activities');
        }
    }
    public function display_cart($sparams=''){
        $_event = self::$event;      
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post("principal_act_id");
       
        if($sparams['principal_act_id'] != ''){
            $principal_act_id = $sparams['principal_act_id'];
        }
        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        
        
        $promo_code = $this->EE->input->get_post('promo_code');
        
        $results = $this->cart_review(array(
                        'principal_act_id' => $principal_act_id,
                        'promotion' => array('code' => $promo_code, 'action' => 'validation')
                    )
                );
        $cart_review = $results['cart_review']; 
        
        $total = $results['total'];
        $tax = $results['tax'];  
        ///////
        // var_dump($tax);array(2) { ["name"]=> string(3) "GST" ["rate"]=> string(2) "10" }
        //// 
        $currency = $results['currency'];
        $datas = array();
        $datas['id'] = $_event['event_id_c'];
        $datas['cart_review_html'] = implode(" ", $cart_review);
        $datas['principal_act_id'] = $principal_act_id;
        $datas['primary_rego_id'] = $primary_rego_id; 
        $datas['promotion'] = $results['promotion'];
        
        $payment = array();
        $datas['payment'] = &$payment;
        
        $payment['total'] = $this->helper->toFixed($total, 2);
        $payment['tax'] = $tax;
        $payment['currency']  = $currency;
        
        $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
        $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt'
                );
        $datas = array(
                    'AID' => $action_id,
                    'dt' => $datas
                );
        
        $this->EE->TMPL->run_template_engine("dentevents", "register_payment_cart");    
        
        $html = $this->EE->output->app_output($swaps, $datas, array('output' => false));  
        
        if($sparams['output'] === false){
            return $html;
        }
        
        echo $html;
        exit;
    }
    
    public function show($sparams=''){
        $_event = self::$event;      
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        //  if($_SERVER['REMOTE_ADDR'] == '149.154.156.99'){
        //     var_dump("expression");exit;
        // }
          
        $img_base_url = $this->_crm_config['main']['upload_url'];
        $principal_act_id = $sparams['principal_act_id'];
        if($principal_act_id == ''){
            $principal_act_id = self::$utility->load_cookie_registration('principal_act_id', array('event' => $_event, 'primary_rego_id' => $primary_rego_id));
        }

        $datas = $this->fetch_basic_data();
        $datas['cart_html'] = $this->display_cart(array_merge($sparams, array('output' => false)));
        $datas['principal_act_id'] = $principal_act_id;
        $datas['primary_rego_id'] = $primary_rego_id;
        
        /// get primary rego option ///
        $fta = '';
        $params = array();
        $params['selects'] = self::$_selects_regooptions;      
        $params['where'] = "{#m}.id='{$primary_rego_id}'";
        $params['single'] = true;
        $_primary_rego = $this->EE->cpd_eventregooptions->get_main_data($params);
        $fta = $_primary_rego['charge_fta_only_c'];
        $datas['fta'] = $fta;        
        //////////////
        $payment = array();
        $datas['payment'] = &$payment;
        
        if(!empty($_event['payment_types_accepted_c'])){
            /// form ///
            $payment_types = $_event['payment_types_accepted_c'];
            $payment_types = trim($payment_types, "^");
            $payment_types = explode("^,^", $payment_types);
            
            $method_maps = array('amex' => 'AE', 'diners' => 'DC', 'mastercard' => 'MC', 'visa' => 'VI', 'JCB' => 'JC');
            if($_event['payments_methods_c'] != null){
                $payment_methods = $_event['payments_methods_c'];
                $payment_methods = trim($payment_methods, "^");
                $payment_methods = explode("^,^", $payment_methods);
            }
            $accept_cards = array();
            foreach($payment_methods as $item){
                if($item == 'paypal'){
                    continue;
                }
                $key = $method_maps[$item];
                $title = $this->helper->get_dropdowns_sugar_labels('payments_methods_list', $item, false);
                $accept_cards[] = array('code' => $key, 'title' => $title);
            }
      
            if(false && self::$total_balance <= 0 ){
                $payment['html'] = '';
            }else{
                $additional = array();
                if(in_array('paypal', $payment_types)){
                    $additional = $this->getPaypalConfig();    
                }
                require_once(PATH_THIRD . 'payments/models/processing.php');
                $processing = new PTSProcessing();
                $processing->initialize("payments:show");
                $payment['html'] = $processing->process(array('accept_gateways' => $payment_types, 'accept_cards' => $accept_cards, 'additional' => $additional));
            }

            ////////////
        }
        
        $payment['note_1'] = $_event['payment_note_1_c'];
        $payment['note_2'] = $_event['payment_note_2_c'];
        $payment['note_1_user'] = $_event['payment_note_1_user_c'];
        $payment['note_2_user'] = $_event['payment_note_2_user_c'];
        
        /// Event Organiser’s Logo ///
        if(!empty(self::$organiser['logo_c'])){
            $datas['org_logo'] = $img_base_url . self::$organiser['logo_c'];
        }
        
        $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
        $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt',
                    'reserve_ticket_html' => 'reserve_ticket_html',
                    'global_message' => 'global_message'
                );
        $datas = array(
                    'AID' => $action_id,
                    'dt' => $datas,
                    'reserve_ticket_html' => $this->render_reserve_ticket(self::$reserve_ticket),
                    'global_message' => $sparams['global_message']
                );
        
        $this->EE->TMPL->run_template_engine("dentevents", "register_payment");
        
        $this->EE->output->app_output($swaps, $datas, array('env' => true));
    }
    
    
    public function step_next($params=''){
        $_event = self::$event;        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        
        $datas = $this->fetch_basic_data();        
        $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
        $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt'
                );
        $datas = array(
                    'AID' => $action_id,
                    'dt' => $datas
                );
        
        $this->EE->TMPL->run_template_engine("dentevents", "register_complete");    
        
        $this->EE->output->app_output($swaps, $datas, array('env' => true));
        
        
    }
}