<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Registration_Payment_Bill extends DEProcessing_Dentevents_Details_Premium_Registration_Payment{
    function initialize($params = array()){
         $this->EE->load->model("accounts");
    }
    
    function process($sparams = array()){
        $_event = self::$event;
        $payment = $this->EE->input->get_post('payment');

        $principal_act_id = $this->EE->input->get_post("principal_act_id");
        $promo_code = $this->EE->input->get_post("promo_code");

        /// get total ///
        $cart = $this->cart_review(array(
            'principal_act_id' => $principal_act_id,
            'promotion' => array('code' => $promo_code, 'action' => 'apply')
        ));
        $total = $cart['total'];
        $this->cart = $cart;
        $promotion = $cart['promotion'];
        /////////////////
        
        if(is_array($payment)){
            $gateway = $payment['method'];
        }else{
            $gateway = $payment;    
        }

        if($total == 0 && $gateway != "paypal") {
            $payment_types = $_event['payment_types_accepted_c'];
            $payment_types = trim($payment_types, "^");
            $payment_types = explode("^,^", $payment_types);

            $payment_methods = strtolower($_event['payments_methods_c']);
            $payment_methods = trim($payment_methods, "^");
            $payment_methods = explode("^,^", $payment_methods);

            if(in_array("no_charge", $payment_types) &&
                in_array("free", $payment_methods) &&
                $_event['auto_accept_free_regos_c'] == "1" ||
                (isset($promotion['action_result']) && $promotion['action_result'] == "applied")
            ) {
                $gateway = 'free';
            } else {
                $this->logger->developer(json_encode($_SERVER));
                return 'failed';
            }
        }

        /*if($_event['allow_waitlist_c']){
            $gateway = 'free';
        }*/
        
        switch($gateway){
            case 'eway':
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/payment/bill/eway.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Payment_Bill_Eway();
                $processing->initialize($sparams);
                return $processing->process($sparams);
            break;
            case 'capture':
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/payment/bill/capture.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Payment_Bill_Capture();
                $processing->initialize($sparams);
                return $processing->process($sparams);
            break;
            case 'free':
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/payment/bill/free.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Payment_Bill_Free();
                $processing->initialize($sparams);
                return $processing->process($sparams);
            break;
            case 'paypal':
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/payment/bill/paypal.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Payment_Bill_Paypal();
                $processing->initialize($sparams);
                return $processing->process($sparams);
            break;
            case 'account':
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/payment/bill/account.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Payment_Bill_Account();
                $processing->initialize($sparams);
                return $processing->process($sparams);
            break;
        }
    }
    
    function prepare_invoice($sparams = array()){
        $_event = self::$event;
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post("principal_act_id");
        
        /// prepare principal activity ///
        $_principal_act = $this->EE->cpd_activity->get_main_data(array(
                    'selects' => "{#m}.id,{#c}.address_used_c",
                    'where' => "{#m}.id='{$principal_act_id}'",
                    'single' => true
                ));
        //////////////////////////////////
        
        /// prepare invoice ///
        $invoice = array();
        //$cart = $this->cart_review(array('principal_act_id' => $principal_act_id));
        $cart = $sparams['cart'];
        $invoice['cart_review_datas'] = $cart['cart_review_datas'];
        $invoice['tax'] = $cart['tax'];
        $invoice['organiser'] = self::$organiser;
        
            /// event ///
            $event = array();
            $event['name'] = $_event['name'];
            $event['city'] = $_event['event_city'];
            $event['country'] = $_event['event_country'];
            $event['start_date'] = $_event['start']['date'];
            $event['end_date'] = $_event['end']['date'];
            $event['tax_name'] = $_event['tax_name_c'];
            $event['tax_rate'] = $_event['tax_rate_c'];
            $event['action'] = $this->seo_helper->get_seo_url(Seo_Helper::DETAILS, array('id' => $_event['event_id_c'], 'name' => $_event['name'], 'country' => $_event['event_country']));
            $event['receipt_footer'] = $_event['receipt_footer_c'];
            $event['merchant_account_name'] = $_event['merchant_account_name_c'];
            $invoice['event'] = $event;
            /////////////
        
            /// address ///
            $address = array();
            $principal_registrant_id = $cart['cart_review_datas'][0]['registrant']['id'];
            $_principal_registrant = $this->EE->contacts->get_main_data(array(   
                                            'selects' => "{#m}.id,{#m}.alt_address_street,{#m}.alt_address_city,{#m}.alt_address_state,{#m}.alt_address_postalcode,{#m}.alt_address_country,{#c}.account_id_c",
                                            'where' => "{#m}.id='{$principal_registrant_id}'",
                                            'single' => true
                                        ));
            if($_principal_act['address_used_c'] == 'Principle'){
                /// principal account ///
                $params = array();
                $params['selects'] = "{#m}.id,{#m}.billing_address_street,{#m}.billing_address_city,{#m}.billing_address_state,{#m}.billing_address_postalcode,{#m}.billing_address_country,{#c}.billing_name_c";
                $params['where'] = "{#m}.id='{$_principal_registrant['account_id_c']}'";
                $params['single'] = true;
                $principal_account = $this->EE->accounts->get_main_data($params);
                ///////////////
                $address['name'] = $principal_account['billing_name_c'];
                $address['city'] = $principal_account['billing_address_city'];
                $address['state'] = $principal_account['billing_address_state'];
                $address['postalcode'] = $principal_account['billing_address_postalcode'];
                $address['street'] = $principal_account['billing_address_street'];
                $address['country'] = $principal_account['billing_address_country'];
            }else{
                $address['city'] = $_principal_registrant['alt_address_city'];
                $address['state'] = $_principal_registrant['alt_address_state'];
                $address['postalcode'] = $_principal_registrant['alt_address_postalcode'];
                $address['street'] = $_principal_registrant['alt_address_street'];
                $address['country'] = $_principal_registrant['alt_address_country'];
            }
            $invoice['address'] = $address;
            //////////////////
        ///////////////////////
        
        return $invoice;
    }
}