<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Registration_Payment_Bill_Eway extends DEProcessing_Dentevents_Details_Premium_Registration_Payment_Bill{
    function initialize($params = array()){

    }

    function process($sparams = array()){
        $stage = $this->EE->input->get_post("stage");
        if($stage == ''){
            $stage = 'start';
        }
        if($stage == 'start'){
            return $this->start();
        }
        if($stage == 'pay'){
            return $this->pay();
        }
        if($stage == 'cancel'){
            return $this->cancel();
        }
    }

    function start($sparams = array()){
        $_event = self::$event;
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post("principal_act_id");
        $promo_code = $this->EE->input->get_post("promo_code");

        $site_url = $this->EE->config->item("site_url");

        /// get total ///
        $cart = $this->cart_review(array(
            'principal_act_id' => $principal_act_id,
            'promotion' => array('code' => $promo_code, 'action' => 'apply')
        ));
        $total = $cart['total'];
        $this->cart = $cart;

        /* info start */
        $eway_customer_id = $_event['payment_gateway_id_c'];

        $info = array();
        $_registrant = $this->EE->cpd_activity->get_relationship_contacts(array(
            'id' => $principal_act_id,
            'selects' => "{#m}.id,{#m}.salutation, {#m}.first_name,{#m}.last_name,{#m}.alt_address_street,{#m}.alt_address_city,{#m}.alt_address_state,{#m}.alt_address_country,{#m}.alt_address_postalcode",
            'single' => true
        ));
        $_act = $this->EE->cpd_activity->get_main_data(array(
            'selects' => "{#m}.id,{#m}.name,{#c}.address_used_c,{#c}.cpd_activity_id_c",
            'where' => "{#m}.id='{$principal_act_id}'",
            'single' => true
        ));
        $_addr = $this->get_address_principal_registrant($principal_act_id);
        if($_registrant['salutation'] == "A/Prof" || $_registrant['salutation'] == "A/Prof."){
            $_registrant['salutation'] == "AProf";
        }
        $res = $_act['name'];
        $ref = preg_replace("/[^a-zA-Z0-9\s]/", "", $res);
        $info['salutation'] = $_registrant['salutation'];
        $info['firstname'] = $_registrant['first_name'];
        $info['lastname'] = $_registrant['last_name'];
        $info['email'] = $this->EE->contacts->get_email_address($_registrant['id']);
        $info['invoice_number'] = $_act['cpd_activity_id_c'];
        $info['invoice_desc'] = $ref;
        $info['invoice_ref'] = $_act['cpd_activity_id_c'];
        $info['street'] = $_addr['street'];
        $info['city'] = $_addr['city'];
        $info['state'] = $_addr['state'];
        $info['country'] = $_addr['country'];
        $info['postcode'] = $_addr['postalcode'];

        $info['address'] = "{$_addr['street']}, {$_addr['city']}, {$_addr['state']}, {$_addr['country']}";
        $info['curreny'] = $cart['currency'];
        ////////////////
        /* info end*/

        $cmd = base64_encode("dentevents:details:premium:registration:payment:bill");
        $markflow = array(
            'return_url' => $site_url . "?ACT=24&cmd={$cmd}&id={$_event['event_id_c']}&primary_rego_id={$primary_rego_id}&principal_act_id={$principal_act_id}&payment=eway&promo_code={$promo_code}&stage=pay",
            'cancel_url' => $site_url . "?ACT=24&cmd={$cmd}&id={$_event['event_id_c']}&primary_rego_id={$primary_rego_id}&principal_act_id={$principal_act_id}&payment=eway&stage=cancel",
        );

        $result = $this->helper->payment(array(
            'amount' => $total, 'customer_id' => $eway_customer_id, 'info' => $info,
            'markflow' => $markflow,
            'stage' => 'start'
        ));

        echo json_encode($result);exit;
    }

    function pay($sparams = array()){
        $principal_act_id = $this->EE->input->get_post("principal_act_id");
        $promo_code = $this->EE->input->get_post("promo_code");

        /// get total ///
        $cart = $this->cart_review(array(
            'principal_act_id' => $principal_act_id,
            'promotion' => array('code' => $promo_code, 'action' => 'apply')
        ));
        $total = $cart['total'];
        $this->cart = $cart;
        /////////////////

        $params = array();
        $params['payment_type'] = "Eway";

//        $this->update_worklog_activities($this->cart, 'Initial',$params);

        $result = $this->helper->payment(array('stage' => 'pay'));
        $result['total'] = $total;

        $code = $result['code'];
        $msg = $result['msg'];


        if($code == 'success'){
            $params['invoice_num'] = $result['transaction_id'];
//            $this->update_worklog_activities($this->cart, 'PaymentEntered', $params);

        }else{
            $params['msg'] = $result['msg'];
//            $this->update_worklog_activities($this->cart, 'PaymentFailed', $params);
        }

        $json_result = array();
        if($code == 'success'){
//            $this->update_worklog_activities($this->cart, 'PaymentAccept', $params);
            $cookie_name = "register_p";
            $cmd = '';
            if(!empty($_COOKIE['register_p'])) {
                $cmd = "reset";

                unset($_COOKIE[$cookie_name]);
                $res = setcookie($cookie_name, '', time() - 3600);
            }else{
                $cookie_value = true;
//              setcookie($cookie_name, $cookie_value, time() + (86400 * 30), '/');
            }
            return $this->process_success(array('cmd' => $cmd, 'payment_result' => $result, 'cart' => $cart));
        }else{
//          $this->update_worklog_activities($this->cart, 'PaymentRjected', $params);
//          $this->update_worklog_activities($this->cart, 'ErrorDisplayed', $params);

            return $this->process_fail(array('payment_result' => $result, 'cart' => $cart));
        }
    }

    function cancel($sparams = array()){
        self::$router = "payment:show";
        return DEProcessing_Dentevents_Details_Premium_Registration::process();
    }


    function process_success($sparams = array()){
        $_event = self::$event;
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post("principal_act_id");
        $payment_result = $sparams['payment_result'];
        $cart = $sparams['cart'];

        ///////// registered check ///////
        $act_list_options = $this->EE->cpd_activity->get_relationship_related_cpdactivity(array(
            'id' => $principal_act_id,
            'selects' => "{#m}.id,{#c}.paid_option_c",
            'where' => "{#c}.rego_option_type_c='Option' or {#c}.rego_option_type_c='Guests'",
            'orders' => "{#m}.date_entered asc"
        ));
        $paid_option = "";
        foreach($act_list_options as $item){
            if($item['paid_option_c'] == "1"){
                $paid_option = $item['id'];
            }
        }
        if(!empty($paid_option)){
            $principal_act_id = $paid_option;
        }
        /////////////////////////////////
        $invoice = $this->prepare_invoice(array('cart' => $cart));

        /// init activity ///
        $_act = $this->EE->cpd_activity->get_main_data(array(
            'selects' => "{#m}.id,{#m}.status,{#c}.cpd_activity_id_c",
            'where' => "{#m}.id='{$principal_act_id}'",
            'single' => true
        ));
        /////////////////////
        /// client ///
        $account_ticket_billing = $this->EE->cpd_events->get_relationship_account_ticket_billing(array(
            'id' => $_event['id'],
            'selects' => '{#m}.id',
            'single' => true
        ));
        //////////////
        $fees = array();
        if(!empty($_event['ticketing_commission_c']) && !empty($account_ticket_billing) && ($payment_result['total'] > 0)){
            $fees['ticketing_commission_c'] = $_event['ticketing_commission_c'];
            /// save invoice xero ///
            $this->EE->load->model('acc_sales');
            $date = new DateTime();
            $date->add(new DateInterval('P30D'));
            $xero = array();

            $xero['currency'] = 'AUD';
            $xero['company_id'] = '8d3ff3f0-5c4d-45c9-8c97-549123d0a6b0';
            // $xero['company_id'] = '0d09ebb2-1525-11e7-80fd-a9b9dbce184d';
            $xero['account_id_c'] = $account_ticket_billing['id'];
            $xero['invoice_date'] = date("Y-m-d");
            $xero['invoice_due'] = $date->format('Y-m-d');
            $xero['amount_includes_tax'] = 1;
            $xero['status'] = 'Service';
            $xero['type'] = 'Invoice';
            $xero['name'] = $_act['cpd_activity_id_c'];
            /// invoice lines ///
            $cart_review_datas = $invoice['cart_review_datas'];

            $lines = array();

            foreach($cart_review_datas as $item){
                $description = "Dentevents.com Ticketing Commission - {$_event['name']} - {$item['registrant']['salutation']} {$item['registrant']['first_name']} {$item['registrant']['last_name']}";
                $lines[] = array('quantity' => 1, 'description' => $description, 'tax_code' => 'OUTPUT', 'account_code' => '290', 'unit_price' => $_event['ticketing_commission_c']);
            }

            if($_event['ticketing_charges_c'] != ''){
                $lines[] = array(
                    'quantity' => 1,
                    'description' => 'Online Processing Charge',
                    'tax_code' => 'OUTPUT',
                    'account_code' => '290',
                    'unit_price' => $_event['ticketing_charges_c']
                );
                $fees['ticketing_charges_c'] = $_event['ticketing_charges_c'];
            }
            /////////////////////
            /// check card fee ///
            $card_type = $this->helper->get_cc_type_name($payment_result['payment']['cc_type']);
            $card_type_label = $this->helper->get_dropdowns_sugar_labels('payments_methods_list', $card_type, false);
            $card_type = "^" . $card_type . "^";
            $card_fee = 0;
            if(strpos($_event['ticketing_merch_fee_app_1_c'], $card_type) !== false){
                $card_fee = $_event['ticketing_merch_fee_1_c'];
            }
            if(strpos($_event['ticketing_merch_fee_app_2_c'], $card_type) !== false){
                $card_fee = $_event['ticketing_merch_fee_2_c'];
            }
            if(strpos($_event['ticketing_merch_fee_app_3_c'], $card_type) !== false){
                $card_fee = $_event['ticketing_merch_fee_3_c'];
            }
            $card_fee = !empty($_event['ticketing_merch_fee_1_c']) ? $_event['ticketing_merch_fee_1_c'] : 0;
            if($card_fee != 0){
                $lines[] = array(
                    'quantity' => 1,
                    'description' => 'Credit Card Processing Fee - ' . $card_type_label,
                    'tax_code' => 'OUTPUT',
                    'account_code' => '290',
                    'unit_price' => $payment_result['total'] * $card_fee / 100
                );
                $fees['ticketing_merchant_fee_c'] = $payment_result['total'] * $card_fee / 100;
            }
            //////////////////////

            // $xero['items'] = $lines;

            $xero['line_items'] = json_encode($lines);

            $xero['acc_config_id_c'] = "0d09ebb2-1525-11e7-80fd-a9b9dbce184d";

            /*            $result = $this->EE->acc_sales->save_invoice($xero);
                        $response = $result->response_data;


                        if(!$response){
                            ////////////// sending email about xero fails /////
                            $address = "joseph@dentist.com.au";
                            $subject = "Xero Fails";

                            $bcc = "adeelgod1225@gmail.com";
                            $content = "Hello Joseph.<br>The connector between XERO and Sugar is not working now.";
                            $this->EE->load->library('email');
                            $this->EE->email->wordwrap = true;
                            $this->EE->email->set_mailtype('html');
                            $this->EE->email->from('info@dentevents.com', 'Creating Xero Invoice Fails');
                            $this->EE->email->to($address);
                            $this->EE->email->bcc($bcc);
                            $this->EE->email->reply_to('info@dentevents.com');
                            $this->EE->email->subject($subject);
                            $this->EE->email->message($content);

                            $status = '';
                            if($this->EE->email->send()){
                                $status = "success";
                            }else{
                                $status = "fail";
                            }
                            ///////////////////////////////////////////////////
                            //return false;

                        }*/
            /// fill response from xero ///
            $xero['remote_id'] = $response->remote_id;
            $xero['remote_last_update_key'] = $response->remote_last_update_key;
            $xero['invoice_no'] = $response->invoice_no;
            $xero['amount'] = $response->amount;
            $xero['amount_due'] = $response->amount_due;
            $xero['tax_amount'] = $response->tax_amount;
            ///////////////////////////////
        }

        $data = array();
        $data['id'] = $principal_act_id;
        $data['terms_accepted_c'] = 1;
        $data['ip_address_c'] = $_SERVER['REMOTE_ADDR'];
        $data['payment_receipt_c'] = $payment_result['transaction_id'];
        $data['receipt_data_c'] = json_encode($invoice);
        $data['status'] = "4PaymentAccepted";
        $data['payment_cardholder_c'] = $payment_result['payment']['cc_holder_name'];
        $data['payment_cc_no_c'] = $this->helper->get_security_card_number($payment_result['payment']['cc_number']);
        $data['payment_date_c'] = $data['payment_process_date_c'] = date("Y-m-d H:i:s");
        $data['payment_total_charged_c'] = $payment_result['total'];
        $data['payment_process_method_c'] = 'eway';

        $data['ticketing_merchant_fee_c'] = !empty($fees['ticketing_merchant_fee_c']) ? $fees['ticketing_merchant_fee_c'] : 0;
        $data['ticketing_charges_c'] = !empty($_event['ticketing_charges_c']) ? $_event['ticketing_charges_c'] : 0;
        $data['ticketing_commission_c'] = !empty($_event['ticketing_commission_c']) ? $_event['ticketing_commission_c'] : 0;

        /*if($payment_result['total'] <= 0){
            $data['payment_type_c'] = "free";
        }
        else{
            $data['payment_type_c'] = $this->helper->get_cc_type_name($payment_result['payment']['cc_type']);
        }
        //// filter card type again ////
        if(empty($data['payment_type_c']) || empty($payment_result['payment']['cc_type'])){
            $data['payment_type_c'] = $this->helper->validate_cc_number($payment_result['payment']['cc_number']);
        }*/
        $data['payment_type_c'] = 'eway';
        ////
        if($fees != ''){
            $data = array_merge($data, $fees);
        }

        /// check tax ///
        $tax = $invoice['tax'];
        if($tax != null){
            $tax_rate = $tax['rate'];
            $data['payment_tax_charged_c'] = $this->helper->toFixed($payment_result['total'] * $tax_rate / (100 + $tax_rate), 2);
        }
        /////////////////

        /*        $success = $this->EE->cpd_activity->set_record($data);
                if(!$success){
                    $this->logger->developer("Failed to update CPD Activity for Payment" . get_class($this));
                    return false;
                }*/
//        $this->update_status_activities($this->cart['all_acts'], '4PaymentAccepted');

        /// send email ///
        self::$router = "receipt:email";
//        DEProcessing_Dentevents_Details_Premium_Registration::process(array('act_id' => $principal_act_id));
        //////////////////

        /// send email to contacts who has receiveNotification///
        self::$router = "sendemail";
//        DEProcessing_Dentevents_Details_Premium_Registration::process(array('act_id' => $principal_act_id, 'payment_result' => $payment_result));
        //////////////////

//        $this->do_apply_reset();

        self::$router = "success:eway";
        if (!empty($sparams['cmd'])) {
            self::$router = $sparams['cmd'];
        }
        return DEProcessing_Dentevents_Details_Premium_Registration::process();
    }

    function process_fail($sparams = array()){
        $_event = self::$event;
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post("principal_act_id");
        $payment_result = $sparams['payment_result'];
        $cart = $sparams['cart'];
        ///////// registered check ///////
        $act_list_options = $this->EE->cpd_activity->get_relationship_related_cpdactivity(array(
            'id' => $principal_act_id,
            'selects' => "{#m}.id,{#c}.paid_option_c",
            'where' => "{#c}.rego_option_type_c='Option' or {#c}.rego_option_type_c='Guests'",
            'orders' => "{#m}.date_entered asc"
        ));
        $paid_option = "";
        foreach($act_list_options as $item){
            if($item['paid_option_c'] == "1"){
                $paid_option = $item['id'];
            }
        }
        if(!empty($paid_option)){
            $principal_act_id = $paid_option;
        }
        /////////////////////////////////
        $invoice = $this->prepare_invoice(array('cart' => $cart));

        $data = array();
        $data['id'] = $principal_act_id;
        $data['terms_accepted_c'] = 1;
        $data['ip_address_c'] = $_SERVER['REMOTE_ADDR'];
        $data['receipt_data_c'] = json_encode($invoice);
        $data['status'] = "5PaymentRejected";
        $data['payment_cardholder_c'] = $payment_result['payment']['cc_holder_name'];
        $data['payment_type_c'] = $this->helper->get_cc_type_name($payment_result['payment']['cc_type']);
        $data['payment_cc_no_c'] = $this->helper->get_security_card_number($payment_result['payment']['cc_number']);
        $data['payment_date_c'] = date("Y-m-d H:i:s");

        $success = $this->EE->cpd_activity->set_record($data);
        if(!$success){
            $this->logger->developer("Failed to update CPD Activity for Payment" . get_class($this));
            return false;
        }
        $this->update_status_activities($this->cart['all_acts'], '5PaymentRejected');

        self::$router = "payment:show";
        return DEProcessing_Dentevents_Details_Premium_Registration::process(array('global_message' => $payment_result['msg']));
    }
}