<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Registration_Payment_Bill_Free extends DEProcessing_Dentevents_Details_Premium_Registration_Payment_Bill{
    function initialize($params = array()){

    }
    
    function process($sparams = array()){
        $_event = self::$event;
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post("principal_act_id");
        $promo_code = $this->EE->input->get_post("promo_code");
        
        /// get total ///
        $cart = $this->cart_review(array(
                            'principal_act_id' => $principal_act_id,
                            'promotion' => array('code' => $promo_code, 'action' => 'apply')
                        ));
        $total = $cart['total'];
        $this->cart = $cart; 
        /////////////////

        $result = array();
        $result['total'] = 0;
        $code = $result['code'] = 'success';
        $msg = $result['msg'];

         
        $json_result = array('free' => 'yes');
        if($code == "success"){
            $this->process_success(array('payment_result' => $result, 'cart' => $cart ));
            $json_result['result'] = "success";
            $json_result['cmd'] = "dentevents:details:premium:registration:success:capture";
            
        }else{
            $this->process_fail(array('payment_result' => $result, 'cart' => $cart));
            $json_result['result'] = "fail";
            $json_result['msg'] = $msg;
        }
        
         echo json_encode($json_result);exit;
    }
    
    function process_success($sparams = array()){
        $_event = self::$event;
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post("principal_act_id");
        $payment_result = $sparams['payment_result'];
        $cart = $sparams['cart'];
        ///////// registered check ///////
        $act_list_options = $this->EE->cpd_activity->get_relationship_related_cpdactivity(array(
                    'id' => $principal_act_id,
                    'selects' => "{#m}.id,{#c}.paid_option_c",
                    'where' => "{#c}.rego_option_type_c='Option' or {#c}.rego_option_type_c='Guests'",
                    'orders' => "{#m}.date_entered asc"
                ));
        $paid_option = "";
        foreach($act_list_options as $item){
            if($item['paid_option_c'] == "1"){
                $paid_option = $item['id'];
            }
        }
        if(!empty($paid_option)){
            $principal_act_id = $paid_option;
        }
        
        /////////////////////////////////
        $invoice = $this->prepare_invoice(array('cart' => $cart));

        $payment_types = $_event['payment_types_accepted_c'];
        $payment_types = trim($payment_types, "^");
        $payment_types = explode("^,^", $payment_types);

        $payment_methods = strtolower($_event['payments_methods_c']);
        $payment_methods = trim($payment_methods, "^");
        $payment_methods = explode("^,^", $payment_methods);

        $data = array();
        $data['id'] = $principal_act_id;
        $data['terms_accepted_c'] = 1;
        $data['ip_address_c'] = $_SERVER['REMOTE_ADDR'];
        $data['receipt_data_c'] = json_encode($invoice);
        $data['status'] = "3aRegistrationRequested";
        $data['payment_date_c'] = date("Y-m-d H:i:s");
        $data['payment_type_c'] = "free";
        //$data['payment_cardholder_c'] = $payment_result['payment']['cc_holder_name'];
        //$data['payment_cc_no_c'] = base64_encode($payment_result['payment']['cc_number']);
        //$data['payment_cc_ccv_c'] = base64_encode($payment_result['payment']['cc_cid']);
        //$data['payment_cc_exp_c'] = base64_encode($payment_result['payment']['cc_exp_month'] . ";" . $payment_result['payment']['cc_exp_year']);
        $data['payment_total_charged_c'] = $payment_result['total'];
        $data['payment_date_c'] = date("Y-m-d H:i:s");
        $data['payment_process_date_c'] = '';
        $data['payment_process_method_c'] = "free";
        
        ////// check auto accept free registration ////////
        $auto_accept = false;        
        if(in_array("no_charge", $payment_types) && in_array("free", $payment_methods) && $_event['auto_accept_free_regos_c'] == "1"){            
            $data['status'] = "6RegistrationAccepted";
            $data['payment_process_date_c'] = $data['payment_date_c'];
            $data['payment_processed_by_c'] = "Auto Accept";
            $auto_accept = true;            
        }
        ///////////////
        /// check tax ///
        $tax = $invoice['tax'];
        if($tax != null){
            $tax_rate = $tax['rate'];
            $data['payment_tax_charged_c'] = $this->helper->toFixed($payment_result['total'] * $tax_rate / (100 + $tax_rate), 2);
        }
        /////////////////
        
        $success = $this->EE->cpd_activity->set_record($data);
        if(!$success){
            $this->logger->developer("Failed to update CPD Activity for Payment" . get_class($this));
            return false;
        }
        
        /// send email ///
        if($auto_accept){            
            self::$router = "receipt:email";
            DEProcessing_Dentevents_Details_Premium_Registration::process(array('act_id' => $principal_act_id, 'auto_accept' => 'yes'));
            $this->update_status_activities($this->cart['all_acts'], '6RegistrationAccepted');
        }else{
            self::$router = "receipt:email";
            DEProcessing_Dentevents_Details_Premium_Registration::process(array('act_id' => $principal_act_id, 'auto_accept' => ''));
            $this->update_status_activities($this->cart['all_acts'], '3aRegistrationRequested');
        }
        //////////////////

        self::$router = "summary:sendemail:success:capture";
        DEProcessing_Dentevents_Details_Premium_Registration::process(array('act_id' => $principal_act_id, 'payment_result' => $payment_result));
        /*self::$utility->set_cookie_registration('principal_act_id', '', array('event' => $_event, 'primary_rego_id' => $primary_rego_id));
        self::$utility->save_step(self::$event, '');*/
        /// send email to contacts who has receiveNotification///
        
        //////////////////
        
        $this->do_apply_reset();
        
         return true;
        
        // self::$router = "success:capture";
        // return DEProcessing_Dentevents_Details_Premium_Registration::process();
    }
    
    function process_fail($sparams = array()){
        $_event = self::$event;
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post("principal_act_id");
        $payment_result = $sparams['payment_result'];
        $cart = $sparams['cart'];
        
        $invoice = $this->prepare_invoice(array('cart' => $cart));

        $data = array();
        $data['id'] = $principal_act_id;
        $data['terms_accepted_c'] = 1;
        $data['ip_address_c'] = $_SERVER['REMOTE_ADDR'];
        $data['receipt_data_c'] = json_encode($invoice);
        $data['status'] = "7RegistrationRejected";
        $data['payment_cardholder_c'] = $payment_result['payment']['cc_holder_name'];
        $data['payment_type_c'] = "free";
        //$data['payment_cc_no_c'] = $this->helper->get_security_card_number($payment_result['payment']['cc_number']);
        $data['payment_date_c'] = date("Y-m-d H:i:s");
        $data['payment_process_method_c'] = "free";
        
        $success = $this->EE->cpd_activity->set_record($data);
        if(!$success){
            $this->logger->developer("Failed to update CPD Activity for Payment" . get_class($this));
            return false;
        }
        $this->update_status_activities($this->cart['all_acts'], '5PaymentRejected');
        // return true;
        self::$router = "payment:show";
        return DEProcessing_Dentevents_Details_Premium_Registration::process(array('global_message' => $payment_result['error']));
    }
}