<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Registration_Receipt extends DEProcessing_Dentevents_Details_Premium_Registration{
    static $act;
    static $_event;
    static $_organiser;
    function initialize($params = array()){
        $act_id = $this->EE->input->get_post('act_id');
        $this->EE->load->model("rates");
        $event_id_c = $this->EE->input->get_post("id");
        
        if(!empty($params['act_id'])){
            $act_id = $params['act_id'];
        }
        self::$act = $this->EE->cpd_activity->get_main_data(array(
                    'selects' => "{#m}.id,{#c}.receipt_data_c,{#c}.payment_receipt_c,{#c}.payment_currency_c,{#c}.payment_tax_charged_c,{#c}.payment_date_c,{#c}.cpd_activity_id_c,{#c}.payment_type_c,{#c}.payment_cc_no_c,{#c}.payment_process_date_c,{#c}.payment_invoice_override_c, {#c}.address_used_c,{#c}.refund_amount_c,{#c}.refund_type_c,{#c}.refund_date_c",
                    'where' => "{#m}.id='{$act_id}'",
                    'single' => true
                ));
        
        /// payment_date_c ///
        $date_time = new DateTime(self::$act['payment_date_c'], new DateTimeZone('UTC'));
        $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
        $date = $date_time->format("d M Y");
        self::$act['payment_date'] = $date;
        //////////////////////
        
        /// payment_process_date_c ///
        if(empty(self::$act['payment_process_date_c'])){
            self::$act['payment_process_date_c'] = self::$act['payment_date_c'];
        }
        $date_time = new DateTime(self::$act['payment_process_date_c'], new DateTimeZone('UTC'));
        $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
        $date = $date_time->format("d M Y");
        self::$act['payment_process_date'] = $date;
        ///////////////////////////////
        
        /// payment cc no ///
        $cc_no = self::$act['payment_cc_no_c'];
        if(base64_encode(base64_decode($cc_no)) == $cc_no ){
            $cc_no = base64_decode($cc_no);
            self::$act['payment_cc_no_c'] = $this->helper->get_security_card_number($cc_no);
        }
        $event_selects = "{#m}.id,{#m}.start_date,{#m}.end_date,{#m}.name,{#m}.event_theme,{#m}.event_url,{#c}.sef_url_c, {#m}.event_logo,{#m}.description,{#m}.event_city,{#m}.event_country,{#m}.listing_type,{#m}.event_banner,{#m}.event_email,{#m}.event_rego_online,{#m}.registration_url,
                                  {#m}.cpd_points_type_1,{#m}.cpd_points_type_2,{#m}.cpd_points_type_3,{#m}.more_info,{#m}.event_format,{#m}.event_max_attendance,{#m}.special_diet_available,{#m}.audience,
                                  {#c}.overview_c,{#c}.overview_detail_c,{#c}.more_info_heading_c,{#c}.accommodation_info_c,{#c}.tax_rate_c,{#c}.tax_name_c,{#c}.sold_out_c,{#c}.rego_close_date_c,{#c}.ticketing_charges_c,  
                                  {#c}.event_options_c,{#c}.event_id_c,{#c}.special_diet_choices_c,{#c}.payment_types_accepted_c,{#c}.payments_methods_c,{#c}.payment_gateway_id_c,{#c}.payment_note_1_c,{#c}.payment_note_2_c,{#c}.payment_success_text_c,
                                  {#c}.cancellation_policy_c,{#c}.cancel_policy_method_c,{#c}.cancel_currency_c,{#c}.cancellation_fee_c,{#c}.cancel_set_fee_expiry_c,{#c}.merchant_account_name_c,{#c}.receipt_footer_c,{#c}.ticketing_commission_c,{#c}.rego_time_limit_c,
                                  {#c}.cancel_refund_1_months_c,{#c}.cancel_refund_2_months_c,{#c}.cancel_refund_3_months_c,
                                  {#c}.cancel_refund_4_months_c,{#c}.cancel_refund_5_months_c,{#c}.cancel_refund_6_months_c,
                                  {#c}.ticketing_merch_fee_app_1_c,{#c}.ticketing_merch_fee_app_2_c,{#c}.ticketing_merch_fee_app_3_c,
                                  {#c}.ticketing_merch_fee_1_c,{#c}.ticketing_merch_fee_2_c,{#c}.ticketing_merch_fee_3_c,{#c}.allow_special_requests_c,
                                  {#c}.force_meal_selection_c,{#c}.allow_waitlist_c,
                                  {#c}.facebook_c,{#c}.twitter_c,{#c}.googleplus_c,{#c}.yelp_c,
                                  {#c}.youtube_c,{#c}.flickr_c,{#c}.pinterest_c,{#c}.linkedin_c,
                                  {#c}.instagram_c,{#c}.xing_c,{#c}.add_option_to_email_c, {#c}.add_option_email_msg_heading_c, {#c}.add_option_email_msg_c,{#c}.dentevents_tv_webinar_info_c,{#c}.dentevents_tv_content_status_c";
        //////event ///////////////
        if(!empty($event_id_c)){
            $params = array();
            $params['selects'] = $event_selects;
            $params['single'] = true;
            $params['where'] = "{#c}.event_id_c = '$event_id_c'";
            self::$_event = $this->EE->cpd_events->get_main_data($params);
        }else{
            $params = array();
            $params['id'] = $act_id;
            $params['selects'] = $event_selects;
            $params['single'] = true;
            
            self::$_event = $this->EE->cpd_activity->get_relationship_events($params);
        }

        //////// organiser ////
        $params = array();
        $params['id'] = self::$_event['id'];
        $params['selects'] = "{#m}.id,{#m}.name,{#m}.phone_office,{#m}.billing_address_city,{#m}.billing_address_state,{#m}.billing_address_postalcode,{#m}.billing_address_street,{#m}.billing_address_country,{#c}.contact_id1_c,{#c}.contact_id_c,{#c}.logo_c,{#c}.billing_name_c,{#c}.tax_nr_c,{#c}.free_phone_c,{#c}.free_fax_c, {#m}.phone_fax, {#c}.mailing_name_c";
        $params['single'] = true;
        self::$_organiser = $this->EE->cpd_events->get_relationship_organiser($params);
        
        if(empty(self::$_organiser)){

            $test_id = self::$_event['id'];
            $principal_event = $this->EE->cpd_events->get_relationship_streams_sessions(array(
                    'id' => $test_id,
                    'selects' => "{#m}.id, {#m}.name,{#c}.event_id_c,{#c}.rec_type_c",
                    'single' => true
                ));

            if($principal_event['rec_type_c'] != 'Master' && $principal_event['rec_type_c'] != 'Standalone'){
                $principal_event =  $this->EE->cpd_events->get_relationship_streams_sessions(array(
                    'id' => $principal_event['id'],
                    'selects' => "{#m}.id, {#m}.name, {#c}.event_id_c,{#c}.rec_type_c",
                    'single' => true
                ));
            }
            
            $params = array();
            $params['id'] = $principal_event['id'];
            $params['selects'] = "{#m}.id,{#m}.name,{#m}.phone_office,{#m}.billing_address_city,{#m}.billing_address_state,{#m}.billing_address_postalcode,{#m}.billing_address_street,{#m}.billing_address_country,{#c}.contact_id1_c,{#c}.contact_id_c,{#c}.logo_c,{#c}.billing_name_c,{#c}.tax_nr_c,{#c}.free_phone_c,{#c}.free_fax_c, {#m}.phone_fax, {#c}.mailing_name_c";
            $params['single'] = true;
            self::$_organiser = $this->EE->cpd_events->get_relationship_organiser($params);
            //var_dump(self::$_organiser);exit;
            $event_id_c = $principal_event['event_id_c'];
            $params = array();
            $params['selects'] = $event_selects;
            $params['single'] = true;
            $params['where'] = "{#c}.event_id_c = '$event_id_c'";
            self::$_event = $this->EE->cpd_events->get_main_data($params);            
        }
        
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "download":
                return $this->download($params);
            break;
            case "downloadIcs":
                return $this->downloadIcs($params);
                break;
            case "email":
                return $this->email($params);
            break;
            case "summary_content":
                return $this->get_contents($params['act_id']);
            break;
        }
    }

    function get_contents($act_id, $sparams = array()){
        $principal_act_id = $act_id;
        
        $promotion = array('code' => '', 'action' => '');
        
        $_event = self::$_event;
        $_organiser = self::$_organiser;
        $_act = self::$act;        
        
        if($sparams['promotion'] == null){
            $sparams['promotion'] = array();
        }
        $diffs = array_diff_key($promotion, $sparams['promotion']);
        $promotion = array_merge($sparams['promotion'], $diffs);
        
        $act_data = $this->EE->cpd_activity->get_main_data(array(
                    'selects' => "{#m}.id,{#c}.paid_option_c",
                    'where' => "{#m}.id='{$principal_act_id}'",
                    'single' => true
                ));

        if($act_data['paid_option_c'] == "1"){
            $act_list = array();
            $act_list[] = $principal_act_id;

            $core_id = self::$utility->get_principal_act($principal_act_id);
            
            $act_lists = $this->EE->cpd_activity->get_relationship_related_cpdactivity(array(
                'id' => $core_id,
                'selects' => "{#m}.id,{#c}.paid_option_id_c",
                'where' => "{#c}.rego_option_type_c='Option' Or {#c}.rego_option_type_c='Guests'"
            ));

            foreach ($act_lists as $key => $item) {
                if($item['paid_option_id_c'] == $principal_act_id){
                    $act_list[] = $item['id'];            
                }
            }
        }else{
            /// render items ///
            $act_list = $this->EE->cpd_activity->get_relationship_transactions_cpdactivity(array(
                        'id' => $principal_act_id,
                        'selects' => "{#m}.id",
                        'where' => "{#c}.rego_option_type_c='Core'",
                        'to_values' => "id"
                    ));
            $act_list = array_merge(array($principal_act_id), $act_list);    
        }                
        self::$all_registrants = self::$utility->get_registrants_from_acts($act_list);
        $first_item = reset($act_list);
        $_registrant_address = array();
        $_registrant_address = $this->EE->cpd_activity->get_relationship_contacts(array(   
                                        'id' => $first_item,
                                        'selects' => "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name, {#m}.alt_address_street, {#m}.alt_address_city, {#m}.alt_address_state, {#m}.alt_address_postalcode, {#m}.alt_address_country, {#c}.email_c",
                                        'single' => true
                                    ));
        self::$act['registrant'] = array('id' => $_registrant_address['id'], 
                                'salutation' => $_registrant_address['salutation'],
                                'first_name' => $_registrant_address['first_name'],
                                'last_name' => $_registrant_address['last_name'],
                                'email' => $_registrant_address['email_c'],
                                );
        /// registrant ///
        $params = array();
        $params['selects'] = "{#m}.salutation,{#m}.first_name,{#m}.last_name,{#m}.phone_mobile,{#m}.phone_fax,
                              {#m}.alt_address_street,{#m}.alt_address_city,{#m}.alt_address_state,{#m}.alt_address_postalcode,
                              {#m}.alt_address_country, {#c}.prefname_c,{#c}.account_id_c,{#c}.gender_c,{#c}.direct_phone_c";
        $params['where'] = "{#m}.id='{$_registrant_address['id']}'";
        $params['single'] = true;
        $_rgnt = $this->EE->contacts->get_main_data($params);
        if($_rgnt['salutation'] == 'AProf'){
            $_rgnt['salutation'] = 'A/Prof';    
        }
        /////////// 
        
        //////address ///
        $contact_address = array();
        if($_act['address_used_c'] == 'Principle'){
            /// principal account ///
            $params = array();
            $params['selects'] = "{#m}.id,{#m}.billing_address_street,{#m}.billing_address_city,{#m}.billing_address_state,{#m}.billing_address_postalcode,{#m}.billing_address_country,{#m}.phone_office,{#m}.phone_fax,{#c}.billing_name_c,{#c}.sef_url_c";
            $params['where'] = "{#m}.id='{$_rgnt['account_id_c']}'";
            $params['single'] = true;
            $principal_account = $this->EE->accounts->get_main_data($params);
            ///////////////
            $contact_address['name'] = $_rgnt['salutation'] . " " . $_rgnt['first_name'] . " " . $_rgnt['last_name'];
            $contact_address['city'] = $principal_account['billing_address_city'];
            $contact_address['state'] = $principal_account['billing_address_state'];
            $contact_address['postalcode'] = $principal_account['billing_address_postalcode'];
            $contact_address['street'] = $principal_account['billing_address_street'];
            $contact_address['country'] = $principal_account['billing_address_country'];
            $contact_address['phone'] = $principal_account['phone_office'];
            $contact_address['fax'] = $principal_account['phone_fax'];
            $contact_address['sef_url'] = $principal_account['sef_url_c'];
            $contact_address['principal_status'] = "principle";
            $contact_address['billing_name'] = $principal_account['billing_name_c'];
        }else{
            $contact_address['name'] = $_rgnt['salutation'] . " " . $_rgnt['first_name'] . " " . $_rgnt['last_name'];
            $contact_address['city'] = $_rgnt['alt_address_city'];
            $contact_address['state'] = $_rgnt['alt_address_state'];
            $contact_address['postalcode'] = $_rgnt['alt_address_postalcode'];
            $contact_address['street'] = $_rgnt['alt_address_street'];
            $contact_address['country'] = $_rgnt['alt_address_country'];
            $contact_address['phone'] = $_rgnt['direct_phone_c'];
            $contact_address['fax'] = $_rgnt['phone_fax'];
            $contact_address['principal_status'] = "other";
        }
        
        ///////////                                                               
        $total = 0;
        $cart_review = array();
        $cart_review_datas = array();
        $number = 1;
        
        $all_acts = array();
        $tax = null;
        $result_promotion = 'no_exist';
        $promotion_message = '';
        
        $sql_where_promocode = "{#c}.rate_type_c='Promo_Code' and {#m}.rategroup='Dentevents' and {#m}.datefrom <= CURDATE() and {#m}.dateto >= CURDATE() and {#m}.amount > 0";
        if($promotion['code'] != ''){
            $sql_where_promocode .= " and {#m}.name='{$promotion['code']}'";    
        }
        $additional_contacts = array();
        $additional_c = '';
        foreach($act_list as $key => $act_id){
            $all_acts[] = $act_id;
            /// pull registrant ///
            $_registrant = $this->EE->cpd_activity->get_relationship_contacts(array(   
                                        'id' => $act_id,
                                        'selects' => "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.email_c,{#c}.rego_domain_c,{#c}.rego_no_c,{#c}.rego_no_nz_c,{#c}.rego_no_other_c,{#c}.pract_type_c,{#c}.pract_type_nz_c,{#c}.pract_type_other_1_c",
                                        'single' => true
                                    ));
            if($key > 0){
                $additional_contacts[] = $_registrant;
            }
            $_contact_pract_type = self::$utility->get_pract_type_from_contact($_registrant);
            $_contact_pract_type = $this->helper->extract_multiselect($_contact_pract_type);
            ///////////////////////
            
            
            /// get options activity ///
            $act_list_options = $this->EE->cpd_activity->get_relationship_related_cpdactivity(array(
                    'id' => $act_id,
                    'selects' => "{#m}.id",
                    'where' => "{#c}.rego_option_type_c='Option' or {#c}.rego_option_type_c='Guests'",
                    'to_values' => "id"
                ));
            $act_list_options = array_merge(array($act_id), $act_list_options);
            ////////////////////////////
            
            /// options review ///
            $options_review = array();
            $sub_total = 0;
            foreach($act_list_options as $act_id_option){
                $all_acts[] = $act_id_option;
                $act_option = $this->EE->cpd_activity->get_main_data(array(
                                'selects' => "{#m}.id,{#c}.rego_option_type_c,{#c}.payment_qty_c,{#c}.payment_disc_type_c,{#c}.payment_disc_note_c,{#c}.payment_disc_c,{#c}.payment_rate_c,{#c}.payment_total_c,{#c}.payment_currency_c,{#c}.payment_tax_c,{#c}.payment_tax_name_c",
                                'where' => "{#m}.id='{$act_id_option}'",
                                'single' => true
                            ));
                $regooption = $this->EE->cpd_activity->get_relationship_cpd_eventregooptions(array(
                                'id' => $act_id_option,
                                'selects' => "{#m}.id,{#m}.name",
                                'single' => true
                            ));
                
                /// check promotion ///
                $rates = $this->EE->cpd_eventregooptions->get_relationship_rates(array(
                            'id' => $regooption['id'],
                            'selects' => "{#m}.id,{#m}.name,{#m}.amount,{#m}.country,{#m}.target,{#c}.cumulative_disc_c",
                            'where' => $sql_where_promocode
                        ));
                //////////cpd activity///////////
                $real_rate = array();
                foreach($rates as $key => $item){
                    $cpd_acts = $this->EE->rates->get_relationship_cpdactivity(array(
                        'id' => $item['id'],
                        'selects' => "{#m}.id"
                    ));
                    foreach($cpd_acts as $_item){
                        if($_item['id'] == $act_id_option){
                            $real_rate = $item;
                            break;    
                        }
                            
                    }
                }
                ////////
                $result_promotion = "exist"; 
                $promotion_rate = $real_rate;
                
                /// check tax ///
                if($tax == null && $act_option['payment_tax_name_c'] != null){
                    $tax = array('name' => $act_option['payment_tax_name_c'], 'rate' => $this->helper->toFixed($act_option['payment_tax_c'], 0));    
                }
                /////////////////
                $item = array();
                $item['review_name'] = $regooption['name'];
                /// get guest ///
                $item['guest'] = '';
                if($act_option['rego_option_type_c'] == 'Guests'){
                    $_guest = $this->EE->cpd_activity->get_relationship_contacts(array(   
                                        'id' => $act_id_option,
                                        'selects' => "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.email_c,{#c}.rego_domain_c,{#c}.rego_no_c,{#c}.rego_no_nz_c,{#c}.rego_no_other_c,{#c}.pract_type_c,{#c}.pract_type_nz_c,{#c}.pract_type_other_1_c",
                                        'single' => true
                                    ));  
                    if($_guest['salutation'] == 'AProf'){
                        $_guest['salutation'] = "A/Prof";    
                    }
                    $name = $_guest['salutation'] . ' ' . $_guest['first_name'] . ' ' . $_guest['initial_c'] . ' ' . $_guest['last_name']; 
                    if(!empty($_registrant['prefname_c'])){
                        $name = $_guest['salutation'] . ' ' .  $_guest['prefname_c'] . ' ' . $_guest['last_name']; 
                    }
                    $item['guest'] = array('name' => $name, 'id' => $_guest['id']);                                 
                }
                /////////////////
                
                if(!empty($act_option['payment_disc_type_c'])){
                    $discount = array();
                    
                    /// label ///
                    $label = '';
                        switch($act_option['payment_disc_type_c']){
                            case 'Earlybird':
                                $label = 'Less Early Bird Discount';
                            break;
                            case 'Member':
                                $label = "Less {$act_option['payment_disc_note_c']} Member Discount";
                            break;
                            case 'Subscriber':
                                $label = "Less {$act_option['payment_disc_note_c']} Subscriber Discount";
                            break;
                        }
                    $discount['label'] = $label;
                    /////////////
                    $discount['value'] = $act_option['payment_disc_c'];
                    $discount['total'] = $this->helper->toFixed($act_option['payment_qty_c'] * $discount['value'], 2);
                    $item['discount'] = $discount;
                }
                
                /// calculate promotion ///
                if($promotion_rate != ''){
                    $discount_promo = array();
                    $discount_promo['label'] = "Less Promo Code Discount - " . $promotion_rate['name'];    
                    $discount_promo['value'] = $this->helper->toFixed($promotion_rate['amount'], 2);
                    $discount_promo['total'] =  $this->helper->toFixed($act_option['payment_qty_c'] * $discount_promo['value'], 2);
                    
                    $data_for_account = array();
                    if($promotion_rate['cumulative_disc_c'] == 1){
                        $item['discount_promo'] = $discount_promo;    
                        $sub_total -= $discount_promo['total'] * 1;
                        
                        $data_for_account['id'] = $act_id_option;
                        $data_for_account['promo_code_disc_c'] = $promotion_rate['amount'];
                        $data_for_account['promo_code_c'] = $promotion_rate['name'];
                    }   
                    if($promotion_rate['cumulative_disc_c'] == 0){
                        $other_discount = ($discount['value'] > 0) ? $discount['value'] : 0;
                        
                        if($discount['value'] != null){
                            if($discount_promo['value'] * 1 < $other_discount){
                                $promotion_message = 'The Promo Code discount has not been applied because it is less than the other discounts applied.';    
                            }
                            if($discount_promo['value'] * 1 > $other_discount){
                                $promotion_message = 'The Promo Code discount has replaced the other discounts applied.';    
                            }
                        }
                        if($discount_promo['value'] * 1 > $other_discount){
                            $item['discount_promo'] = $discount_promo;    
                            $sub_total = $sub_total - $discount_promo['total'] * 1 + $discount['total'] * 1;
                            
                            $data_for_account['id'] = $act_id_option;
                            $data_for_account['promo_code_disc_c'] = $promotion_rate['amount'];
                            $data_for_account['promo_code_c'] = $promotion_rate['name'];
                            $data_for_account['payment_disc_type_c'] = '';
                            $data_for_account['payment_disc_c'] = '';
                            unset($item['discount']);
                        }
                    }
                    
                    if($promotion['action'] == 'apply' && !empty($data_for_account)){
                        $success = $this->EE->cpd_activity->set_record($data_for_account);
                        if(!$success){
                            $this->logger->developer("Failed to update the account linked to rego option.");
                            return false; 
                        }
                        
                        $success = $this->EE->rates->add_relationship_app($promotion_rate['id'], $act_id_option, 'cpdactivity_promotion');
                        if(!$success){
                            $this->logger->developer("Failed to link between rate and cpdactivity.");
                            return false; 
                        }
                    } 
                }
                ///////////////////////////
                
                $item['qty'] = $act_option['payment_qty_c'] * 1;
                $item['base_rate'] = $act_option['payment_rate_c'];
                $item['total'] = $this->helper->toFixed($item['qty'] * $item['base_rate'], 2);
                
                $item['currency'] = $act_option['payment_currency_c'];   
                $options_review[] = $item;                               
                            
                $sub_total += $act_option['payment_total_c'] * 1;
            }
            $sub_total = $this->helper->toFixed($sub_total, 2);
            //////////////////////
            
            /// check tax ///
            if($tax != null){
                $tax['amount'] = self::$act['payment_tax_charged_c'];
            }
            /////////////////
            
            /// render cart review ///
            $swaps = array(
                        'registrant' => 'registrant', 'options_review' => 'options_review', 'total' => 'total', 'number' => 'number'
                    );
            $datas = array(
                        'registrant' => $_registrant, 'options_review' => $options_review, 'total' => $sub_total, 'number' => $number++
                    );
            $TMPL = new EE_Template();
            $TMPL->run_template_engine('dentevents', 'register_payment_review');
            $cart_review[] = $this->EE->output->app_output($swaps, $datas, array('output' => false));
            $cart_review_datas[] = $datas;
            //////////////////////////
            
            $total += $sub_total;
        }
        
        if(!empty($additional_contacts)){
            $additional_c = 'yes';
        }
        $all_acts = array_unique($all_acts);
        
        /// promotion ///
        $promotion['result'] = $result_promotion;
        
        if($promotion_message == '' && $promotion['code'] != '' && $result_promotion == 'no_exist'){
            $promotion_message = 'The Promo Code entered is invalid or has expired';    
        }
        $promotion['message'] = $promotion_message;
        /////////////////
        /// receipt ///                                      
        self::$act['receipt_number'] = self::$act['cpd_activity_id_c'];
        if(!empty(self::$act['payment_invoice_override_c'])){
            self::$act['receipt_number'] = self::$act['payment_invoice_override_c'];
        }
        ///////////////
        
        /// check refund ///
        $date = new DateTime(self::$act['refund_date_c']);
        $date->setTimezone( new DateTimeZone("Australia/Sydney"));
        $refund_date = $date->format("d M Y");
        $refund_time = $date->format("g:i:s A");
        
        self::$act['refund_date'] = $refund_date;
        self::$act['refund_amount'] = $this->helper->toFixed(self::$act['refund_amount_c'], 2);;
        /////////cart review data///////////
        $reg_num = 1;
        $tabledata = array();
        
        foreach($cart_review_datas as $registrant){
            $head_title = "Registrant" . " " . $reg_num . " - " . $registrant['registrant']['salutation'] . " " . $registrant['registrant']['first_name'] . " " . $registrant['registrant']['last_name'];
            $reg_num++;
            $cart_head_variables = array(
                'cpd_option' => $head_title,
                'UnitPrice' => "",
                'Quantity' => "",
                'amount' => ""
            );
            $tabledata[] = $cart_head_variables;
            $cpd_option = $registrant['options_review'];
            foreach($cpd_option as $item){
                $cart_option_variables = array(
                    'cpd_option' => $item['review_name'],
                    'UnitPrice' => $item['base_rate'],
                    'Quantity' => strval($item['qty']),
                    'amount' => $item['total']
                );
                $tabledata[] = $cart_option_variables;
                if(array_key_exists('discount', $item)){
                    $discount_variables = array(
                        'cpd_option' => $item['discount']['label'],
                        'UnitPrice' => "",
                        'Quantity' => "",
                        'amount' => "-" . $item['discount']['total']    
                    ); 
                    $tabledata[] = $discount_variables;
                }
                if(array_key_exists('discount_promo', $item)){
                    $discount_variables = array(
                        'cpd_option' => $item['discount_promo']['label'],
                        'UnitPrice' => "",
                        'Quantity' => "",
                        'amount' => "-" . $item['discount_promo']['total']    
                    ); 
                    $tabledata[] = $discount_variables;
                }
            }
            
        }
        /////////formatting date/////////////
        $_event['start_date'] = new DateTime($_event['start_date'], new DateTimeZone('UTC'));
        $_event['start_date']->setTimezone( new DateTimeZone("Australia/Sydney"));
        $temp_startdate = $_event['start_date'];
        $starttime = $_event['start_date'];
        $starttime = $starttime->format("g.i a");
        //$_event['start_date'] = $_event['start_date']->format("D, j F, Y g.i a");
        $_event['startdate'] = $temp_startdate->format("D, j F, Y");
        $_event['start_date'] = $_event['startdate'] . "<br>" . $starttime;
        $_event['startdate'] = $starttime . " " . $_event['startdate'];

        $_event['end_date'] = new DateTime($_event['end_date'], new DateTimeZone('UTC'));
        $_event['end_date']->setTimezone( new DateTimeZone("Australia/Sydney"));
        $temp_enddate = $_event['end_date'];
        $endtime = $_event['end_date'];
        $endtime = $endtime->format("g.i a");
        //$_event['end_date'] = $_event['end_date']->format("D, j F, Y g.i a");
        $_event['enddate'] = $temp_enddate->format("D, j F, Y");
        $_event['end_date'] = $_event['enddate'] . "<br>" . $endtime;        
        $_event['enddate'] = $endtime . " " . $_event['enddate'];
        
        $total = $this->helper->toFixed($total, 2);
        
        /////////venue//////
        $venue = $this->EE->cpd_events->get_relationship_event_venue(array("id" => $_event['id'], 'selects' => "{#m}.name, {#m}.billing_address_street,{#m}.billing_address_city,{#m}.billing_address_state,{#m}.billing_address_postalcode,{#m}.billing_address_country", 'single' => true));
        $venue_address= $venue['name'] . ", " . $venue['billing_address_street'] . ", " . $venue['billing_address_city'] . " " . $venue['billing_address_state'] . " " . $venue['billing_address_country'];
        $venue['full_address'] = $venue_address;
        ///////////
        $payment = $this->EE->input->get_post('payment');
        
        $content  = '';
        $template_name = "";
        if($_act['payment_type_c'] == "free"){
            if($_event['event_format'] == 'OnlineLearning' || $_event['event_format'] == 'Webinar'){
                $template_name = "register_receipt_content_free_other";
            }else{
                $template_name = "register_receipt_content_free";
            }
        }else{
            if($_event['event_format'] == 'OnlineLearning' || $_event['event_format'] == 'Webinar'){
                $template_name = "register_receipt_content_other";
            }else{
                $template_name = "register_receipt_content";
            }
            
        }

        /// email option link ///
        $email_option = array();
        $_event['add_option_to_email_c'] = trim($_event['add_option_to_email_c'], "^");
        $_event['add_option_to_email_c'] = explode("^,^", $_event['add_option_to_email_c']);
        
        if(in_array("receipt", $_event['add_option_to_email_c']) && (self::$act['payment_process_method_c'] == 'eway' || self::$act['payment_process_method_c'] == 'paypal')){
            $core_id = self::$act['id'];
            $email_option['exist'] = "yes";
            $email_option['link'] = "https://www.dentevents.com/addoptions={$core_id}&id={$_event['event_id_c']}";
        }
        if(in_array("confirmation", $_event['add_option_to_email_c']) && (self::$act['payment_process_method_c'] == 'capture' || self::$act['payment_process_method_c'] == 'account')){
            $core_id = self::$act['id'];
            $email_option['exist'] = "yes";
            $email_option['link'] = "https://www.dentevents.com/addoptions={$core_id}&id={$_event['event_id_c']}";
        }
        /////////////////////////
        ////Tel number and fax number ///////
        if($sparams['email_template'] == "yes"){
            if(!empty($_organiser['phone_office'])){
                $_organiser['phone_office'] = "Tel: " . $_organiser['phone_office'];    
            }
            else{
                if(!empty($_organiser['free_phone_c']))
                    $_organiser['phone_office'] = "Tel: " . $_organiser['free_phone_c'];
                else
                    $_organiser['phone_office'] = "";
            }
            
            if(!empty($_organiser['phone_fax'])){
                $_organiser['phone_fax'] = "Fax: " . $_organiser['phone_fax'];    
            }
            else{
                if(!empty($_organiser['free_fax_c']))
                    $_organiser['phone_fax'] = "Fax: " . $_organiser['free_fax_c'];
                else
                    $_organiser['phone_fax'] = "";
            }
        }
        ////////////
        $_event['auto_accept'] = $sparams['auto_accept'];

        /// content ///
        $walletUrls = [
            'apple' => $this->getAppleWalletUrl()
        ];
        $receiptUrl = $this->getReceiptUrl();
        $icsUrl = $this->getIcsUrl();
        $swaps = array(
                    'act' => 'act', 'organiser' => 'organiser', 'event' => 'event', 'cart_reviews' => 'cart_reviews', 'cart_review_datas' => 'cart_review_datas', 'address' => 'address', 'total' => 'total', 'tax' => 'tax', 'promotion' => 'promotion', 'venue' => 'venue', 'payment' => 'payment', 'email_option' => 'email_option', 'additional_contacts' => 'additional_contacts', 'additional_c' => 'additional_c', 'wallet_urls' => 'wallet_urls', 'receipt_url' => 'receipt_url', 'ics_url' => 'ics_url'
                );
        $datas = array(
                    'act' => self::$act, 'organiser' => $_organiser, 'event' => $_event, 'cart_reviews' => $tabledata, 'cart_review_datas' => $cart_review_datas, 'address' => $contact_address, 'total' => $total, 'tax' => $tax, 'promotion' => $promotion, 'venue' => $venue, 'payment' => $payment, 'email_option' => $email_option, 'additional_contacts' => $additional_contacts, 'additional_c' => $additional_c, 'wallet_urls' => $walletUrls, 'receipt_url' => $receiptUrl,  'ics_url' => $icsUrl
                );

        $TMPL = new EE_Template();         
        $TMPL->run_template_engine('dentevents', $template_name);
        $content = $this->EE->output->app_output($swaps, $datas, array('output' => false));

        if($sparams['email_template'] == "yes"){
            return $content;
        }
        
        return array('act' => self::$act, 'organiser' => $_organiser, 'event' => $_event, 'cart_review' => $cart_review, 'cart_review_datas' => $cart_review_datas, 'address' => $contact_address, 'total' => $total, 'all_acts' => $all_acts, 'tax' => $tax, 'promotion' => $promotion, 'venue' => $venue);
        
    }     
    function create_receipt($id){
        require_once (APPPATH . 'application/helpers/phpdocx/classes/CreateDocx.inc');
        
        //$template_url = $this->upload_path . $id;
        $template_url = $this->_crm_config['main']['temp_path'] . "ReceiptTemplate.docx";
        $docx = new CreateDocxFromTemplate($template_url);
        
        $document_variables = $docx->getTemplateVariables();
        
        $act_id = $this->EE->input->get_post('act_id');
        $content = $this->get_contents($act_id);
        
        $cart_review_info = $content['cart_review_datas'];
        $organiser_info = $content['organiser'];
        $invoice_info = $content['act'];
        $address_info = $content['address'];
        $event_info =$content['event'];
        $tax_info = $content['tax'];
        $venue_info = $content['venue'];
        
        /// header part ////
        $receipt_logo_url = $this->_crm_config['main']['upload_url'] . $organiser_info['logo_c'];
        $logo_image_url = $receipt_logo_url . ".png";
        $logo_image_temp = $this->_crm_config['main']['temp_path'] . $organiser_info['logo_c'] . ".png";
        if(!empty($organiser_info['logo_c'])){
            copy($receipt_logo_url, $logo_image_temp);
        }

        $heading_variables = array(
            'Organization_title' => $organiser_info['name']
        );

        $options = array('target' => 'document');
        $image_options = array('width' => 'auto', 'height' => 'auto', 'target' => 'document');

        $docx->replacePlaceholderImage('HEADERIMG', $logo_image_temp, $image_options);
                
        $organiser_address = $organiser_info['billing_address_street'] . " " . $organiser_info['billing_address_city'] . " " . $organiser_info['billing_address_state'] . " " . $organiser_info['billing_address_postalcode'] . " " . $organiser_info['billing_address_country'];
        $contact_name = $address_info['name'];
        $contact_address =$address_info['street'] . " " . $address_info['city'] . " " . $address_info['state'] . $address_info['postalcode'] . " " . $address_info['country'];
        
        $contact_street = $address_info['street'];
        $company_name = '';
        if(!empty($address_info['billing_name'])){
            $company_name = $address_info['billing_name'];
        }

        $organization_street = $organiser_info['billing_address_street'];
        ////Tel number and fax number ///////
        if(!empty($organiser_info['phone_office'])){
            $tel_number = "Tel: " . $organiser_info['phone_office'];    
        }
        else{
            if(!empty($organiser_info['free_phone_c']))
                $tel_number = "Tel: " . $organiser_info['free_phone_c'];
            else
                $tel_number = "";
        }
        
        if(!empty($organiser_info['phone_fax'])){
            $fax_number = "Fax: " . $organiser_info['phone_fax'];    
        }
        else{
            if(!empty($organiser_info['free_fax_c']))
                $fax_number = "Fax: " . $organiser_info['free_fax_c'];
            else
                $fax_number = "";
        }
        ////////////            
        $header_variables = array(
            'ContactName' => $contact_name,
            'CompanyName' => $company_name,
            'ContactPostalStreet' => $contact_street,
            'ContactPostalCity' => $address_info['city'] . " " . $address_info['state'] . " " . $address_info['postalcode'],
            'ContactPostalCountry' => $address_info['country'],
            'InvoiceDate' => $invoice_info['payment_date'],
            'InvoiceNumber' => $invoice_info['receipt_number'],
            'abn_tax_number' =>$organiser_info['tax_nr_c'],
            'OrganisationName' => $organiser_info['name'],
            'OrganisationPostalStreet' => $organization_street,
            'OrganisationPostalCity' => $organiser_info['billing_address_city'] . " " . $organiser_info['billing_address_state'] . " " . $organiser_info['billing_address_postalcode'],
            'OrganisationPostalCountry' => $organiser_info['billing_address_country'],
            'organization_tel' => $tel_number,
            'organization_fax' => $fax_number
        );
        
        ////////////////////
        
        /// event part /////////
        $event_link = $event_info['sef_url_c'];
        $event_period = $event_info['startdate'] . " to " . $event_info['enddate'];
                    
        if(($event_info['event_format'] == 'OnlineLearning' || $event_info['event_format'] == 'Webinar') && $event_info['dentevents_tv_content_status_c'] == 'Library'){
            $event_period = "Available ON-Demand at Dentevents.TV";
            $venue_info['full_address'] = "";
        }
        $event_name = $event_info['name'];
        $event_city = $event_info['event_city'];
        $event_country = $event_info['event_country'];
        
        $event_variables = array(
            'event_name' => $event_name,
            'event_city' => $event_city,
            'event_country' => $event_country,
            'EventPeriod' => $event_period,
            'venueInfo' => $venue_info['full_address'],
            'eventLink' => $event_link
        ); 
        ///////////////////
        
        /////// cart part ////
        $reg_num = 1;
        $tabledata = array();
        
            foreach($cart_review_info as $registrant){
                $head_title = "Registrant" . " " . $reg_num . " - " . $registrant['registrant']['salutation'] . " " . $registrant['registrant']['first_name'] . " " . $registrant['registrant']['last_name'];
                $reg_num++;
                $cart_head_variables = array(
                    'cpd_option' => $head_title,
                    'UnitPrice' => "",
                    'Quantity' => "",
                    'amount' => ""
                );
                $tabledata[] = $cart_head_variables;
                $cpd_option = $registrant['options_review'];
                foreach($cpd_option as $item){
                    $cart_option_variables = array(
                        'cpd_option' => $item['review_name'],
                        'UnitPrice' => $item['base_rate'],
                        'Quantity' => strval($item['qty']),
                        'amount' => $item['total']
                    );
                    $tabledata[] = $cart_option_variables;
                    if(array_key_exists('discount', $item)){
                        $discount_variables = array(
                            'cpd_option' => $item['discount']['label'],
                            'UnitPrice' => "",
                            'Quantity' => "",
                            'amount' => "-" . $item['discount']['total']    
                        ); 
                        $tabledata[] = $discount_variables;
                    }
                    if(array_key_exists('discount_promo', $item)){
                        $discount_variables = array(
                            'cpd_option' => $item['discount_promo']['label'],
                            'UnitPrice' => "",
                            'Quantity' => "",
                            'amount' => "-" . $item['discount_promo']['total']    
                        ); 
                        $tabledata[] = $discount_variables;
                    }
                }
                
            }
        
        $payment_type = "";
        if($invoice_info['payment_type_c'] == "amex")
            $payment_type = "American Express";
        if($invoice_info['payment_type_c'] == "paypal")
            $payment_type = "Paypal";
        if($invoice_info['payment_type_c'] == "visa")
            $payment_type = "Visa";
        if($invoice_info['payment_type_c'] == "mastercard")
            $payment_type = "MasterCard";
                        
        $balance_name = $invoice_info['registrant']['first_name'] . " " . $invoice_info['registrant']['last_name'];
        $content['total'] = $this->helper->toFixed($content['total'], 2);
        
        
        $result_variables = array(
            'GrandTotal' => $content['total'],
            'tax_c' => $tax_info['rate'],
            'tax_name' => $tax_info['name'],
            'includes_tax' => $tax_info['amount'],
            'PCard' => $payment_type,
            'InvoiceTotal' => $content['total'],
            'balance_amount' => "0.00",
            'PPCard'  => $payment_type,
            'card_number' => $invoice_info['payment_cc_no_c'],
            'pay_date' => $invoice_info['payment_date'],
            'pay_name' => $event_info['merchant_account_name_c'],
            'CUY' => $invoice_info['payment_currency_c']
        );
        //var_dump($invoice_info['payment_cc_no_c']); exit;
        $all_variables = array_merge($heading_variables, $header_variables, $event_variables, $result_variables);
        $options = array('parseLineBreaks' => true);
        
        $docx->replaceVariableByText($all_variables, $options);
        //replace table data ///
        
        $docx->replaceTableVariable($tabledata, array('parseLineBreaks' => true));
        
        /////
        if($invoice_info['payment_type_c'] == "paypal"){
            $p_logo = PATH_THEMES . "site_themes/dentevents/skin/images/app/payments/v2/card_paypal.png";
            
            $docx->replacePlaceholderImage('payment_logo', $p_logo , array('target' => 'document'));
        }else if($invoice_info['payment_type_c'] == "mastercard"){
            $p_logo = PATH_THEMES . "site_themes/dentevents/skin/images/app/payments/v2/card_mastercard.png";
            $docx->replacePlaceholderImage('payment_logo', $p_logo , array('target' => 'document'));
        }else if($invoice_info['payment_type_c'] == "amex"){
            $p_logo = PATH_THEMES . "site_themes/dentevents/skin/images/app/payments/v2/card_amex.png";
            $docx->replacePlaceholderImage('payment_logo', $p_logo , array('target' => 'document'));
        }

        
        ////////////////////
        
        /////refund ///////
        $_refund_amount = intVal($invoice_info['refund_amount']);
        if($invoice_info['refund_type_c'] == "Discount"){
            $refund_text = "A discount of " . $invoice_info['refund_amount'] . " was applied on " . $invoice_info['refund_date'];
            $paragraphOptions = array(
                'bold' => true,
                'color' => 'ff0000'
            );
            $docx->addText($refund_text,$paragraphOptions);
            $cancel = "An error was made in the original booking.";
            $docx->addText($cancel,$paragraphOptions);
        }
        else if($_refund_amount > 0){
            $refund_text = "A refund of " . $invoice_info['refund_amount'] . " was applied on " . $invoice_info['refund_date'];
            $paragraphOptions = array(
                'bold' => true,
                'color' => 'ff0000'
            );
            $docx->addText($refund_text,$paragraphOptions);
            $cancel = "The event was cancelled.";
            $docx->addText($cancel,$paragraphOptions);
        }
        if(!empty($event_info['receipt_footer_c'])){
            $_receipt_footer = new WordFragment($docx, 'defaultFooter');
            $event_info['receipt_footer_c'] = '<div style="font-size:9pt!important;text-align:center;">' . $event_info['receipt_footer_c'] .'</div>';
            $_receipt_footer->embedHTML($event_info['receipt_footer_c']);
            $docx->addFooter(array('first' => $_receipt_footer, 'even' => $_receipt_footer, 'default' => $_receipt_footer));
        }
            
        //////
        
        $docx->createDocx($this->_crm_config['main']['temp_path'] . 'receipt');
        
        $docx_file = $this->_crm_config['main']['temp_path'] . 'receipt.docx';
        $pdf_destination_file = $this->_crm_config['main']['temp_path'] . "receipt.pdf";
        
        putenv("HOME=/home/dentalcommun/");
        //echo getenv("HOME");exit;
        $_docx = new TransformDocAdvLibreOffice();
        $_docx->transformDocument($docx_file, $pdf_destination_file, NULL, array('odfconverter' => 'false'));
    }                 
    
    function remove_receipt_pdf(){
        $filepath = $this->_crm_config['main']['temp_path'] . "receipt.pdf";
        if(file_exists($filepath)){
            unlink($filepath);
        }
    }
    
    function download($params = array()){
        $act_id = $this->EE->input->get_post('act_id');
        //$content = $this->get_content($act_id);
        $this->create_receipt($act_id);
        
        
        $now_date = date("Y-m-d H:i");
        $now_date = new DateTime($now_date, new DateTimeZone('UTC'));
        $now_date->setTimezone( new DateTimeZone("Australia/Sydney"));
        //$now_date= $now_date->format("l, j M Y - h:i A");
        $pdf_name = "Registration_receipt_" . $now_date->format("d") . "_" . $now_date->format("M") . "_" . $now_date->format("Y") . "_" . $now_date->format("H") . "_" . $now_date->format("i") . ".pdf";
        ////downloading receipt pdf ///
        $_receipt_file = $this->_crm_config['main']['temp_path'] . "receipt.pdf";
        if(file_exists($_receipt_file)){
            header('Content-Description: File Transfer');
            header('Content-Type: application/pdf');
            header('Content-Disposition: attachment; filename=' . $pdf_name);
            header('Expires: 0');
            header('Content-Length: ' . filesize($_receipt_file));
            readfile($_receipt_file);
            $this->remove_receipt_pdf();
            exit;    
        }
        
        $GLOBALS['shine_pdf_content'] = $content;
        $datas = array();
        $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
        $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt'
                );
        $datas = array(
                    'AID' => $action_id,
                    'dt' => $datas
                );
        
        $this->EE->TMPL->run_template_engine("dentevents", "register_receipt");    
        $this->EE->output->app_output($swaps, $datas);
    }

    function downloadIcs()
    {
        $event = self::$event;

        $date_time = new DateTime($event['start_date'], new DateTimeZone('UTC'));
        $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
        $start = $date_time->format("m/d/Y H:i");

        $date_time = new DateTime($event['end_date'], new DateTimeZone('UTC'));
        $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
        $end = $date_time->format("m/d/Y H:i");

        $name = $event['name'];
        $url = $event['sef_url_c'];
        $location = $event['event_city'] . ", " . $event['event_country'];
        $description = $event['event_theme'];

        $eventDates = $this->getEventDateSequences($start, $end);
        $icsEvents = [];
        $idx = 1;
        foreach ($eventDates as $eventDate) {
            $start = $eventDate['startDateTime'];
            $start = date("Ymd\THis",strtotime($start));

            $end = $eventDate['endDateTime'];
            $end = date("Ymd\THis",strtotime($end));
            $uid = "{$event['id']}-$idx";
            $now = date("Ymd\THis\Z");
            if ($idx == 1) {
                $alaram = <<<EOD

BEGIN:VALARM
TRIGGER:-PT10080M
ACTION:DISPLAY
DESCRIPTION:Reminder
END:VALARM
EOD;
            } else {
                $alaram = '';
            }
            $icsEvents[] = <<<EOD
BEGIN:VEVENT
DTSTART;TZID=Australia/Sydney:$start
DTEND;TZID=Australia/Sydney:$end
LOCATION:$location
TRANSP: OPAQUE
SEQUENCE:0
UID: $uid
DTSTAMP:$now
SUMMARY:$name
URL:$url
DESCRIPTION:$description
PRIORITY:1
CLASS:PUBLIC$alaram
END:VEVENT
EOD;
            $idx++;
        }

        $icsEvents = implode("\n", $icsEvents);

        $data = <<<EOD
BEGIN:VCALENDAR
VERSION:2.0
METHOD:PUBLISH
$icsEvents
END:VCALENDAR
EOD;

        $fileName = "event_{$event['id']}.ics";
        header("Content-type:text/calendar");
        header('Content-Disposition: attachment; filename="'.$fileName.'"');
        Header('Content-Length: '.strlen($data));
        Header('Connection: close');
        echo $data;
        exit;
    }

    function update_worklog($act_id,$to_email){
        $time = new DateTime();
        $time->setTimezone(new DateTimeZone("Australia/Sydney"));
        $time = $time->format("d M Y - h:i:s");
        $data = array();
        $old_work = $this->EE->cpd_activity->get_main_data(array(
                        "selects" => "{#m}.id,{#m}.work_log",
                        'where' => "{#m}.id='{$act_id}'",
                        'single' => true
                    ));
        $data['id'] = $old_work['id'];
        $data['work_log'] = "{$old_work['work_log']}\r\n{$time} – Tax Invoice & Receipt emailed to $to_email";

        $success = $this->EE->cpd_activity->set_record($data);
        return $success;

    }
    
    function email($params = array()){
        $_event = self::$event;
        
        $act_id = $params['act_id'];
        if ($act_id == null) {
            $act_id = $this->EE->input->get_post('principal_act_id');
        }
        $testEmail = $this->EE->input->get_post('test_email');
        $task_type = '';
        $message_no = '';
        $task_name_confirm = '';

        $autoAccept = isset($params['auto_accept']) ? $params['auto_accept'] : '';
        $content = $this->get_contents($act_id, array('email_template' => 'yes', 'auto_accept' => $autoAccept));
//echo $content;exit;
        $payment = $this->EE->input->get_post('payment');
        $status = "";
        if(($payment['method'] == "capture") || ($payment['method'] == "account")){
            $subject = 'Registration in Progress for ' . $_event['name'];
            $task_type = 'progress';
            $message_no = 'DVT002';
        }else{
            $subject = 'Registration receipt ' . $_event['name'];
            $task_type = 'receipt';
            $message_no = 'DVT001';
            $task_name_confirm = 'Confirmation, Tax Invoice & Receipt Email Sent';
        }
        if(self::$act['payment_type_c'] == "free"){
            $subject = 'Registration in Progress for ' . $_event['name'];
            $task_type = 'progress';
            $message_no = 'DVT002';
            if($params['auto_accept'] == 'yes'){
                $subject = 'Registration receipt ' . $_event['name'];
                $task_type = 'receipt';
                $message_no = 'DVT003';
                $task_name_confirm = 'Confirmation Email Sent';
            }
        }
        $token = "";
        foreach (self::$all_registrants as $key => $item) {
            $address = $key;
            $token = $token.", ".$address;
            $bcc = $_event['event_email'];

            $this->EE->load->library('email');
            $this->EE->email->wordwrap = true;
            $this->EE->email->set_mailtype('html');
            $this->EE->email->from('info@dentevents.com', 'Dentevents Registrations');

            if ($testEmail != '') {
                $address = $testEmail;
            }
            $this->EE->email->to($address);

            if ($testEmail == '') {
                $this->EE->email->bcc($bcc);
            }

            $this->EE->email->reply_to('info@dentevents.com');
            $this->EE->email->subject($subject);
            $this->EE->email->message($content);
            
            $status = '';
            if($this->EE->email->send()){
                $status = "success";

            }else{
                $status = "fail";
            }
            $this->EE->email->clear(true);
            //////creating task /////
            $this->EE->load->model('tasks');
            if($task_type == 'progress') {
                $task_datas = array(
                    'name' => 'Registration in Progress Email Sent',
                    'status' => 'Completed',
                    'priority' => 'Low',
                    'message_type_c' => 'User',
                    'description' => $content,
                    'email_from_name_c' => $address,
                    'message_no_c' => $message_no,
                    'contact_id' => $item['id'],
                    'ext_cpdactivity_tasks_1ext_cpdactivity_ida' => $item['act_id']
                );

                $success = $this->tasks->set_record($task_datas);
                if (!$success) {
                    $this->logger->developer("Failed to create the tasks for Registration in Progress.");
                }
            }else{
                $task_datas = array(
                    'name' => $task_name_confirm,
                    'status' => 'Completed',
                    'priority' => 'Low',
                    'message_type_c' => 'User',
                    'description' => $content,
                    'email_from_name_c' => $address,
                    'message_no_c' => $message_no,
                    'contact_id' => $item['id'],
                    'ext_cpdactivity_tasks_1ext_cpdactivity_ida' => $item['act_id']
                );

                $success = $this->tasks->set_record($task_datas);
                if (!$success) {
                    $this->logger->developer("Failed to create the tasks for Registration Receipt.");
                }
            }
            /// ////////////
        }
        if($status == "success"){
            $token = rtrim(trim($token),",");
            $token = ltrim(trim($token),",");
            $this->update_worklog($act_id,$token);

        }
        
        return $status;
    }
}