<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Registration_Registrants extends DEProcessing_Dentevents_Details_Premium_Registration{
    static $primary_rego = '';
    protected $step = 'registrants';

    function initialize($params = array()){
        $this->EE->load->model("contacts");
        $this->EE->load->model("accounts");
        
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        /// check primary rego ///
        if(!empty($primary_rego_id)){
            $_rego = $this->EE->cpd_eventregooptions->get_main_data(array(
                        'selects' => "{#m}.id,{#m}.audience,{#m}.country,{#c}.block_multiple_registrations_c,{#c}.hide_price_c",
                        'where' => "{#m}.id='{$primary_rego_id}'",
                        'single' => true
                     ));
            self::$primary_rego = $_rego;
        }
        //////////////////////////
         // var_dump($_rego);
        
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "show":
                self::$utility->save_step(self::$event, $this->step);
                return $this->show();
            break;
            case "add":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/registrants/add.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Registrants_Add();
                $processing->initialize($params);
                return $processing->process($params);
            break; 
            case "remove":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/registrants/remove.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Registrants_Remove();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "save":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/registrants/save.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Registrants_Save();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "auto_fill":
                return $this->auto_fill();
            break;
            case "auto_next":
                return $this->auto_next();
            break;
            case "step_next":
                return $this->step_next($params);
            break;
        }

    }
    
    public function make_registrants_history($principal_act_id){
        $_event = self::$event;
        $act_list = $this->EE->cpd_activity->get_relationship_transactions_cpdactivity(array(
                    'id' => $principal_act_id,
                    'selects' => "{#m}.id",
                    'where' => "{#c}.rego_option_type_c='Core'",
                    'to_values' => "id"
                ));
        $act_list = array_merge(array($principal_act_id), $act_list);
        $history = array();
        $i = 1;
        foreach($act_list as $item){
            /// rego option ///
            $_rego_option = $this->EE->cpd_activity->get_relationship_cpd_eventregooptions(array(   
                                    'id' => $item,
                                    'selects' => "{#m}.id,{#m}.name",
                                    'single' => true
                                ));
                                
            ///////////////////
            $_registrant = $this->EE->cpd_activity->get_relationship_contacts(array(   
                                    'id' => $item,
                                    'selects' => "{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.rego_domain_c,{#c}.rego_no_c,{#c}.rego_no_nz_c,{#c}.rego_no_other_c,{#c}.pract_type_c,{#c}.pract_type_nz_c,{#c}.pract_type_other_1_c",
                                    'single' => true
                                ));
            $_registrant['country_opts'] = $this->helper->make_select_opts('countries_dom', $_registrant['rego_domain_c']);
            $pract_type = '';
            if(strtolower($_registrant['rego_domain_c']) == 'australia'){
                $_registrant['rego'] = $_registrant['rego_no_c'];    
                $pract_type_field = 'pract_type_list'; 
                $pract_type = $_registrant['pract_type_c'];
                $_registrant['pract_type_opts'] = $this->helper->make_select_opts($pract_type_field, $_registrant['pract_type_c'], array('multiple_values' => true));
            }else if(strtolower($_registrant['rego_domain_c']) == 'new zealand'){
                $_registrant['rego'] = $_registrant['rego_no_nz_c'];
                $pract_type_field = 'pract_type_nz_list'; 
                $pract_type = $_registrant['pract_type_nz_c'];
                $_registrant['pract_type_opts'] = $this->helper->make_select_opts($pract_type_field, $_registrant['pract_type_nz_c'], array('multiple_values' => true));
            }else{
                $_registrant['rego'] = $_registrant['rego_no_other_c'];
                $pract_type_field = 'pract_type_other_opt_list'; 
                $pract_type = $_registrant['pract_type_other_1_c'];
                $_registrant['pract_type_opts'] = $this->helper->make_select_opts($pract_type_field, $_registrant['pract_type_other_1_c'], array('multiple_values' => true));
            }
            $_registrant['pract_type'] = str_replace("^", "", $pract_type);
            
            $label = '';
            if($item == $principal_act_id){
                $label = "Principal Registrant";
            }else{
                $label = "Registrant {$i}";
            }
            $i++;
            
            /// special diet choices ///
            $_activity = $this->EE->cpd_activity->get_main_data(array(
                            'selects' => "{#m}.id,{#c}.special_diet_choice_c,{#c}.address_used_c",
                            'where' => "{#m}.id='{$item}'",
                            'single' => true
                        ));
            if(!empty($_event['special_diet_choices_c'])){
                $diets = trim($_event['special_diet_choices_c'], "^");
                $diets = explode("^,^", $diets);
                $diets_labels = $this->helper->get_dropdowns_sugar_labels('special_diet_choices_list', $_event['special_diet_choices_c'], true);
                $_registrant['diets_opts'] = $this->helper->make_select_opts(array_combine($diets, $diets_labels), $_activity['special_diet_choice_c']);
            }    
            ////////////////////////////
            /// check editable ///
            $editable = '';
            if($_activity['address_used_c'] != "Principle"){
                $editable = "yes";    
            }
            //////////////////////
             
            $history[] = array('id' => $item, 'label' => $label, 'registrant' => $_registrant, 'editable' => $editable, 'rego_option' => $_rego_option);
        }
        return $history;
    }
    public function show($sparams=''){

        if(!empty($_COOKIE['register_o'])){ 
            unset($_COOKIE["register_o"]);
            $res = setcookie("register_o", "", time() - 3600);
        }
     
        $_event = self::$event;        
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $img_base_url = $this->_crm_config['main']['upload_url'];

        
        
        
        if($_event['event_max_attendance'] != ''){
            /// add reserve tickets ///
            if(empty(self::$reserve_ticket)){
                self::$reserve_ticket = self::$utility->add_reserve_ticket($_event, $primary_rego_id);
                self::$cookie_reserve_ticket = self::$utility->save_cookie_reserve_ticket(
                        $_event, $primary_rego_id,
                        array( 'key' => 'id_for_master', 'value' => self::$reserve_ticket['id'])
                    );
            }
            if($sparams['referer'] == 'additional'){
                $sub_reserve_ticket = self::$utility->add_reserve_ticket(
                                            $_event, $primary_rego_id, 
                                            array(
                                                'data' => array('expired_at' => self::$reserve_ticket['expired_at'])
                                            )
                                 );    
                self::$cookie_reserve_ticket = self::$utility->save_cookie_reserve_ticket(
                        $_event, $primary_rego_id,
                        array( 'key' => 'ids_for_add_registrants', 'value' => $sub_reserve_ticket['id'])
                    );
            }
            ///////////////////////////
        }
               
        $principal_act_id = self::$utility->load_cookie_registration('principal_act_id', array('event' => $_event, 'primary_rego_id' => $primary_rego_id));
        if(!empty($sparams['principal_act_id'])){
            $principal_act_id = $sparams['principal_act_id']; 
        }
        if(!empty($principal_act_id)){
            $_principal_act = $this->EE->cpd_activity->get_main_data(array(
                    'selects' => "{#m}.id",
                    'where' => "{#m}.id='{$principal_act_id}'",
                    'single' => true
                ));
            if(empty($_principal_act)){
                $principal_act_id = ''; 
            }
        }
        
        $datas = $this->fetch_basic_data();
        
        /// check primary rego ///
        $datas['primary_rego'] = self::$primary_rego;
        $datas['primary_rego']['block_multiple'] = $datas['primary_rego']['block_multiple_registrations_c'];
        //////////////////////////
        
        if($_event['event_max_attendance'] != ''){
            /// check reserve status ///
            $reserve_status = self::$utility->load_reserve_tickets($_event);
            if($reserve_status['remains'] < 1){
                $datas['primary_rego']['block_multiple'] = 1;
            }
            ////////////////////////////
        }
        
        /// registrants history ///
        if(!empty($principal_act_id)){
            $datas['history'] = $this->make_registrants_history($principal_act_id);
        }
        ///////////////////////////
        
        $datas['principal_act_id'] = $principal_act_id;
                
        $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
        $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt',
                    'reserve_ticket_html' => 'reserve_ticket_html'
                );
        $datas = array(
                    'AID' => $action_id,
                    'dt' => $datas,
                    'reserve_ticket_html' => $this->render_reserve_ticket(self::$reserve_ticket)
                );
        
        $this->EE->TMPL->run_template_engine("dentevents", "register_registrants");    
        
        $this->EE->output->app_output($swaps, $datas, array('env' => true));
    }
    
    public function auto_fill($params=''){
        require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/registrants/autofill.php');
        $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Registrants_AutoFill();
        $processing->initialize($params);
        return $processing->process($params);
    }

    public function auto_next($params=''){
        require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/registrants/autonext.php');
        $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Registrants_AutoNext();
        $processing->initialize($params);
        return $processing->process($params);
    }

    public function step_next($params=''){
        self::$router = "add:process";
        $principal_act_id = DEProcessing_Dentevents_Details_Premium_Registration_Registrants::process($params);

        self::$router = "options:show";
        return DEProcessing_Dentevents_Details_Premium_Registration::process(array('principal_act_id' => $principal_act_id));
    }
}