<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Registration_Registrants_Add extends DEProcessing_Dentevents_Details_Premium_Registration_Registrants{

    function initialize($params = array()){
        require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/registrants/lib/detect.php');
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "process":
                return $this->do_process();
            break; 
            case "additional":
                return $this->additional();
            break;
        }

    }
    
    function do_process($sparams = ''){
    	$this->EE->load->model("topics");

        $_event = self::$event;
        $contact_id = $this->EE->input->get_post("contact_id");
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post("principal_act_id");
        $address_changed = $this->EE->input->get_post("address_changed");  
        $skip_additional_registrant = $this->EE->input->get_post("skip_additional_registrant");  
        
        $r_account = $this->EE->input->get_post("account");
        $r_contact = $this->EE->input->get_post("contact");

        
        ////////
        $is_principal_registrant = false;
        if(empty($principal_act_id)){  /// for principal registrant
            $is_principal_registrant = true;
        }
        if(!empty($principal_act_id) && $skip_additional_registrant == 'yes'){  /// for principal registrant
            return $principal_act_id;
        }
        
        $special_meal = $this->EE->input->get_post("special_meal");
        if($special_meal == 'none'){
            $special_meal = '';            
        }
        $notes = $this->EE->input->get_post("notes");
        /// prepare contact ///
        $is_principle_address = false;
        if(!empty($contact_id) && $address_changed != "yes"){
            $is_principle_address = true;    
        }
        
        /////// update contact ///
        $data = array();
        if(!empty($contact_id) && $address_changed == "yes"){
            if(empty($r_account['name'])){
                $data['alt_address_street'] = $r_account['name'] . "\r\n" . $r_account['street'];    
            }else{
                $data['alt_address_street'] = $r_account['name'] ."," . "\r\n" . $r_account['street'];    
            }            
            $data['alt_address_city'] = $r_account['city'];
            $data['alt_address_state'] = $r_account['state'];
            $data['alt_address_postalcode'] = $r_account['postalcode'];
            $data['alt_address_country'] = $r_account['country'];
        }     
        if(!empty($contact_id) && !empty($special_meal)){
            $data['special_meal_pref_c'] = $special_meal;    
        }  
        if(!empty($contact_id) && !empty($r_contact['email'])){
            $data['email1'] = $data['email_c'] = $r_contact['email']; 
        }
        if(!empty($contact_id) && !empty($r_contact['mobile_phone'])){
            $data['phone_mobile'] = $r_contact['mobile_phone'];   
        }
        if(!empty($contact_id) && !empty($data)){
            $data['id'] = $contact_id;
            
            $success = $this->EE->contacts->set_record($data);
            if(!$success){
                $this->logger->developer("Failed to update the contact for registrant.");
                return false;
            }
        } 
        //////////////////////////////////
       
        ///////// send email to registered user /////////////
        $registered = "";
        if(!empty($contact_id)){
        	$registered = self::$utility->check_already_register($_event['id'], $contact_id, $primary_rego_id);	
        }

        if(!empty($registered)){
        	self::$registered = "yes";
            $adding_link = "https://www.dentevents.com/addoptions={$registered}&id={$_event['event_id_c']}";
            $address = "coderun.soft@zohomail.com";
            //$address = "production@dentist.com.au";
            $this->EE->load->library('email');
            $this->EE->email->wordwrap = true;
            $this->EE->email->set_mailtype('html');
            $this->EE->email->from('info@dentevents.com', 'Adding new option');
            $this->EE->email->to($address);
            $this->EE->email->reply_to('info@dentevents.com');
            $this->EE->email->subject("adding new option");
            $this->EE->email->message($adding_link);
            
            $status = '';
            if($this->EE->email->send()){
                $status = "success";
            }else{
                $status = "fail";
            }                
            if(!empty($principal_act_id)){
            	$success = $this->EE->cpd_activity->add_relationship_app($registered, $principal_act_id, 'transactions_cpdactivity');

	            if(!$success){
	                $this->logger->developer("Failed to create the link between principal activity and created activity");
	                return false;
	            }
	            
	            return $principal_act_id;
            }
            return $registered;
        }
        //////////////////////////////////
        
        if(empty($contact_id)){
            $data = array();
            $data['salutation'] = $r_contact['salutation'];
            $data['first_name'] = $r_contact['first_name'];
            $data['last_name'] = $r_contact['last_name'];
            $data['email1'] = $data['email_c'] = $r_contact['email'];
            $data['contact_type_c'] = 'Registrant';
            $data['phone_mobile'] = $r_contact['mobile_phone'];
            $data['rego_domain_c'] = $r_contact['country'];
            $data['special_meal_pref_c'] = $special_meal; 
            $data['creator_ip_address_c'] = $_SERVER['REMOTE_ADDR'];
            
            switch(strtolower($r_contact['country'])){
                case 'australia':
                    $data['rego_no_c'] = $r_contact['rego'];
                    $data['pract_type_c'] = "^" . $r_contact['pract_type'] . "^";
                break; 
                case 'new zealand':
                    
                    $data['rego_no_nz_c'] = $r_contact['rego'];
                    if($r_contact['pract_type'] == "Oral Health Therapist"){
                        
                        // $r_contact['pract_type'] = 'OralHealthTherapist';
                         $data['pract_type_nz_c'] = "^OralHealthTherapist^";
                    }else{
                        $data['pract_type_nz_c'] = "^" . $r_contact['pract_type'] . "^";
                    }
                break;                                         
                default:
                    $data['rego_no_other_ctry_c'] = $r_contact['country'];
                    $data['rego_no_other_c'] = $r_contact['rego'];     
                    $data['pract_type_other_1_c'] = "^" . $r_contact['pract_type'] . "^";
            }
            if($is_principal_registrant){  /// for principal registration
                if(empty($r_account['name'])){
                    $data['alt_address_street'] = $r_account['name'] . "\r\n" . $r_account['street'];
                }else{
                    $data['alt_address_street'] = $r_account['name'] . "," . "\r\n" . $r_account['street'];
                }                
                $data['alt_address_city'] = $r_account['city'];
                $data['alt_address_state'] = $r_account['state'];
                $data['alt_address_postalcode'] = $r_account['postalcode'];
                $data['alt_address_country'] = $r_account['country'];
                $data['direct_phone_c'] = $r_account['phone_office'];
                $data['phone_fax'] = $r_account['phone_fax'];
            }
            

            $success = $this->EE->contacts->set_record($data);
            // if($_SERVER['REMOTE_ADDR'] == '149.154.156.99'){
                
            //     var_dump("***********Contacts data*************");
            //     var_dump( $success);
            //     var_dump('</br>&&&&&&&&&&&&&&&&&&&&&</br>');
            // }
            if(!$success){
                return '';
                //echo "Failed to create the contact for registration";exit;
                $this->logger->developer("Failed to create the contact for registration");
                return false;
            }
            $contact_id = $success;

            /// create task ///
            $desc = "A new contact record was created as a registrant for the CPD Event {$_event['name']}. Please check it.";
            $task_data = array(
                    'name' => 'New Contact Added as Event Registrant',
                    'status' => 'In Progress',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'High',
                    'message_type_c' => 'System',
                    'description' => $desc,
                    'contact_id' => $contact_id,
                    'message_no_c' => 'MEV0080',
                );
            $success = $this->tasks->set_record($task_data);
            if (!$success){
                $this->logger->developer("Failed to create the tasks for new contact added as event registrant.");
            }
            ///////////////////
        }
        /////////////////////// 

        /// connecting to topic ////
        $_topic = $this->EE->cpd_events->get_relationship_topics(array(
                'id' => $_event['id'],
                'selects' => "{#m}.id"
                //'single' => true
            ));
        if(!empty($_topic)){
            foreach($_topic as $_item){
                $success = $this->EE->contacts->add_relationship_app($contact_id, $_item['id'], 'event_topics');


                if(!$success){
                    $this->logger->developer("Failed to connect contact to topic");
                }
            }
        }
        ////
        
        //////// get event linked to event rego option ////////
        $linked_event = $this->EE->cpd_eventregooptions->get_relationship_payment_matrix_event(array(
                                                'id' => $primary_rego_id,
                                                'selects' => "{#m}.id",
                                                'single' => true
                                            ));
        //////////
        $added_number = 0;
        if($is_principal_registrant){
            $added_number = 0;
        }else{
            $added_list = $this->EE->cpd_activity->get_relationship_transactions_cpdactivity(array(
            'id' => $principal_act_id,
            'selects' => "{#m}.id",
            'where' => "{#c}.rego_option_type_c='Core'",
            'to_values' => "id"
            ));
            $added_list = array_merge(array($principal_act_id), $added_list);
            $added_number = count($added_list);
        }
        
        /// CPD Activity ///
        $data = array();
        $data['name'] = $_event['name'];
        $starttime = new DateTime($_event['start_date'], new DateTimeZone('UTC'));
        $starttime->setTimezone(new DateTimeZone("Australia/Sydney"));
        $starttime = $starttime->format("Y-m-d");
        
        $endtime = new DateTime($_event['end_date'], new DateTimeZone('UTC'));
        $endtime->setTimezone(new DateTimeZone("Australia/Sydney"));
        $endtime = $endtime->format("Y-m-d");

        $data['date_commenced_c'] = $starttime;
        $data['date_undertaken'] = $endtime;
        if($_event['event_format'] == 'Lecture'){
            $data['acttype'] = strtolower($_event['event_format']);    
        }else{
            $data['acttype'] = $_event['event_format'];
        }
        
        $data['status'] = "1Incomplete";
        $data['location'] = $_event['event_city'] . ", " . ucfirst(strtolower($_event['event_country']));
        $data['special_diet_choice_c'] = $special_meal; 
        $data['attendance'] = "Pending";
        $data['event_organiser_c'] = self::$organiser['name'];
        $data['rego_option_type_c'] = "Core";
        $data['cat_a_cpd_c'] = $_event['cpd_points_type_1'];
        $data['cat_b_cpd_c'] = $_event['cpd_points_type_2'];
        $data['cat_c_cpd_c'] = $_event['cpd_points_type_3'];
        if($is_principle_address){
            $data['address_used_c'] = "Principle";    
        }else{
            $data['address_used_c'] = "Alternate_2";    
        }
        if($notes != ''){
            $data['notes_c'] = $notes;
            $data['notes_checked_c'] = 1;
        }
        $data['accounts_ext_cpdactivity_1accounts_ida'] = self::$organiser['id'];
        $detect = new Detect;
        $data['web_browser_c'] = $detect->browser();
        $data['device_c'] = $detect->deviceType() . " - " . $detect->os();
        $data['ip_address_c'] = $_SERVER['REMOTE_ADDR'];
        $data['user_update_log_c'] = $this->EE->input->get_post("comp_question");

        //added 190911

        $time = new DateTime();
        $time->setTimezone(new DateTimeZone("Australia/Sydney"));
        $time = $time->format("d M Y - h:i:s");


        if($added_number > 0){
            $add_num = $added_number + 1;
            $data['work_log'] = $time ." – CPD Activity Record Created – Status = Incomplete – Registrant ".(string)$add_num;
        }else{
            $data['work_log'] = $time ." – CPD Activity Record Created – Status = Incomplete – Registrant 1";
        }

        
            
        
       
        //added 190911


        if(!empty($data['user_update_log_c'])){
            $data['notes_checked_c'] = 1;    
        }        
        $success = $this->EE->cpd_activity->set_record($data);
        // if($_SERVER['REMOTE_ADDR'] == '149.154.156.99'){
                
        //         var_dump("***********cpd_activity data*************");
        //         var_dump( $success);
        //         var_dump('</br>&&&&&&&&&&&&&&&&&&&&&</br>');exit;
        // }

        if(!$success){
            $this->logger->developer("Failed to create the cpd activity.");
            return false;
        }
        $activity_id = $success;      
            /// link it to contact ///
            $success = $this->EE->contacts->add_relationship_app($contact_id, $activity_id, 'cpdactivity');


            if(!$success){
                $this->logger->developer("Failed to link the cpd activity to contact");
                return false;
            }
            //////////////////////////
            
        /// link it to event ///
        $success = $this->EE->cpd_events->add_relationship_app($linked_event['id'], $activity_id, 'cpdactivity');
        if(!$success){
            $this->logger->developer("Failed to link the cpd activity to event");
            return false;
        }
        //////////////////////////
        ////////////////////

        if($is_principal_registrant){
            $principal_act_id = $activity_id; 
            self::$utility->set_cookie_registration('principal_act_id', $principal_act_id, array('event' => $_event, 'primary_rego_id' => $primary_rego_id));
        }else{
            $success = $this->EE->cpd_activity->add_relationship_app($activity_id, $principal_act_id, 'transactions_cpdactivity');
            if(!$success){
                $this->logger->developer("Failed to create the link between principal activity and created activity");
                return false;
            }
        }
        
        /// prepare the link between activity and rego option ///
        $_contact = self::$utility->fetch_contact_by_id($contact_id);
        $_contact_pract_type = self::$utility->get_pract_type_from_contact($_contact);
        $_contact_pract_type = $this->helper->extract_multiselect($_contact_pract_type);

        $audience = self::$primary_rego['audience'];
        $audience = $this->helper->extract_multiselect($audience);
        $country = self::$primary_rego['country'];
        $country = $this->helper->extract_multiselect($country);
        
        $link_rego_option_id = $primary_rego_id;
        $paddress = $this->get_address_principal_registrant($principal_act_id);
        //////// Different price setting /////

        $registrant_number = 0;
        $act_list = $this->EE->cpd_activity->get_relationship_transactions_cpdactivity(array(
            'id' => $principal_act_id,
            'selects' => "{#m}.id",
            'where' => "{#c}.rego_option_type_c='Core'",
            'to_values' => "id"
        ));
        $act_list = array_merge(array($principal_act_id), $act_list);
        $registrant_number = count($act_list);
        

        //added 190911

        // $time = new DateTime();
        // $time->setTimezone(new DateTimeZone("Australia/Sydney"));
        // $time = $time->format("d M Y - h:i:s");

        // $old_worklog = $this->EE->cpd_activity->get_main_data(array(
        //                     "selects" => "{#m}.work_log",
        //                     'where' => "{#m}.id='{$principal_act_id}'",
        //                     'single' => true
        //                 ));

        
        //     var_dump($old_worklog);
        //     var_dump("<br/>");
        //     var_dump($registrant_number);
            
        
        // if(empty($old_worklog)){
        //     $new_worklog = $time + " – CPD Activity Record Created – Status = Incomplete – Registrant " + $registrant_number; 
        // }else{
        //     $new_worklog = $old_worklog + "<br/>" + $time + " – CPD Activity Record Created – Status = Incomplete – Registrant " + $registrant_number;
        // }
        // $sub_data['work_log'] = $new_worklog;
        // $this->EE->cpd_activity->set_record($sub_data);
        //added 190911

        ////////////////////////////////////
        if($registrant_number <= 1){
            if(!array_intersect($_contact_pract_type, $audience) || !in_array($paddress['country'], $country)){
                $alternate_options = $this->EE->cpd_eventregooptions->get_relationship_alternate_options(array(
                    'id' => $primary_rego_id,
                    'selects' => "{#m}.id,{#m}.audience,{#m}.country,{#c}.registrant_no_c"
                ));
                foreach($alternate_options as $item){
                    $audience = $item['audience'];
                    $audience = $this->helper->extract_multiselect($audience);
                    if(array_intersect($_contact_pract_type, $audience)){
                        $country = $item['country'];
                        $country = $this->helper->extract_multiselect($country);
                        if((in_array($paddress['country'], $country)) || ($item['registrant_no_c'] == 1 || $item['registrant_no_c'] == '')){
                            $link_rego_option_id = $item['id'];
                            break;
                        }
                    }
                }
            }
        }else{
                $alternate_options = $this->EE->cpd_eventregooptions->get_relationship_alternate_options(array(
                    'id' => $primary_rego_id,
                    'selects' => "{#m}.id,{#m}.audience,{#m}.country,{#c}.registrant_no_c"
                ));

                $registrant_nums = array();
                $selected_price = '';
                foreach($alternate_options as $item){
                    $audience = $item['audience'];
                    $audience = $this->helper->extract_multiselect($audience);
                    if(array_intersect($_contact_pract_type, $audience)){
                        $country = $item['country'];
                        $country = $this->helper->extract_multiselect($country);
                        if($item['registrant_no_c'] == $registrant_number){
                            $link_rego_option_id = $item['id'];
                            $selected_price = $item['id'];
                            break;
                        }
                        $price_id = $item['id'];
                        $registrant_nums[$price_id] = $item['registrant_no_c'];
                    }
                }

                if(empty($selected_price)){
                    $temp_rego_option_id = $this->getClosest($registrant_number, $registrant_nums);
                    if(!empty($temp_rego_option_id)){
                        $link_rego_option_id = $temp_rego_option_id;
                    }
                }
        }


        $success = $this->EE->cpd_eventregooptions->add_relationship_app($link_rego_option_id, $activity_id, 'cpdactivity');
        if(!$success){
            $this->logger->developer("Failed to create the link between rego option and cpd activity");
            return false;
        }
        /////////////////////////////////////////////////////////
        
        return $principal_act_id;
        
    }
    function additional($sparams = ''){
        $principal_act_id = $this->do_process();   
        return DEProcessing_Dentevents_Details_Premium_Registration_Registrants::show(array('principal_act_id' => $principal_act_id, 'referer' => 'additional'));
    }

    function getClosest($search, $arr) {
        $closest = null;
        $closest_id = null;

        foreach ($arr as $key => $item) {
            if (($closest === null || abs($search - $closest) > abs($item - $search)) && ($search >= $item)) {
                $closest = $item;
                $closest_id = $key;
            }
        }
        return $closest_id;
    }
}