<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Registration_Success extends DEProcessing_Dentevents_Details_Premium_Registration{
    protected $step = 'success';
    
    function initialize($params = array()){

    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();

        switch($cmd){
            case "eway":
                return $this->process_eway($params);
            break;
            case "capture":
                return $this->process_capture($params);
            break;
            case "paypal":
                return $this->process_paypal($params);
            break;
            case "account":
                return $this->process_account($params);
            break;
        }
    }
    
    function process_eway($params = array()){
        if(false && !empty($_COOKIE['register_p_s'])) {
                    $cookie_name = "register_p_s";
                    unset($_COOKIE[$cookie_name]);
                    $res = setcookie($cookie_name, "", time() - 3600);
                    self::$router = "reset";
                    return DEProcessing_Dentevents_Details_Premium_Registration::process($sparams);
                    
        }else{
            $_event = self::$event;      
            $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
            $principal_act_id = $this->EE->input->get_post('principal_act_id');
            
            $img_base_url = $this->_crm_config['main']['upload_url'];

            $datas = $this->fetch_basic_data();
            $datas['event']['payment_success_text'] = $_event['payment_success_text_c']; 
            $datas['event']['payment_success_user_message'] = $_event['payment_success_user_message_c'];
            $datas['payment_method'] = "eway";
            $datas['receipt_url'] = $this->getReceiptUrl();
            $datas['apple_wallet_url'] = $this->getAppleWalletUrl();

            $cookie_name = "register_p_s";
            $cookie_value = true;
            setcookie($cookie_name, $cookie_value, time() + (86400 * 30), '/'); 
            
            $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
            $this->write_worklog($principal_act_id);
            $swaps = array(
                        'AID' => 'AID',
                        'dt' => 'dt'
                    );
            $datas = array(
                        'AID' => $action_id,
                        'dt' => $datas
                    );
            
            $this->EE->TMPL->run_template_engine("dentevents", "register_success");    
            
            $this->EE->output->app_output($swaps, $datas, array('env' => true));
        }
    }
    
    function process_paypal($params = array()){
        $_event = self::$event;      
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post('principal_act_id');
        
        $img_base_url = $this->_crm_config['main']['upload_url'];

        $datas = $this->fetch_basic_data();
        $datas['event']['payment_success_text'] = $_event['payment_success_text_c'];
        $datas['event']['payment_success_user_message'] = $_event['payment_success_user_message_c'];
        $datas['payment_method'] = "paypal";
        $datas['receipt_url'] = $this->getReceiptUrl();
        $datas['apple_wallet_url'] = $this->getAppleWalletUrl();
        
        $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
        $this->write_worklog($principal_act_id);
        $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt'
                );
        $datas = array(
                    'AID' => $action_id,
                    'dt' => $datas
                );
        
        $this->EE->TMPL->run_template_engine("dentevents", "register_success");    
        
        $this->EE->output->app_output($swaps, $datas, array('env' => true));
    }
    
    function process_capture($params = array()){
        
        $_event = self::$event;      
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post('principal_act_id');
        
        $img_base_url = $this->_crm_config['main']['upload_url'];

        $datas = $this->fetch_basic_data();
        /////// check auto accept free /////
        
        $act_data = $this->EE->cpd_activity->get_main_data(array(
                'selects' => "{#c}.payment_processed_by_c",
                'where' => "{#m}.id='{$principal_act_id}'",
                'single' => true
            ));
        //////
        if ($act_data['payment_processed_by_c'] == 'Auto Accept') {
            $datas['event']['payment_success_text'] = $_event['payment_success_text_c'];
            $datas['event']['payment_success_user_message'] = $_event['payment_success_user_message_c'];
        }else{
            $datas['event']['payment_success_text'] = $_event['payment_in_progress_text_c'];
            $datas['event']['payment_success_user_message'] = $_event['payment_in_progress_user_msg_c'];
        }        
        $datas['payment_method'] = "capture";
        $datas['apple_wallet_url'] = $this->getAppleWalletUrl();
        $this->write_worklog($principal_act_id);
                        
        $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
        $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt'
                );
        $datas = array(
                    'AID' => $action_id,
                    'dt' => $datas
                );
        
        $this->EE->TMPL->run_template_engine("dentevents", "register_success");    
        
        $this->EE->output->app_output($swaps, $datas, array('env' => true));
    }

    function write_worklog($act_id){

        $time = new DateTime();
        $time->setTimezone(new DateTimeZone("Australia/Sydney"));
        $time = $time->format("d M Y - h:i:s");
        $data = array();
        $old_work = $this->EE->cpd_activity->get_main_data(array(
                        "selects" => "{#m}.id,{#m}.work_log",
                        'where' => "{#m}.id='{$act_id}'",
                        'single' => true
                    ));
        $data['id'] = $old_work['id'];
        $data['work_log'] = "{$old_work['work_log']}\r\n{$time} – Registration Complete Page Displayed";
        $success = $this->EE->cpd_activity->set_record($data);

    }
    
    function process_account($params = array()){
        $_event = self::$event;      
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        $principal_act_id = $this->EE->input->get_post('principal_act_id');
        
        $img_base_url = $this->_crm_config['main']['upload_url'];


        $datas = $this->fetch_basic_data();
        $datas['event']['payment_success_text'] = $_event['payment_in_progress_text_c'];
        $datas['event']['payment_success_user_message'] = $_event['payment_in_progress_user_msg_c'];
        $datas['payment_method'] = "account";
        $datas['apple_wallet_url'] = $this->getAppleWalletUrl();
                        
        $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
        $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt'
                );
        $datas = array(
                    'AID' => $action_id,
                    'dt' => $datas
                );

        $this->write_worklog($principal_act_id);

        // $time = new DateTime();
        // $time->setTimezone(new DateTimeZone("Australia/Sydney"));
        // $time = $time->format("d M Y - h:i:s");
        // $data = array();
        // $old_work = $this->EE->cpd_activity->get_main_data(array(
        //                 "selects" => "{#m}.id,{#m}.work_log",
        //                 'where' => "{#m}.id='{$principal_act_id}'",
        //                 'single' => true
        //             ));
        // $data['id'] = $old_work['id'];
        // $data['work_log'] = "{$old_work['work_log']}\r\n{$time} – Registration Complete Page Displayed";
        // $success = $this->EE->cpd_activity->set_record($data);
        // DEProcessing_Dentevents_Details_Premium_Registration::logConsole("cart_id",$principal_act_id,true);
        // DEProcessing_Dentevents_Details_Premium_Registration::logConsole("data_id",$data['id'],true);
        // DEProcessing_Dentevents_Details_Premium_Registration::logConsole("success_worklog",$data['work_log'],true);


        // DEProcessing_Dentevents_Details_Premium_Registration::logConsole("success",$success,true);
        // if(!$success){
        //     $this->logger->developer("Failed to update the work_log-" . get_class($this) . '-update_worklog_activities');
        // }
        
        $this->EE->TMPL->run_template_engine("dentevents", "register_success");    
        
        $this->EE->output->app_output($swaps, $datas, array('env' => true));
    }
}