<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Registration_Summary extends DEProcessing_Dentevents_Details_Premium_Registration{
    static $act;
    static $contact_name = array();
    function initialize($params = array()){
        $act_id = $this->EE->input->get_post('act_id');
        if(!empty($params['act_id'])){
            $act_id = $params['act_id'];
        }
        self::$act = $this->EE->cpd_activity->get_main_data(array(
            'selects' => "{#m}.id,{#m}.date_entered,{#m}.status,{#c}.receipt_data_c,{#c}.payment_receipt_c,{#c}.payment_currency_c,{#c}.payment_tax_charged_c,{#c}.rego_option_type_c,{#c}.payment_total_charged_c,{#c}.payment_date_c,{#c}.cpd_activity_id_c,{#c}.payment_type_c,{#c}.payment_cc_no_c,{#c}.payment_process_date_c",
            'where' => "{#m}.id='{$act_id}'",
            'single' => true
        ));

        /// payment_date_c ///
        $date_time = new DateTime(self::$act['payment_date_c'], new DateTimeZone('UTC'));
        $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
        $date = $date_time->format("l, d M Y - h:i A");
        self::$act['payment_datetime'] = $date;
        //////////////////////

        /// payment_process_date_c ///
        if(empty(self::$act['payment_process_date_c'])){
            self::$act['payment_process_date_c'] = self::$act['payment_date_c'];
        }
        $date_time = new DateTime(self::$act['payment_process_date_c'], new DateTimeZone('UTC'));
        $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
        $date = $date_time->format("l, d M Y - h:i A");
        self::$act['payment_process_datetime'] = $date;
        ///////////////////////////////

        /// payment cc no ///
        $cc_no = self::$act['payment_cc_no_c'];
        if(base64_encode(base64_decode($cc_no)) == $cc_no ){
            $cc_no = base64_decode($cc_no);
            self::$act['payment_cc_no_c'] = $this->helper->get_security_card_number('', $cc_no);
        }
        /////////////////////

        /// receipt ///
        self::$act['receipt_number'] = self::$act['cpd_activity_id_c'];
        if(!empty(self::$act['payment_invoice_override_c'])){
            self::$act['receipt_number'] = self::$act['payment_invoice_override_c'];
        }
        ///////////////
    }

    function process($params = array()){
        $cmd = self::$utility->fetch_router();

        switch($cmd){
            case "create_booking_summary":
                return $this->create_booking_summary($params);
                break;
        }
    }

    function get_contents(){
        $_event = self::$event;

        /// start date ///
        $start_date = $_event['start_date'];
        $start_date = new DateTime($start_date, new DateTimeZone('UTC'));
        $start_date->setTimezone( new DateTimeZone("Australia/Sydney"));
        $_event['start_date'] = array(
                   'y' => $start_date->format("Y"), 'm' => $start_date->format("M"), 'd' => $start_date->format("d"),
                   'date' => $start_date->format("d M Y"),
                   'day' => $start_date->format("l"),
                   'time' => $start_date->format("g:i A"),
                );
        //////////////////

        /// end date ///
        $end_date = $_event['end_date'];
        $end_date = new DateTime($end_date, new DateTimeZone('UTC'));
        $end_date->setTimezone( new DateTimeZone("Australia/Sydney"));
        $_event['end_date'] = array(
                   'date' => $end_date->format("d M Y"),
                   'day' => $end_date->format("l"),
                   'time' => $end_date->format("g:i A"),
                );


        // if($_SERVER['REMOTE_ADDR'] == '103.6.219.2'){
        //         DEProcessing_Dentevents_Details_Premium_Registration::logConsole("invoice",self::$act,true);
        //     }
        /////////////////
        if(self::$act['receipt_data_c'] != null){
            $invoice = self::$act['receipt_data_c'];
            $invoice = json_decode($invoice, true);
            // if($_SERVER['REMOTE_ADDR'] == '103.6.219.2'){
            //     DEProcessing_Dentevents_Details_Premium_Registration::logConsole("invoice",self::$act,true);
            // }

            /// principal registrant ///
            $first_item = reset($invoice['cart_review_datas']);
            $_registrant = $first_item['registrant'];
            ////////////////////////////
        }else{
            $_registrant = "";
        }


        


        /// get summary data////
        self::$router = "receipt:summary_content";
        $data_content = DEProcessing_Dentevents_Details_Premium_Registration::process(array('act_id' => self::$act['id']));
        //////////////

        // if($_SERVER['REMOTE_ADDR'] == '103.6.219.2'){
        //         DEProcessing_Dentevents_Details_Premium_Registration::logConsole("data_content",$data_content,true);
        //     }


        /// booking head summary ///
        $heading = array();
        $heading['delegates'] = count($data_content['cart_review_datas']);
        $heading['receipt_no'] = self::$act['receipt_number'];
        ////////////////////////////


        /// booking summary ///
        $summary = self::$act;
        /// payment type ///
        $summary['card_type'] = strtolower($summary['payment_type_c']);
        ////////////////////

        /// payment date ///
        $date = $summary['date_entered'];
        $date = new DateTime($date, new DateTimeZone('UTC'));
        $date->setTimezone( new DateTimeZone("Australia/Sydney"));
        $summary['payment_date'] = $date->format("d M Y - g:i:s A");
        ////////////////////

        $registrants = array();
        return array(
            'act' => self::$act, 'event' => $_event, 'heading' => $heading, 'registrants' => $registrants, 'summary' => $summary, 'data_content' => $data_content, 'principal_reg' => $_registrant
        );
    }

    function create_booking_summary($params = array()){
        require_once (APPPATH . 'application/helpers/phpdocx/classes/CreateDocx.inc');
        putenv("HOME=/home/dentalcommun/");

        $content = $this->get_contents();



        $organiser_info = $content['data_content']['organiser'];
        $contact_info = $content['data_content']['address'];
        $event_info = $content['event'];
        $act_info = $content['act'];
        $heading_info = $content['heading'];
        $payment_info = $params['payment_result'];
        $registrant_info = $content['registrants'];
        $cart_review_info = $content['data_content']['cart_review_datas'];
        $principal_info = $content['principal_reg'];

    
        // if($_SERVER['REMOTE_ADDR'] == '103.6.219.2'){
        //         DEProcessing_Dentevents_Details_Premium_Registration::logConsole("content",$content,true);
        //         DEProcessing_Dentevents_Details_Premium_Registration::logConsole("principal_info",$principal_info,true);
        //         DEProcessing_Dentevents_Details_Premium_Registration::logConsole("cart_review_info",$cart_review_info,true);
        //         DEProcessing_Dentevents_Details_Premium_Registration::logConsole("contact_info",$contact_info,true);
        //     }
        self::$contact_name = explode(" ", $contact_info['name']);
        if($act_info['status'] == "4PaymentAccepted"){
            $template_crm_url = $this->_crm_config['main']['upload_url'] . "booking_summary_template_paid.docx";
            $template_url = $this->_crm_config['main']['temp_path'] . "booking_summary_template_paid.docx";
            copy($template_crm_url, $template_url);
        }else{
            $template_crm_url = $this->_crm_config['main']['upload_url'] . "booking_summary_template.docx";
            $template_url = $this->_crm_config['main']['temp_path'] . "booking_summary_template.docx";
            copy($template_crm_url, $template_url);

        }

        if($act_info['payment_type_c'] == "free"){
            if($act_info['status'] == '6RegistrationAccepted'){
                $template_crm_url = $this->_crm_config['main']['upload_url'] . "booking_summary_template_free_auto.docx";
                $template_url = $this->_crm_config['main']['temp_path'] . "booking_summary_template_free_auto.docx";
            }else{
                $template_crm_url = $this->_crm_config['main']['upload_url'] . "booking_summary_template_free.docx";
                $template_url = $this->_crm_config['main']['temp_path'] . "booking_summary_template_free.docx";
            }
            copy($template_crm_url, $template_url);
        }
        $docx = new CreateDocxFromTemplate($template_url);
        ///// header part/////////
        $heading_variables = array(
            'event_name' => $event_info['name'],
            'tag_line' => $event_info['event_theme']
        );
        $options = array('target' => 'document');

        $event_location = $event_info['event_city'] . " " . $event_info['event_country'];
        if($act_info['status'] == "4PaymentAccepted"){
            $payment_processed =$act_info['payment_process_datetime'];
        }
        else{
            $payment_processed = "UNPAID - Please Process";
        }

        $start_date = $event_info['start_date']['day'] . ", " . $event_info['start_date']['date'] . " - " . $event_info['start_date']['time'];
        // $start_date = $event_info['start_date'];
        $end_date = $event_info['end_date']['day'] . ", " . $event_info['end_date']['date'] . " - " . $event_info['end_date']['time'];
        // $end_date = $event_info['end_date'];
        $header_variables = array(
            "location_data" => $event_location,
            "Delegate_count" => $heading_info['delegates'],
            "reference_num" => $heading_info['receipt_no'],
            "Start_date_time" => $start_date,
            "End_date_time" => $end_date,
            "Booking_received" => $act_info['payment_datetime'],
            "Payment_processed" => $payment_processed
        );
        ///////////////

        ////// booking detail///
        if(empty($contact_info['email_c'])){
            $contact_info['email_c'] = $principal_info['email_c'];
            // $contact_info['email_c'] = $registrant_info['email_c'];
        }
        $contact_cCity = $contact_info['city'] . " " . $contact_info['state'] . " " . $contact_info['postalcode'];
        $booking_variables = array(
            "ContactName" => $contact_info['name'],
            "EmailAddress" => $contact_info['email_c'],
            "ContactPostalStreet" => $contact_info['street'],
            "ContactPostalCity" => $contact_cCity,
            "ContactPostalCountry" => $contact_info['country'],
            "Telephone" => $contact_info['phone']
        );

        ///////////

        //////// payment details ////////
        $payment_amount = $act_info['payment_currency_c'] . " " . $this->helper->toFixed($payment_info['total'], 2);
        if($act_info['status'] == "4PaymentAccepted"){
            $payment_processed ="PAID";
        }
        else{
            $payment_processed = "UNPAID";
        }

        if($act_info['payment_type_c'] == "account"){
            $card_num_caption = "Account Number:";
            $card_holder_name = "Account Name:";
            $card_number = $payment_info['payment']['account_number'];
            $card_holder = $payment_info['payment']['account_name'];
        }else{
            $card_num_caption = "Card Number:";
            $card_holder_name = "Card Holder Name:";
            $card_number = $payment_info['payment']['cc_number'];
            $card_holder = $payment_info['payment']['cc_holder_name'];
        }
        $payment_variables = array(
            "Amount" => $payment_amount,
            "CardNumber" => $card_number,
            "card_num_caption" => $card_num_caption,
            "CardHolderName" => $card_holder,
            "card_holder_caption" => $card_holder_name,
            "Expiry" => $payment_info['payment']['cc_exp_month'] . " " . $payment_info['payment']['cc_exp_year'],
            "CCV" => $payment_info['payment']['cc_cid'],
            "Status" => $payment_processed
        );
        if($act_info['payment_type_c'] == "paypal"){
            $p_logo = PATH_THEMES . "site_themes/dentevents/skin/images/app/payments/v2/card_paypal.png";
            $docx->replacePlaceholderImage('payment_logo', $p_logo , array('target' => 'document'));
        }else if($act_info['payment_type_c'] == "mastercard"){
            $p_logo = PATH_THEMES . "site_themes/dentevents/skin/images/app/payments/v2/card_mastercard.png";
            $docx->replacePlaceholderImage('payment_logo', $p_logo , array('target' => 'document'));
        }else if($act_info['payment_type_c'] == "amex"){
            $p_logo = PATH_THEMES . "site_themes/dentevents/skin/images/app/payments/v2/card_amex.png";
            $docx->replacePlaceholderImage('payment_logo', $p_logo , array('target' => 'document'));
        }else if($act_info['payment_type_c'] == "account"){
            $p_logo = PATH_THEMES . "site_themes/dentevents/skin/images/app/payments/v2/card_account.png";
            $docx->replacePlaceholderImage('payment_logo', $p_logo , array('target' => 'document'));
        }
        /////////////////////////////////

        ///////registrant summary ///////
        $reg_num = 1;
        $tabledata = array();

        foreach($cart_review_info as $registrant){
            $head_title = $registrant['registrant']['salutation'] . " " . $registrant['registrant']['first_name'] . " " . $registrant['registrant']['last_name'];
            $reg_num++;

            $cpd_option = $registrant['options_review'];
            foreach($cpd_option as $key => $item){
                if($key == 0){
                    $cart_head_variables = array(
                        'cpd_option' => $registrant['registrant']['cpd_id'],
                        'registrants_list' => $head_title,
                        'event_list' => $item['review_name'],
                        'UnitPrice' => $item['base_rate'],
                        'Quantity' => strval($item['qty']),
                        'amount' => $item['total']
                    );
                    $tabledata[] = $cart_head_variables;
                }else{
                    $cart_option_variables = array(
                        'cpd_option' => "",
                        'registrants_list' => "",
                        'event_list' => $item['review_name'],
                        'UnitPrice' => $item['base_rate'],
                        'Quantity' => strval($item['qty']),
                        'amount' => $item['total']
                    );
                    $tabledata[] = $cart_option_variables;
                }


                if(array_key_exists('discount', $item)){
                    $discount_variables = array(
                        'cpd_option' => "",
                        'registrants_list' => "",
                        'event_list' => $item['discount']['label'],
                        'UnitPrice' => "",
                        'Quantity' => "",
                        'amount' => "-" . $item['discount']['total']
                    );
                    $tabledata[] = $discount_variables;
                }
                if(array_key_exists('discount_promo', $item)){
                    $discount_variables = array(
                        'cpd_option' => "",
                        'registrants_list' => "",
                        'event_list' => $item['discount_promo']['label'],
                        'UnitPrice' => "",
                        'Quantity' => "",
                        'amount' => "-" . $item['discount_promo']['total']
                    );
                    $tabledata[] = $discount_variables;
                }
            }

        }
        /////////////////////////////////
        $following_data = array();
        $following_names = array();
        // foreach($registrant_info['followings'] as $item){
        //     $_name = $item['salutation'] . " " . $item['first_name'] . " " . $item['last_name'];
        //     $following_names[] = $_name;
        //     $following_registrant = array("OtherRegistrants" => $_name);
        //     $following_data[] = $following_registrant;
        // }

        $options = array('parseLineBreaks' => true);
        $all_variables = array_merge($heading_variables, $header_variables, $booking_variables, $payment_variables);
        $docx->replaceVariableByText($all_variables, $options);
        $docx->replaceTableVariable($tabledata, array('parseLineBreaks' => true));
        ////// Other Registrants in this booking: //
        if(!empty($following_data)){
            $other_regs = self::$reg_utility->make_ul_items($following_names);
            $docx->replaceVariableByText(array("other_reg_caption" => "Other Registrants in this booking:"), $options);
            $docx->replaceVariableByHTML('OtherRegistrants', 'inline', $other_regs, array('isFile' => false, 'customListStyles' => true));
        }
        else{
            $docx->replaceVariableByText(array("other_reg_caption" => ""), $options);
            $docx->replaceVariableByText(array("OtherRegistrants" => ""), $options);
        }
        ////////////

        if(!empty($event_info['receipt_footer_c'])){
            $_receipt_footer = new WordFragment($docx, 'defaultFooter');
            $event_info['receipt_footer_c'] = '<div style="font-size:9pt!important;text-align:center;">' . $event_info['receipt_footer_c'] .'</div>';
            $_receipt_footer->embedHTML($event_info['receipt_footer_c']);
            $docx->addFooter(array('first' => $_receipt_footer, 'even' => $_receipt_footer, 'default' => $_receipt_footer));
        }

        $docx->createDocx($this->_crm_config['main']['temp_path'] . 'booking_summary');

        $docx_file = $this->_crm_config['main']['temp_path'] . 'booking_summary.docx';
        $pdf_destination_file = $this->_crm_config['main']['temp_path'] . "booking_summary.pdf";

        $_docx = new TransformDocAdvLibreOffice();
        $_docx->transformDocument($docx_file, $pdf_destination_file, NULL);

        return $pdf_destination_file;
    }

    function remove_pdf(){
        $filepath = $this->_crm_config['main']['temp_path'] . "booking_summary.pdf";
        if(file_exists($filepath)){
            unlink($filepath);
        }
    }

}