<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Registration_Wallet extends DEProcessing_Dentevents_Details_Premium_Registration
{
    static $act;

    function initialize($params = array())
    {
        $act_id = $this->EE->input->get_post("principal_act_id");

        self::$act = $this->EE->cpd_activity->get_main_data(array(
            'selects' => "{#m}.id,{#m}.status,{#m}.date_undertaken,{#c}.receipt_data_c,{#c}.payment_receipt_c,{#c}.payment_currency_c,{#c}.payment_tax_charged_c,{#c}.payment_date_c,{#c}.cpd_activity_id_c,{#c}.payment_type_c,{#c}.payment_cc_no_c,{#c}.payment_process_date_c,{#c}.payment_invoice_override_c, {#c}.address_used_c,{#c}.refund_amount_c,{#c}.refund_type_c,{#c}.refund_date_c,{#c}.cpd_attendance_length_c",
            'where' => "{#m}.id='{$act_id}'",
            'single' => true
        ));
    }

    public function getTicketData()
    {
        $_event = self::$event;
        $img_base_url = $this->_crm_config['main']['upload_url'];
        $invoice = self::$act['receipt_data_c'];
        $invoice = json_decode($invoice, true);

        $registrants = array();
        foreach ($invoice['cart_review_datas'] as $item) {
            $registrant = $item['registrant'];
            $registrants[] = array(
                'salutation' => $registrant['salutation'],
                'name' => $registrant['first_name'] . ' ' . $registrant['last_name']
            );
        }

        $organiser = $invoice['organiser'];
        $organiser['logo'] = $img_base_url . $organiser['logo_c'];
        $event = $invoice['event'];
        $event['banner'] = $img_base_url . $_event['event_banner'];
        $event['sys_start_date'] = $_event['start_date'];
        $event['sys_end_date'] = $_event['end_date'];
        $address = $invoice['address'];
        $address['value'] = "{$address['street']}, {$address['city']}, {$address['state']}, {$address['postalcode']}";

        $venue = $this->EE->cpd_events->get_relationship_event_venue(array("id" => $_event['id'], 'selects' => "{#m}.name, {#m}.billing_address_street,{#m}.billing_address_city,{#m}.billing_address_state,{#m}.billing_address_postalcode,{#m}.billing_address_country", 'single' => true));
        //$venue_address= $venue['name'] . ", " . $venue['billing_address_street'] . ", " . $venue['billing_address_city'] . " " . $venue['billing_address_state'] . " " . $venue['billing_address_country'];
        $venue_address= $venue['name'] . ", " . $venue['billing_address_street'] . ", " . $venue['billing_address_city'] . " " . $venue['billing_address_state'] . " " . $venue['billing_address_country'];

        return array(
            'registrants' => $registrants,
            'organiser' => $organiser,
            'event' => $event,
            'address' => $venue_address
        );
    }

    public function getBarcodeMessage(array $data)
    {
        $event_id = self::$event['event_id'];
        $cmd = base64_encode("dentevents:details:premium:registration:wallet:scan");

        $site_url = $this->EE->config->item("site_url");
        $principal_act_id = self::$act['id'];
        $data = json_encode($data);
        $data = base64_encode($data);
        $scanUrl = $site_url . "?ACT=24&cmd={$cmd}&id=$event_id&principal_act_id={$principal_act_id}&data=$data";

        return $scanUrl;
    }

    function process($params = []){
        $cmd = self::$utility->fetch_router();

        switch($cmd){
            case "apple":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/wallet/apple.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Wallet_Apple();
                $processing->initialize($params);
                return $processing->process($params);
            case "scan":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/wallet/scan.php');
                $processing = new DEProcessing_Dentevents_Details_Premium_Registration_Wallet_Scan();
                $processing->initialize($params);
                return $processing->process($params);
        }
    }
}