<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Registration_Wallet_Apple extends DEProcessing_Dentevents_Details_Premium_Registration_Wallet
{
    protected $tempPath = PATH_THIRD . 'libraries/pkpass/tmp';

    function initialize($params = array())
    {

    }

    public function getPKPassByRegistrant($idx, $ticketData, $registrant)
    {
        $receiptId = self::$act['cpd_activity_id_c'];
        $pass = new PKPass(PATH_THIRD . 'libraries/pkpass/certificates.p12', 'F3ZKLHZ85B');

        // Pass content
        $data = [
            'description' => $ticketData['event']['name'],
            'formatVersion' => 1,
            'organizationName' => $ticketData['organiser']['name'],
            'passTypeIdentifier' => 'pass.com.dentevents.ticket',
            'serialNumber' => $receiptId,
            'teamIdentifier' => 'F3ZKLHZ85B', // Change this!
            'eventTicket' => [
                'primaryFields' => [

                ],
                'secondaryFields' => [
                    [
                        'key' => 'event',
                        'label' => 'Event',
                        'value' => $ticketData['event']['name'],
                    ],
                    [
                        'key' => 'attend',
                        'label' => 'REGISTRANT',
                        'value' => $registrant['name'],
                    ],
                ],
                'auxiliaryFields' => [
                    [
                        'key' => 'location',
                        'label' => 'Location',
                        'value' => $ticketData['address'],
                    ]
                ],
                'headerFields' => [
                    [
                        'key' => 'date',
                        'label' => 'Start Date',
                        'value' => $ticketData['event']['start_date'],
                    ]
                ],
                'backFields' => [
                    [
                        'key' => 'passenger-name',
                        'label' => 'Passenger',
                        'value' => $ticketData['registrant']['name'],
                    ],
                ],
            ],
            'barcodes' => [
                [
                    'format' => 'PKBarcodeFormatQR',
                    'message' => "Event-{$receiptId}",
                    'messageEncoding' => 'iso-8859-1',
                ]
            ],
            'backgroundColor' => 'rgb(32,110,247)',
            'relevantDate' => date('Y-m-d\TH:i:sP')
        ];

        $pass->setData($data);

        // Add files to the pass package
        /*$pass->addFile(PATH_THIRD . 'libraries/pkpass/images/icon.png');
        $pass->addFile(PATH_THIRD . 'libraries/pkpass/images/icon@2x.png');
        $pass->addFile(PATH_THIRD . 'libraries/pkpass/images/logo.png');*/
        $pass->addRemoteFile($ticketData['organiser']['logo'], 'icon.png');
        $pass->addRemoteFile($ticketData['organiser']['logo'], 'icon@2x.png');
        $pass->addRemoteFile($ticketData['organiser']['logo'], 'logo.png');
        $pass->addRemoteFile($ticketData['event']['banner'], 'strip.png');

        // Create and output the pass
        //return $pass->create(true);
        $pass->create(true);
        exit;
    }


    function process($params = array()){
        require_once(PATH_THIRD . 'libraries/pkpass/PKPass.php');

        $ticketData = $this->getTicketData();
        $registrants = $ticketData['registrants'];
        /*$registrants[] = [
            'name' => 'Test Test'
        ];*/

        $zip = new ZipArchive();
        $filename = tempnam($this->tempPath, 'pkpass');
        if (!$zip->open($filename, ZipArchive::CREATE)) {
            throw new \Exception('Could not open ' . basename($filename) . ' with ZipArchive extension.');
        }


        $idx = 1;
        foreach ($registrants as $registrant) {
            $pkPass = $this->getPKPassByRegistrant($idx, $ticketData, $registrant);
            $zip->addFromString($idx . ".pkpass", $pkPass);
            $idx++;
        }

        $zip->close();

        if (!file_exists($filename) || filesize($filename) < 1) {
            @unlink($filename);
            throw new \Exception('Error while creating pass.pkpass. Check your ZIP extension.');
        }

$filename= $this->tempPath . '/pass1.pkpass';
        $zip = file_get_contents($filename);
  //      unlink($filename);

        // Output pass
        header('Content-Description: File Transfer');
        header('Content-Type: application/vnd.apple.pkpass');
        header('Content-Disposition: attachment; filename="passes.pkpasses"');
        header('Content-Transfer-Encoding: binary');
        header('Connection: Keep-Alive');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s T'));
        header('Pragma: public');
        echo $zip;
        exit;
    }
}