<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Registration_Wallet_Scan extends DEProcessing_Dentevents_Details_Premium_Registration_Wallet
{

    function initialize($params = array())
    {

    }

    function process($params = []){
        $data = $this->EE->input->get_post("data");
        $data = base64_decode($data);
        $data = json_decode($data, true);

        $registrant  = $data['registrant'];
        $registrantName = $registrant['salutation'] . ' ' . $registrant['name'];

        $ticketData = $this->getTicketData();

        $result = 'failed';
        if (self::$act['cpd_attendance_length_c'] == "Scanned") {
            $result = 'scanned';
        } else if (in_array(self::$act['status'], ['4PaymentAccepted', '6RegistrationAccepted'])) {
            $now = time();
            $timeRegoOpen = self::$event['rego_opens_date_c'] != null ? self::$event['rego_opens_date_c'] : '';
            $timeRegoOpen = strtotime($timeRegoOpen) * 1;
            if ($timeRegoOpen < $now) {
                $actData = [
                    'id' => self::$act['id'],
                    'cpd_attendance_length_c' => 'Scanned'
                ];
                $success = $this->EE->cpd_activity->set_record($actData);
                if(!$success){
                    $this->logger->developer("Failed to update the cpd activity for Scan result" . get_class($this));
                    return false;
                }
                $result = 'passed';
            }
        }

        $datas = [
            'registrant' => $registrantName,
            'event_name' => $ticketData['event']['name'],
            'event_start_date' => $ticketData['event']['start_date'],
            'logo' => $ticketData['organiser']['logo'],
            'banner' => $ticketData['event']['banner'],
            'result' => $result
        ];
        $swaps = array(
            'dt' => 'dt'
        );
        $datas = array(
            'dt' => $datas
        );

        $this->EE->TMPL->run_template_engine("dentevents", "ticket_scan_result");
        $this->EE->output->app_output($swaps, $datas, array('env' => true));
    }
}