<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Premium_Speakers extends DEProcessing_Dentevents_Details_Premium{

    function initialize($params = array()){
        
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "fetch_data":
                return $this->fetch_data();
            break;
        }

    }
    
    function fetch_data($params = array()){
        $_event = self::$event;
        $speakers = self::$speakers;
        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        
        $temp = array();
        foreach($speakers as $item){
            $temp[$item['id']] = $item;
        }
        $speakers = $temp;
        
        $last_names = array();
        foreach($speakers as $key => $item){
            $last_names[$key] = $item['last_name'];
        }
        //array_multisort($last_names, SORT_ASC, $speakers);
        
        foreach($speakers as $key => $item){
            if($item['salutation'] == 'AProf'){
                $item['salutation'] = "A/Prof";
            }
            if(!empty($item['prefname_c'])){
                $speakers[$key]['name'] = $item['salutation'] . " " . $item['prefname_c'] . " " . $item['last_name'];
            }else{
                if(!empty($item['initial_c'])){
                    $speakers[$key]['name'] = $item['salutation'] . " " . $item['first_name'] . " " . $item['initial_c'] . " " . $item['last_name'];
                }else{
                    $speakers[$key]['name'] = $item['salutation'] . " " . $item['first_name'] . " " . $item['last_name'];
                }
            }
            /// pract type ///
            $pract_type = $item['pract_type_c'];
            $pract_type = trim($pract_type, "^");
            $pract_type = explode("^,^", $pract_type);
            if(count($pract_type) > 1){
                $last_pract = array_pop($pract_type);
                $pract_type = implode(", ", $pract_type) . " and " . $last_pract;
            }else{
                $pract_type = implode(", ", $pract_type);
            }
            $speakers[$key]['pract_type'] = $pract_type;
            //////////////////
            
            /// bio_pro_c ///
            $bio = $item['bio_pro_c'];
            $bio = $this->helper->getLimitText($bio, 200);
            $speakers[$key]['bio_pro'] = $bio;
            /////////////////
            
            /// photo ///
            if(!empty($item['photo_prof_url_c'])){
                $speakers[$key]['photo'] = $item['photo_prof_url_c'];
            }
            /////////////
            
            $speakers[$key]['action'] = $this->seo_helper->get_seo_url(Seo_Helper::SPEAKER_PROFILE, array('id' => $item['contact_id_nr_c'], 'name' => $speakers[$key]['name'],'event' => $_event['id']));
        }
        
        return $speakers;
    }
}