<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Details_Standard extends DEProcessing_Dentevents_Details{

    function initialize($params = array()){

    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "show":
                return $this->show();
            break;
        }

    }
    
    function show($params = array()){
        $_event = self::$event;
        
        /// logging events ///
        self::$router = "logger:record_click";
        DEProcessing_Dentevents_Details::process();
        //////////////////////
        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        $datas = array();
        
        $now_date = date("Y-m-d");
        /// event ///
            /// start date ///
            $date_time = new DateTime($_event['start_date'], new DateTimeZone('UTC'));
            $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
            $date = $date_time->format("l, j F, Y");
            $time = $date_time->format("g:i A");
            $calender_time =$date_time->format("m/d/Y H:i");
            $_event['start'] = array('date' => $date, 'time' => $time,'calender_time' =>$calender_time);
            //////////////////
            /// end date ///
            $date_time = new DateTime($_event['end_date'], new DateTimeZone('UTC'));
            $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
            $date = $date_time->format("l, j F, Y");
            $time = $date_time->format("g:i A");
            $calender_time =$date_time->format("m/d/Y H:i");
            $_event['end'] = array('date' => $date, 'time' => $time,'calender_time' =>$calender_time);
            ////////////////
            
            /// check concluded ///
            if($now_date > $_event['end_date']){
                $_event['concluded'] = "yes";
                $_event['registration_url'] = '';
            }
            ///////////////////////
            
            /// event options ///
            $event_options_list = $this->helper->get_dropdowns_sugar("event_options_list");
            $event_options = $_event['event_options_c'];
            $event_options = trim($event_options, "^");
            $event_options = explode("^,^", $event_options);

            foreach($event_options as $key => $_option){
                $event_options[$key] = $event_options_list[$_option];
            }
            $_event['event_options'] = implode(", ", $event_options);
            /////////////////////
            /// registration ///
            $_event['registration_url'] = $this->helper->getStrippedUrl($_event['registration_url']);
            /// email link ///
            $_event['email_link'] = $this->seo_helper->get_seo_url(Seo_Helper::EVENT_DETAILS_EMAIL, array('id' => $_event['event_id_c']));
            ////////////////////
            
            /// event url ///
            $_event['event_url'] = $this->helper->getStrippedUrl($_event['event_url']);
            /////////////////
        /////////////
        
        /// speakers ///
        $params = array();
        $params['id'] = $_event['id'];
        $params['selects'] = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.initial_c,{#c}.prefname_c,{#c}.quals_c,{#c}.bio_pro_c,{#c}.photo_prof_url_c,{#c}.contact_id_nr_c,{#c}.pract_type_c";
        $params['orders'] = "{#r}.sort_order  asc,{#r}.date_modified asc";
        
        $speakers = $this->EE->cpd_events->get_relationship_speakers($params);

        foreach($speakers as $key => $item){
            if($item['salutation'] == 'AProf'){
               $item['salutation'] = "A/Prof.";     
            }    
            if(!empty($item['prefname_c'])){
                $speakers[$key]['name'] = $item['salutation'] . " " . $item['prefname_c'] . " " . $item['last_name'];
            }else{
                if(!empty($item['initial_c'])){
                    $speakers[$key]['name'] = $item['salutation'] . " " . $item['first_name'] . " " . $item['initial_c'] . " " . $item['last_name'];
                }else{
                    $speakers[$key]['name'] = $item['salutation'] . " " . $item['first_name'] . " " . $item['last_name'];
                }
            }
            /// pract type ///
            $pract_type = $item['pract_type_c'];
            $pract_type = trim($pract_type, "^");
            $pract_type = explode("^,^", $pract_type);
            if(count($pract_type) > 1){
                $last_pract = array_pop($pract_type);
                $pract_type = implode(", ", $pract_type) . " and " . $last_pract;
            }else{
                $pract_type = implode(", ", $pract_type);
            }
            $speakers[$key]['pract_type'] = $pract_type;
            //////////////////
            
            /// bio_pro_c ///
            $bio = $item['bio_pro_c'];
            $bio = $this->helper->getLimitText($bio, 200);
            $speakers[$key]['bio_pro'] = $bio;
            /////////////////
            
            /// photo ///
            if(!empty($item['photo_prof_url_c'])){
                $speakers[$key]['photo'] = $item['photo_prof_url_c'];
            }
            /////////////
            
            $speakers[$key]['action'] = $this->seo_helper->get_seo_url(Seo_Helper::SPEAKER_PROFILE, array('id' => $item['contact_id_nr_c'], 'name' => $speakers[$key]['name'],'event' => $_event['id']));
        }
        $datas['speakers'] = $speakers;
        ////////////////
        
        if($_event['listing_type'] == 'Express'){
            /// upcoming events ///
            self::$router = "events:home:fetch_data";
            $events = DEProcessing_Dentevents::process(array('limit' => 5, 'disable_pagination' => true));
            $datas['upcoming_events'] = $events;
            //////////////////////
            $params = array();
            $params['id'] = $_event['id'];
            $params['rel_module_name'] = 'postcodes';
            $params["selects"] = '{#m}.id,{#m}.country,{#c}.time_zone_utc_c,{#c}.time_zone_abbr_c,{#c}.time_zone_name_c';
            $params["single"] = true; 
            $temp = $this->EE->cpd_events->get_relationship($params);
            $timezone_formats = $temp['country'].' - '.$temp['time_zone_name_c'].' - (UTC '.$temp['time_zone_utc_c'].')';
            $timezone_abbr = $temp['time_zone_abbr_c'];
            $_event['timezone_formats'] = $timezone_formats;
            $_event['timezone_abbr'] = $timezone_abbr;
            
                
        }else{
            /// event venue ///
            $params = array();
            $params['id'] = $_event['id'];
            $params['selects'] = "{#m}.billing_address_street,{#m}.billing_address_city,{#m}.billing_address_state,{#m}.billing_address_postalcode,{#m}.billing_address_country,{#m}.phone_office,{#m}.website,
                                  {#c}.free_phone_c,{#c}.billing_name_c,{#c}.billing_address_region_nz_c,{#c}.lat_c,{#c}.longitude_c,{#c}.intl_phone_c,{#c}.account_id_nr_c 
                                 ";
            $params['single'] = true;
            $_venue = $this->EE->cpd_events->get_relationship_event_venue($params);
            
            $_venue['billing_name'] = $_venue['billing_name_c'];
            $_venue['latitude'] = $_venue['lat_c'];
            $_venue['longitude'] = $_venue['longitude_c'];
            $_venue['free_phone'] = $_venue['free_phone_c'];
                /// street ///
                $_venue['billing_address_street'] = nl2br($_venue['billing_address_street']);
                //////////////
                
                /// check show country ///
                $country = $this->helper->getRemoteCountry(true);
                $show = "yes";
                if($country != null && strtolower($country->country_name) == strtolower($_venue['billing_address_country'])){
                    $show = "no";
                }
                $_venue['show_country'] = $show;
                //////////////////////////
                
                /// phone office ///
                if($show == "yes" && !empty($_venue['intl_phone_c'])){
                    $_venue['phone_office'] = $_venue['intl_phone_c'];
                }
                ////////////////////
                
                /// new zealand region ///
                if(strtolower($_venue['billing_address_country']) == 'new zealand' && !empty($_venue['billing_address_region_nz_c'])){
                    $_venue['region_nz'] = $_venue['billing_address_region_nz_c'];
                }
                //////////////////////////
                
                /// website ///
                $_venue['website'] = $this->helper->getStrippedUrl($_venue['website']);
                ///////////////
                $_venue['action'] = $this->seo_helper->get_seo_url(Seo_Helper::ACCOUNT_VENUE_DETAIL, array('id' => $_venue['account_id_nr_c'], 'country' => $_venue['billing_address_country'], 'name' => $_venue['billing_name']));
                
            $datas['venue'] = $_venue;    
            ///////////////////
            
            /// event organiser ///
            $params = array();
            $params['id'] = $_event['id'];
            $params['selects'] = "{#m}.billing_address_street,{#m}.billing_address_city,{#m}.billing_address_state,{#m}.billing_address_postalcode,{#m}.billing_address_country,{#m}.phone_office,{#m}.website,
                                  {#c}.free_phone_c,{#c}.billing_name_c,{#c}.billing_address_region_nz_c,{#c}.lat_c,{#c}.longitude_c,{#c}.intl_phone_c,{#c}.account_id_nr_c 
                                 ";
            $params['single'] = true;
            $_organiser = $this->EE->cpd_events->get_relationship_event_organiser($params);
            
            $_organiser['billing_name'] = $_organiser['billing_name_c'];
            $_organiser['latitude'] = $_organiser['lat_c'];
            $_organiser['longitude'] = $_organiser['longitude_c'];
            $_organiser['free_phone'] = $_organiser['free_phone_c'];
                /// street ///
                $_organiser['billing_address_street'] = nl2br($_organiser['billing_address_street']);
                //////////////
                
                /// check show country ///
                $country = $this->helper->getRemoteCountry(true);
                $show = "yes";
                if($country != null && strtolower($country->country_name) == strtolower($_organiser['billing_address_country'])){
                    $show = "no";
                }
                $_organiser['show_country'] = $show;
                //////////////////////////
                
                /// phone office ///
                if($show == "yes" && !empty($_organiser['intl_phone_c'])){
                    $_organiser['phone_office'] = $_organiser['intl_phone_c'];
                }
                ////////////////////
                
                /// new zealand region ///
                if(strtolower($_organiser['billing_address_country']) == 'new zealand' && !empty($_organiser['billing_address_region_nz_c'])){
                    $_organiser['region_nz'] = $_organiser['billing_address_region_nz_c'];
                }
                //////////////////////////
                
                /// website ///
                $_organiser['website'] = $this->helper->getStrippedUrl($_organiser['website']);
                ///////////////
                $_organiser['action'] = $this->seo_helper->get_seo_url(Seo_Helper::ACCOUNT_ORG_DETAIL, array('id' => $_organiser['account_id_nr_c'], 'country' => $_organiser['billing_address_country'], 'name' => $_organiser['billing_name']));
            $datas['org'] = $_organiser;    
            //////////////////////
            
            /// related events ///
            self::$router = "events:search:related_events:fetch_data";
            $events = DEProcessing_Dentevents::process(array('event_id' => $_event['id'], 'disable_pagination' => true));
            $datas['related_events'] = $events;
            //////////////////////    
        }
        if(($_event['event_format'] == 'Webinar' || $_event['event_format'] == 'OnlineLearning') && $_event['dentevents_tv_content_status_c'] == 'LIVE')
                $_event['timezone_view'] = 'Yes';
        
        $datas['event'] = $_event;
        
        /// get total read ///
        $params = array();
        $params['selects'] = "sum({#m}.schclick) as total";
        $params['where'] = "{#m}.keytype='Event' and {#m}.keyvalue='{$_event['event_id_c']}'";
        $params['single'] = true;
        $_hit_total = $this->EE->general_hits->get_main_data($params);
        $datas['total_read'] = $_hit_total['total'];
        //////////////////////
        
        /// get popular total ///
        $params = array();
        $params['id'] = $_event['id'];
        $params['selects'] = "count(*) as total";
        $params['single'] = true;
        $_popular_total = $this->EE->cpd_events->get_relationship_interested_contacts($params);
        $datas['total_popular'] = $_popular_total['total'];
        ///////////////////
        
        /// cpd points ///
        $datas['cpd_points'] = array_sum(array($_event['cpd_points_type_1'], $_event['cpd_points_type_2'], $_event['cpd_points_type_3']));
        //////////////////
        
        /// topics and audience ///
        $audience = $_event['audience'];  
        $audience = trim($audience, "^");
        if($audience != ''){
            $audience = explode("^,^", $audience);
        }
        $datas['audience_list'] = $this->helper->get_dropdowns_sugar_labels("pract_type_list", $_event['audience']);
        foreach($datas['audience_list'] as $key => $item){
            if($item == 'Dental Industry Personnel'){
                continue;
            }
            if(strpos($item, 'Specialist') !== false){
                $item = str_replace("Specialist", "Specialists", $item);
                $datas['audience_list'][$key] = $item;
                continue;
            }
            $datas['audience_list'][$key] = $item . "s";
        }
        ///////////////////////////
        $params = array();
        $params['id'] = $_event['id'];
        $params['rel_module_name'] = 'postcodes';
        $params["selects"] = '{#m}.id';
        $temp = $this->EE->cpd_events->get_relationship($params);

        $post_id = $temp[0]['id'];

        $this->EE->load->model("postcodes");
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.country,{#c}.time_zone_utc_c,{#c}.time_zone_abbr_c,{#c}.time_zone_name_c,{#c}.time_zone_google_name_c";
        $params['where'] = "{#m}.id = '{$post_id}'";
        $params['orders'] = "{#m}.country asc";
        $params['single'] = true;

        $_result = $this->EE->postcodes->get_main_data($params);

        $time_zone_string =  $_result['time_zone_abbr_c'].' - '.$_result['time_zone_name_c'].' (UTC'.$_result['time_zone_utc_c'].')';
        // var_dump($time_zone_string);var_dump($_result);

        $datas['postcodes_str'] = $time_zone_string;
        $datas['timezone'] =  $_result['time_zone_abbr_c'];
        $datas['r_zone'] = '(UTC'.$_result['time_zone_utc_c'].')';
         $datas['calendar_zone'] = str_replace("\/", "/", $temp['time_zone_google_name_c']);
        /// linked topics ///
        $params = array();
        $params['id'] = $_event['id'];
        $params['selects'] = "{#m}.id,{#m}.name";
        $datas['topic_list'] = $this->EE->cpd_events->get_relationship_topics($params);
        /////////////////////
        
        /// META tags ///
        $GLOBALS['meta']['name'] = $_event['name'];
        $GLOBALS['meta']['country'] = $_event['event_country'];
        $GLOBALS['meta']['event_id'] = $_event['event_id_c'];
        /////////////////
        
        $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
        $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt'
                );
        $datas = array(
                    'AID' => $action_id,
                    'dt' => $datas
                );
        
        if($_event['listing_type'] == 'Express'){
            $this->EE->TMPL->run_template_engine("dentevents", "details_express");
        }else{
            $this->EE->TMPL->run_template_engine("dentevents", "details");    
        }       
        
        $this->EE->output->app_output($swaps, $datas);
    }
}