<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Download extends DEProcessing_Dentevents{
    function initialize($params = array()){
        $this->EE->load->model("document_revisions");
        $this->EE->load->model("documents");
    }
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "document":
                return $this->document($params);
            break;
        }
    }
    
    function document($params = array()){
        $file_id = $this->EE->input->get_post("file_id");
        $document_id = $this->EE->input->get_post("document_id");

        $crm_file_basepath = $this->_crm_config['main']['upload_url'];
        
        /// fetch document revision data ///
        $params = array();
        $params['selects'] = "{#m}.filename";
        $params['where'] = "{#m}.id='$file_id'";
        $params['single'] = true;

        $revision = $this->EE->document_revisions->get_main_data($params);
        /////////////////////////////////////

        /////// saving dentevents_download_c /////
        $document = $this->EE->documents->get_main_data(array(
           'selects' => "{#m}.id,{#c}.dentevents_downloads_c",
            'where' => "{#m}.id='$document_id'",
            'single' => true
        ));
        $params = array();
        $params['id'] = $document_id;
        $params['dentevents_downloads_c'] = $document['dentevents_downloads_c'] + 1;
        $success = $this->EE->documents->set_record($params);
        if(!$success){
            $this->logger->developer("Failed to save document dentevents download.");
            return false;
        }
        /// /////////
        /// set header for download ///
        $filename = str_replace(" ", "_", $revision['filename']);
        $file = $crm_file_basepath . rawurlencode($revision['filename']);
        $_file = $this->_crm_config['main']['temp_path'] . $file_id;

        copy($file, $_file);
        
        if(file_exists($_file)){
              header('Content-Description: File Transfer');
              header('Content-Type: application/octet-stream');
              header('Content-Disposition: attachment; filename='.$filename);
              header('Content-Transfer-Encoding: binary');
              header('Expires: 0');
              header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
              header('Pragma: public');
              header('Content-Length: ' . filesize($_file));
              ob_clean();
              flush();
              readfile($_file);
              exit;
        }
        ///////////////////////////////
    }
}