<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Events extends DEProcessing_Dentevents{
    static $events;
    static $selects_events;
    protected $current_page;
    
    function initialize($params = array()){
        $this->EE->load->model("cpd_events");
        self::$selects_events = "{#m}.id,{#m}.start_date,{#m}.end_date,{#m}.name,{#m}.event_theme,{#m}.description,{#m}.event_city,{#m}.event_country,{#m}.listing_type,{#m}.event_banner,{#m}.event_rego_online,{#m}.event_url,{#m}.registration_url,{#m}.event_format,{#c}.event_options_c,{#c}.event_id_c,{#c}.event_banner_url_c,{#c}.cpd_points_total_c,{#m}.cpd_points_type_1,{#m}.cpd_points_type_2";

    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "fetch_data":
                return $this->fetch_data($params);
            break;
            case "show":
                return $this->show($params);
            break;
            case "home":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/events/home.php');
                $processing = new DEProcessing_Dentevents_Events_Home();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "search":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/events/search.php');
                $processing = new DEProcessing_Dentevents_Events_Search();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "pagination":
                 return $this->_prepare_pagination();
            break;
            case "show_e_listing":
                return $this->show_express_listing($params);
            break;
            case "set_e_listing":
                return $this->set_express_listing($params);
            break;
            case "edit_express":
                return $this->edit_express($params);
            break;
        }

    }
    function nl2p($string) {
        return $string_with_paragraphs = "<p>".implode("</p>\n<p>", explode("\n", $string))."</p>";
    }
    function p2nl($string) {
        $string = str_replace("<p>", "", $string);
        $string = str_replace("</p>", "", $string);
        return $string;
    }
    function edit_express($params=''){
        $data = array();
        $params = array();

        $id =  $this->EE->input->get_post("event_id");
        $data['id'] = $id;
        $params['selects'] ="{#m}.id,{#m}.start_date,{#m}.end_date,{#m}.name,{#m}.event_status,{#m}.event_email,{#m}.event_theme,{#m}.description,{#m}.event_city,{#m}.event_country,{#m}.listing_type,{#m}.event_region,{#m}.event_rego_online,{#m}.event_url,{#m}.registration_url,{#m}.event_format,{#m}.cpd_points_type_1,{#m}.cpd_points_type_2,{#c}.event_options_c,{#c}.event_id_c,{#c}.express_add_organiser_c,{#c}.express_add_name_c,{#c}.express_add_phone_c,{#c}.express_add_email_c";
        $params['where'] = "{#m}.listing_type='Express' and {#m}.id='{$id}'";
        $params['single'] = true;
        $cur_event = $this->EE->cpd_events->get_main_data($params);
        
        $event_format = $cur_event['event_format'];
        $data['event_format_opts'] = $this->helper->make_select_opts('Event_Format_list', $event_format);
        $prepend = array('00','01','02','03','04','05','06','07','08','09');
        $hours = range(1, 12); 
        $hours = array_combine($hours, $hours);
        $minutes = array_merge($prepend, range(10, 59)); 
        $minutes = array_combine($minutes, $minutes);

        $start_date = $cur_event['start_date'];
        
        $start_date = new DateTime($start_date, new DateTimeZone('UTC'));
        $start_date->setTimezone( new DateTimeZone("Australia/Sydney"));
        $data['start_date'] = array(
                   'h_opts' => $this->helper->make_select_opts($hours, $start_date->format("g")), 
                   'm_opts' => $this->helper->make_select_opts($minutes, $start_date->format("i")), 
                   'a_opts' => $this->helper->make_select_opts(array('AM'=>'AM','PM'=>'PM'), $start_date->format("A")),
                   'date' => $start_date->format("d/m/Y"),
                );
        /// end date ///
        $end_date = $cur_event['end_date'];
        $end_date = new DateTime($end_date, new DateTimeZone('UTC'));
        $end_date->setTimezone( new DateTimeZone("Australia/Sydney"));
        $data['end_date'] = array(
                   'h_opts' => $this->helper->make_select_opts($hours, $end_date->format("g")), 
                   'm_opts' => $this->helper->make_select_opts($minutes, $end_date->format("i")), 
                   'a_opts' => $this->helper->make_select_opts(array('AM'=>'AM','PM'=>'PM'), $end_date->format("A")),
                   'date' => $end_date->format("d/m/Y"),
                );
        /// event country ///
        $data['event_country_opts'] = $this->helper->make_select_opts('countries_dom', $cur_event['event_country']);
        /////////////////////
        
        /// event region ///
        $data['event_region_opts'] = $this->helper->make_select_opts('event_region_list', $cur_event['event_region']);
        $data['name'] = $cur_event['name'];
        $data['description'] = $this->p2nl($cur_event['description']);
        $data['event_url'] = $cur_event['event_url'];
        $data['event_email'] = $cur_event['event_email'];
        $data['event_city'] = $cur_event['event_city'];
        $data['organiser'] = $cur_event['express_add_organiser_c'];
        $data['your_name'] = $cur_event['express_add_name_c'];
        $data['contact_number'] = $cur_event['express_add_phone_c'];
        $data['your_email'] = $cur_event['express_add_email_c'];
        $cpd_type = array('scientific' => 'Scientific', 'nonscientific' => 'Non-Scientific');
        if($cur_event['cpd_points_type_1'] != 0){
            $data['cpd_hours'] = $cur_event['cpd_points_type_1'];
            $data['cpd_type'] = $this->helper->make_select_opts($cpd_type, 'scientific');
        }elseif($cur_event['cpd_points_type_2'] != 0){
            $data['cpd_hours'] = $cur_event['cpd_points_type_2'];
            $data['cpd_type'] = $this->helper->make_select_opts($cpd_type, 'nonscientific');
        }else{
            $data['cpd_hours'] = 0;
            $data['cpd_type'] = $this->helper->make_select_opts($cpd_type, 'scientific');
        }
        
        $status_labels = array('Incomplete_Offline' => 'Incomplete Offline', 'Approved_Online' => 'Approved Online', 'Approved_Online_Private' => 'Approved Online Private', 'Hold_Offline' => 'Hold Offline', 'Awaiting_Approval_Offline' => 'Awaiting Approval', 'Completed_Offline' => 'Completed Offline');
        $status_classes = array('Incomplete_Offline' => 'bstatus-p', 'Approved_Online' => 'bstatus-g', 'Approved_Online_Private' => 'bstatus-g', 'Hold_Offline' => 'bstatus-h', 'Awaiting_Approval_Offline' => 'bstatus-p', 'Completed_Offline' => 'bstatus-b');
        $data['event_status'] = $status_labels[$cur_event['event_status']];
        $data['status_cls'] = $status_classes[$cur_event['event_status']];

        $this->EE->load->model("postcodes");
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.country,{#c}.time_zone_utc_c,{#c}.time_zone_abbr_c,{#c}.time_zone_name_c";
        $params['where'] = "{#c}.time_zone_record_c = 1";
        $params['orders'] = "{#m}.country asc";

        $_result = $this->EE->postcodes->get_main_data($params);
        $params = array();
        $params['id'] = $id;
        $params['rel_module_name'] = 'postcodes';
        $params["selects"] = '{#m}.id';
        $temp = $this->EE->cpd_events->get_relationship($params);
        
        $timezone_formats = array();
        $default;
        foreach ($_result as $key => $value) {
            if($value['time_zone_abbr_c'] == "AEST")
                $default = $value['id'];
            $timezone_formats[$value['id']] = $value['country'].' - '.$value['time_zone_name_c'].' - '.$value['time_zone_abbr_c'].' - '.$value['time_zone_utc_c'];
        }
        $data['event_timezone'] = $this->helper->make_select_opts($timezone_formats, $temp[0]['id']);

        
        $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
        
        $swaps = array(
                    'AID' => 'AID',
                    'org_id' => 'org_id',
                    'dt' => 'dt'
                 );
        $datas = array(
                    'AID' => $action_id,
                    'org_id' => $org_id,
                    'dt' => $data
                 );
       
        $this->EE->TMPL->run_template_engine('pages', 'edit_express');    
        $this->EE->output->app_output($swaps, $datas);
    }
    function increase_str($s){
        $num = (int)substr($s, 1);
        $num++;
        return $s[0] . $num;
    }

    function show_express_listing($params=''){
        
        $data = array();
        $data['event_format_opts'] = $this->helper->make_select_opts('Event_Format_list', 'Seminar');
        $prepend = array('00','01','02','03','04','05','06','07','08','09');
        $hours = range(1, 12); 
        $hours = array_combine($hours, $hours);
        $minutes = array_merge($prepend, range(10, 59)); 
        $minutes = array_combine($minutes, $minutes);
        /// start date ///
        $start_date = date("Y-m-d");
        $start_date = new DateTime($start_date, new DateTimeZone('UTC'));
        $start_date->setTimezone( new DateTimeZone("Australia/Sydney"));
        $data['start_date'] = array(
                   'h_opts' => $this->helper->make_select_opts($hours, 9), 
                   'm_opts' => $this->helper->make_select_opts($minutes, '00'), 
                   'a_opts' => $this->helper->make_select_opts(array('AM'=>'AM','PM'=>'PM'), 'AM'),
                   'date' => $start_date->format("d/m/Y"),
                );
        /// end date ///
        $end_date = date("Y-m-d");
        $end_date = new DateTime($end_date, new DateTimeZone('UTC'));
        $end_date->setTimezone( new DateTimeZone("Australia/Sydney"));
        $data['end_date'] = array(
                   'h_opts' => $this->helper->make_select_opts($hours, 5), 
                   'm_opts' => $this->helper->make_select_opts($minutes, '00'), 
                   'a_opts' => $this->helper->make_select_opts(array('AM'=>'AM','PM'=>'PM'), 'PM'),
                   'date' => $end_date->format("d/m/Y"),
                );
        /// event country ///
        $data['event_country_opts'] = $this->helper->make_select_opts('countries_dom', 'AUSTRALIA');
        /////////////////////
        
        /// event region ///
        $data['event_region_opts'] = $this->helper->make_select_opts('event_region_list', 'Australia_and_Oceania');
        $this->EE->load->model("postcodes");
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.country,{#c}.time_zone_utc_c,{#c}.time_zone_abbr_c,{#c}.time_zone_name_c";
        $params['where'] = "{#c}.time_zone_record_c = 1";
        $params['orders'] = "{#m}.country asc";

        $_result = $this->EE->postcodes->get_main_data($params);

        

        $timezone_formats = array();
        $default;
        foreach ($_result as $key => $value) {
            if($value['time_zone_abbr_c'] == "AEST")
                $default = $value['id'];
            $timezone_formats[$value['id']] = $value['country'].' - '.$value['time_zone_name_c'].' - '.$value['time_zone_abbr_c'].' - '.$value['time_zone_utc_c'];
        }
        $data['event_timezone'] = $this->helper->make_select_opts($timezone_formats, $default);
        $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
        
        $swaps = array(
                    'AID' => 'AID',
                    'org_id' => 'org_id',
                    'dt' => 'dt'
                 );
        $datas = array(
                    'AID' => $action_id,
                    'org_id' => $org_id,
                    'dt' => $data
                 );
       
        $this->EE->TMPL->run_template_engine('pages', 'add_event');    
        $this->EE->output->app_output($swaps, $datas);

        
    }
    function set_express_listing($params=''){

        $data = array();
        $event_name = $this->EE->input->get_post("event_name");
        $data['name'] = $event_name;
        $event_format = $this->EE->input->get_post("event_format");
        $event_id = $this->EE->input->get_post("id");
        $timezone = $this->EE->input->get_post("event_postcode");
        if(!empty($event_id)){
            $data['id'] = $event_id;
        }
        $data['event_format'] = $event_format;
        if($event_format == 'Webinar' || $event_format == 'OnlineLearning'){
            $data['dentevents_tv_content_status_c'] = 'LIVE';
            $data['dentevents_tv_c'] = 'Yes';
               
        }    
        $data['event_country'] = $this->EE->input->get_post("event_country");    
        $data['event_region'] = $this->EE->input->get_post("event_region");    
        $data['event_city'] = $this->EE->input->get_post("major_city"); 
        $data['listing_type'] = "Express";
        $data['event_status'] = "Awaiting_Approval_Offline";
        $data['event_url'] = $this->EE->input->get_post("event_url");
        
        $descritpion = $this->nl2p($this->EE->input->get_post("description"));
        $event_org = $this->EE->input->get_post("event_organiser");
        $user_name = $this->EE->input->get_post("ps_name");
        $contact_number = $this->EE->input->get_post("contact_number");
        $email = $this->EE->input->get_post("email_address");
        $data['express_add_organiser_c'] = $event_org;
        $data['express_add_name_c'] = $user_name;
        $data['express_add_phone_c'] = $contact_number;
        $data['express_add_email_c'] = $email;
        $data['description'] = $descritpion;
        $data['event_email'] = $this->EE->input->get_post("event_email");
        $cpd_type = $this->EE->input->get_post("cpd_type");
        $cpd_hour = $this->EE->input->get_post("cpd_hour");

        if($cpd_type == "scientific"){
            $data['cpd_points_type_1'] = $cpd_hour;
            $data['cpd_points_type_2'] = 0;
        }else{
            $data['cpd_points_type_2'] = $cpd_hour;
            $data['cpd_points_type_1'] = 0;
        }
        // $data['description'] = $descritpion.$event_org.'\r\n'.$user_name.'\r\n'.$contact_number.'\r\n'.$email;
        






        
         /// start date ///
        $date = $this->EE->input->get_post("tdetails_start_date");
        $h = $this->EE->input->get_post("tdetails_start_date_h");
        $m = $this->EE->input->get_post("tdetails_start_date_m");
        $a = $this->EE->input->get_post("tdetails_start_date_a");
        if($h !== false){
             if($date == ''){
                 $date = new DateTime($_event['start_date'], new DateTimeZone("UTC"));
                 $date->setTimezone( new DateTimeZone("Australia/Sydney"));
                 $date = $date->format("d/m/Y");
             }
             $date = DateTime::createFromFormat("d/m/Y g:i A", "{$date} {$h}:{$m}:{$a}", new DateTimeZone("Australia/Sydney"));
             $date->setTimeZone(new DateTimeZone('UTC'));

             // $reminder_date_1 = $reminder_date_2 = $reminder_date_1 = $date;
             
             // $reminder_date_1 = date('Y/m/d',strtotime('+1 week',$startdate));
             

             $data['start_date'] = $date->format("Y-m-d H:i:00");

             $reminder_date_1 = $date->modify('-3 day');
             

             ///set reminder
             $data['event_reminder_1_c'] = $reminder_date_1->format("Y-m-d H:i:00");
             $reminder_date_2 = $date->modify('-11 day');
             $data['event_reminder_2_c'] = $reminder_date_2->format("Y-m-d H:i:00");

             $reminder_date_3 = $date->modify('+7 day');
             $data['event_reminder_3_c'] = $reminder_date_3->format("Y-m-d H:i:00");

        }
        /// end date ///
        $date = $this->EE->input->get_post("tdetails_end_date");
        $h = $this->EE->input->get_post("tdetails_end_date_h");
        $m = $this->EE->input->get_post("tdetails_end_date_m");
        $a = $this->EE->input->get_post("tdetails_end_date_a");
         
        if($h !== false){
             if($date == ''){
                 $date = new DateTime($_event['end_date'], new DateTimeZone("UTC"));
                 $date->setTimezone( new DateTimeZone("Australia/Sydney"));
                 $date = $date->format("d/m/Y");
             }
             $date = DateTime::createFromFormat("d/m/Y g:i A", "{$date} {$h}:{$m}:{$a}", new DateTimeZone("Australia/Sydney"));
             $date->setTimeZone(new DateTimeZone('UTC'));
             $data['end_date'] = $date->format("Y-m-d H:i:00");
         }
         // $data['accounts_cpd_events_1accounts_ida'] = "1952ae03-5b45-06dc-076e-4e43ff200a3b";
        // $data['event_format'] = $this->EE->input->get_post("event_format");
        // $data['event_email'] = $this->EE->input->get_post("event_email");
        // $data['event_url'] = $this->EE->input->get_post("event_url");
        // $data['event_country'] = $this->EE->input->get_post("event_country");
        // $data['event_region'] = $this->EE->input->get_post("event_region");
        // $data['event_city'] = $this->EE->input->get_post("major_city");
        // $descritpion = htmlspecialchars_decode($this->EE->input->get_post("description"));
        // $event_org = $this->EE->input->get_post("event_organiser");
        // $user_name = $this->EE->input->get_post("ps_name");
        // $contact_number = $this->EE->input->get_post("contact_number");
        // $email = $this->EE->input->get_post("email_address");
        
        // $data['description'] = $descritpion.'<br />'.$event_org.'<br />'.$user_name.'<br />'.$contact_number.'<br />'.$email;

        // $data = $this->helper->array_exclude_unset($data);
        $params = array();
        $params['selects'] = "{#m}.id,MAX({#c}.event_id_c) as idc";
        $params['single'] = true;
        $_event = $this->EE->cpd_events->get_main_data($params);
        $idc = $this->increase_str($_event['idc']);
        $data['event_id_c'] = $idc;
        
        
        $success = $this->EE->cpd_events->set_record($data);
        $token = "ig8yeute8ywew0uew90w";
        $data = array();
        $data['id'] = $success;
        $express_update_url = "https://www.dentevents.com/express/id=".$success."/".$token;
        $data['express_update_url_c'] = $express_update_url;
        $success = $this->EE->cpd_events->set_record($data);
        $success = $this->EE->cpd_events->add_relationship_app($success, $timezone, 'postcodes');

        if($_SERVER['REMOTE_ADDR'] == '103.6.219.60'){
            // var_dump($data);var_dump($success);exit;
        }
        
        
        
        $content = "<div class='body-wrap' style='background-color: #ffffff;width: 100%;'>
                        <div class='email-container' style='display: block !important;max-width: 600px !important;margin: 0 auto !important;clear: both !important;'>
                            <div class='email-content' style='max-width: 600px;margin: 0 auto;display: block;padding: 20px;text-align: center;'>
                                <div class='content-block' style='padding: 0 0 20px;background-color: #ffffff;margin-bottom: 20px;'>
                                    <img style='width:350px;' src='https://www.dentevents.com/themes/site_themes/dentevents/skin/images/app/logo/Dentevents-Blue-NEW.png'>
                                </div>
                                <div class='' style='padding: 0 0 20px; text-align:center;margin-top:20px;'>
                                    <p style='color: #9FA29E;'>An Express Listing has been submitted to the dentevents.com dental education calendar for</p>
                                </div>
                                <div class='content-block email-title alignleft' style='padding: 0 0 20px;text-align: left;'>
                                    <h1 style='color: #9FA29E;text-align:center;'>".$event_name."</h1>
                                </div>
                                <div class='' style='text-align:center;margin-top:20px;'>
                                    <p style='color: #9FA29E;'>Your event is currently being reviewed and will be posted within 24 hours.</p>
                                </div>
                                <div class='' style='text-align:center;'>
                                    <p style='color: #9FA29E;'>You can edit or update the event at any time using the link below.</p>
                                </div>          
                                <div class='verify_btn' style='padding:10px;'>
                                  <a href='".$express_update_url."' style='background-color:#00aced;border-color:#00aced;padding:10px;color:white;text-decoration: none;'>EDIT EVENT</a>
                                  
                                </div>
                                <div class='' style='padding: 0 0 20px; text-align:center;margin-top:20px;'>
                                    <p style='color: #9FA29E;'>Dentevents...</p>
                                    <p style='color: #9FA29E;'>205 West Street, Crows Nest NSW 2065 AUSTRALIA</p>
                                    <p style='color: #9FA29E;'>Tel: (02) 9920-1900 Fax: (02) 9929-1999</p>
                                </div>
                            </div>
                        </div>
                    </div>";

        $email_tit = 'Express Listing submitted';
        $email_msg = $content;
        
        $this->EE->load->library('email');
        $this->EE->email->wordwrap = true;
        $this->EE->email->set_mailtype('html');
        $this->EE->email->from('info@dentevents.com', 'Dentevents');
        $this->EE->email->to($email);
        $this->EE->email->bcc("joseph@dentist.com.au");
        $this->EE->email->reply_to('info@dentevents.com');
        $this->EE->email->subject($email_tit);
        $this->EE->email->message($email_msg);
        $result = $this->EE->email->send();

        $result_txt ="<p class=''>Your Express Listing was successfully submitted for review.</p>
                <p>Your event will be reviewed within 24 hours and posted to the calendar.</p>
                <p>An email with a link to update your listing was sent to "."<span class='cnt-email'>".$email."</span></p>";
        $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
        
        $swaps = array(
                    'AID' => 'AID',
                    'org_id' => 'org_id',
                    'dt' => 'dt'
                 );
        $datas = array(
                    'AID' => $action_id,
                    'org_id' => $org_id,
                    'dt' => $result_txt
                 );
       
        $this->EE->TMPL->run_template_engine('pages', 'add_event_result');    
        $this->EE->output->app_output($swaps, $datas);
    }
    function fetch_data($params=''){
        $disable_pagination = $params['disable_pagination'];
        
        /// INITIALIZE the pagination ///
        if(!empty($params['current_page'])){
            $this->current_page = $params['current_page'];
        }

        $current_page = $this->current_page;

        $items_per_page = $this->_app_config['pagination']['events']['items_per_page'];
        //$items_per_page = 3;
        $items_per_navigation = $this->_app_config['pagination']['events']['items_per_navigation'];
        if(empty($current_page)){
             $current_page = 1;
        }
        if($params['pagination'] === false)
            $items_per_page = 100;
        $totals = count(self::$events);
        self::$p_events_total = $totals;


        //////////////////////////////////
        
        $offset = ($current_page - 1) * $items_per_page;
        $events = array_slice(self::$events, $offset, $items_per_page);
        if($disable_pagination === true){
            $events = self::$events;
        }
        
        /// logging events ///
        self::$router = "logger:record_events";
        DEProcessing_Dentevents::process(array('events' => $events));
        //////////////////////
        
        $image_base_url = $this->_crm_config['main']['upload_url'];
        
        $limit_text_length = 70;
        if($this->helper->is_mobile_device()){
            $limit_text_length = 40;
        }

        $limit_summary_length = 45;
        
        $event_options_list = $this->helper->get_dropdowns_sugar("event_options_list");

        $cur_date = date("d-m-Y");
        $date_time = new DateTime($cur_date, new DateTimeZone('UTC'));
        $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));
        $cur_date = $date_time->format("Y");


        $page =  $params['page'];
       
        
        foreach($events as $key => $item){

            /// start date ///
            $start_date = $item['start_date'];
            $start_date = new DateTime($start_date, new DateTimeZone('UTC'));
            // $start_date->format("Y") !=
            $event_year = $start_date->format("Y");

            $start_date->setTimezone( new DateTimeZone("Australia/Sydney"));
            if($page == 'speaker_side'){
                $events[$key]['start_date'] = array('y' => $start_date->format("Y"), 'm' => $start_date->format("F"), 'd' => $start_date->format("d"));
                $limit_text_length = 55;
                if($this->helper->is_mobile_device()){
                    $limit_text_length = 40;    
                }
            }else{
                if($event_year != $cur_date){
                    $events[$key]['start_date'] = array('y' => $start_date->format("Y"), 'm' => $start_date->format("F"), 'd' => $start_date->format("d"));
                }else{
                    $events[$key]['start_date'] = array('y' => $start_date->format("F"), 'm' => $start_date->format("l"), 'd' => $start_date->format("d"));
                }
            }
            $events[$key]['cnt'] = $key;
            
            //////////////////
            $limit_text_length = 10000;
            $events[$key]['name'] = $this->helper->getLimitText($item['name'], $limit_text_length);    
            
            $events[$key]['expanded_name'] = $item['name'];
            /// action ///
            $events[$key]['action'] = $this->seo_helper->get_seo_url(Seo_Helper::DETAILS, array('id' => $item['event_id_c'], 'name' => $item['name'], 'country' => $item['event_country']));
            //////////////
            
            /// checking register ///
            $register_now = self::$utility->check_register_now($item['id']);
            $register = '';
            if($register_now['register'] === true){
                $register = $events[$key]['action'] . "?register=1";   
            }else if($register_now['external_url'] != ''){
                $register = $events[$key]['action'] . "?register=1";
            }
            $events[$key]['register'] = $register;
            /////////////////////////
            //event_format
                $format = $item['event_format'];
                $events[$key]['event_format'] = $this->helper->get_dropdowns_sugar_labels('Event_Format_list',$format, false);
            $params = array();
            $params['id'] = $item['id'];
            $params['selects'] = "{#m}.id,{#m}.name";
            $params['single'] = true;
            $organiser = $this->EE->cpd_events->get_relationship_organiser($params);
            $events[$key]['organiser'] = $organiser['name'];

            // speakers //
            $params = array();
            $params['id'] = $item['id'];
            $params['selects'] = "{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.initial_c,{#c}.prefname_c";
            $results = $this->EE->cpd_events->get_relationship_speakers($params);
            $speakers = array();

            foreach($results as $item1){
                if($item1['salutation'] == 'AProf')
                    $item1['salutation'] = 'A/Prof';
                if(!empty($item1['prefname_c'])){
                    $speakers[] = $item1['salutation'] . " " . $item1['prefname_c'] . " " . $item1['last_name'];
                }else{
                    if(!empty($item1['initial_c'])){
                        $speakers[] = $item1['salutation'] . " " . $item1['first_name'] . " " . $item1['initial_c'] . " " . $item1['last_name'];
                    }else{
                        $speakers[] = $item1['salutation'] . " " . $item1['first_name'] . " " . $item1['last_name'];
                    }
                }
            }

            if(!empty($speakers)){
                $speakers = implode(", ", $speakers);
            }else{
                $speakers = '';
            }
            $events[$key]['speakers'] = $speakers;
            
            /// summary ///
            $summary = $item['event_theme'];
            if(empty($summary)){
                $summary = $speakers;
            }
            if(empty($summary)){
                $summary = $item['description'];
            }
            $summary = strip_tags($summary);
            $events[$key]['summary'] = $this->helper->getLimitText($summary, $limit_summary_length);
            ///////////////
            
            if($item['listing_type'] == 'Premium'){
                if(!empty($item['event_banner_url_c'])){
                    if (strpos($item['event_banner_url_c'], 'https') === false) {
                        $events[$key]['event_banner'] = $image_base_url . $item['event_banner_url_c'];
                    } else {
                        $events[$key]['event_banner'] = $item['event_banner_url_c'];
                    }
                }
            }
            if($item['listing_type'] == 'Express'){
                /// start date time ///
                $time = new DateTime($item['start_date'], new DateTimeZone('UTC'));
                $time->setTimezone( new DateTimeZone("Australia/Sydney"));
                $events[$key]['start_date']['time'] = array(
                                                        'first' => $time->format("h:i A - l"),
                                                        'second' => $time->format("j F, Y"),
                                                        'third' => $time->format("m/d/Y H:i")
                                                    );
                ///////////////////////
                
                /// end date time ///
                $time = new DateTime($item['end_date'], new DateTimeZone('UTC'));
                $time->setTimezone( new DateTimeZone("Australia/Sydney"));
                $events[$key]['end_date'] = array();
                $events[$key]['end_date']['time'] = array(
                                                        'first' => $time->format("h:i A - l"),
                                                        'second' => $time->format("j F, Y"),
                                                        'third' => $time->format("m/d/Y H:i")
                                                    );
                /////////////////////
                
                /// event options ///
                $event_options = $item['event_options_c'];
                $event_options = trim($event_options, "^");
                $event_options = explode("^,^", $event_options);

                foreach($event_options as $key1 => $_option){
                    $event_options[$key1] = $event_options_list[$_option];
                }
                $events[$key]['event_options'] = implode(", ", $event_options);
                /////////////////////
                
                /// event url ///
                $events[$key]['event_url'] = $this->helper->getStrippedURL($events[$key]['event_url']);
                /////////////////
                $params = array();
                $params['id'] = $item['id'];
                $params['rel_module_name'] = 'postcodes';
                $params["selects"] = '{#m}.id,{#m}.country,{#c}.time_zone_utc_c,{#c}.time_zone_abbr_c,{#c}.time_zone_name_c,{#c}.time_zone_google_name_c';
                $params["single"] = true; 
                $temp = $this->EE->cpd_events->get_relationship($params);
                $timezone_formats = $temp['country'].' - '.$temp['time_zone_name_c'].' - (UTC '.$temp['time_zone_utc_c'].')';
                $timezone_abbr = $temp['time_zone_abbr_c'];
                $events[$key]['timezone_formats'] = $timezone_formats;
                $events[$key]['timezone_abbr'] = $timezone_abbr;
                $events[$key]['r_zone'] = str_replace("\/", "/", $temp['time_zone_google_name_c']);

                if($item['cpd_points_total_c'] != 0)
                    $events[$key]['event_cpd'] = $item['cpd_points_total_c']." Hours Scientific";
                else
                    $events[$key]['event_cpd'] = $item['cpd_points_total_c']." Hours Non-Scientific";
                // $events[$key]['r_zone'] = '(UTC'.$temp['time_zone_utc_c'].')';
                


            }
            $events[$key]['cpd_points_total_c'] *= 1;
        }
        
        return $events;
    }
    
    function _prepare_pagination(){
        $totals = count(self::$events);
        /// INITIALIZE the pagination ///
        $current_page = $this->current_page;
        $items_per_page = $this->_app_config['pagination']['events']['items_per_page'];
        //$items_per_page = 3;
        $items_per_navigation = $this->_app_config['pagination']['events']['items_per_navigation'];
        if(empty($current_page)){
             $current_page = 1;
        }
        //////////////////////////////////
        
        $totals = ceil($totals / $items_per_page);
        
        $start_page_number =  (int)(($current_page - 1) / $items_per_navigation) * $items_per_navigation + 1;
        $end_page_number = $start_page_number + $items_per_navigation - 1;
        $end_page_number = min($totals, $end_page_number);
        
        /// FETCH datas ///
        $datas = array();
        if($start_page_number == 1){
             $datas['start_class'] = 'disabled';
        }
        if($end_page_number == $totals){
             $datas['end_class'] = 'disabled';
        }
        if ($current_page == 1)
             $datas['prev_class'] = 'disabled';  
        if ($current_page == $totals)
             $datas['next_class'] = 'disabled';       
        
        $datas['links'] = array();
        for ($i = $start_page_number; $i < $end_page_number + 1; $i++){
            $active = '';
            if($i == $current_page){
                $active = "active";    
            }
            $datas['links'][] = array('number' => $i, 'active' => $active); 
        }
         
        $datas['current_page'] = $current_page;
        $datas['total_pages'] = $totals;
        ///////////////////
        
        return $datas;
    }
    
    function show($params=''){        
        $template = $this->EE->input->get_post("template");
        $live_flag = $this->EE->input->get_post("live_flag");

        $is_mobile_device = 'no';
        if($this->helper->is_mobile_device()) {
            $is_mobile_device = 'yes';
        }

        if($template == "yes"){
            $template = "account_sidebar_past_events";
        }else{
            $template = "events_list";
            if ($is_mobile_device == 'yes') {
                $template = "events_list_mobile";
            }
        }
        $params['express'] = "yes";

        $search_pagination = $this->EE->input->get_post("search_pagination");

        if(!empty($search_pagination)){
            if($live_flag == 'yes')
                self::$router = "search:fetch_live_data";
            else
                self::$router = "search:fetch_data";
            $result = DEProcessing_Dentevents::process(array('output' => false, 'current_page' => 1));
            if (!empty($result)) {
                self::$events = $result;
            }

            $params['current_page'] = $this->EE->input->get_post("current_page");
        }
        $datas = array();

        if(!empty($params['events_filtered'])){
           self::$events = $params['events_filtered'];
        }

        $datas['events'] = $this->fetch_data($params);
        $datas['totals'] = count(self::$events);
        $pagination = $this->_prepare_pagination();

        $swaps = array(
                    'dt' => 'dt',
                    'pagination' => 'pagination',
                    'is_mobile' => 'is_mobile'
                );
        $datas = array(
                    'dt' => $datas,
                    'pagination' => $pagination,
                    'is_mobile' => $is_mobile_device
                );


        // if($_SERVER['REMOTE_ADDR'] == '207.126.90.2'){
        //     var_dump("--------------------".$template);
        //     var_dump($datas);
        //    }
        $TMPL = new EE_Template();         
        $TMPL->run_template_engine('dentevents', $template);
        $html = $this->EE->output->app_output($swaps, $datas, array('output' => false));  
        
        if($params['output'] === false){
            return $html;
        }
        
        echo $html;
        exit;
    }
    
}