<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Events_Home extends DEProcessing_Dentevents_Events{

    function initialize($params = array()){
        $this->EE->load->model("cpd_events");
        
        if(!empty($params['limit'])){
            $limit = $params['limit'];
        }
        $current_page = $this->EE->input->get_post('current_page');
        if(!empty($params['current_page'])){
            $current_page = $params['current_page'];
        }
        $this->current_page = $current_page;
        
        if(!empty(self::$events)){
            return;
        }
        $start_date = $this->EE->input->get_post("start_date");

        if(empty($start_date)){
            $start_date = date("Y-m-d");
        }else{
            $date = DateTime::createFromFormat('D, j F, Y', $start_date);
            if($date === false){
                $date = DateTime::createFromFormat('Y-m-d', $start_date);
            }
            $start_date = $date->format("Y-m-d");    
        }  
        
        $country = $this->EE->input->get_post("country"); 
        if(empty($country)){
            $country = 'Worldwide';
        }   
        $country = strtolower($country);
        
        $now_date = date("Y-m-d");
        //////////////////////////////////
        $params = array();
        $params['selects'] = self::$selects_events;
        
        if($country != 'worldwide'){
            $params['where'] = "{#m}.end_date >= '{$start_date}' and LOWER({#m}.event_country)='{$country}' and {#m}.event_status='Approved_Online' and ({#c}.rec_type_c NOT IN('Session','Day','Break','Stream') or {#c}.rec_type_c is null) and (({#m}.event_format IN ('Webinar','OnlineLearning') and {#c}.dentevents_tv_content_status_c <> 'Library') or {#m}.event_format NOT IN ('Webinar','OnlineLearning'))";
        }else{
            $params['where'] = "{#m}.end_date >= '{$start_date}' and {#m}.event_status='Approved_Online' and ({#c}.rec_type_c NOT IN('Session','Day','Break','Stream') or {#c}.rec_type_c is null) and (({#m}.event_format IN ('Webinar','OnlineLearning') and {#c}.dentevents_tv_content_status_c <> 'Library') or {#m}.event_format NOT IN ('Webinar','OnlineLearning'))";
        }
        if(!empty($limit)){
            $params['limit'] = $limit;
        }
        $params['orders'] = "{#m}.start_date asc";
        
        self::$events = $this->EE->cpd_events->get_main_data($params);
        //////////////////////////////////
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "fetch_data":
                return $this->fetch_data($params);
            break;
            case "show":
                return $this->show($params);
            break;
        }

    }
     
}