<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Logger extends DEProcessing_Dentevents{
    
    function initialize($params = array()){
        $this->EE->load->model("general_hits"); 
    }
    
    function process($params = array()){
        if($this->helper->is_crawlers_bots()){
            return true;
        }
        
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "record_search_action":
                return $this->record_search_action($params);
            break;
            case "record_events":
                return $this->record_events($params);
            break;
        }
    }
    
    function record_search_action($params = array()){
        $country = $this->EE->input->get_post("country");
        
        $now_date = new DateTime();
        $now_month = $now_date->format("m");
        $now_year = $now_date->format("Y");

        /// GET general hits and update ///
        $general_hits = $this->EE->general_hits;

        ///// general search /////
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.schresult";
        $params['where'] = "{#m}.name='Event Search' and {#m}.month='$now_month' and {#m}.year='$now_year' and {#m}.keytype='Event' and {#m}.keyvalue='{$country}'";
        $params['single'] = true;
        $_hit = $general_hits->get_main_data($params);
        if(!empty($_hit)){
            $_hit['schresult'] = $_hit['schresult'] * 1 + 1;
            $success = $general_hits->set_record($_hit);
            if(!$success){
                $this->logger->developer("Failed to increase the schresult on dentevents results page.");
                return false;
            }
        }else{
            $data = array(
                        'name' => 'Event Search',
                        'month' => $now_month,
                        'year' => $now_year,
                        'keytype' => 'Event',
                        'keyvalue' => $country,
                        'schresult' => 1
                    );
            $success = $general_hits->set_record($data);
            if(!$success){
                $this->logger->developer("Failed to create the general hits record on dentevents results page.");
                return false;
            }
        }
        //////////////////////////
    
    }
    
    function record_events($params = array()){
        $_events = $params['events'];
        
        $ids = array();
        foreach($_events as $item){
            if(empty($item['id'])){
                continue;
            }
            $ids[] = $item['id'];
        }
        
        require_once(PATH_THIRD . 'mlogger/models/processing.php');
        $processing = new MLOGProcessing();
        $processing->initialize('logger:file');
        return $processing->process(array('code' => 'search_events', 'ids' => $ids));
    }
}