    <?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_SpeakerProfile extends DEProcessing_Dentevents{
    static $speaker;
    static $events;
    protected $current_page;
    
    function initialize($params = array()){
        $id = $this->EE->input->get_post("id");
        
        $this->EE->load->model("contacts");
        
        /// fetch contact data ///
       $params = array();
       $params['selects'] = "{#c}.id_c as id,{#c}.contact_id_nr_c,{#c}.prefname_c,{#c}.initial_c,{#c}.quals_c,{#c}.rego_domain_c,{#c}.prof_photo_c,{#c}.photo_prof_url_c,{#c}.bio_pro_c,
                    {#c}.pract_type_c,{#c}.pract_type_nz_c,{#c}.pract_type_other_1_c,{#c}.languages_c,{#c}.display_email_on_internet_c,{#c}.personal_url_c,{#c}.display_on_internet_c,
                    {#c}.facebook_c,{#c}.twitter_c,{#c}.googleplus_c,{#c}.linkedin_c,{#c}.pinterest_c,
                    {#c}.instagram_c,{#c}.flickr_c,{#c}.xing_c,{#c}.tumblr_c,{#c}.vk_c,{#c}.youtube_c,{#c}.dentevents_banner_c
                    ";
       $params['where'] = "{#c}.contact_id_nr_c='$id'";
       $cstm = $this->EE->contacts->get_cstm_data($params, false);
        
       $params = array();
       $params['selects'] = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.*";
       $params['joins'] = array(
                               "{#c}" => array(
                                   'sql' => $cstm['sql'],
                                   'table' => $cstm['table'],
                                   'type' => 'inner'
                               )
                            );
       $params['single'] = true;
       $_contact = $this->EE->contacts->get_contacts($params);
       
       $email1 = $this->EE->contacts->get_email_address($_contact['id']);
       $_contact['email1'] = $email1;
       
       /// check salutation ///
       if($_contact['salutation'] == 'AProf'){
           $_contact['salutation'] = "A/Prof.";     
       }
        if($_contact['salutation'] == 'Prof'){
           $_contact['salutation'] = "Prof.";     
       }
       ////////////////////////
       
       self::$speaker = $_contact;
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "show":
                return $this->show($params);
            break;
            case "logger":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/speaker_profile/logger.php');
                $processing = new DEProcessing_Dentevents_SpeakerProfile_Logger();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "email":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/speaker_profile/email.php');
                $processing = new DEProcessing_Dentevents_SpeakerProfile_Email();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "show_current_page":
                return $this->show_current_page($params);
            break;
        }

    }
    function show_current_page($params=''){
       
        $current_page = $this->EE->input->get_post("current_page");

        $this->current_page = $current_page;
        
        $id = $this->EE->input->get_post("id");
        
        $this->EE->load->model("contacts");
        
        /// fetch contact data ///
       $params = array();
       $params['selects'] = "{#c}.id_c as id,{#c}.contact_id_nr_c,{#c}.prefname_c,{#c}.initial_c,{#c}.quals_c,{#c}.rego_domain_c,{#c}.prof_photo_c,{#c}.photo_prof_url_c,{#c}.bio_pro_c,
                    {#c}.pract_type_c,{#c}.pract_type_nz_c,{#c}.pract_type_other_1_c,{#c}.languages_c,{#c}.display_email_on_internet_c,{#c}.personal_url_c,{#c}.display_on_internet_c,
                    {#c}.facebook_c,{#c}.twitter_c,{#c}.googleplus_c,{#c}.linkedin_c,{#c}.pinterest_c,
                    {#c}.instagram_c,{#c}.flickr_c,{#c}.xing_c,{#c}.tumblr_c,{#c}.vk_c,{#c}.youtube_c,{#c}.dentevents_banner_c
                    ";
       $params['where'] = "{#c}.id_c='$id'";
       $cstm = $this->EE->contacts->get_cstm_data($params, false);
        
       $params = array();
       $params['selects'] = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.*";
       $params['joins'] = array(
                               "{#c}" => array(
                                   'sql' => $cstm['sql'],
                                   'table' => $cstm['table'],
                                   'type' => 'inner'
                               )
                            );
       $params['single'] = true;
       $_contact = $this->EE->contacts->get_contacts($params);
       
       $email1 = $this->EE->contacts->get_email_address($_contact['id']);
       $_contact['email1'] = $email1;
       
       /// check salutation ///
       if($_contact['salutation'] == 'AProf'){
           $_contact['salutation'] = "A/Prof.";     
       }
      



        $_datas = array();
        /// past events ///
        self::$router = "events:search:speaker:fetch_data";
        self::$events = DEProcessing_Dentevents::process(array('speaker' => $_contact['id'], 'disable_pagination' => true, 'upcoming_or_past' => 'past','page' => 'speaker_side'));
        
        self::$router = "events:search:speaker:fetch_data";
        $events = DEProcessing_Dentevents::process(array('speaker' => $_contact['id'], 'disable_pagination' => false, 'upcoming_or_past' => 'past','page' => 'speaker_side','current_page'=>$current_page));

        $_datas['events'] = $events;
        $_datas['totals'] = count(self::$events);
        $pagination = $this->_prepare_pagination();
        
        $swaps = array(
                    'dt' => 'dt',
                    'pagination' => 'pagination'
                );
        $datas = array(
                    'dt' => $_datas,
                    'pagination' => $pagination
                );
          
        $TMPL = new EE_Template();         
        $TMPL->run_template_engine('dentevents','speaker_profile_sidebar_past');
        // $html = '';
        $return = $this->EE->output->app_output($swaps, $datas);  
        

        return $return;

    }
    function _prepare_pagination(){
        $totals = count(self::$events);
        /// INITIALIZE the pagination ///
        $current_page = $this->current_page;
        $items_per_page = $this->_app_config['pagination']['events']['items_per_page'];
        //$items_per_page = 3;
        $items_per_navigation = $this->_app_config['pagination']['events']['items_per_navigation'];
        if(empty($current_page)){
             $current_page = 1;
        }
        //////////////////////////////////
        
        $totals = ceil($totals / $items_per_page);
        
        $start_page_number =  (int)(($current_page - 1) / $items_per_navigation) * $items_per_navigation + 1;
        $end_page_number = $start_page_number + $items_per_navigation - 1;
        $end_page_number = min($totals, $end_page_number);
        
        /// FETCH datas ///
        $datas = array();
        if($start_page_number == 1){
             $datas['start_class'] = 'disabled';
        }
        if($end_page_number == $totals){
             $datas['end_class'] = 'disabled';
        }
        if ($current_page == 1)
             $datas['prev_class'] = 'disabled';  
        if ($current_page == $totals)
             $datas['next_class'] = 'disabled';       
        
        $datas['links'] = array();
        for ($i = $start_page_number; $i < $end_page_number + 1; $i++){
            $active = '';
            if($i == $current_page){
                $active = "active";    
            }
            $datas['links'][] = array('number' => $i, 'active' => $active); 
        }
         
        $datas['current_page'] = $current_page;
        $datas['total_pages'] = $totals;
        ///////////////////
        
        return $datas;
    }
    function show($params=''){
        $_speaker = self::$speaker;
        
        $datas = array();
        $img_base_url = $this->_crm_config['main']['upload_url'];
        $now_date = date("Y-m-d");
        
        ///////// log ////////
        self::$router = "logger:record_click";
        DEProcessing_Dentevents_SpeakerProfile::process(array( 'speaker' => $_speaker ));
        //////////////////////
        
        /// main data ///
        $main = array();
        // if(!empty($_speaker['prof_photo_c'])){
        //     $main['photo'] = $img_base_url . $_speaker['prof_photo_c'];
        // }
        if(!empty($_speaker['photo_prof_url_c'])){
            $main['photo'] = $_speaker['photo_prof_url_c'];
        }
        // if($_speaker['salutation'] == 'Prof');
        //     $_speaker['salutation'] = 'Prof.';
        $main['name'] = $_speaker['salutation'] . ' ' . $_speaker['first_name'] . ' ' . $_speaker['initial_c'] . ' ' . $_speaker['last_name']; 
        if(!empty($_speaker['prefname_c'])){
            $main['name'] = $_speaker['salutation'] . ' ' .  $_speaker['prefname_c'] . ' ' . $_speaker['last_name']; 
        }

        $main['id'] = $_speaker['id'];
        $main['salutation'] = $_speaker['salutation'];
        $main['last_name'] = $_speaker['last_name'];

        
        $main['quals'] = $_speaker['quals_c'];
        
            /// pract type ///
            $practs = '';
            if(strtolower($_speaker['rego_domain_c']) == 'australia'){
                 $practs = $_speaker['pract_type_c'];
            }else if(strtolower($_speaker['rego_domain_c']) == 'new zealand'){
                 $practs = $_speaker['pract_type_nz_c'];
            }else{
                 $practs = $_speaker['pract_type_other_1_c'];
            }
            $practs = trim($practs, "^");
            $practs = explode("^,^", $practs);
            
            if(count($practs) > 1){
                 $last_pract = array_pop($practs);
                 $practs = implode(", ", $practs) . " and " . $last_pract;
            }else{
                 $practs = implode(", ", $practs);
            }
            $main['practs'] = $practs;
            /////////////////
        
        if(!empty($_speaker['dentevents_banner_c'])){
            $main['banner'] = $img_base_url .$_speaker['dentevents_banner_c'];
        }

        // var_dump($main['banner']);
        $main['country'] = $_speaker['rego_domain_c'];
        $main['email'] = $_speaker['email1'];
        $main['email_link'] = $this->seo_helper->get_seo_url(Seo_Helper::SPEAKER_PROFILE_EMAIL, array('id' => $_speaker['contact_id_nr_c']));


        
        $main['personal_url'] = $_speaker['personal_url_c'];
        if($main['personal_url'] == 'http://'){
            $main['personal_url'] = '';
        }
        
        $main['bio_pro'] = $_speaker['bio_pro_c'];
        if(empty($main['bio_pro']))
            $main['bio_pro'] = ' ';
        
            /// socials /// 
            $main['socials'] = array('facebook' => $_speaker['facebook_c'],
                                    'googleplus' => $_speaker['googleplus_c'],
                                    'pinterest' => $_speaker['pinterest_c'], 'instagram' => $_speaker['instagram_c'],
                                    'flickr' => $_speaker['flickr_c'], 'xing' => $_speaker['xing_c'],
                                    'tumblr' => $_speaker['tumblr_c'], 'vk' => $_speaker['vk_c'], 'youtube' => $_speaker['youtube_c'],
                                );
            if(!empty($_speaker['twitter_c'])){
                $main['socials']['twitter'] = "https://twitter.com/" . $_speaker['twitter_c'];
            }
            if(!empty($_speaker['linkedin_c'])){
                $main['socials']['linkedin'] = $_speaker['linkedin_c'];
            }
            ///////////////
        $datas['main'] = $main;
        /////////////////
        
        /// fetch members ///
        $params = array();
        $params['id'] = $_speaker['id'];
        $params['selects'] = "{#m}.id,{#m}.name,{#m}.website,{#c}.photo_thumb_c,{#c}.billing_name_c";
        $memberships = $this->EE->contacts->get_relationship_memberships($params);
        foreach($memberships as $key => $item){
            $memberships[$key]['thumb'] = $img_base_url . $item['photo_thumb_c'];
            $memberships[$key]['name'] = $item['billing_name_c'];
        }
        $datas['memberships'] = $memberships;
        /////////////////////
        
        /// image gallery ///
        $params['id'] = $_speaker['id'];
        $params['selects'] = "{#m}.id,{#m}.article_image";
        $params['where'] = "{#m}.image_type='Photograph' and {#m}.image_format='News' and {#m}.portal_show='Public'";
        $image_gallery = $this->EE->contacts->get_relationship_article_images($params);
        foreach($image_gallery as $key => $item){
            $image_gallery[$key]['image'] = $img_base_url . $item['article_image'];
        }
        $datas['image_gallery'] = $image_gallery;
        /////////////////////
        
        /// video gallery ///
        $params['id'] = $_speaker['id'];
        $params['selects'] = "{#m}.id,{#c}.video_id_c";
        $params['where'] = "{#m}.image_type='Video' and {#m}.portal_show='Public'";
        $video_gallery = $this->EE->contacts->get_relationship_article_images($params);
        $datas['video_gallery'] = $video_gallery;
        /////////////////////
        
        /// upcoming events ///
        self::$router = "events:search:speaker:fetch_data";
        $events = DEProcessing_Dentevents::process(array('speaker' => $_speaker['id'], 'disable_pagination' => true));
        $datas['upcoming_events'] = $events;
        ///////////////////////
        if($_SERVER['REMOTE_ADDR'] == '103.6.219.60'){
            // var_dump($events);
         }
        /// past events ///
        self::$router = "events:search:speaker:fetch_data";
        self::$events = DEProcessing_Dentevents::process(array('speaker' => $_speaker['id'], 'disable_pagination' => true, 'upcoming_or_past' => 'past','page' => 'speaker_side'));
        self::$router = "events:search:speaker:fetch_data";
        $events = DEProcessing_Dentevents::process(array('speaker' => $_speaker['id'], 'disable_pagination' => false, 'upcoming_or_past' => 'past','page' => 'speaker_side'));
        $datas['past_events'] = $events;
         
        $datas['past_events']['total'] = count(self::$events);
        $_datas = array();
        $_datas['events'] = $events;
        $_datas['totals'] = count(self::$events);
        $pagination = $this->_prepare_pagination();
        
        $swaps = array(
                    'dt' => 'dt',
                    'pagination' => 'pagination'
                );
        $_datas = array(
                    'dt' => $_datas,
                    'pagination' => $pagination
                );
          
        $TMPL = new EE_Template();         
        $TMPL->run_template_engine('dentevents', 'speaker_profile_sidebar_events');
        $html = $this->EE->output->app_output($swaps, $_datas, array('output' => false));  
        
        $datas['past_events_html'] = $html;
        ///////////////////
        
        /// REGISTER META DATAS TO GLOBALS ///
       $GLOBALS['meta']['name'] = $main['name'];
       $GLOBALS['meta']['id'] = $_speaker['contact_id_nr_c'];
       //////////////////////////////////////


        // var_dump($speaker_datas);exit;
        $sub_params = array();
        $sub_params['id'] = $_speaker['id'];
        $sub_params['selects'] = "{#m}.id,{#m}.name,{#c}.dentevents_tv_thumbnail_c,{#c}.dentevents_tv_source_c,{#c}.dentevents_tv_source_id_c,{#c}.dentevents_tv_thumnail_img_c,{#c}.dentevents_tv_channel_c,{#c}.dentevents_tv_thumb_sm_img_c,{#c}.dentevents_tv_duration_c";
        $sub_params['where'] = "{#c}.dentevents_tv_c = 1 AND {#c}.dentevents_tv_content_status_c = 'Library'";
        $selected_events = $this->EE->contacts->get_relationship_cpd_events_speakers($sub_params);

        // $site_url = $this->EE->config->item("site_url");
        
        // $genre_img = $site_url."themes/site_themes/dentevents/skin/images/genre/hd_".$id.".jpg";

        $video_datas = array();
        $video_count ;
        foreach ($selected_events as $key => $value) {
            if($value['dentevents_tv_source_id_c']){

                $video_datas[$key]['sub_id'] = $value['id'];
                $video_datas[$key]['name'] = $value['name'];

                $rego_data = $this->EE->cpd_events->get_relationship_payment_matrix(array(
                    'id' => $value['id'],
                    'selects' => "{#m}.base_rate",
                    'orders' => "{#c}.sort_order_c asc",
                    'single' => true
                ));
                if(!$rego_data['base_rate'] || $rego_data['base_rate'] == 0)
                    $video_datas[$key]['price'] = "FREE";
                else
                    $video_datas[$key]['price'] = '$'.number_format($rego_data['base_rate'],2,'.','');


                $video_datas[$key]['thumb_type'] = $value['dentevents_tv_thumbnail_c'];
                $video_datas[$key]['type'] = $value['dentevents_tv_source_c'];
                $url = $value['dentevents_tv_source_id_c'];
                $video_datas[$key]['source_id'] = $url;
                
                if($value['dentevents_tv_source_c'] == "YouTube"){
                    if($video_datas['dentevents_tv_thumnail_img_c'])
                        $video_datas[$key]['thumb_url'] = $img_base_url.$value['dentevents_tv_thumnail_img_c'];
                    
                    if($value['dentevents_tv_duration_c']){
                        $video_datas[$key]['duration'] = $value['dentevents_tv_duration_c'];
                    }
                    $data[$key]['content_type'] ="YouTube";
                }elseif ($value['dentevents_tv_source_c'] == "Vimeo") {
                    if($value['dentevents_tv_thumnail_img_c'])
                        $video_datas[$key]['thumb_url'] = $img_base_url.$value['dentevents_tv_thumnail_img_c'];
                    
                    if($value['dentevents_tv_duration_c']){
                        $video_datas[$key]['duration'] = $value['dentevents_tv_duration_c'];
                    }
                    $video_datas[$key]['content_type'] ="Vimeo";
                }
                
                $video_datas[$key]['target_url'] = 'https://www.dentevents.tv/?ACT=60&cmd=events:video_detail&video_id='.$url.'&content_type='.$video_datas[$key]['content_type'].'&sub_id='.$value['id']."&pre=no";
            }
        }
        if(count($video_datas) > 0)
            $video_count = 'yes';
        else
            $video_count = 'no';

        // if($_SERVER['REMOTE_ADDR'] == '207.126.90.2'){
        //     var_dump($video_datas);
        // }
        
        $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
        $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt',
                    'genre_data' => 'genre_data',
                    'video_count' => 'video_count',
                );
        $datas = array(
                    'AID' => $action_id,
                    'dt' => $datas,
                    'genre_data' =>$video_datas,
                    'video_count' => $video_count,
                );
               
        $this->EE->TMPL->run_template_engine("dentevents", "speaker_profile");
        $this->EE->output->app_output($swaps, $datas);
    }
    
}