<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_SpeakerProfile_Logger extends DEProcessing_Dentevents_SpeakerProfile{
    
    function initialize($params = array()){
        $this->EE->load->model("contact_hits"); 
    }
    
    function process($params = array()){
        if($this->helper->is_crawlers_bots()){
            return true;
        }
        
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "record_click":
                return $this->record_click($params);
            break;
        }
    }
    
    function record_click($params = array()){
        $_speaker = $params['speaker'];
        
        $now_date = new DateTime();
        $now_month = $now_date->format("m");
        $now_year = $now_date->format("Y");

        /// GET contact hits and update ///
        $contact_hits = $this->EE->contact_hits;

        $params = array();
        $params['id'] = $_speaker['id'];
        $params['selects'] = "{#m}.id,{#m}.schclick";
        $params['where'] = "{#m}.month='$now_month' and {#m}.year='$now_year' and {#c}.type_c='Speaker'";
        $params['single'] = true;
        
        $_hit = $this->EE->contacts->get_relationship_contacthits($params);   
        if(empty($_hit)){
             $link_data = array('name' => $_speaker['first_name'] . ' ' . $_speaker['last_name'], 'month' => $now_month, 'year' => $now_year, 'schclick' => 1, 'type_c' => 'Speaker');
             $success = $this->EE->contact_hits->set_record($link_data);
             if(!$success){
                $this->logger->developer("Failed to create the contact hits.");
                return false;
             }
             $success = $this->EE->contacts->add_relationship_app($_speaker['id'], $success, 'contact_hits');    
             if(!$success){
                $this->logger->developer("Failed to link the contact hits to contact.");
                return false; 
             }
        }else{
             $schclick = $_hit['schclick'] * 1 + 1;
             $_hit['schclick'] = $schclick;
             $success = $this->EE->contact_hits->set_record($_hit);
             if(!$success){
                $this->logger->developer("Failed to update the contact hit.");
                return false;
             }
        }
    
        return true;
    }
}