<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Widget_UpcomingEvents extends DEProcessing_Dentevents_Widget{

    function initialize($params = array()){
        $this->EE->load->model("cpd_events");
    }
    
    function process($params = array()){
        $now_date = date("Y-m-d");
        
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.start_date,{#m}.end_date,{#m}.name,{#m}.event_theme,{#m}.description,{#m}.event_city,{#m}.event_country,{#m}.listing_type,{#m}.event_banner,{#m}.event_rego_online,{#m}.event_url,{#c}.event_options_c,{#c}.event_id_c";
        $params['where'] = "{#m}.event_status='Approved_Online' and {#m}.end_date >= '{$now_date}' and ({#c}.rec_type_c NOT IN('Session','Day','Break','Stream') or {#c}.rec_type_c is null) and (({#m}.event_format IN ('Webinar','OnlineLearning') and {#c}.dentevents_tv_content_status_c <> 'Library') or {#m}.event_format NOT IN ('Webinar','OnlineLearning'))";
        $params['orders'] = "{#m}.start_date asc";
        $params['limit'] = "10";
        $events = $this->EE->cpd_events->get_main_data($params);    
        //////////////////////////////////
        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        ////////////////////////////////
        $swaps = array(
                    'y' => 'y','m' => 'm','d' => 'd',
                    'name' => 'name',
                    'city' => 'city',
                    'country' => 'country',
                    'action' => 'action'
                );
        $tagdata = $this->EE->TMPL->tagdata;
        
        $return = '';
        foreach($events as $item){
            /// start date ///
            $start_date = $item['start_date'];
            $start_date = new DateTime($start_date, new DateTimeZone('UTC'));
            $start_date->setTimezone( new DateTimeZone("Australia/Sydney"));
            $_event = array('y' => $start_date->format("Y"), 'm' => $start_date->format("M"), 'd' => $start_date->format("d"));
            //////////////////
            
            $_event['name'] = $item['name'];
            $_event['city'] = $item['event_city'];
            $_event['country'] = $item['event_country'];
            $_event['action'] = $this->seo_helper->get_seo_url(Seo_Helper::DETAILS, array('id' => $item['event_id_c'], 'name' => $item['name'], 'country' => $item['event_country']));
            
            $return .= $this->helper->render_results($swaps, $_event, $tagdata);
        }
        /////////////////////////////////
        
        return $return;
    }
     
}