<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing{
    
    protected $EE = '';
    public static $contact = null;
    protected $contacts;
    protected $helper;
    protected $seo_helper;
    protected $tasks;
    protected $logger;
    protected $_crm_config = '';
    protected $_app_config = '';
    
    public static $utility = null;
    public static $router = null;
    
    function __construct(){
        
        $this->EE =& get_instance();
        $this->EE->load->model('contacts');
        $this->contacts = $this->EE->contacts;
        
        $this->EE->load->library('logger');
        $this->logger = $this->EE->logger;
        
        $this->EE->load->helper('data');
        $this->helper = new Data_Helper();
        
        $this->EE->load->helper('seo');
        $this->seo_helper = new Seo_Helper();
        
        $this->_crm_config = $this->EE->config->item('crm');
        
        $this->_app_config = $this->EE->config->item('app');
        
        $this->EE->load->model('tasks');
        $this->tasks = $this->EE->tasks;
        $this->EE->load->library('template', NULL, 'TMPL');
        
        ///////////////////////////////////

        if (self::$utility == null){
           require_once(PATH_THIRD . 'mdentevents/models/utility.php');
           self::$utility = new DEProcessing_Utility();
        }
    }
    
    function initialize($cmd=''){
       if (empty($cmd)){
           $cmd = $this->EE->TMPL->fetch_param("cmd"); 
       }
       if (empty($cmd)){
         $cmd = $this->EE->input->get_post("cmd");
       }
       /*base64 decode if encoded*/
       if (base64_decode($cmd, true)) {
           $cmd = base64_decode($cmd);
       }

       self::$router = $cmd;
    } 
    function go_to_home($value='')
    {
        echo('OK');
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "dentevents":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents.php');
                $processing = new DEProcessing_Dentevents();
                $processing->initialize($params);
                return $processing->process($params);
            break;  
            case "c_register":
                require_once(PATH_THIRD . 'mdentevents/models/contacts/register.php');
                $processing = new DEProcessing_Register();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "terms":
                require_once(PATH_THIRD . 'mdentevents/models/contacts/terms_none_user.php');
                
                $processing = new DEProcessing_Noneuser_Terms();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "privacy":
                require_once(PATH_THIRD . 'mdentevents/models/contacts/none_user_privacy.php');
                $processing->initialize($params);
                $processing = new DEProcessing_Noneuser_Privacy();
                return $processing->process($params);
            break;   
        }
    }
}