<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Utility extends DEProcessing{
    
    function __construct(){
        self::$utility = $this;
        parent::__construct();
    }
    
    function fetch_router(){
        $router = self::$router;
        
        $routers = explode(":", $router);
        
        $cmd = $routers[0];
        $routers = array_slice($routers, 1);
        $router = implode(":", $routers);
        
        self::$router = $router;
        
        return $cmd;
    }
    function make_audience_dropdown(){
        $this->EE->load->model('cpd_events');
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.audience";
        $params['where'] = "{#m}.event_status = 'Approved_Online' and {#m}.event_format NOT IN('Webinar' , 'OnlineLearning')";
        $params['orders'] = "{#m}.start_date desc";
        $selected_events = $this->EE->cpd_events->get_main_data($params);


        $result = array();
        $temp = array();

       

        foreach ($selected_events as $key => $value) {
            $audience = $value['audience'];
            $audience = str_replace('^', '', $audience);
            $audience_list = explode(',',$audience);
            if($audience_list){
                
                $result = array_unique(array_merge($temp,$audience_list), SORT_REGULAR);
                // $result = array_merge(array_unique($result,$_curr_topics), $result);
            }
            $temp = $result;

        }
        $list_data = array();
        foreach ($result as $key => $value) {
            $list_data[$value] = $value;
        }

    

        

        return $list_data;

    }
    function make_topic_dropdown(){

        $topic_list;
        $this->EE->load->model('cpd_events');
        $params = array();
        $params['selects'] = "{#m}.id";
        $params['where'] = "{#m}.event_status = 'Approved_Online' and {#m}.event_format NOT IN('Webinar' , 'OnlineLearning')";
        $params['orders'] = "{#m}.start_date desc";
        $selected_events = $this->EE->cpd_events->get_main_data($params);
        
        $result = array();
        $temp = array();
        foreach ($selected_events as $key => $value) {
            $sparams = array();
            $sparams['id'] = $value['id'];
            $sparams['selects'] = "{#m}.name";
            $_curr_topics = $this->EE->cpd_events->get_relationship_topics($sparams);
            if($_curr_topics){
                
                $result = array_unique(array_merge($temp,$_curr_topics), SORT_REGULAR);
                // $result = array_merge(array_unique($result,$_curr_topics), $result);
            }
            $temp = $result;

        }
        // array_unique(array_merge($array1,$array2), SORT_REGULAR);
        // $temp = array_unique($result);

        // var_dump($result);
        sort($result);
        $list_data = array();
        foreach ($result as $key => $value) {
            $list_data[$value['name']] = $value['name'];
        }

        return $list_data;

        // var_dump( $this->helper->make_select_opts($list_data, null));
    }
    
    function fetch_contact($username = ''){
        $this->EE->load->model("contacts");
        
        if(!empty(self::$contact)){
            return self::$contact;
        }
        $contacts = $this->EE->contacts;
       
        if($username == ''){
            $username = $_COOKIE['my_events_user'];
        }
        if (empty($username)){
            return false;
        }
        $selects = "{#c}.id_c as id,{#c}.pract_type_c,{#c}.pract_type_nz_c,{#c}.rego_domain_c,{#c}.email_c,{#c}.prefname_c,{#c}.initial_c";
        $where = "{#c}.username_c='$username'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params); 
        
        self::$contact = $_contact;
        
        return $_contact;       
    }
    function check_user($email = ''){
        $this->EE->load->model("contacts");
        $contacts = $this->EE->contacts;
        $_email = $email;

        $selects = "{#c}.id_c as id,{#c}.prefname_c,{#c}.initial_c,{#c}.email_c,{#c}.username_c,{#c}.first_time_c,{#c}.password_c";
        $where = "{#c}.username_c='$email' or {#c}.email_c='$email'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $_contact = $contacts->get_contacts($params); 
        return $_contact;
    }
    
    function fetch_contact_by_id($id){
        $this->EE->load->model("contacts");
        
        $contacts = $this->EE->contacts;
       
        if (empty($id)){
            return false;
        }
        $selects = "{#c}.id_c as id,{#c}.pract_type_c,{#c}.pract_type_nz_c,{#c}.pract_type_other_1_c,{#c}.rego_domain_c,{#c}.email_c,{#c}.prefname_c,{#c}.initial_c";
        $where = "{#c}.id_c='$id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params); 
        
        self::$contact = $_contact;
        
        return $_contact;       
    }
    function get_pract_type_from_contact($_contact){
        switch(strtolower($_contact['rego_domain_c'])){
            case 'australia':
                return $_contact['pract_type_c'];
            break; 
            case 'new zealand':
                return $_contact['pract_type_nz_c'];
            break;                                         
            default:
                return $_contact['pract_type_other_1_c'];
        }
        return $_contact['pract_type_c'];
    }
    
    function load_cookie_registration($key, $params){
        $_event = $params['event'];
        $primary_rego_id = $params['primary_rego_id'];
        if(!empty($_COOKIE["{$key}_" . $_event['id'] . $primary_rego_id])){
            return $_COOKIE["{$key}_" . $_event['id'] . $primary_rego_id];    
        }
    }
    function set_cookie_registration($key, $value, $params){
        $_event = $params['event'];
        $primary_rego_id = $params['primary_rego_id'];

        setcookie("{$key}_" . $_event['id'] . $primary_rego_id, $value, time() + 60*60*24*5000, '/');
        $_COOKIE["{$key}_" . $_event['id'] . $primary_rego_id] = $value;
    }
    
    function save_step($_event, $value){
        $primary_rego_id = $this->EE->input->get_post("primary_rego_id");
        
        self::$utility->set_cookie_registration('step', $value, array('event' => $_event, 'primary_rego_id' => $primary_rego_id));
    }
    
    function check_register_now($event_id){
        $this->EE->load->model("cpd_eventregooptions");
        
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.end_date,{#m}.event_rego_online,{#m}.registration_url,{#c}.sold_out_c,{#c}.rego_close_date_c";
        $params['where'] = "{#m}.id='{$event_id}'";
        $params['single'] = true;
        
        $_event = $this->EE->cpd_events->get_main_data($params);
        
        $now_date = date("Y-m-d H:i:s");
        $registration_url = $this->helper->getStrippedUrl($_event['registration_url']);
        /// check conclude ///
        $concluded = false;
        if($now_date > $_event['end_date']){
            return array('concluded' => true);
        }
        //////////////////////
        
        /// check closed ///
        if($now_date < $_event['end_date'] && $_event['rego_close_date_c']){
            if($now_date >= $_event['rego_close_date_c']){
                return array('closed' => true);
            }
        }
        ////////////////////
        
        if($_event['sold_out_c'] == 1){
            return array('sold_out' => true);
        }

        if($_event['event_rego_online'] == 'External' && $_event['registration_url'] != ''){
            return array('register' => false, 'all_sold_out' => false, 'external_url' => $_event['registration_url']);
        }
        if($_event['event_rego_online'] == 'Yes'){
            /// get all dependent events ///
            $events = array();

            $this->check_register_now_sessions($event_id, $events);
            if(empty($events)){
                $this->check_register_now_days($event_id, $events);
            }
            if(empty($events)){
                $this->check_register_now_streams($event_id, $events);
            }
            $events[$_event['id']] = $_event;
            /////////////////////////////////

            $rego_options = array();
            $_selects_regooptions = "{#m}.id,{#c}.option_type_c,{#c}.accept_bookings_c,{#c}.sold_out_c";
            $params = array();
            $params['selects'] = $_selects_regooptions;
            $params['where'] = "{#c}.option_type_c='Primary'";
            foreach($events as $item){
                $params['id'] = $item['id'];
                $params['selects'] = $_selects_regooptions;
                $sold_out = '';
                if(($sold_out = $item['sold_out_c']) != null){
                    $sold_out = ($sold_out == 1 ? 'sold-out' : '');
                }
                if($_event['sold_out_c'] == 1){
                    $sold_out = 'sold-out';
                }
                $params['selects'] .= ",'{$sold_out}' as sold_out";
                $options = $this->EE->cpd_events->get_relationship_payment_matrix($params);
                $rego_options = array_merge($rego_options, $options);
            }

            $results = array();
            $params = array();
            $params['selects'] = $_selects_regooptions;
            $params['where'] = "{#c}.option_type_c='Option'";
            foreach($rego_options as $key => $item){
                if(!empty($results[$item['id']])){
                    continue;
                }
                $results[$item['id']] = $item;
                $params['id'] = $item['id'];

                $options = $this->EE->cpd_eventregooptions->get_relationship_eventregooptions($params);
                $options = $this->get_child_regos($options);

                $results = array_merge($results, $options);
            }

            $all_sold_out = false;
            if(!empty($results)){
                $all_sold_out = true;

                foreach($results as $key => $item){
                    $results[$key] = $this->set_sold_out_option($_event, $item);
                    if(in_array($results[$key]['option_type_c'], array('Primary', 'Alternate')) && $results[$key]['sold_out'] != 'sold-out'){
                        $all_sold_out = false;
                    }
                }
                $rego_options = $results;
            }

            $register = false;
            /// check register ///
            foreach($rego_options as $key => $item){
                if($item['accept_bookings_c'] == 1 && $_event['event_rego_online'] == 'Yes'){
                   $rego_options[$key]['can_register'] = 1;
                   $register = true;
                }
            }
            if($all_sold_out){
                $register = false;
            }
            //////////////////////
            if(!$register && $registration_url != ''){
                $external_url = $registration_url;
            }
        }
       
       return array('register' => $register, 'all_sold_out' => $all_sold_out, 'external_url' => $external_url); 
    }
    
    public function set_sold_out_option($_event, $option, $sparams = ''){
        $_matrix_event = $this->EE->cpd_eventregooptions->get_relationship_payment_matrix_event(array(
                                'id' => $option['id'],
                                'selects' => '{#m}.id,{#m}.event_max_attendance,{#c}.sold_out_c',
                                'single' => true
                            ));
                
        $sold_out = '';
        if($_matrix_event['sold_out_c'] == 1 || $option['sold_out_c'] == 1 || $_event['sold_out_c'] == 1){
            $sold_out = 'sold-out';    
        }
        
        /// check reserve tickets ///
        $option['reserve_tickets'] = '';
        if($sold_out != 'sold-out'){
            $option['reserve_tickets'] = $this->load_reserve_tickets($_matrix_event, $sparams);
            if(!empty($option['reserve_tickets'])){
                if($option['reserve_tickets']['status'] == 'sold-out'){
                    $sold_out = 'sold-out';    
                }
            }
        }
        /////////////////////////////
        
        $option['sold_out'] = $sold_out;
        return $option;
    }
    
    public function load_reserve_tickets($_event, $sparams = '')
    {
        if($_event == null){
            return '';
        }
        $max_tickets = $_event['event_max_attendance'];
        if($max_tickets == ''){
            return '';
        }        
        $this->EE->load->model('reserve_tickets');
        
        $data = array();
        
        /// get sold tickets ///
        $sold_tickets = $this->EE->cpd_events->get_relationship_cpdactivity(array(
                                'id' => $_event['id'],
                                'selects' => "{#m}.id",
                                'where' => "{#m}.status IN('4PaymentAccepted','3PaymentEntered','6RegistrationAccepted','3aRegistrationRequested')"
                            ));
        ////////////////////////
        
        $reserve_tickets = $this->EE->reserve_tickets->load($_event['id']);
        if($sparams['exclude_cookie_reserve_ticket'] === true){
            $cookie = $sparams['cookie'];
            $excl_ids = array($cookie['id_for_master']);
            $excl_ids = array_merge($excl_ids, $cookie['ids_for_add_registrants']);
            $excl_ids = array_merge($excl_ids, $cookie['ids_for_options']);
            
            $result = array();
            foreach($reserve_tickets as $item){
                if(in_array($item['id'], $excl_ids)){
                    continue;
                }    
                $result[] = $item;
            }
            $reserve_tickets = $result;
        }
        
        $data['list'] = $reserve_tickets;
        $data['remains_exclude_reserved'] = $max_tickets * 1 - count($sold_tickets);
        $data['remains'] = $max_tickets * 1 - count($sold_tickets) - count($reserve_tickets);
        $data['max'] = $max_tickets;
        
        $status = '';
        if($data['remains_exclude_reserved'] <= 0){
            $status = 'sold-out';
        }else if($data['remains'] <= 0){
            $status = 'unavailable';
        }
        $data['status'] = $status;
        
        return $data;
    } 
    
    public function add_reserve_ticket($_event, $rego_id, $sparams = '')
    {
        $this->EE->load->model('reserve_tickets');
        $reserve_ticket = $this->EE->reserve_tickets->add(
                    $_event['id'],
                    $rego_id,
                    $_event['rego_time_limit_c'],
                    $sparams
                );
        
        return $reserve_ticket;        
    }
    public function get_reserve_ticket($reserve_id)
    {
        $this->EE->load->model('reserve_tickets');
        $reserve_ticket = $this->EE->reserve_tickets->loadById(
                   $reserve_id 
                );
        
        if($reserve_ticket != null){
            $expired_at = strtotime($reserve_ticket['expired_at']);
            if($expired_at <= time()){
                $this->EE->reserve_tickets->remove($reserve_id);                
                return '';
            }
        }
        
        return $reserve_ticket;
    }
    
    function reset_reserve_ticket($event, $rego_id)
    {
        $result = $this->load_cookie_reserve_ticket(
                    $event, $rego_id
                );
        $list = array($result['id_for_master']);
        $list = array_merge($list, $result['ids_for_add_registrants']);
        $list = array_merge($list, $result['ids_for_options']);
        
        foreach($list as $id){
            $this->EE->reserve_tickets->remove($id);   
        }
        
        $this->set_cookie_registration(
                    'reserve_ticket',
                    '',
                    array('event' => $event, 'primary_rego_id' => $rego_id)
                );
    }
    
    public function load_cookie_reserve_ticket($event, $rego_id)
    {    
        $result = $this->load_cookie_registration(
                    'reserve_ticket',
                    array('event' => $event, 'primary_rego_id' => $rego_id)
                );
        if($result != ''){
            $result = unserialize($result);
        }else{
            $result = array();
        }           
        
        $default = array(
                        'id_for_master' => '',
                        'ids_for_add_registrants' => array(),
                        'ids_for_options' => array(),
                    );
        
        return array_merge($default, $result);
    }
    
    public function save_cookie_reserve_ticket($event, $rego_id, $data)
    {
        $cookie = $this->load_cookie_reserve_ticket($event, $rego_id); 
        $key = $data['key'];
        $value = $data['value'];
        
        if(is_array($value)){
            $cookie[$key] = array_merge($cookie[$key], $value);
        }else{
            if(is_array($cookie[$key])){
                $cookie[$key] = array_merge($cookie[$key], array($value));
            }else{
                $cookie[$key] = $value;    
            }                                      
        }   
        
        $result = serialize($cookie);
        
        $this->set_cookie_registration(
                    'reserve_ticket',
                    $result,
                    array('event' => $event, 'primary_rego_id' => $rego_id)
                );
        return $cookie;
    }   
  
    function get_child_regos($rego_options){
        $_selects_regooptions = "{#m}.id,{#c}.option_type_c,{#c}.accept_bookings_c,{#c}.sold_out_c";
        
        $results = array();
        $params = array();
        $params['selects'] = $_selects_regooptions;      
        $params['where'] = "{#c}.option_type_c='Option'";
        $params['orders'] = "{#c}.sequence_c asc";
        foreach($rego_options as $key => $item){
            if(!empty($results[$item['id']])){
                continue;
            }
            $results[$item['id']] = $item;
            $params['id'] = $item['id'];

            $options = $this->EE->cpd_eventregooptions->get_relationship_eventregooptions($params);
            foreach($options as $key1 => $item1){
                $options[$key1]['parent'] = $item['id'];
            }
            $results = array_merge($results, $options);
        }
        
        return $results;
    }
    
    function check_register_now_sessions($parent_id, &$events){
        $params = array();
        $params['id'] = $parent_id;
        $params['selects'] = "{#m}.id,{#c}.sold_out_c";
        $params['where'] = "{#c}.rec_type_c IN('Session','Break')";
        $sessions = $this->EE->cpd_events->get_relationship_streams_sessions($params);
        foreach($sessions as $item){
            $key = $item['id'];
            $events[$key] = $item;
        }
        
        return $sessions;
    }
    
    function check_register_now_days($parent_id, &$events){
        $params = array();
        $params['id'] = $parent_id;
        $params['selects'] = "{#m}.id,{#c}.sold_out_c";
        $params['where'] = "{#c}.rec_type_c='Day'";
        $days = $this->EE->cpd_events->get_relationship_streams_sessions($params);
        
        foreach($days as $item){
            $key = $item['id'];
            $events[$key] = $item;
            
            $this->check_register_now_sessions($item['id'], $events);
        }
        
        return $days;
    }
    
    function check_already_register($event_id, $contact_id, $rego_id){
        $registered = "";
        
        $params = array();
        $params['id'] = $contact_id;
        $params['selects'] = "{#m}.id";
        $params['where'] = "{#m}.status IN('3PaymentEntered','3aRegistrationRequested', '4PaymentAccepted', '6RegistrationAccepted')";
        $activity = $this->EE->contacts->get_relationship_cpdactivity($params);
        
        foreach($activity as $act){
            $params = array();
            $params['id'] = $act['id'];
            $params['selects'] = "{#m}.id";
            $params['single'] = true;
            $_event = $this->EE->cpd_activity->get_relationship_cpd_eventregooptions($params);
            if($_event['id'] == $rego_id){
                $registered = $act['id'];
                break;
            }
        }

        return $registered;
    }

    function check_already_register_by_act($act_id){
        $status = array('3PaymentEntered', '3aRegistrationRequested', '4PaymentAccepted', '6RegistrationAccepted');
        $params = array();
        $params['selects'] = "{#m}.id, {#m}.status, {#c}.paid_option_c";
        $params['where'] = "{#m}.id='{$act_id}'";
        $params['single'] = true;

        $registered_act = $this->EE->cpd_activity->get_main_data($params);
        
        if(empty($registered_act)){
            return false;
        }else{
            if(in_array($registered_act['status'], $status)){
                return true;
            }else{
                return false;
            }
        }
    }

    function check_register_now_streams($parent_id, &$events){
        $params = array();
        $params['id'] = $parent_id;
        $params['selects'] = "{#m}.id,{#c}.sold_out_c";
        $params['where'] = "{#c}.rec_type_c='Stream'";
        $streams = $this->EE->cpd_events->get_relationship_streams_sessions($params);
        
        foreach($streams as $item){
            $key = $item['id'];
            $events[$key] = $item;
            
            $this->check_register_now_days($item['id'], $events);
        }
        
        return $streams;
    }

    function filter_events($events_box = array()){
        $box_size = count($events_box);        
        $events_ids = array();
        $filtered_ids = array();
        $filtered_events = array();
        
        foreach($events_box as $box){
            $box_ids = array();
            foreach($box as $event){
                $box_ids[] = $event['id'];
            }
            $events_ids[] = $box_ids;
        }



        foreach($events_ids[0] as $event_id){
            $temp_id = '';
            for($i = 1;$i < $box_size; $i++){
                if(in_array($event_id, $events_ids[$i])){
                    $temp_id = $event_id;
                }else{
                    $temp_id = '';
                    break;
                }
            }    
  
            if(!empty($temp_id)){
                $filtered_ids[] = $temp_id;
            }               
        } 



        if(!empty($filtered_ids)){
            foreach($filtered_ids as $_id){
                $_event = $this->EE->cpd_events->get_main_data(array(
                            'selects' => "{#m}.id,{#m}.start_date,{#m}.end_date,{#m}.name,{#m}.event_theme,{#m}.description,{#m}.event_city,{#m}.event_country,{#m}.listing_type,{#m}.event_banner,{#m}.event_rego_online,{#m}.event_url,{#m}.registration_url,{#m}.event_format,{#c}.event_options_c,{#c}.event_id_c,{#c}.cpd_points_total_c,{#c}.event_banner_url_c",
                            'where' => "{#m}.id='$_id'",
                            'single' => true
                        ));
                $filtered_events[] = $_event;
    
            }
            return $filtered_events;
        }else{
            return false;
        }
    }
    function filter_events_forid($events_box = array()){
        $box_size = count($events_box);        
        $events_ids = array();
        $filtered_ids = array();
        $filtered_events = array();



        
        foreach($events_box as $box){
            $box_ids = array();

            foreach($box as $event){
                $box_ids[] = $event['id'];
            }
            $events_ids[] = $box_ids;
        }
        

        foreach($events_ids as $event_id){
            $temp_id = '';
            for($i = 1;$i < $box_size; $i++){

                // var_dump($event_id);var_dump($events_ids[$i]);
                if(in_array($event_id, $events_ids[$i])){
                    $temp_id = $event_id;
                }else{
                    $temp_id = '';
                    break;
                }
            }    
  
            if(!empty($temp_id)){
                $filtered_ids[] = $temp_id;
            }               
        } 
       
        // $filtered_ids = $events_ids;

        // $filtered_ids[] = "509cb45a-2232-11ea-ba97-d29e7ee95453";
        // $filtered_ids[] = "03095d7e-2232-11ea-83d1-3ba2e2fbb03d";
         // var_dump($filtered_ids);
        if(!empty($filtered_ids)){
            foreach($filtered_ids as $_id){
                $_event = $this->EE->cpd_events->get_main_data(array(
                            'selects' => "{#m}.id,{#m}.start_date,{#m}.end_date,{#m}.name,{#m}.event_theme,{#m}.description,{#m}.event_city,{#m}.event_country,{#m}.listing_type,{#m}.event_banner,{#m}.event_rego_online,{#m}.event_url,{#m}.registration_url,{#c}.event_options_c,{#c}.event_id_c",
                            'where' => "{#m}.id='$_id'"
                        ));
                // var_dump($_event);
                // $datSomething = strtotime($_event['start_date']);                     

                    // $y = date("Y", $datSomething ) ; 
                    // $m = date("m", $datSomething); 
                    // $d = date("d", $datSomething); 
                    // $_event['start_date']['y'] = $y;
                    // $_event['start_date']['d'] = $d;
                    // $_event['start_date']['m'] = $m;

                $filtered_events[] = $_event;
    
            }
            

            return $filtered_events;
        }else{

            return false;
        }
    }

    public function get_principal_act($act_id){

        $act = $this->EE->cpd_activity->get_relationship_related_cpdactivity_core(array(
                        'id' => $act_id,
                        'selects' => "{#m}.id",
                        'single' => true
                    ));
        if(!empty($act)){
            $act_id = $act['id'];
        }
        $primary_act = $this->EE->cpd_activity->get_relationship_transactions_cpdactivity_principal(array(
                    'id' => $act_id,
                    'selects' => "{#m}.id",
                    'single' => true
                ));
        if(!empty($primary_act)){
            return $primary_act['id'];
        }
                     
        return $act_id;
    }

    public function get_registrants_from_acts($acts){
        $registrants = array();

        foreach ($acts as $key => $item) {
            $registrant = $this->EE->cpd_activity->get_relationship_contacts(array(   
                                        'id' => $item,
                                        'selects' => "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name, {#m}.alt_address_street, {#m}.alt_address_city, {#m}.alt_address_state, {#m}.alt_address_postalcode, {#m}.alt_address_country, {#c}.email_c",
                                        'single' => true
                                    ));
            $email = $registrant['email_c'];
            $registrants[$email] = array('id' => $registrant['id'], 
                                'salutation' => $registrant['salutation'],
                                'first_name' => $registrant['first_name'],
                                'last_name' => $registrant['last_name'],
                                'act_id' => $item
                                );
        }

        return $registrants;
    }
}