<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class MLOGProcessing_Logger extends MLOGProcessing{
   static $enables;
   static $root_path;
   
   protected $log_records;
   
   function initialize($params=''){
      self::$enables = $this->_app_config['logger']['enables'];
      self::$root_path = BASE_WEB_PATH . '/' . $this->_app_config['logger']['root_path'];
   } 
   function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "file":
                return $this->process_file($params);
                break;
            break;    
            case "sugar":
                return $this->process_sugar($params);
                break;
            break;
        }
   }
   
   function process_file($params = array()){
        $code = $params['code'];
        $ids = $params['ids'];
       
        $filename = self::$root_path . "/". $code . ".log";
        $delimiter = PHP_EOL;
        $content = implode($delimiter, $ids) . $delimiter;
        // Let's make sure the file exists and is writable first.
        if (is_writable(self::$root_path)) {

            // In our code we're opening $filename in append mode.
            // The file pointer is at the bottom of the file hence
            // that's where $somecontent will go when we fwrite() it.
            if (!$handle = fopen($filename, 'a')) {
                 $this->logger->developer("Cannot open file ($filename)");
                 return false;
            }

            // Write $somecontent to our opened file.
            if (fwrite($handle, $content) === FALSE) {
                $this->logger->developer("Cannot write to file ($filename)");
                return false;
            }

            fclose($handle);

        } else {
            $this->logger->developer("The file $filename is not writable");
            return false;
        }

   }
   
   function process_sugar($params = array()){
       foreach(self::$enables as $code => $item){
           if($item != 1){
               continue;
           }
           $class = $code;
           $class = str_replace("_", " ", $class);
           $class = ucwords($class);
           $class = str_replace(" ", "", $class);
           $class = "MLOGProcessing_Logger_{$class}";
           
           $filename = PATH_THIRD . "mlogger/models/logger/{$code}.php";
           if(file_exists($filename)){
               require_once($filename);
               if(class_exists($class)){
                  $processing = new $class();
                  $processing->initialize(array('code' => $code));      
                  $processing->process(array('code' => $code));      
               }
           } 
       }
   }
}