<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class MLOGProcessing_Logger_SearchContacts extends MLOGProcessing_Logger{
   protected $filename;
   
   function initialize($params = ''){
        $code = $params['code'];
        $filename = self::$root_path . "/". $code . ".log";
        $this->filename = $filename;
        $this->log_records = self::$utility->fetch_log_records($filename);    
   } 
   function process($params = array()){
        $this->EE->load->model("contact_hits");
        
        $now_date = new DateTime();
        $now_month = $now_date->format("m");
        $now_year = $now_date->format("Y");
        
        $datas = array();
        $link_datas = array();
        $link_contact_ids = array();
        
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.schresult";
        $params['where'] = "{#m}.month='$now_month' and {#m}.year='$now_year'";
        $params['single'] = true;
        foreach($this->log_records as $id => $_increase){
            /// account main data ///
            $_contact = $this->EE->contacts->get_main_data(array(
                                    'selects' => "{#m}.first_name,{#m}.last_name",
                                    'where' => "{#m}.id='{$id}'",
                                    'single' => true
                                ));
            if(empty($_contact)){
                continue;
            }
            /////////////////////////
            
            $params['id'] = $id;
            $_hit = $this->EE->contacts->get_relationship_contacthits($params);   
            if(empty($_hit)){
                 $name = "{$_contact['first_name']} {$_contact['last_name']}";
                 $link_datas[] = array('name' => $name, 'month' => $now_month, 'year' => $now_year, 'schresult' => $_increase);
                 $link_contact_ids[] = $id;
            }else{
                 $schresult = $_hit['schresult'] * 1 + $_increase;
                 $_hit['schresult'] = $schresult;
                 $datas[] = $_hit;    
            }
        }
        
        /// UPDATE contact_hits ///
        if(!empty($datas)){
            $success = $this->EE->contact_hits->set_records($datas);
            if(!$success){
                $this->logger->developer("Failed to update the contact hits.");
                return false;
            }    
        } 
        ///////////////////////////
        
        /// CREATE contact_hits and linke those ///
        if(!empty($link_datas)){
            $success = $this->EE->contact_hits->set_records($link_datas);
            if(!$success){
                $this->logger->developer("Failed to create the contact hits.");
                return false;
            }
            $ids = $success;
            $success = $this->EE->contacts->add_relationships_app($link_contact_ids, $ids, 'contact_hits');    
            if(!$success){
                $this->logger->developer("Failed to add the contact hits links.");
                return false;
            }
        }
        /////////////////////////// 
        
        self::$utility->clean_log_records($this->filename);    
   }
}