<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class MLOGProcessing_Logger_SearchEvents extends MLOGProcessing_Logger{
   protected $filename;
   
   function initialize($params = ''){
        $code = $params['code'];
        $filename = self::$root_path . "/". $code . ".log";
        $this->filename = $filename;
        $this->log_records = self::$utility->fetch_log_records($filename);    
   } 
   function process($params = array()){
        $this->EE->load->model("general_hits");     
        $this->EE->load->model("cpd_events");
        
        $now_date = new DateTime();
        $now_month = $now_date->format("m");
        $now_year = $now_date->format("Y");
        
        $datas = array();
        $link_datas = array();
        $link_event_ids = array();
        
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.schresult";
        $params['where'] = "{#m}.month='$now_month' and {#m}.year='$now_year'";
        $params['single'] = true;
        foreach($this->log_records as $id => $_increase){
            
            /// event main data ///
            $_event = $this->EE->cpd_events->get_main_data(array(
                                    'selects' => "{#m}.name",
                                    'where' => "{#m}.id='{$id}'",
                                    'single' => true
                                ));
            if(empty($_event)){
                continue;
            }
            ////////////////////////
            
            $params['id'] = $id;
            $_hit = $this->EE->cpd_events->get_relationship_hits($params);   
            if(empty($_hit)){
                 $link_datas[] = array('name' => $_event['name'], 'month' => $now_month, 'year' => $now_year, 'schresult' => $_increase);
                 $link_event_ids[] = $id;
            }else{
                 $schresult = $_hit['schresult'] * 1 + $_increase;
                 $_hit['schresult'] = $schresult;
                 $datas[] = $_hit;
            }
        }
        
        /// UPDATE general_hits ///
        if(!empty($datas)){
            $success = $this->EE->general_hits->set_records($datas);
            if(!$success){
                $this->logger->developer("Failed to update the general hits.");
                return false;
            }    
        } 
        ///////////////////////////
        
        /// CREATE general_hits and link those ///
        if(!empty($link_datas)){
            $success = $this->EE->general_hits->set_records($link_datas);
            if(!$success){
                $this->logger->developer("Failed to create the general hits.");
                return false;
            }
            $ids = $success;
            
            $success = $this->EE->cpd_events->add_relationships_app($link_event_ids, $ids, 'general_hits');    
            /*foreach($link_account_ids as $key => $id){
                $this->EE->accounts->add_relationship_app($id, $ids[$key], 'account_hits');    
            } */
        }
        /////////////////////////// 
        
        self::$utility->clean_log_records($this->filename);    
   }
}