<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class MLOGProcessing{
    
    protected $EE = '';
    protected $contacts;
    protected $helper;
    protected $output_helper;
    protected $seo_helper;
    protected $tasks;
    protected $logger;
    protected $_crm_config = '';
    protected $_app_config = '';
    
    public static $utility = null;
    public static $router = null;
    
    function __construct(){
        
        $this->EE =& get_instance();
        $this->EE->load->model('contacts');
        $this->contacts = $this->EE->contacts;
        
        $this->EE->load->library('logger');
        $this->logger = $this->EE->logger;
        
        $this->EE->load->helper('data');
        $this->helper = new Data_Helper();
        
        $this->EE->load->helper("output");
        $this->output_helper = new Output_Helper();
        
        $this->EE->load->helper('seo');
        $this->seo_helper = new Seo_Helper();
        
        $this->_crm_config = $this->EE->config->item('crm');
        
        $this->_app_config = $this->EE->config->item('app');
        $this->_app_config['skin_url'] = $this->EE->config->item('theme_folder_url') . "site_themes/dentist/skin/";
        
        $this->EE->load->model('tasks');
        $this->tasks = $this->EE->tasks;
        $this->EE->load->library('template', NULL, 'TMPL');
        
        if (self::$utility == null){
           require_once(PATH_THIRD . 'mlogger/models/utility.php');
           self::$utility = new MLOGProcessing_Utility();
       }
    }
    
    function initialize($cmd=''){
        if (empty($cmd))
          $cmd = $this->EE->input->get_post("cmd");
        if (empty($cmd))
          $cmd = $this->EE->TMPL->fetch_param('cmd');
        self::$router = $cmd;
    } 
   
    function process($params = ''){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "logger":
                require_once(PATH_THIRD . 'mlogger/models/logger.php');
                $processing = new MLOGProcessing_Logger();
                $processing->initialize($params);
                return $processing->process($params);
            break;    
            default:
            break;
        }
    }
}