<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class MLOGProcessing_Utility extends MLOGProcessing{
    function __construct(){
        self::$utility = $this;
        parent::__construct();

    }
    
    function fetch_router(){
        $router = self::$router;
        
        $routers = explode(":", $router);
        
        $cmd = $routers[0];
        $routers = array_slice($routers, 1);
        $router = implode(":", $routers);
        
        self::$router = $router;
        
        return $cmd;
    }
    
    function fetch_log_records($filename){
        $handle = @fopen($filename, "r");
        
        $log_records = array();
        if ($handle) {
            while (($buffer = fgets($handle)) !== false) {
               if(empty($buffer)){
                   continue;
               }
               $buffer = trim($buffer, PHP_EOL); 
               if(empty($buffer)){
                   continue;
               }
               if(!empty($log_records[$buffer])){
                   $count = $log_records[$buffer] * 1;
                   $count++;
                   $log_records[$buffer] = $count;
               }else{
                   $log_records[$buffer] = 1;
               } 
            }
            if (!feof($handle)) {
                $this->logger->developer("Error: unexpected fgets() fail");
                return false;
            }
            fclose($handle);
        }
        
        return $log_records;
    }
    
    function clean_log_records($filename){
        $handle = fopen($filename, "w+");
        fwrite($handle , '');
        fclose($handle);
    }
}