<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class PTSProcessing_Payments_Account extends PTSProcessing_Payments{
 
    protected $code = 'account';
    protected $title = 'Pay On {account} Account';

    function initialize($params = array()){
        $this->EE->load->model("accounts");
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "show":
                return $this->show($params);
            break;
            case "bill":
                return $this->bill($params);
            break;
        }
    }
    
    function show($params = array()){
        $payment = $this->EE->input->get_post("payment");
        $event_id_c = $this->EE->input->get_post("id");

        ////// fetch event////
        $params =array();
        $params['selects'] = "{#m}.id,{#m}.name,{#c}.account_heading_override_c,{#c}.account_text_override_c";
        $params['where'] = "{#c}.event_id_c = '$event_id_c'";
        $params['single'] = true;
        
        $_event = $this->EE->cpd_events->get_main_data($params);

        /// fetch account ///
        $params = array();
        $params['id'] = $_event['id'];
        $params['selects'] = "{#m}.id,{#m}.name";
        $params['single'] = true;
       
        $account = $this->EE->cpd_events->get_relationship_organiser($params);
        ///////////////
        $accountText = '';
        if ($_event['account_text_override_c'] != '') {
            $accountText = $_event['account_text_override_c'];
        }
        if(empty($payment)){
            $payment = array('account_name' => '', 'account_number' => '');
        }
        
        $form_template = "form_{$this->code}";
        $swaps = array(
                    'code' => 'code',
                    'pt' => 'pt',
                    'account' => 'account',
                    'account_text' => 'account_text'
                 );
        $datas = array(
                    'code' => $this->code,
                    'pt' => $payment,
                    'account' => $account,
                    'account_text' => $accountText
                 );
        
        $TMPL = new EE_Template();         
        $TMPL->run_template_engine('payments', $form_template);
        $form = $this->EE->output->app_output($swaps, $datas, array('output' => false));

        if ($_event['account_heading_override_c'] != '') {
            $title = $_event['account_heading_override_c'];
        } else {
            $title = str_replace("{account}", $account['name'], $this->title);
        }
        return array('code' => $this->code, 'title' => $title, 'form' => $form);
    }
    
    function bill($params = array()){
        $amount = $params['amount'];
        $amount = round($amount * 100);
        
        $payment = $this->EE->input->get_post("payment");

        $result = "success";
        $msg = "";
        
        return array('code' => $result, 'msg' => $msg, 'trxn_number' => '', 'payment' => $payment);
    }
    
    function get_ccv_infos($params){
        $sel_month = $params['month'];
        $sel_year = $params['year'];
        
        $months_value = array('01','02','03','04','05','06','07','08','09', '10', '11', '12');
        $months_label = array('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
        $months = array_combine($months_value, $months_label);
        foreach($months as $key => $value){
            $months[$key] = "$key - $value";
        }
        
        $months_opts = $this->helper->make_select_opts($months, $sel_month);
        
        $first_year = date('Y') * 1 - 2000;
        $years = array();
        for($i = 0; $i <= 10; $i++){
           $years[$first_year + $i] = 2000 + $first_year + $i; 
        }
        $years_opts = $this->helper->make_select_opts($years, $sel_year);
        
        return array('months' => $months_opts, 'years' => $years_opts);
    }
}