<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class PTSProcessing_Payments_Capture extends PTSProcessing_Payments{
 
    protected $code = 'capture';
    protected $title = 'Pay With a Debit Or Credit Card';

    function initialize($params = array()){
        $this->EE->load->model("accounts");
        $this->EE->load->model("cpd_events");
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "show":
                return $this->show($params);
            break;
            case "bill":
                return $this->bill($params);
            break;
        }
    }
    
    function show($params = array()){
        $payment = $this->EE->input->get_post("payment");
        $event_id_c = $this->EE->input->get_post("id");
        $accept_cards = $params['accept_cards'];
        
        $payment_type = "";
        ////// fetch event////
        $params =array();
        $params['selects'] = "{#m}.id, {#m}.name, {#c}.payment_types_accepted_c";
        $params['where'] = "{#c}.event_id_c = '$event_id_c'";
        $params['single'] = true;
        
        $_event = $this->EE->cpd_events->get_main_data($params);
        $_event['payment_types'] = trim($_event['payment_types_accepted_c'], "^");
        if($_event['payment_types'] != ''){
            $_event['payment_types'] = explode("^,^", $_event['payment_types']);
        }
        if(in_array('account', $_event['payment_types'])){
            $payment_type = "account";    
        }
        /// fetch account ///
        $params = array();
        $params['id'] = $_event['id'];
        $params['selects'] = "{#m}.id,{#m}.name";
        $params['single'] = true;
       
        $account = $this->EE->cpd_events->get_relationship_organiser($params);
        ///////////////
        
        if(empty($payment)){
            $payment = array('cc_holder_name' => '', 'cc_number' => '', 'cc_type' => '', 'cc_exp_month' => '', 'cc_exp_year' => '', 'cc_cid' => '');
        }        
        
        $ccv_info = $this->get_ccv_infos(
                array('month' => $payment['cc_exp_month'], 'year' => $payment['cc_exp_year'])
            );
        
        $form_template = "form_{$this->code}";
        $swaps = array(
                    'code' => 'code',
                    'ccv_info' => 'ccv_info',
                    'pt' => 'pt', 
                    'accept_cards' => 'accept_cards',
                    'json_accept_cards' => 'json_accept_cards',
                    'account' => 'account',
                    'payment_type' => 'payment_type'
                 );
        $datas = array(
                    'code' => $this->code,
                    'ccv_info' => $ccv_info,
                    'pt' => $payment,
                    'accept_cards' => $accept_cards,
                    'json_accept_cards' => json_encode($accept_cards),
                    'account' => $account,
                    'payment_type' => $payment_type
                 );
        
        $TMPL = new EE_Template();         
        $TMPL->run_template_engine('payments', $form_template);
        $form = $this->EE->output->app_output($swaps, $datas, array('output' => false));
        
        return array('code' => $this->code, 'title' => $this->title, 'form' => $form);
    }
    
    function bill($params = array()){
        $amount = $params['amount'];
        $amount = round($amount * 100);
        
        $payment = $this->EE->input->get_post("payment");

        if(!$this->LuhnCheck($payment['cc_number'])){
            $result = "fail";
            $msg = "Invalid card number.";
        }else{
            $result = "success";    
            $msg = "";
        }
        
        return array('code' => $result, 'msg' => $msg, 'trxn_number' => '', 'payment' => $payment);
    }
    
    function LuhnCheck($number){
        $checksum = 0;
        for ($i=(2-(strlen($number) % 2)); $i<=strlen($number); $i+=2) {
            $checksum += (int) ($number{$i-1});
        }
        // Analyze odd digits in even length strings or even digits in odd length strings.
        for ($i=(strlen($number)% 2) + 1; $i<strlen($number); $i+=2) {
            $digit = (int) ($number{$i-1}) * 2;
            if ($digit < 10) {
                $checksum += $digit;
            } else {
                $checksum += ($digit-9);
            }
        }
        if (($checksum % 10) == 0) {
            return true;
        } else {
            return false;
        }
    }

    function get_ccv_infos($params){
        $sel_month = $params['month'];
        $sel_year = $params['year'];
        
        $months_value = array('01','02','03','04','05','06','07','08','09', '10', '11', '12');
        $months_label = array('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
        $months = array_combine($months_value, $months_label);
        foreach($months as $key => $value){
            $months[$key] = "$key - $value";
        }
        
        $months_opts = $this->helper->make_select_opts($months, $sel_month);
        
        $first_year = date('Y') * 1 - 2000;
        $years = array();
        for($i = 0; $i <= 10; $i++){
           $years[$first_year + $i] = 2000 + $first_year + $i; 
        }
        $years_opts = $this->helper->make_select_opts($years, $sel_year);
        
        return array('months' => $months_opts, 'years' => $years_opts);
    }
}