<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class PTSProcessing_Payments_Eway extends PTSProcessing_Payments{

    const COOKIE_KEY_EWAY_ACCESS_CODE = 'eway_access_code';

    protected $code = 'eway';
    protected $title = 'Pay With Eway';
    protected $paypal = '';
    protected $accessCode = '';
    static $p_type;
    static $p_account;

    function initialize($params = array()){
        $this->EE->load->model("accounts");
        $this->EE->load->model("cpd_events");

        $event_id_c = $this->EE->input->get_post("id");

        $params =array();
        $params['selects'] = "{#m}.id, {#m}.name, {#c}.payment_types_accepted_c";
        $params['where'] = "{#c}.event_id_c = '$event_id_c'";
        $params['single'] = true;

        $_event = $this->EE->cpd_events->get_main_data($params);
        $_event['payment_types'] = trim($_event['payment_types_accepted_c'], "^");
        if($_event['payment_types'] != ''){
            $_event['payment_types'] = explode("^,^", $_event['payment_types']);
        }
        if(in_array('account', $_event['payment_types'])){
            self::$p_type = "account";
        }
        else{
            self::$p_type = "eway";
        }

        //// fetch account /////
        $params = array();
        $params['id'] = $_event['id'];
        $params['selects'] = "{#m}.id,{#m}.name,{#c}.eway_rapid_api_key_c,{#c}.eway_rapid_api_key_pw_c,{#c}.eway_client_side_key_c";
        $params['single'] = true;

        self::$p_account = $this->EE->cpd_events->get_relationship_organiser($params);
        /////////////

        require_once (PATH_THIRD . "payments/models/gateways/eway/lib/eway-rapid-php-master/include_eway.php");
        /*$apiKey = self::$p_account['eway_rapid_api_key_c'];
        $apiPassword = self::$p_account['eway_rapid_api_key_pw_c'];*/
        $apiKey = "F9802CPI85zrWVu/tAYVArY+dYZ+DNy3Ny5SKitRLutV68lR6ETdlSUiUoA1e5ELJ9Mnjm";
        $apiPassword = "LjSKJCJX";
        $apiEndpoint = 'production';
        //$this->eway = \Eway\Rapid::createClient($apiKey, $apiPassword, $apiEndpoint);
        $this->eway = \Eway\Rapid::createClient($apiKey, $apiPassword);
        $this->accessCode = $this->EE->input->get('AccessCode');
        if ($this->accessCode == '') {
            $this->accessCode = $this->EE->session->flashdata(self::COOKIE_KEY_EWAY_ACCESS_CODE);
        }
        $this->EE->session->set_flashdata(self::COOKIE_KEY_EWAY_ACCESS_CODE, $this->accessCode);
    }

    function process($params = array()){
        $cmd = self::$utility->fetch_router();

        switch($cmd){
            case "show":
                return $this->show($params);
                break;
            case "bill":
                return $this->bill($params);
                break;
        }
    }

    function show($params = array()){
        $config = $params['additional'];
        $form_template = "form_{$this->code}";

        $swaps = array(
            'code' => 'code',
            'payment_type' => 'payment_type',
            'account' => 'account',
            'config' => 'config'
        );
        $datas = array(
            'code' => $this->code,
            'payment_type' => self::$p_type,
            'account' => self::$p_account,
            'config' => $config
        );

        $TMPL = new EE_Template();
        $TMPL->run_template_engine('payments', $form_template);
        $form = $this->EE->output->app_output($swaps, $datas, array('output' => false));

        return array('code' => $this->code, 'title' => $this->title, 'form' => $form);
    }

    public function bill($sparams = array())
    {
        $stage = $sparams['stage'];

        switch($stage){
            case 'start':
                return $this->start($sparams);
                break;
            case 'pay':
                return $this->pay($sparams);
                break;
            case 'do_payment':
                return $this->do_payment($sparams);
                break;
        }
    }

    protected function getSharedPaymentUrl($params = array())
    {
        $amount = $params['amount'];
        $amount = round($amount * 100);

        $payment = $this->EE->input->get_post("payment");
        $eway_card_number = $this->EE->input->get_post("eway_card_number");
        $eway_card_cvn = $this->EE->input->get_post("eway_card_cvn");

        $eway = $this->eway;
        $info = $params['info'];

        ///// filter invoice desc & street/////
        $info['invoice_desc'] = substr($info['invoice_desc'], 0, 60);
        if(strlen($info['invoice_desc']) >= 60){
            $info['invoice_desc'] = $info['invoice_desc'] . "...";
        }

        $info['street'] = substr($info['street'], 0, 45);
        if(strlen($info['street']) >= 45){
            $info['street'] = $info['street'] . "...";
        }

        $markflow = $params['markflow'];
        //////
        $transaction = array(
            'Customer' => array(
                'Title' => $info['salutation'],
                'FirstName' => $info['firstname'],
                'LastName' => $info['lastname'],
                'Street1' => $info['street'],
                'City' => $info['city'],
                'State' => $info['state'],
                'PostalCode' => $info['postcode'],
                'Country' => 'au',
                'Email' => $info['email'],
            ),
            'Payment' => array(
                'TotalAmount' => $amount,
                'InvoiceNumber' => $info['invoice_number'],
                'InvoiceDescription' => $info['invoice_desc'],
                'InvoiceReference' => $info['invoice_ref'],
                'CurrencyCode' => $info['currency'],
            ),
            'TransactionType' => \Eway\Rapid\Enum\TransactionType::PURCHASE,
            'Capture' => true,
            'RedirectUrl' => $markflow['return_url'],
            'CancelUrl' => $markflow['cancel_url'],
            'HeaderText' => $this->title,
            'CustomerReadOnly' => true,
            'Language' => 'EN'
        );


        return $eway->createTransaction(\Eway\Rapid\Enum\ApiMethod::RESPONSIVE_SHARED, $transaction);
    }

    public function start($sparams = array())
    {
        $response = $this->getSharedPaymentUrl($sparams);
        if (!$response->getErrors()) {
            // Redirect to the Responsive Shared Page
            $this->accessCode = $response->AccessCode;
            $this->EE->session->set_flashdata(self::COOKIE_KEY_EWAY_ACCESS_CODE, $this->accessCode);
            return array('result' => 'success', 'url' => $response->SharedPaymentUrl);
        } else {
            $messages = array();
            foreach ($response->getErrors() as $error) {
                $messages[] = "Error: ".\Eway\Rapid::getMessage($error);
            }
            return array('result' => 'fail', 'msg' => $messages);
        }
    }
    public function pay($sparams = array())
    {
        if ($this->accessCode == '') {
            return array('code' => 'fail', 'error' => 'No Access Code');
        }

        $transactionResponse  = $this->eway
            ->queryAccessCode($this->accessCode);

        if ($transactionResponse->TransactionStatus) {
            $transactionID = $transactionResponse->TransactionID;
        } else {
            $msg = '';
            $errors = explode(',', $transactionResponse->ResponseMessage);
            foreach ($errors as $error) {
                $msg .= "Payment failed: ".\Eway\Rapid::getMessage(trim($error));
            }
            return array(
                'code' => 'fail',
                'msg' => $msg
            );
        }
        return array(
            'code' => 'success',
            'msg' => "Payment successful! ID: {$transactionID}",
            'transaction_id' => $transactionID
        );
    }
}