<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class PTSProcessing_Payments_Eway extends PTSProcessing_Payments{
 
    protected $code = 'eway';
    protected $title = 'Eway Payment';
    protected $eway = '';
    static $p_type;
    static $p_account;
    function initialize($params = array()){
        require_once (PATH_THIRD . "payments/models/gateways/eway/lib/eway_payment.php");
        //$this->eway = $eway = new EwayPayment( '87654321', 'https://www.eway.com.au/gateway_cvn/xmltest/testpage.asp' );
        //$this->eway = $eway = new EwayPayment( '87654321', 'https://api.sandbox.ewaypayments.com/gateway/Xml/CvnXmlPaymentRequestHandler.ashx' );
        $this->eway = $eway = new EwayPayment( '14168478', 'https://www.eway.com.au/gateway_cvn/xmlpayment.asp' );
        
        $this->EE->load->model("accounts");
        $this->EE->load->model("cpd_events");
        
        $payment = $this->EE->input->get_post("payment");
        $event_id_c = $this->EE->input->get_post("id");
        
        ////// fetch event////
        if(empty($payment)){
            $params =array();
            $params['selects'] = "{#m}.id, {#m}.name, {#c}.payment_types_accepted_c";
            $params['where'] = "{#c}.event_id_c = '$event_id_c'";
            $params['single'] = true;
            
            $_event = $this->EE->cpd_events->get_main_data($params);
            $_event['payment_types'] = trim($_event['payment_types_accepted_c'], "^");
            if($_event['payment_types'] != ''){
                $_event['payment_types'] = explode("^,^", $_event['payment_types']);
            }
            if(in_array('account', $_event['payment_types'])){
                self::$p_type = "account";    
            }
            else{
                self::$p_type = "eway";
            }
            
            /// fetch account ///
            $params = array();
            $params['id'] = $_event['id'];
            $params['selects'] = "{#m}.id,{#m}.name";
            $params['single'] = true;
           
            self::$p_account = $this->EE->cpd_events->get_relationship_organiser($params);
            ///////////////    
        }    
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "show":
                return $this->show($params);
            break;
            case "bill":
                return $this->bill($params);
            break;
        }
    }
    
    function show($params = array()){
        $payment = $this->EE->input->get_post("payment");
        
        if(empty($payment)){
            $payment = array('cc_holder_name' => '', 'cc_number' => '', 'cc_type' => '', 'cc_exp_month' => '', 'cc_exp_year' => '', 'cc_cid' => '');
        }
        
        $accept_cards = $params['accept_cards'];
        
        $ccv_info = $this->get_ccv_infos(
                array('month' => $payment['cc_exp_month'], 'year' => $payment['cc_exp_year'])
            );
        
        $form_template = "form_{$this->code}";
        $swaps = array(
                    'code' => 'code',
                    'ccv_info' => 'ccv_info',
                    'pt' => 'pt',
                    'accept_cards' => 'accept_cards',
                    'json_accept_cards' => 'json_accept_cards',
                    'account' => 'account',
                    'payment_type' => 'payment_type'
                 );
        $datas = array(
                    'code' => $this->code,
                    'ccv_info' => $ccv_info,
                    'pt' => $payment,
                    'accept_cards' => $accept_cards,
                    'json_accept_cards' => json_encode($accept_cards),
                    'account' => self::$p_account,
                    'payment_type' => self::$p_type
                 );
        
        $TMPL = new EE_Template();         
        $TMPL->run_template_engine('payments', $form_template);
        $form = $this->EE->output->app_output($swaps, $datas, array('output' => false));
        
        return array('code' => $this->code, 'title' => $this->title, 'form' => $form);
    }
    
    function bill($params = array()){
        $customer_id = $params['customer_id'];
        $amount = $params['amount'];
        $amount = round($amount * 100);
        
        $payment = $this->EE->input->get_post("payment");

        if(!empty($customer_id)){
            $this->eway->setCustomerID($customer_id);
        }
        
        /// trigger payment transaction ///
        $result = '';
        $eway = $this->eway;        
        /*$eway->setCustomerFirstname( 'John' ); 
        $eway->setCustomerLastname( 'Smith' );
        $eway->setCustomerEmail( 'name@xyz.com.au' );
        $eway->setCustomerAddress( '123 Someplace Street, Somewhere ACT' );
        $eway->setCustomerPostcode( '2609' );
        $eway->setCustomerInvoiceDescription( 'Testing' );
        $eway->setCustomerInvoiceRef( 'INV120394' ); */
        $eway->setCardHoldersName( $payment['cc_holder_name'] );
        $eway->setCardNumber( $payment['cc_number'] );
        $eway->setCardExpiryMonth( $payment['cc_exp_month'] );
        $eway->setCardExpiryYear( $payment['cc_exp_year'] );
        //$eway->setTrxnNumber( '4230' );
        $eway->setTotalAmount( $amount );
        $eway->setCVN( $payment['cc_cid'] );
        
        /// set info ///
        $info = $params['info'];
        $eway->setCustomerFirstname($info['firstname']);
        $eway->setCustomerLastname($info['lastname']);
        $eway->setCustomerAddress($info['address']);
        $eway->setCustomerPostcode($info['postcode']);        
        $eway->setCustomerEmail($info['email']);
        $eway->setCustomerInvoiceDescription($info['invoice_desc']);
        $eway->setCustomerInvoiceRef($info['invoice_ref']);
        ///////////////////

        $result = $eway->doPayment();
    
        if( $result == EWAY_TRANSACTION_OK ) {
            $msg = "Transaction successful. Auth Code: " . $eway->getAuthCode();
        } else {
            $msg = "Error occurred (".$eway->getError()."): " . $eway->getErrorMessage();
        }
        ///////////////////////////////////
        
        return array('code' => $result, 'msg' => $msg, 'trxn_number' => $eway->getTrxnNumber(), 'payment' => $payment);
    }
    
    function get_ccv_infos($params){
        $sel_month = $params['month'];
        $sel_year = $params['year'];
        
        $months_value = array('01','02','03','04','05','06','07','08','09', '10', '11', '12');
        $months_label = array('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
        $months = array_combine($months_value, $months_label);
        foreach($months as $key => $value){
            $months[$key] = "$key - $value";
        }
        
        $months_opts = $this->helper->make_select_opts($months, $sel_month);
        
        $first_year = date('Y') * 1 - 2000;
        $years = array();
        for($i = 0; $i <= 10; $i++){
           $years[$first_year + $i] = 2000 + $first_year + $i; 
        }
        $years_opts = $this->helper->make_select_opts($years, $sel_year);
        
        return array('months' => $months_opts, 'years' => $years_opts);
    }
}