<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class PTSProcessing_Payments_Eway extends PTSProcessing_Payments{
 
    protected $code = 'eway';
    protected $title = 'Pay With a Debit Or Credit Card';
    protected $eway = '';
    static $p_type;
    static $p_account;
    function initialize($params = array()){     
        $this->EE->load->model("accounts");
        $this->EE->load->model("cpd_events");
        
        $payment = $this->EE->input->get_post("payment");
        $event_id_c = $this->EE->input->get_post("id");
        
        ////// fetch event////
        //if(empty($payment)){
            $params =array();
            $params['selects'] = "{#m}.id, {#m}.name, {#c}.payment_types_accepted_c";
            $params['where'] = "{#c}.event_id_c = '$event_id_c'";
            $params['single'] = true;
            
            $_event = $this->EE->cpd_events->get_main_data($params);
            $_event['payment_types'] = trim($_event['payment_types_accepted_c'], "^");
            if($_event['payment_types'] != ''){
                $_event['payment_types'] = explode("^,^", $_event['payment_types']);
            }
            if(in_array('account', $_event['payment_types'])){
                self::$p_type = "account";    
            }
            else{
                self::$p_type = "eway";
            }
            
            /// fetch account ///
            $params = array();
            $params['id'] = $_event['id'];
            $params['selects'] = "{#m}.id,{#m}.name,{#c}.eway_rapid_api_key_c,{#c}.eway_rapid_api_key_pw_c,{#c}.eway_client_side_key_c";
            $params['single'] = true;
           
            self::$p_account = $this->EE->cpd_events->get_relationship_organiser($params);
            ///////////////    
        //}
        /*self::$p_account['eway_client_side_key_c'] = "wt3hEhtVhRHVz1urh4HCGI4Hj7a9Ar3hirGjqqhgGpYUnpQ9OEOp0J1XQhiqIm32ej24hsapMd9J91vHoC/Pq5uuQ900JQmwRkDFfFCk/5+5w+zCGm++lpmlMWDTfdrx973/+Qdznj5vhezJggbYxr/+0uCXr7g75fMNMM6/xZ9lhw9nA/LHwG6WG5y57xDdtHJ5nZNTxBKbRh4ZzDqO0tQ89mbQyGAdoBViUX+qUP10dvh6GbqngmAQvzIxZJkLHZX9TD12aNElzYcKq0VtEqk1jvjWfL/76s7yB+9zsqRG44c2rB40n0WP6gEDkquqPz/OGQ7sX+m0JKF2Rp+6Xw==";*/
        require_once (PATH_THIRD . "payments/models/gateways/eway/lib/eway-rapid-php-master/include_eway.php");
        $apiKey = self::$p_account['eway_rapid_api_key_c'];
        $apiPassword = self::$p_account['eway_rapid_api_key_pw_c'];
        /*$apiKey = "F9802CPI85zrWVu/tAYVArY+dYZ+DNy3Ny5SKitRLutV68lR6ETdlSUiUoA1e5ELJ9Mnjm";
        $apiPassword = "LjSKJCJX";*/
        $apiEndpoint = 'production';
        $this->eway = $eway = \Eway\Rapid::createClient($apiKey, $apiPassword, $apiEndpoint);    
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "show":
                return $this->show($params);
            break;
            case "bill":
                return $this->bill($params);
            break;
        }
    }
    
    function show($params = array()){
        $payment = $this->EE->input->get_post("payment");
        
        if(empty($payment)){
            $payment = array('cc_holder_name' => '', 'cc_number' => '', 'cc_type' => '', 'cc_exp_month' => '', 'cc_exp_year' => '', 'cc_cid' => '');
        }
        
        $accept_cards = $params['accept_cards'];
        
        $ccv_info = $this->get_ccv_infos(
                array('month' => $payment['cc_exp_month'], 'year' => $payment['cc_exp_year'])
            );
        
        $form_template = "form_{$this->code}";
        $swaps = array(
                    'code' => 'code',
                    'ccv_info' => 'ccv_info',
                    'pt' => 'pt',
                    'accept_cards' => 'accept_cards',
                    'json_accept_cards' => 'json_accept_cards',
                    'account' => 'account',
                    'payment_type' => 'payment_type'
                 );
        $datas = array(
                    'code' => $this->code,
                    'ccv_info' => $ccv_info,
                    'pt' => $payment,
                    'accept_cards' => $accept_cards,
                    'json_accept_cards' => json_encode($accept_cards),
                    'account' => self::$p_account,
                    'payment_type' => self::$p_type
                 );
        
        $TMPL = new EE_Template();         
        $TMPL->run_template_engine('payments', $form_template);
        $form = $this->EE->output->app_output($swaps, $datas, array('output' => false));
        
        return array('code' => $this->code, 'title' => $this->title, 'form' => $form);
    }
    
    function bill($params = array()){
        $customer_id = $params['customer_id'];
        $amount = $params['amount'];
        $amount = round($amount * 100);
        
        $payment = $this->EE->input->get_post("payment");
        $eway_card_number = $this->EE->input->get_post("eway_card_number");
        $eway_card_cvn = $this->EE->input->get_post("eway_card_cvn");
        /*if(!empty($customer_id)){
            $this->eway->setCustomerID($customer_id);
        }*/
        
        /// trigger payment transaction ///
        $result = '';
        $eway = $this->eway;
        $info = $params['info'];
        $transaction = array();
        /*$transaction = [
            'Customer' => [
                'Title' => $info['salutation'],
                'FirstName' => $info['firstname'],
                'LastName' => $info['lastname'],
                'Street1' => $info['street'],
                'City' => $info['city'],
                'State' => $info['state'],
                'PostalCode' => $info['postcode'],
                'Country' => 'au',
                'Email' => $info['email'],
                'CardDetails' => [
                    'Name' => $payment['cc_holder_name'],
                    'Number' => $payment['cc_number'],
                    'ExpiryMonth' => $payment['cc_exp_month'],
                    'ExpiryYear' => $payment['cc_exp_year'],
                    'CVN' => $payment['cc_cid'],
                ],
            ],
            'Payment' => [
                'TotalAmount' => $amount,
                'InvoiceDescription' => $info['invoice_desc'],
                'InvoiceReference' => $info['invoice_ref'],
                'CurrencyCode' => 'AUD',
            ],
            'TransactionType' => \Eway\Rapid\Enum\TransactionType::PURCHASE,
            'Capture' => true,
        ];*/

        ///// filter invoice desc & street/////
        $info['invoice_desc'] = substr($info['invoice_desc'], 0, 60);
        if(strlen($info['invoice_desc']) >= 60){
            $info['invoice_desc'] = $info['invoice_desc'] . "...";
        }

        $info['street'] = substr($info['street'], 0, 45);
        if(strlen($info['street']) >= 45){
            $info['street'] = $info['street'] . "...";
        }
        //////
        $transaction = array(
            'Customer' => array(
                'Title' => $info['salutation'],
                'FirstName' => $info['firstname'],
                'LastName' => $info['lastname'],
                'Street1' => $info['street'],
                'City' => $info['city'],
                'State' => $info['state'],
                'PostalCode' => $info['postcode'],
                'Country' => 'au',
                'Email' => $info['email'],
                'CardDetails' => array(
                    'Name' => $payment['cc_holder_name'],
                    'Number' => $eway_card_number,
                    'ExpiryMonth' => $payment['cc_exp_month'],
                    'ExpiryYear' => $payment['cc_exp_year'],
                    'CVN' => $eway_card_cvn,
                ),
            ),
            'Payment' => array(
                'TotalAmount' => $amount,
                'InvoiceDescription' => $info['invoice_desc'],
                'InvoiceReference' => $info['invoice_ref'],
                'CurrencyCode' => $info['currency'],
            ),
            'TransactionType' => \Eway\Rapid\Enum\TransactionType::RECURRING,
            'Capture' => true,
        );

        $result = $eway->createTransaction(\Eway\Rapid\Enum\ApiMethod::DIRECT, $transaction);
        
        
        if ($result->TransactionStatus) {
            $msg = "Transaction successful. Auth Code: " . $result->TransactionID;
        } else {
            if ($result->getErrors()) {
                foreach ($result->getErrors() as $error) {
                    $msg = "Error: ".\Eway\Rapid::getMessage($error);
                }
            } else {
                $msg = "Sorry, your payment was declined";
            }
        }
        ///////////////////////////////////
        
        return array('code' => $result, 'msg' => $msg, 'trxn_number' => $result->TransactionID, 'payment' => $payment);
    }
    
    function get_ccv_infos($params){
        $sel_month = $params['month'];
        $sel_year = $params['year'];
        
        $months_value = array('01','02','03','04','05','06','07','08','09', '10', '11', '12');
        $months_label = array('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
        $months = array_combine($months_value, $months_label);
        foreach($months as $key => $value){
            $months[$key] = "$key - $value";
        }
        
        $months_opts = $this->helper->make_select_opts($months, $sel_month);
        
        $first_year = date('Y') * 1 - 2000;
        $years = array();
        for($i = 0; $i <= 10; $i++){
           $years[$first_year + $i] = 2000 + $first_year + $i; 
        }
        $years_opts = $this->helper->make_select_opts($years, $sel_year);
        
        return array('months' => $months_opts, 'years' => $years_opts);
    }
}