<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class PTSProcessing_Payments_Paypal extends PTSProcessing_Payments{
 
    protected $code = 'paypal';
    protected $title = 'Pay With Paypal';
    protected $paypal = '';
    protected $access_token = '';
    static $p_type;
    static $p_account;

    function initialize($params = array()){
        $this->EE->load->model("accounts");
        $this->EE->load->model("cpd_events");

        $event_id_c = $this->EE->input->get_post("id");
        
        $params =array();
        $params['selects'] = "{#m}.id, {#m}.name, {#c}.payment_types_accepted_c";
        $params['where'] = "{#c}.event_id_c = '$event_id_c'";
        $params['single'] = true;
        
        $_event = $this->EE->cpd_events->get_main_data($params);
        $_event['payment_types'] = trim($_event['payment_types_accepted_c'], "^");
        if($_event['payment_types'] != ''){
            $_event['payment_types'] = explode("^,^", $_event['payment_types']);
        }
        if(in_array('account', $_event['payment_types'])){
            self::$p_type = "account";    
        }
        else{
            self::$p_type = "paypal";
        }

        //// fetch account /////
        $params = array();
        $params['id'] = $_event['id'];
        $params['selects'] = "{#m}.id,{#m}.name,{#c}.eway_rapid_api_key_c,{#c}.eway_rapid_api_key_pw_c,{#c}.eway_client_side_key_c";
        $params['single'] = true;
       
        self::$p_account = $this->EE->cpd_events->get_relationship_organiser($params);
        /////////////

        require_once (PATH_THIRD . "payments/models/gateways/paypal/lib/paypal_payment.php");
        //$this->eway = $eway = new EwayPayment( '87654321', 'https://www.eway.com.au/gateway_cvn/xmltest/testpage.asp' );
        $this->paypal = new PaypalPayment();
        $this->access_token = $this->EE->session->flashdata('paypal_access_token');
    }
        
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "show":
                return $this->show($params);
            break;
            case "bill":
                return $this->bill($params);
            break;
        }
    }
    
    function show($params = array()){
        $config = $params['additional'];
        $form_template = "form_{$this->code}";

        $swaps = array(
                    'code' => 'code',
                    'payment_type' => 'payment_type',
                    'account' => 'account',
                    'config' => 'config'
                 );
        $datas = array(
                    'code' => $this->code,
                    'payment_type' => self::$p_type,
                    'account' => self::$p_account,
                    'config' => $config
                 );
        
        $TMPL = new EE_Template();         
        $TMPL->run_template_engine('payments', $form_template);
        $form = $this->EE->output->app_output($swaps, $datas, array('output' => false));
        
        return array('code' => $this->code, 'title' => $this->title, 'form' => $form);
    }
    
    public function bill($sparams = array())
    {
        $stage = $sparams['stage'];
        
        switch($stage){
            case 'start':
                return $this->start($sparams);
            break;
            case 'pay':
                return $this->pay($sparams);
            break; 
            case 'do_payment':
                return $this->do_payment($sparams);
            break;
        }        
    }
    public function start($sparams = array())
    {
        $config = $sparams['config'];
        $markflow = $sparams['markflow'];
        $this->paypal->initialize($config);
        
        $this->access_token = $this->paypal->getAccessToken();
        $this->EE->session->set_flashdata('paypal_access_token', $this->access_token);
        
        $markFlowJson = json_encode($markflow);
        
        $approval_url = $this->paypal->getApprovalURL($this->access_token, $markFlowJson). "&useraction=commit";
        
        header("Location:".$approval_url);
        exit;
    }
    public function pay($sparams = array())
    {
        $config = $sparams['config'];
        $this->paypal->initialize($config);
        
        if( isset($_GET['paymentId']) && isset($_GET['PayerID'])){ //Proceed to Checkout or Mark flow
            //call to execute payment
            $response = $this->paypal->doPayment(filter_input( INPUT_GET, 'paymentId', FILTER_SANITIZE_STRING ), filter_input( INPUT_GET, 'PayerID', FILTER_SANITIZE_STRING ), NULL, $this->access_token);
            if ($response['http_code'] != 200 && $response['http_code'] != 201) {        
                return array('code' => 'fail', 'error' => $response['json']['message']);
            }
            
            $json_response = $response['json']; 
    
            $paymentID= $json_response['id'];
            $paymentState = $json_response['state'];
            $finalAmount = $json_response['transactions'][0]['amount']['total'];
            $currency = $json_response['transactions'][0]['amount']['currency'];
            $transactionID= $json_response['transactions'][0]['related_resources'][0]['sale']['id'];
            
            return array(
                    'code' => 'success',
                    'payment_id' => $paymentID,
                    'payment_state' => $paymentState,
                    'final_amount' => $finalAmount,
                    'currency' => $currency,
                    'transaction_id' => $transactionID
                );
        }   
        
        return array('code' => 'fail', 'error' => 'No Payment ID'); 
    }
    public function do_payment($sparams = array())
    {
        
    }
}