<?php

//Whether Sandbox environment is being used, Keep it true for testing
define("PAYPAL_SANDBOX_FLAG", true);

//PayPal REST API endpoints
define("PAYPAL_SANDBOX_ENDPOINT", "https://api.sandbox.paypal.com");
define("PAYPAL_LIVE_ENDPOINT", "https://api.paypal.com");

//Merchant ID
define("PAYPAL_MERCHANT_ID","E9GCL5FX4TU2C");

//PayPal REST App SANDBOX Client Id and Client Secret
define("PAYPAL_SANDBOX_CLIENT_ID" , "AZazaq902xcELwoNkYxhzsbbdIX-jShBHYnKT0d43ODzXRvHdwkdjubUXO9yR20kYlVAFabTsZJuhKmM");
define("PAYPAL_SANDBOX_CLIENT_SECRET", "EEsK8Bs1NKdA7VCxwO2tR1uMtUV5hhboEHKMR5HBkEa44rlJyeUlr7T12D5B1cMc2hqZ2daEVTOk6tWx");

//Environments -Sandbox and Production/Live
define("PAYPAL_SANDBOX_ENV", "sandbox");
define("PAYPAL_LIVE_ENV", "production");

//PayPal REST App SANDBOX Client Id and Client Secret
define("PAYPAL_LIVE_CLIENT_ID" , "live_Client_Id");
define("PAYPAL_LIVE_CLIENT_SECRET" , "live_Client_Secret");

//ButtonSource Tracker Code
define("PAYPAL_SBN_CODE","PP-Dentevents-EC-IC-php-REST");    

class PaypalPayment {
    protected $MERCHANT_ID;
    protected $SANDBOX_CLIENT_ID;
    protected $SANDBOX_CLIENT_SECRET;
    protected $LIVE_CLIENT_ID;
    protected $LIVE_CLIENT_SECRET;
    protected $ENV;
    protected $SANDBOX_FLAG;
    
    public function initialize($config)
    {
        $this->MERCHANT_ID = $config['MERCHANT_ID'];    
        $this->SANDBOX_CLIENT_ID = $config['SANDBOX_CLIENT_ID'];
        $this->SANDBOX_CLIENT_SECRET = $config['SANDBOX_CLIENT_SECRET'];
        $this->LIVE_CLIENT_ID = $config['LIVE_CLIENT_ID'];
        $this->LIVE_CLIENT_SECRET = $config['LIVE_CLIENT_SECRET'];
        $this->ENV = $config['ENV'];
        $this->SANDBOX_FLAG = $config['SANDBOX_FLAG'];
    }
    
    function curlCall($curlServiceUrl, $curlHeader, $curlPostData) {
        // response container
        $resp = array(
            "http_code" => 0,
            "jason"     => ""
        );

        //set the cURL parameters
        $ch = curl_init($curlServiceUrl);
        curl_setopt($ch, CURLOPT_VERBOSE, 1);

        //turning off the server and peer verification(TrustManager Concept).
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);

        curl_setopt($ch, CURLOPT_SSLVERSION , 'CURL_SSLVERSION_TLSv1_2');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        //curl_setopt($ch, CURLOPT_HEADER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $curlHeader);

        if(!is_null($curlPostData)) {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $curlPostData);
        }

/// custom proxy /////
curl_setopt($ch, CURLOPT_PROXY, "147.124.212.139");
curl_setopt($ch, CURLOPT_PROXYPORT, "22");
curl_setopt($ch, CURLOPT_PROXYTYPE, "HTTP");
curl_setopt($ch, CURLOPT_PROXYUSERPWD, "adeel:UY92d8931lMYLoClqp");

        //getting response from server
        $response = curl_exec($ch);

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        curl_close($ch); // close cURL handler
        
        // some kind of an error happened
        if (empty($response)) {
            return $resp;
        }
        
        $resp["http_code"] = $http_code;
        $resp["json"] = json_decode($response, true);
        
        return $resp;
    }


    /**
     * Prevents Cross-Site Scripting Forgery
     * @return boolean
     */
    function verify_nonce() {
        if( isset($_GET['csrf']) && $_GET['csrf'] == $_SESSION['csrf'] ) {
            return true;
        }
        if( isset($_POST['csrf']) && $_POST['csrf'] == $_SESSION['csrf'] ) {
            return true;
        }
        return false;
    }  
    
    function getAccessToken(){
        $curlServiceUrl = ($this->SANDBOX_FLAG ? PAYPAL_SANDBOX_ENDPOINT : PAYPAL_LIVE_ENDPOINT);
        $curlServiceUrl = $curlServiceUrl. "/v1/oauth2/token";
        $clientId = ($this->SANDBOX_FLAG ? $this->SANDBOX_CLIENT_ID : $this->LIVE_CLIENT_ID);
        $clientSecret = ($this->SANDBOX_FLAG ? $this->SANDBOX_CLIENT_SECRET : $this->LIVE_CLIENT_SECRET);
        $curlHeader = array(
             "Content-type" => "application/json",
             "Authorization: Basic ". base64_encode( $clientId .":". $clientSecret),
             "PayPal-Partner-Attribution-Id" => PAYPAL_SBN_CODE
             );
        $postData = array(
             "grant_type" => "client_credentials"
             );

        $curlPostData = http_build_query($postData);
        $curlResponse = $this->curlCall($curlServiceUrl, $curlHeader, $curlPostData);
        
        $access_token = $curlResponse['json']['access_token'];
        //$access_token = $curlResponse['access_token'];
        return $access_token;
    }


    /*
        * Purpose:     Gets the PayPal approval URL to redirect the user to.
        * Inputs:
        *        access_token    : The access token received from PayPal
        * Returns:              approval URL
        */
    function getApprovalURL($access_token, $postData){
        $curlServiceUrl = ($this->SANDBOX_FLAG ? PAYPAL_SANDBOX_ENDPOINT : PAYPAL_LIVE_ENDPOINT);
        $curlServiceUrl = $curlServiceUrl. "/v1/payments/payment";
        $curlHeader = array("Content-Type:application/json", "Authorization:Bearer ".$access_token, "PayPal-Partner-Attribution-Id:".PAYPAL_SBN_CODE);

        $curlResponse = $this->curlCall($curlServiceUrl, $curlHeader, $postData);
        $jsonResponse = $curlResponse['json'];

        foreach ($jsonResponse['links'] as $link) {
        //foreach ($curlResponse['links'] as $link) {
            if($link['rel'] == 'approval_url'){
                $approval_url = $link['href'];
                //echo($approval_url);
                return $approval_url;
            }
         }

    }

    /*
        * Purpose:     Look up a payment resource, to get details about payments that have not yet been completed
        * Inputs:
        *        paymentID    : The id of the created payment
        * Returns:              the payment object
        */
    function lookUpPaymentDetails($paymentID, $access_token){
        $curlServiceUrl = ($this->SANDBOX_FLAG ? PAYPAL_SANDBOX_ENDPOINT : PAYPAL_LIVE_ENDPOINT);
        $curlServiceUrl = $curlServiceUrl. "/v1/payments/payment/". $paymentID;
        $curlHeader = array("Content-Type:application/json", "Authorization:Bearer ".$access_token, "PayPal-Partner-Attribution-Id:".PAYPAL_SBN_CODE);

        $curlResponse = $this->curlCall($curlServiceUrl, $curlHeader, NULL);
        return $curlResponse['json'];

    }


    /*
        * Purpose:     Executes the previously created payment for a given paymentID for a specific user's payer id.
        * Inputs:
        *        paymentID    : The id of the previously created PayPal payment
        *       payerID      : The id of the user received from PayPal
        *       transactionAmountArray   : amount array if updating the payment amount
        * Returns:
        *        array["http_code"]   : the http status code   
        *        array["jason"]       : the response string
        */
    function doPayment($paymentID, $payerID, $transactionAmountArray, $access_token){
        $curlServiceUrl = ($this->SANDBOX_FLAG ? PAYPAL_SANDBOX_ENDPOINT : PAYPAL_LIVE_ENDPOINT);
        $curlServiceUrl = $curlServiceUrl. "/v1/payments/payment/". $paymentID ."/execute";
        $curlHeader = array("Content-Type:application/json", "Authorization:Bearer ".$access_token, "PayPal-Partner-Attribution-Id:".PAYPAL_SBN_CODE);

        $postData = array(
                        "payer_id" => $payerID
                        );

        if(!is_null($transactionAmountArray)){
            $postData ["transactions"][0] = $transactionAmountArray;
        }

        $curlPostData = json_encode($postData);
        $curlResponse = $this->curlCall($curlServiceUrl, $curlHeader, $curlPostData);
        return $curlResponse;
    }  
}