<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class PTSProcessing_Payments extends PTSProcessing{
 
    function initialize($params = array()){
    }
    
    function process($params = array()){
        $_gateways = self::$gateways;
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "show":
                return $this->show($params);
            break;
            case "bill":
                return $this->bill($params);
            break;
        }
        
        
        foreach($_gateways as $_gateway){
            if($cmd == $_gateway){
                require_once(PATH_THIRD . "payments/models/gateways/{$_gateway}.php");
                $class = "PTSProcessing_Payments_" . ucfirst($_gateway);
                $processing = new $class();
                $processing->initialize($params);
                return $processing->process($params);
            }
        }
    }
    
    function show($params = array()){
        $forms = array();
        $data = array();
        $_gateways = self::$gateways;
        $accept_gateways = $params['accept_gateways'];

        $index = 1;
        foreach($_gateways as $_gateway){
            if(!empty($accept_gateways) && !in_array($_gateway, $accept_gateways)){
                continue;
            }
            self::$router = "{$_gateway}:show";
            $form = PTSProcessing_Payments::process($params);
            //if((!empty($forms)) && ($_gateway == "account")){
                //continue;
            //}
            $form['index'] = $index++;
            $forms[] = $form;
        }

        if(empty($forms)){
            return '';
        }
        $forms['count'] = count($forms);
        
        ////// Get default gateway //////
        $default_gateway = 'capture';
        if(in_array('account', $accept_gateways) && count($accept_gateways) == 2){
            foreach($accept_gateways as $key => $item){
                if($item !== 'account'){
                    $default_gateway = $item;
                    continue;
                }
            }
        }
        $data['default_gateway'] = $default_gateway;
        //////////////////////////////

        ///// Prepare help text /////
        $maps_helptexts = array("upgrade_refund");
        $helptexts = $this->helper->setup_helptext($maps_helptexts);
        /////////////////////////////
        
        $swaps = array(
                    'forms' => 'forms',
                    'dt' => 'dt',
                    'ht' => 'ht'
                 );
        $datas = array(
                    'forms' => $forms,
                    'dt' => $data,
                    'ht' => $helptexts
                 );
        
        $TMPL = new EE_Template();         
        $TMPL->run_template_engine('payments', 'methods');
        return $this->EE->output->app_output($swaps, $datas, array('output' => false)); 
    }
    
    function bill($params = array()){
        $payment = $this->EE->input->get_post('payment');
        if(is_array($payment)){
            $gateway = $payment['method'];
        }else{
            $gateway = $payment;    
        }
        
        $cmd = "{$gateway}:bill";
        self::$router = $cmd;
        
        return PTSProcessing_Payments::process($params);
    }
}