<?php

/*
=====================================================
    author : Adeel
    Date   : 2013/4/20
    Description : 
=====================================================
*/

if ( ! defined('EXT'))
{
    exit('Invalid file request');
}

require_once(PATH_THIRD . 'seo/model/base.php');
class Seo_CanonicalLinks extends Seo_Base{
    protected $router = '';
    
    function Seo_CanonicalLinks()
    {
        parent::__construct();
    }
    
    private function make_tag($uri){
        $url = $this->EE->config->item("site_url") . $uri;
        $tag = "<link rel=\"canonical\" href=\"{$url}\" />";
        
        return $tag;
    }
    
    function get_canonical_link(){
        $this->seo_helper->matches();
        $this->router = $this->seo_helper->get_router();
        
        switch($this->router){
            case Seo_Helper::HOME:
                return $this->trigger_router_HOME();
            break;
            case Seo_Helper::BLOGS:
                return $this->trigger_router_BLOGS();
            break;
            case Seo_Helper::DETAILS:
                return $this->trigger_router_DETAILS();
            break;
            case Seo_Helper::SPEAKER_PROFILE:
                return $this->trigger_router_SPEAKER_PROFILE();
            break;
            case Seo_Helper::ACCOUNT_VENUE_DETAIL:
                return $this->trigger_router_ACCOUNT_VENUE_DETAIL();
            break;
            case Seo_Helper::ACCOUNT_ORG_DETAIL:
                return $this->trigger_router_ACCOUNT_ORG_DETAIL();
            break;
            case Seo_Helper::ACCOUNT_EXHIBITOR_DETAIL:
                return $this->trigger_router_ACCOUNT_EXHIBITOR_DETAIL();
            break;
            case Seo_Helper::EXPRESS_EDIT_OPTION:
                return $this->trigger_router_EXPRESS_EDIT_OPTION();
            break;
            default:
                return $this->trigger_router_NOTFOUND();
            break;
        }
    }
    
    /// triggers for routers ///
    function trigger_router_HOME(){
        return $this->make_tag('');
    }
        
    function trigger_router_BLOGS(){
        $uri = $this->EE->uri->uri_string;
       
        return $this->make_tag($uri);        
    }
    
    function trigger_router_DETAILS(){
        $name = $GLOBALS['meta']['name'];
        $country = $GLOBALS['meta']['country'];
        $id = $GLOBALS['meta']['event_id'];
                
        $country = $this->seo_helper->get_seo_text($country);
        $name = $this->seo_helper->get_seo_text($name);
        $id = $this->seo_helper->get_seo_text($id);
        $uri = "{$country}/{$name}/{$id}";

        return $this->make_tag($uri);
    }
    
    function trigger_router_SPEAKER_PROFILE(){
        $name = $GLOBALS['meta']['name'];
        $id = $GLOBALS['meta']['id'];
        
        $name = $this->seo_helper->get_seo_text($name);
        $id = $this->seo_helper->get_seo_text($id);
        $uri = "speaker-profile/{$name}/{$id}";

        return $this->make_tag($uri);
    }
    
    function trigger_router_ACCOUNT_VENUE_DETAIL(){
        $country = $GLOBALS['meta']['country'];
        $name = $GLOBALS['meta']['name'];
        $id = $GLOBALS['meta']['id'];
        
        $country = $this->seo_helper->get_seo_text($country);
        $name = $this->seo_helper->get_seo_text($name);
        $id = $this->seo_helper->get_seo_text($id);
        $uri = "event-venue/{$country}/{$name}/{$id}";

        return $this->make_tag($uri);
    }
    function trigger_router_ACCOUNT_ORG_DETAIL(){
        $country = $GLOBALS['meta']['country'];
        $name = $GLOBALS['meta']['name'];
        $id = $GLOBALS['meta']['id'];
        
        $country = $this->seo_helper->get_seo_text($country);
        $name = $this->seo_helper->get_seo_text($name);
        $id = $this->seo_helper->get_seo_text($id);
        $uri = "org/{$country}/{$name}/{$id}";

        return $this->make_tag($uri);
    }
    function trigger_router_ACCOUNT_EXHIBITOR_DETAIL(){
        $country = $GLOBALS['meta']['country'];
        $name = $GLOBALS['meta']['name'];
        $id = $GLOBALS['meta']['id'];
        
        $country = $this->seo_helper->get_seo_text($country);
        $name = $this->seo_helper->get_seo_text($name);
        $id = $this->seo_helper->get_seo_text($id);
        $uri = "exhibitor/{$country}/{$name}/{$id}";

        return $this->make_tag($uri);
    }
    function trigger_router_EXPRESS_EDIT_OPTION(){
        $country = $GLOBALS['meta']['country'];
        $name = $GLOBALS['meta']['name'];
        $id = $GLOBALS['meta']['id'];
        
        $country = $this->seo_helper->get_seo_text($country);
        $name = $this->seo_helper->get_seo_text($name);
        $id = $this->seo_helper->get_seo_text($id);
        $uri = "express/{$id}";

        return $this->make_tag($uri);
    }
    
    function trigger_router_NOTFOUND(){
        $uri = "system/not_found_page";
        
        return $this->make_tag($uri);
    }
    ////////////////////////////
}